/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.InmSortTable;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SorterInterface;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.TableSortInterface;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class SortableTableModel
extends DefaultTableModel
implements TableSortInterface,
SorterInterface {
    public int[] indexes;
    private TableSorter sorter;
    private boolean dirty = false;

    public SortableTableModel() {
    }

    public SortableTableModel(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public SortableTableModel(Object[] data, int numRows) {
        super(data, numRows);
    }

    public SortableTableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    public SortableTableModel(Vector columnNames, int numRows) {
        super(columnNames, numRows);
    }

    public SortableTableModel(Vector data, Vector columnNames) {
        super(data, columnNames);
    }

    @Override
    public Object getValueAt(int row, int col) {
        this.getIndexes();
        int rowIndex = row;
        if (this.indexes != null) {
            if (row >= this.indexes.length) {
                return null;
            }
            rowIndex = this.indexes[row];
        }
        return super.getValueAt(rowIndex, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int rowIndex = row;
        if (this.indexes != null && this.indexes.length > 0) {
            rowIndex = this.indexes[row];
        }
        super.setValueAt(value, rowIndex, col);
        this.dirty = false;
    }

    @Override
    public Object getModelValueAt(int row, int column) {
        Vector rowData = this.getDataVector().elementAt(row);
        return rowData.elementAt(column);
    }

    public void setValueAt(Object value, int row, int col, boolean isAutoSort) {
        this.setValueAt(value, row, col);
        this.dirty = isAutoSort;
    }

    public void setValueAt(Object value, int row, int col, boolean isAutoSort, boolean bfireTableCellUpdated) {
        int rowIndex = row;
        if (this.indexes != null && this.indexes.length > 0) {
            rowIndex = this.indexes[row];
        }
        Vector rowVector = (Vector)this.dataVector.elementAt(rowIndex);
        rowVector.setElementAt(value, col);
        if (bfireTableCellUpdated) {
            this.fireTableCellUpdated(rowIndex, col);
        }
        this.dirty = isAutoSort;
    }

    public void addRow(Vector rowData) {
        this.getIndexes();
        if (this.indexes != null) {
            int rowCount = this.getRowCount();
            int[] array = new int[rowCount + 1];
            System.arraycopy(this.indexes, 0, array, 0, this.indexes.length);
            array[rowCount] = rowCount;
            this.indexes = array;
        }
        super.addRow(rowData);
    }

    @Override
    public void moveRow(int startIndex, int endIndex, int toIndex) {
        super.moveRow(startIndex, endIndex, toIndex);
        this.dirty = true;
    }

    @Override
    public void removeRow(int row) {
        this.getIndexes();
        int rowIndex = row;
        if (this.indexes != null && this.indexes.length > 0) {
            rowIndex = this.indexes[row];
        }
        super.removeRow(rowIndex);
        this.dirty = true;
    }

    @Override
    public void setRowCount(int rowCount) {
        super.setRowCount(rowCount);
        this.dirty = true;
    }

    @Override
    public void sortByColumn(int column, boolean isAscent) {
        if (this.sorter == null) {
            this.sorter = new TableSorter(this);
        }
        this.sorter.sort(column, isAscent);
        this.fireTableDataChanged();
    }

    @Override
    public int[] getIndexes() {
        if (this.dirty) {
            this.dirty = false;
            this.indexes = null;
        }
        int n = this.getRowCount();
        if (this.indexes != null && this.indexes.length == n) {
            return this.indexes;
        }
        this.indexes = null;
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
        return this.indexes;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(600, 700);
        Container c = frame.getContentPane();
        c.setLayout(new BorderLayout());
        int rowCount = 5;
        Object[][] data = new String[rowCount][3];
        for (int i = 0; i < rowCount; ++i) {
            data[i][0] = "MM " + i;
            data[i][1] = "" + i;
            data[i][2] = "TT " + i;
        }
        Object[] col = new String[]{"name", "age", "height"};
        final SortableTableModel model = new SortableTableModel(data, col);
        final InmSortTable table = new InmSortTable(model);
        table.addColumnSortAction();
        JScrollPane scroll = new JScrollPane(table);
        c.add((Component)scroll, "Center");
        JPanel pane = new JPanel(new FlowLayout());
        final JTextField field = new JTextField();
        field.setPreferredSize(new Dimension(100, 24));
        pane.add(field);
        JButton insertBtn = new JButton("Insert Row");
        pane.add(insertBtn);
        insertBtn.addActionListener(new ActionListener(){
            int num = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < 1; ++i) {
                    Object[] str = new String[]{field.getText() + this.num, "20" + this.num, "170" + this.num};
                    ++this.num;
                    model.insertRow(Math.max(0, table.getSelectedRow()), str);
                }
            }
        });
        JButton addBtn = new JButton("Add Row");
        pane.add(addBtn);
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] str = new String[]{field.getText(), "20", "170"};
                model.addRow(str);
            }
        });
        JButton deleteBtn = new JButton("Delete Row");
        pane.add(deleteBtn);
        deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int num = table.getSelectedRow();
                if (num > -1) {
                    model.removeRow(num);
                }
            }
        });
        JButton rowCountBtn = new JButton("Row Count");
        pane.add(rowCountBtn);
        rowCountBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int count = table.getRowCount() - 1;
                try {
                    count = Integer.parseInt(field.getText());
                }
                catch (Exception ex) {
                    TEAppletLogMgr.error("SortableTableModel.actionPerformed() fail!", ex);
                }
                count = Math.max(0, count);
                model.setRowCount(count);
            }
        });
        c.add((Component)pane, "South");
        frame.show();
    }

    public int convertTableRowIndexToModel(int tableRowIndex) {
        return this.getIndexes()[tableRowIndex];
    }

    public int convertModelRowIndexToTable(int modelRowIndex) {
        int[] indexes = this.getIndexes();
        int tableIndex = modelRowIndex;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] != modelRowIndex) continue;
            tableIndex = i;
            break;
        }
        return tableIndex;
    }
}

