/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.HeaderListener;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.InmEntry;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortButtonRenderer;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortableTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SortableTableExample
extends JPanel {
    String[] headerStr = new String[]{"Name", "Date", "Size", "Dir"};
    SortableTableModel dm = new SortableTableModel(this.headerStr, 0){

        @Override
        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Date.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return TestData.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };
    JTable table = new JTable(this.dm);
    JScrollPane jScrollPane1 = new JScrollPane();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private static DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.JAPAN);

    public SortableTableExample() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            TEAppletLogMgr.error("SortableTableExample.SortableTableExample() fail!", e);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("SortableTable Example");
        f.getContentPane().add((Component)new SortableTableExample(), "Center");
        f.setSize(400, 160);
        f.setVisible(true);
    }

    private static Date getDate(String dateString) {
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException ex) {
            date = new Date();
        }
        return date;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.table, null);
        SortButtonRenderer renderer = new SortButtonRenderer();
        TableColumnModel model = this.table.getColumnModel();
        int n = this.headerStr.length;
        for (int i = 0; i < n; ++i) {
            model.getColumn(i).setHeaderRenderer(renderer);
        }
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new HeaderListener(header, renderer));
        Object[][] data = new Object[][]{{"b", SortableTableExample.getDate("98/12/02"), new Integer(14), new TestData(1, 1)}, {"a", SortableTableExample.getDate("99/2/02"), new Integer(67), new TestData(1, 2)}, {"d", SortableTableExample.getDate("20/2/08"), new Integer(2), new TestData(2, 3)}, {"c", SortableTableExample.getDate("08/12/01"), new Integer(2), new TestData(2, 5)}, {"foo", new Date(), new Integer(5), new TestData(2, 7)}, {"bar", new Date(), new Integer(10), new TestData(3, 1)}};
        for (int i = 0; i < data.length; ++i) {
            this.dm.addRow(data[i]);
        }
    }

    class TestData
    implements InmEntry {
        int a;
        int b;

        public TestData(int _a, int _b) {
            this.a = _a;
            this.b = _b;
        }

        @Override
        public int compare(Object o) {
            if (!(o instanceof TestData)) {
                return -1;
            }
            TestData data = (TestData)o;
            if (this.a != data.a) {
                return this.a - data.a;
            }
            if (this.b != data.b) {
                return this.b - data.b;
            }
            return 0;
        }

        public String toString() {
            return this.a + "-" + this.b;
        }
    }
}

