/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class SortButtonRenderer
extends DefaultTableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    private static TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "imageresource.ini");
    private static final Icon sortableIcon = resUtil.getIcon("sortable.gif");
    private static final Icon upSortedIcon = resUtil.getIcon("upsorted.gif");
    private static final Icon downSortedIcon = resUtil.getIcon("downsorted.gif");
    private boolean isSelect = true;
    private int pressedColumn = -1;
    private int sortState = 0;
    private int sortColumn = -1;

    public SortButtonRenderer() {
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(2);
        this.setName("SortableTableHeaderRenderer_iconLabel");
        LookAndFeel.installBorder(this, "TableHeader.cellBorder");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table instanceof InmTable) {
            InmTable tablecolumnsortable = (InmTable)table;
            if (tablecolumnsortable.isSortable() && tablecolumnsortable.isColumnSortable(column)) {
                int k = this.getState(column);
                if (k == 1) {
                    this.setIcon(downSortedIcon);
                } else if (k == 2) {
                    this.setIcon(upSortedIcon);
                } else {
                    this.setIcon(sortableIcon);
                }
            } else {
                this.setIcon(null);
            }
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setToolTipText(text);
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
    }

    private void setSelect(boolean select) {
        this.isSelect = select;
    }

    public void setPressedColumn(int col) {
        this.pressedColumn = col;
    }

    public void setSelectedColumn(int col) {
        if (col < 0) {
            return;
        }
        if (this.sortColumn == col) {
            switch (this.sortState) {
                case 2: {
                    this.sortState = 1;
                    break;
                }
                default: {
                    this.sortState = 2;
                    break;
                }
            }
        } else {
            this.sortColumn = col;
            this.sortState = 2;
        }
    }

    public int getState(int col) {
        if (this.sortColumn != col) {
            return 0;
        }
        return this.sortState;
    }

    public int getStateEx(int col) {
        if (this.sortColumn == col) {
            if (this.sortState == 1) {
                return 2;
            }
            if (this.sortState == 2) {
                return 1;
            }
        }
        return 0;
    }

    public void clearSortFlag() {
        this.setPressedColumn(-1);
        this.sortColumn = -1;
        this.sortState = 0;
    }

    public void clearSortRender() {
        this.clearSortFlag();
    }

    int getSortState(int col) {
        return this.sortColumn == col ? this.sortState : 0;
    }

    public void setDefaultCapable(boolean setDefaultCapable) {
    }
}

