/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortButtonRenderer;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.TableSortInterface;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ResizeableHeaderListener
extends MouseAdapter {
    private JTableHeader header = null;
    SortButtonRenderer renderer = null;
    private JTable table = null;
    private int resizingColumnIndex = 0;
    private boolean isResizingArea = false;

    public ResizeableHeaderListener(JTableHeader header, SortButtonRenderer renderer, JTable table) {
        this.header = header;
        this.renderer = renderer;
        this.table = table;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int curMaxLength;
        TableColumn resizingColumn;
        TableColumnModel columnModel;
        int index;
        Point p = e.getPoint();
        int clickCount = e.getClickCount();
        if (2 == clickCount && (index = (columnModel = this.header.getColumnModel()).getColumnIndexAtX(p.x)) != -1 && this.canResize(resizingColumn = this.getResizingColumn(p, index)) && (curMaxLength = this.getCurMaxLength()) <= resizingColumn.getMaxWidth()) {
            resizingColumn.setPreferredWidth(curMaxLength);
            this.table.sizeColumnsToFit(-1);
        }
    }

    private int getCurMaxLength() {
        int curMaxLength = 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            TableCellRenderer cellRenderer = this.table.getCellRenderer(i, this.resizingColumnIndex);
            Component comp = cellRenderer.getTableCellRendererComponent(this.table, this.table.getValueAt(i, this.resizingColumnIndex), false, false, i, this.resizingColumnIndex);
            int compLength = comp.getPreferredSize().width;
            if (compLength <= curMaxLength) continue;
            curMaxLength = compLength;
        }
        TableColumn column = this.table.getColumnModel().getColumn(this.resizingColumnIndex);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer != null) {
            Component _comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = _comp.getPreferredSize().width;
            if (headerWidth > curMaxLength) {
                curMaxLength = headerWidth;
            }
        }
        return curMaxLength + 2;
    }

    private boolean canResize(TableColumn column) {
        return column != null && this.header.getResizingAllowed() && column.getResizable();
    }

    private TableColumn getResizingColumn(Point p, int column) {
        int columnIndex;
        if (!this.isResizingArea(p, column)) {
            return null;
        }
        Rectangle r = this.header.getHeaderRect(column);
        int midPoint = r.x + r.width / 2;
        int n = columnIndex = p.x < midPoint ? column - 1 : column;
        if (columnIndex == -1) {
            return null;
        }
        this.resizingColumnIndex = columnIndex;
        return this.header.getColumnModel().getColumn(columnIndex);
    }

    private boolean isResizingArea(Point p, int column) {
        if (column == -1) {
            return false;
        }
        Rectangle r = this.header.getHeaderRect(column);
        r.grow(-3, 0);
        this.isResizingArea = !r.contains(p);
        return this.isResizingArea;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        int index = this.header.getColumnModel().getColumnIndexAtX(p.x);
        int col = this.header.columnAtPoint(e.getPoint());
        int sortCol = this.header.getTable().convertColumnIndexToModel(col);
        if (!this.isResizingArea(p, index)) {
            TableCellRenderer headerRenderer = this.table.getColumnModel().getColumn(index).getHeaderRenderer();
            if (!(headerRenderer instanceof SortButtonRenderer)) {
                return;
            }
            this.renderer = (SortButtonRenderer)headerRenderer;
            this.renderer.setPressedColumn(col);
            this.renderer.setSelectedColumn(col);
            this.header.repaint();
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean isAscent = 1 == this.renderer.getState(col);
            TableModel m = this.header.getTable().getModel();
            if (m instanceof TableSortInterface) {
                ((TableSortInterface)((Object)m)).sortByColumn(sortCol, isAscent);
            }
            this.isResizingArea = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isResizingArea) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }
}

