/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortButtonRenderer;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.TableSortInterface;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class HeaderListener
extends MouseAdapter {
    protected JTableHeader header;
    protected SortButtonRenderer renderer;
    private TableSortInterface sortInterface;

    public HeaderListener(JTableHeader header, SortButtonRenderer renderer) {
        this(header, renderer, null);
    }

    public HeaderListener(JTableHeader header, SortButtonRenderer renderer, TableSortInterface sortI) {
        this.header = header;
        this.renderer = renderer;
        this.sortInterface = sortI;
        JTable table = header.getTable();
        if (table instanceof InmTable) {
            int colcount = table.getColumnCount();
            for (int i = 0; i < colcount; ++i) {
                table.getColumnModel().getColumn(i).setHeaderRenderer(renderer);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.renderer.isEnabled()) {
            return;
        }
        int type = this.header.getCursor().getType();
        if (type != 10 && type != 11 && SwingUtilities.isLeftMouseButton(e)) {
            int col = this.header.columnAtPoint(e.getPoint());
            int sortCol = this.header.getTable().convertColumnIndexToModel(col);
            if (col < 0 || sortCol < 0) {
                return;
            }
            JTable table = this.header.getTable();
            TableCellRenderer tcr = table.getColumnModel().getColumn(col).getHeaderRenderer();
            if (!(tcr instanceof SortButtonRenderer)) {
                return;
            }
            SortButtonRenderer hr = (SortButtonRenderer)table.getColumnModel().getColumn(col).getHeaderRenderer();
            if (table instanceof InmTable && !((InmTable)table).isColumnSortable(col)) {
                return;
            }
            hr.setPressedColumn(col);
            hr.setSelectedColumn(col);
            this.header.repaint();
            if (table.isEditing()) {
                table.getCellEditor().stopCellEditing();
            }
            boolean isAscent = 1 == hr.getState(col);
            if (this.sortInterface != null) {
                this.sortInterface.sortByColumn(sortCol, isAscent);
            } else {
                TableModel m = this.header.getTable().getModel();
                if (m instanceof TableSortInterface) {
                    ((TableSortInterface)((Object)m)).sortByColumn(sortCol, isAscent);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.renderer.setPressedColumn(-1);
        this.header.repaint();
    }
}

