/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class MultiRowToolTip
extends JToolTip {
    private static final int _$135386 = 6;
    private static final int _$135387 = 4;
    private static final int _$135388 = 15;
    private FontMetrics fm = null;
    private String[] lines = null;

    public MultiRowToolTip() {
        Font font = (Font)UIManager.get("ToolTip.font");
        this.setFont(font);
    }

    @Override
    public void setTipText(String tipText) {
        super.setTipText(tipText);
        if (tipText == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(tipText, System.getProperty("line.separator"));
        int tokenCount = stringTokenizer.countTokens();
        this.lines = new String[tokenCount];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = stringTokenizer.nextToken();
        }
        int height = this.fm.getHeight() * this.lines.length;
        int width = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            if (width >= this.fm.stringWidth(this.lines[i])) continue;
            width = this.fm.stringWidth(this.lines[i]);
        }
        Dimension d = new Dimension(width + 6, height + 4);
        this.setPreferredSize(d);
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            super.setFont(font);
            BufferedImage image = new BufferedImage(10, 10, 2);
            Graphics g = ((Image)image).getGraphics();
            this.fm = g.getFontMetrics(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics scratchGraphics;
        Graphics graphics = scratchGraphics = g == null ? null : g.create();
        if (scratchGraphics != null) {
            try {
                Color background = this.getBackground();
                scratchGraphics.setColor(background);
                scratchGraphics.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
                Color foreground = this.getForeground();
                scratchGraphics.setColor(foreground);
                if (0 == this.lines.length) {
                    return;
                }
                int rowHeight = this.getHeight() / this.lines.length;
                for (int i = 0; i < this.lines.length; ++i) {
                    scratchGraphics.setColor(this.getTextColor(i + 1, this.lines[i]));
                    scratchGraphics.drawString(this.lines[i], 3, i * rowHeight + 15);
                }
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }

    protected Color getTextColor(int row, String data) {
        return this.getForeground();
    }
}

