/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class InmTridStateIcon
implements Icon,
UIResource,
Serializable {
    private byte iState = 1;
    public static final byte NONE_SELECT = 1;
    public static final byte PART_SELECT = 2;
    public static final byte ALL_SELECT = 3;
    public static final InmTridStateIcon ALL_SELECT_ICON = new InmTridStateIcon(3);
    public static final InmTridStateIcon NONE_SELECT_ICON = new InmTridStateIcon(1);
    public static final InmTridStateIcon PART_SELECT_ICON = new InmTridStateIcon(2);
    private ImageIcon imageIcon = null;
    private int iControlSize = 13;

    public InmTridStateIcon() {
        this.iState = 1;
    }

    public InmTridStateIcon(byte state) {
        this.iState = state;
    }

    protected int getControlSize() {
        return this.iControlSize;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean isEnabled = true;
        int controlSize = this.getControlSize();
        boolean isBorderPaintedFlat = true;
        if (c instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            isEnabled = model.isEnabled();
            isBorderPaintedFlat = cb.isBorderPaintedFlat();
        }
        if (isEnabled) {
            if (isBorderPaintedFlat) {
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.drawRect(x + 1, y, controlSize - 1, controlSize - 1);
            }
            if (2 == this.iState) {
                if (isBorderPaintedFlat) {
                    g.setColor(UIManager.getColor("controlShadow"));
                    g.fillRect(x + 2, y + 1, controlSize - 2, controlSize - 2);
                } else {
                    g.setColor(UIManager.getColor("controlShadow"));
                    g.fillRect(x, y, controlSize - 1, controlSize - 1);
                    this.drawPressed3DBorder(g, x, y, controlSize, controlSize);
                }
            } else if (!isBorderPaintedFlat) {
                this.drawFlush3DBorder(g, x, y, controlSize, controlSize);
            }
            g.setColor(UIManager.getColor("controlText"));
        } else {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawRect(x, y, controlSize - 1, controlSize - 1);
        }
        if (3 == this.iState || 2 == this.iState) {
            if (isBorderPaintedFlat) {
                ++x;
            }
            this.drawCheck(c, g, x, y);
        }
        if (null != this.getImageIcon()) {
            this.drawOpenFlagIcon(this.getImageIcon(), g, x, y);
        }
    }

    public void drawOpenFlagIcon(ImageIcon imageIcon, Graphics g, int x, int y) {
        g.drawImage(imageIcon.getImage(), x + this.getControlSize() + 5, y, null);
    }

    protected void drawCheck(Component c, Graphics g, int x, int y) {
        int controlSize = this.getControlSize();
        g.fillRect(x + 3, y + 5, 2, controlSize - 8);
        g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
        g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
    }

    @Override
    public int getIconWidth() {
        if (null != this.imageIcon) {
            return this.getControlSize() + this.imageIcon.getIconWidth() + 8;
        }
        return this.getControlSize();
    }

    @Override
    public int getIconHeight() {
        return this.getControlSize();
    }

    public void setState(byte iState) {
        this.iState = iState;
    }

    public void setControlSize(int iControlSize) {
        this.iControlSize = iControlSize;
    }

    void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(UIManager.getColor("controlLtHighlight"));
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(UIManager.getColor("control"));
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        this.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(UIManager.getColor("controlShadow"));
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }
}

