/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.View;

public class InmTextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private boolean bSameRowHeight = false;
    private static final String PROP_TABLE_ROW_HEIGHT = "_table_row_height_";
    private Color unselectedForeground;
    private Color unselectedBackground;

    public InmTextAreaCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    public void setSameRowHeight(boolean bSame) {
        this.bSameRowHeight = bSame;
    }

    public boolean isSameRowHeight() {
        return this.bSameRowHeight;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        this.setUI(new InmBasicTextAreaUI());
        this.invalidate();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color back;
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setValue(value);
        int height = this.getPreferredSize().height;
        HashMap<RowColumn, Integer> heightMap = (HashMap<RowColumn, Integer>)table.getClientProperty(PROP_TABLE_ROW_HEIGHT);
        if (heightMap == null) {
            heightMap = new HashMap<RowColumn, Integer>();
            table.putClientProperty(PROP_TABLE_ROW_HEIGHT, heightMap);
        }
        heightMap.put(new RowColumn(row, column), new Integer(height));
        int oldH = table.getRowHeight(row);
        int newH = 22;
        for (int c = table.getColumnCount() - 1; c >= 0; --c) {
            Object _height = heightMap.get(new RowColumn(row, c));
            if (_height == null) continue;
            newH = Math.max(newH, (Integer)_height);
        }
        if (newH != oldH) {
            if (!this.bSameRowHeight) {
                table.setRowHeight(row, newH);
            } else {
                table.setRowHeight(newH);
            }
        }
        boolean colorMatch = (back = this.getBackground()) != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    class RowColumn {
        int row = -1;
        int column = -1;

        public RowColumn(int _row, int _column) {
            this.row = _row;
            this.column = _column;
        }

        public int hashCode() {
            return this.row * this.column;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RowColumn)) {
                return false;
            }
            RowColumn o = (RowColumn)obj;
            return this.row == o.row && this.column == o.column;
        }
    }

    class InmBasicTextAreaUI
    extends BasicTextAreaUI {
        InmBasicTextAreaUI() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension getPreferredSize(JComponent c) {
            Document doc = this.getComponent().getDocument();
            Insets i = c.getInsets();
            Dimension d = c.getSize();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            View rootView = this.getRootView(null);
            try {
                if (d.width > i.left + i.right && d.height > i.top + i.bottom) {
                    rootView.setSize(d.width - i.left - i.right, d.height - i.top - i.bottom);
                }
                d.width = (int)Math.min((long)rootView.getPreferredSpan(0) + (long)i.left + (long)i.right, Integer.MAX_VALUE);
                d.height = (int)Math.min((long)rootView.getPreferredSpan(1) + (long)i.top + (long)i.bottom, Integer.MAX_VALUE);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
            return d;
        }
    }
}

