/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.MultiRowToolTip;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortableTableModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class InmTable
extends JTable {
    private static final long serialVersionUID = 6908812843480640746L;
    public static final String RECORD_LABEL = InmUtilResourceManager.getString("recordInfoLabel");
    public static final int MIN_ColumnWidth = 75;
    public static final int ADDITIONAL_WIDTH = 10;
    private static final int ROW_HEIGHT = 22;
    public static final int AUTO_RESIZE_HUAWEI_MODE = 0;
    public ArrayList m_editCellList = new ArrayList();
    private boolean bNeedSetMinWidth = true;
    private HashMap colSupportAttMap = new HashMap();
    private boolean customizable = true;
    private boolean customUnResizeble = false;
    private boolean canRename = false;
    public static final int CAL_BY_CONTENT = 0;
    public static final int CAL_BY_HEADER_CONTENT = 1;
    private boolean showCustomPopupMenu = true;
    private JLabel recordInfoLabel = new JLabel();
    public static final String TABLE_PROPERTY_CHANGE = "TABLE_CHANGE";
    private boolean isSortable = false;
    public static final int SORT_ICOM_WIDTH = 11;
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() != 4) {
                return;
            }
            int row = InmTable.this.rowAtPoint(e.getPoint());
            int col = InmTable.this.columnAtPoint(e.getPoint());
            if (row < 0 || col < 0 || row >= InmTable.this.getRowCount() || col >= InmTable.this.getColumnCount()) {
                return;
            }
            if (InmTable.this.isRowSelected(row)) {
                if (!InmTable.this.getCellSelectionEnabled()) {
                    return;
                }
                if (InmTable.this.isColumnSelected(col)) {
                    return;
                }
            }
            InmTable.this.cancelEditing();
            InmTable.this.setRowSelectionInterval(row, row);
            InmTable.this.setColumnSelectionInterval(col, col);
        }
    };
    private ListSelectionListener listSelectionListner = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!InmTable.this.getAutoscrolls()) {
                InmTable.this.setAutoscrolls(true);
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            InmTable.this.refreshRecordInfo();
        }
    };
    private TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            int type = e.getType();
            if (type == 1 || type == 0 || type == -1) {
                InmTable.this.refreshRecordInfo();
            }
        }
    };
    private boolean hasNotified = false;
    private Vector unsortableColumns = new Vector();
    private Hashtable toolTipHa = new Hashtable();

    public InmTable() {
        this(null, null, null);
    }

    public InmTable(TableModel model) {
        this(model, null, null);
    }

    public InmTable(TableModel model, String[] invisibleColumn) {
        this();
    }

    public InmTable(final Object[][] rowData, final String[] columnNames, boolean isSetup) {
        this(new AbstractTableModel(){
            private static final long serialVersionUID = 6494519983793606014L;

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                return rowData.length;
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return rowData[row][col];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                rowData[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        });
    }

    public InmTable(Object[][] data, String[] columnName) {
        this(data, columnName, true);
    }

    public InmTable(TableModel model, boolean bSetMinWidth) {
        this(model);
        this.bNeedSetMinWidth = bSetMinWidth;
        if (this.bNeedSetMinWidth) {
            this.setMinColumnWidth();
        }
    }

    public InmTable(TableModel model, int minColumnWidth) {
        this(model);
        this.setMinColumnWidth(minColumnWidth);
    }

    public InmTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        this.setMinColumnWidth(75);
        this.setRowHeight(22);
        this.addMouseListener(this.mouseListener);
        this.getSelectionModel().addListSelectionListener(this.listSelectionListner);
        this.getModel().addTableModelListener(this.tableModelListener);
    }

    public void removeSelectionModelListener() {
        this.getSelectionModel().removeListSelectionListener(this.listSelectionListner);
    }

    public void removeTableModelListener() {
        this.getModel().removeTableModelListener(this.tableModelListener);
    }

    public JMenuItem[] getOtherHeaderMenu() {
        return null;
    }

    public void appendColSupportAttr(HashMap hm) {
        this.colSupportAttMap.putAll(hm);
    }

    public void setColSupportAttrMap(HashMap hm) {
        this.colSupportAttMap.clear();
        this.colSupportAttMap.putAll(hm);
    }

    public HashMap getColSupportAttrMap() {
        return this.colSupportAttMap;
    }

    public void setCanRename(boolean rename) {
        this.canRename = rename;
    }

    public boolean isCanRename() {
        return this.canRename;
    }

    public void setCustomizable(boolean b) {
        if (this.customizable == b) {
            return;
        }
        this.customizable = b;
    }

    public void setCustomUnResizebleTable(boolean b) {
        this.customUnResizeble = b;
    }

    boolean getCustomUnResizebleTable() {
        return this.customUnResizeble;
    }

    public void setShowCustomPopupMenu(boolean b) {
        this.showCustomPopupMenu = b;
    }

    public boolean isCustomizable() {
        return this.customizable;
    }

    public boolean isShowCustomPopupMenu() {
        return this.showCustomPopupMenu;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.hasNotified && this.getParent() instanceof JViewport) {
            this.hasNotified = true;
            if (this.autoResizeMode == 0) {
                this.sizeColumnsToFit(-1);
            }
        }
    }

    public int columnHeaderWidth(TableColumn col) {
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = new DefaultTableCellRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this, col.getHeaderValue(), false, false, 0, 0);
        int result = comp.getPreferredSize().width;
        result += 2 * this.columnModel.getColumnMargin();
        if ((result += 10) < 75 && this.bNeedSetMinWidth) {
            result = 75;
        }
        return result;
    }

    public void addEditCell(int row) {
        Integer cell = row;
        int pos = Collections.binarySearch(this.m_editCellList, cell);
        if (pos < 0) {
            this.m_editCellList.add(-1 - pos, cell);
        }
    }

    public void clearEditCell() {
        this.m_editCellList.clear();
    }

    public int getEditCell(int index) {
        return (Integer)this.m_editCellList.get(index);
    }

    public void addColumnSortAction() {
        this.unsortableColumns.clear();
    }

    public void addColumnSortAction(int column) {
        int modelIndex = this.columnModel.getColumn(column).getModelIndex();
        this.unsortableColumns.remove((Object)modelIndex);
    }

    public void setSortable(boolean sortable) {
        this.isSortable = sortable;
    }

    public boolean isSortable() {
        return this.isSortable;
    }

    public boolean isColumnSortable(int column) {
        if (this.unsortableColumns.isEmpty()) {
            return true;
        }
        int modelIndex = this.columnModel.getColumn(column).getModelIndex();
        return !this.unsortableColumns.contains(modelIndex);
    }

    public void removeSortAction(int column) {
        TableColumn col = this.columnModel.getColumn(column);
        if (col != null) {
            this.removeSortAction(col);
        }
    }

    public void removeSortAction(TableColumn column) {
        int modelIndex = column.getModelIndex();
        Integer _mi = modelIndex;
        if (!this.unsortableColumns.contains(_mi)) {
            this.unsortableColumns.add(_mi);
        }
    }

    public void setMinColumnWidth() {
        int minColumnWidth = 40;
        this.setMinColumnWidth(40);
    }

    public void setMinColumnWidth(int minColumnWidth) {
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn column = null;
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            column = columnModel.getColumn(i);
            column.setMinWidth(minColumnWidth);
        }
    }

    public void setHeaderWidth(int size) {
        int t = this.getColumnCount();
        if (t == 0) {
            return;
        }
        int w = size / t;
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn column = null;
        for (int i = 0; i < t; ++i) {
            column = columnModel.getColumn(i);
            column.setPreferredWidth(w);
        }
    }

    public void cancelEditing() {
        TableCellEditor ce = this.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    public boolean isSelfAdaptionTableContent() {
        return true;
    }

    public boolean isUseAdapdation() {
        return true;
    }

    public MouseAdapter getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            this.cancelEditing();
        }
        super.columnMarginChanged(e);
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new SortableTableModel();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = -3278636478809276724L;

            @Override
            public JToolTip createToolTip() {
                MultiRowToolTip tip = new MultiRowToolTip();
                tip.setComponent(this);
                return tip;
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                String tip = "";
                if (InmTable.this.toolTipHa.isEmpty()) {
                    tip = super.getToolTipText(event);
                } else {
                    Object o;
                    tip = super.getToolTipText(event);
                    if (null != tip && InmTable.this.toolTipHa.containsKey(tip) && (o = InmTable.this.toolTipHa.get(tip)) != null) {
                        tip = (String)o;
                    }
                }
                return tip;
            }
        };
    }

    public void setColToolTip(Hashtable haTable) {
        this.toolTipHa = haTable;
    }

    public void tableColumnChange() {
        this.firePropertyChange(TABLE_PROPERTY_CHANGE, null, null);
    }

    public void refreshRecordInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.refreshRecord();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InmTable.this.refreshRecord();
                }
            });
        }
    }

    private void refreshRecord() {
        int selectedRowCount = this.getSelectedRowCount();
        int count = this.getRowCount();
        String[] param = new String[]{String.valueOf(count), String.valueOf(selectedRowCount)};
        String recordInfo = MessageFormat.format(RECORD_LABEL, param);
        if (this.recordInfoLabel != null) {
            this.recordInfoLabel.setText(recordInfo);
        }
    }

    public JLabel getRecordInfoLabel() {
        this.refreshRecordInfo();
        return this.recordInfoLabel;
    }
}

