/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class InmScreenToolKit {
    private static MouseListener glassMouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    };
    private static final KeyStroke ENTER_KEYSTROKE = KeyStroke.getKeyStroke(10, 0, false);
    private static final KeyStroke ESCAPE_KEYSTROKE = KeyStroke.getKeyStroke(27, 0, false);
    public static KeyAdapter shieldKeyMap = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }
    };

    private InmScreenToolKit() {
    }

    public static void centerLocateToScreen(Component comptoLocate) {
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dComponent = comptoLocate.getSize();
        Point pos = new Point();
        pos.x = (int)(dScreen.getWidth() / 2.0 - dComponent.getWidth() / 2.0);
        pos.y = (int)(dScreen.getHeight() / 2.0 - dComponent.getHeight() / 2.0);
        comptoLocate.setLocation(pos);
    }

    public static void adjustToScreen(Container comptoSize) {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        comptoSize.setSize(screenWidth, screenHeight - 30);
        comptoSize.setLocation(0, 0);
    }

    public static int getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static int getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static int getMaxPopupMenuRowCount() {
        return (InmScreenToolKit.getScreenHeight() - 50) / 23 - 1;
    }

    public static void showPopupMenu(JPopupMenu popupMenu, MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        popupMenu.pack();
        popupMenu.validate();
        Dimension dim = popupMenu.getSize();
        int width = dim.width;
        int height = dim.height;
        if (width == 0 || height == 0) {
            dim = popupMenu.getPreferredSize();
            width = dim.width;
            height = dim.height;
        }
        Component comp = e.getComponent();
        Point compAbsLoc = comp.getLocationOnScreen();
        Component mainFrame = null;
        mainFrame = comp;
        while (mainFrame.getParent() != null) {
            mainFrame = mainFrame.getParent();
        }
        Point mainAbsLoc = mainFrame.getLocationOnScreen();
        Dimension mainFrameDim = mainFrame.getSize();
        Insets ins_Popup = new Insets(0, 0, 0, 0);
        if (popupMenu.isBorderPainted()) {
            ins_Popup = popupMenu.getBorder().getBorderInsets(popupMenu);
        }
        Insets ins_MainFrame = ((Container)mainFrame).getInsets();
        int paneOffset = 1;
        int bottomInset = ins_Popup.bottom + ins_MainFrame.bottom + paneOffset;
        int rightInset = ins_Popup.right + ins_MainFrame.right + paneOffset;
        if (compAbsLoc.y + y + height + bottomInset > mainAbsLoc.y + mainFrameDim.height) {
            y = mainAbsLoc.y + mainFrameDim.height - height - bottomInset - compAbsLoc.y;
        }
        if (compAbsLoc.x + x + width + rightInset > mainAbsLoc.x + mainFrameDim.width) {
            x = mainAbsLoc.x + mainFrameDim.width - width - rightInset - compAbsLoc.x;
        }
        popupMenu.show(e.getComponent(), x, y);
    }

    public static Point getPopupMenuShowupPosition(Component invoker, JPopupMenu popupMenu, int xpos, int ypos) {
        Point _location = invoker.getLocationOnScreen();
        int x = _location.x + xpos;
        int y = _location.y + ypos;
        int width = popupMenu.getPreferredSize().width;
        int height = popupMenu.getPreferredSize().height;
        if (x + width > InmScreenToolKit.getScreenWidth()) {
            xpos -= width;
        }
        if (xpos + _location.x < 0) {
            xpos = -_location.x;
        }
        if (y + height > InmScreenToolKit.getScreenHeight() - 30) {
            ypos -= height;
        }
        if (30 > ypos + _location.y) {
            ypos = 30 - _location.y;
        }
        return new Point(xpos, ypos);
    }

    public static void setComponentCursorBusy(final RootPaneContainer rootPaneContainer, final boolean isBusy) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (isBusy) {
                rootPaneContainer.getGlassPane().setVisible(true);
                rootPaneContainer.getGlassPane().addMouseListener(glassMouseListener);
                rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            } else {
                rootPaneContainer.getGlassPane().setVisible(false);
                rootPaneContainer.getGlassPane().removeMouseListener(glassMouseListener);
                rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (isBusy) {
                        rootPaneContainer.getGlassPane().setVisible(true);
                        rootPaneContainer.getGlassPane().addMouseListener(glassMouseListener);
                        rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                    } else {
                        rootPaneContainer.getGlassPane().setVisible(false);
                        rootPaneContainer.getGlassPane().removeMouseListener(glassMouseListener);
                        rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
    }

    public static void setFrameCursorBusy(final RootPaneContainer rootPaneContainer, final boolean isBusy) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (isBusy) {
                rootPaneContainer.getGlassPane().setVisible(true);
                rootPaneContainer.getGlassPane().addMouseListener(glassMouseListener);
                rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            } else {
                rootPaneContainer.getGlassPane().setVisible(false);
                rootPaneContainer.getGlassPane().removeMouseListener(glassMouseListener);
                rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (isBusy) {
                        rootPaneContainer.getGlassPane().setVisible(true);
                        rootPaneContainer.getGlassPane().addMouseListener(glassMouseListener);
                        rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                    } else {
                        rootPaneContainer.getGlassPane().setVisible(false);
                        rootPaneContainer.getGlassPane().removeMouseListener(glassMouseListener);
                        rootPaneContainer.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
    }

    public static void registerEnterAction(Container ancestor, AbstractButton button, int focusType) {
        InmScreenToolKit.registerKeyAction(ancestor, button, focusType, ENTER_KEYSTROKE);
    }

    public static void registerEscapeAction(Container ancestor, AbstractButton button, int focusType) {
        InmScreenToolKit.registerKeyAction(ancestor, button, focusType, ESCAPE_KEYSTROKE);
    }

    public static void registerKeyAction(Container ancestor, AbstractButton button, int focusType, String keyStroke) {
        InmScreenToolKit.registerKeyAction(ancestor, button, focusType, KeyStroke.getKeyStroke(keyStroke));
    }

    public static void registerKeyAction(Container ancestor, AbstractButton button, int focusType, KeyStroke keyStroke) {
        InputMap inputmap = null;
        ActionMap actionmap = null;
        if (focusType == 0 || focusType == 2) {
            inputmap = button.getInputMap(focusType);
            actionmap = button.getActionMap();
        } else if (focusType == 1) {
            if (ancestor instanceof JComponent) {
                inputmap = ((JComponent)ancestor).getInputMap(focusType);
                actionmap = ((JComponent)ancestor).getActionMap();
            } else if (ancestor instanceof RootPaneContainer) {
                JRootPane rootpane = ((RootPaneContainer)((Object)ancestor)).getRootPane();
                inputmap = rootpane.getInputMap(focusType);
                actionmap = rootpane.getActionMap();
            }
        }
        if (inputmap != null && actionmap != null) {
            inputmap.put(keyStroke, keyStroke);
            actionmap.put(keyStroke, InmScreenToolKit.createKeyboardAction(button));
        }
    }

    private static Action createKeyboardAction(final AbstractButton btn) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btn.doClick();
            }
        };
    }

    public static void setSameWidthOf(JComponent[] comp) {
        if (comp == null || comp.length == 0) {
            return;
        }
        int maxWidth = 0;
        int width = 0;
        for (int i = comp.length - 1; i >= 0; --i) {
            width = comp[i].getPreferredSize().width;
            maxWidth = Math.max(maxWidth, width);
        }
        Dimension dim = null;
        for (int i = comp.length - 1; i >= 0; --i) {
            dim = new Dimension(maxWidth, comp[i].getPreferredSize().height);
            comp[i].setPreferredSize(dim);
        }
    }

    public static void setSameWidthOf(JComponent[] comp, int height) {
        if (comp == null || comp.length == 0) {
            return;
        }
        int maxWidth = 0;
        int width = 0;
        for (int i = comp.length - 1; i >= 0; --i) {
            width = comp[i].getPreferredSize().width;
            maxWidth = Math.max(maxWidth, width);
        }
        Dimension dim = new Dimension(maxWidth, height);
        for (int i = comp.length - 1; i >= 0; --i) {
            comp[i].setPreferredSize(dim);
        }
    }

    public static void setSameHeightOf(JComponent[] comp) {
        if (comp == null || comp.length == 0) {
            return;
        }
        int maxHeight = 0;
        int height = 0;
        for (int i = comp.length - 1; i >= 0; --i) {
            height = comp[i].getPreferredSize().height;
            maxHeight = Math.max(maxHeight, height);
        }
        Dimension dim = null;
        for (int i = comp.length - 1; i >= 0; --i) {
            dim = new Dimension(comp[i].getPreferredSize().width, maxHeight);
            comp[i].setPreferredSize(dim);
        }
    }

    public static void setSameHeightOf(JComponent[] comp, int width) {
        if (comp == null || comp.length == 0) {
            return;
        }
        int maxHeight = 0;
        int height = 0;
        for (int i = comp.length - 1; i >= 0; --i) {
            height = comp[i].getPreferredSize().height;
            maxHeight = Math.max(maxHeight, height);
        }
        Dimension dim = new Dimension(width, maxHeight);
        for (int i = comp.length - 1; i >= 0; --i) {
            comp[i].setPreferredSize(dim);
        }
    }

    public static void setSameSizeOf(JComponent[] comp) {
        if (comp == null || comp.length == 0) {
            return;
        }
        int maxWidth = 0;
        int maxHeight = 0;
        int width = 0;
        int height = 0;
        for (int i = comp.length - 1; i >= 0; --i) {
            width = comp[i].getPreferredSize().width;
            height = comp[i].getPreferredSize().height;
            maxWidth = Math.max(maxWidth, width);
            maxHeight = Math.max(maxHeight, height);
        }
        Dimension dim = new Dimension(maxWidth, maxHeight);
        for (int i = comp.length - 1; i >= 0; --i) {
            comp[i].setPreferredSize(dim);
        }
    }

    public static class SPLITPANE_SET {
        public static final int SPLIT_WIDTH = 3;
        public static final int BIG_WIDTH = 8;
        public static final boolean bSupport = false;
    }
}

