/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmAreaDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmFileDescObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;

public class InmProfileFactory {
    public static final String ENGLISH_LANGUAGE_ID = "C";
    public static final String CHINESE_LANGUAGE_ID = "zh";
    static final String CUSTOMIZE_PATH = "style" + File.separator + "users";
    static final String COMMON_PATH = "common";
    static final String COMMON_CUSTOMIZE_PATH = "allusers";
    static String LanguageID = null;
    private static boolean isReleaseEnv = true;
    private static String debugPath = null;
    private static Hashtable fileTable;
    static final int POSITION_TYPE_ALLUSER = 0;
    static final int POSITION_TYPE_USER = 1;
    static final int POSITION_TYPE_JAR = 2;
    private static Hashtable commonFileTable;
    private static String CommonCustomPath;
    private static String developPath;

    private InmProfileFactory() {
    }

    public static String getLanguageID() {
        return LanguageID;
    }

    private static void initLanguageID() {
        LanguageID = Locale.getDefault().getLanguage();
        LanguageID = LanguageID.equalsIgnoreCase(CHINESE_LANGUAGE_ID) ? CHINESE_LANGUAGE_ID : ENGLISH_LANGUAGE_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InmFileDescObject getCommonFileDescObject(String filename) {
        Hashtable hashtable = commonFileTable;
        synchronized (hashtable) {
            InmFileDescObject fileObject = (InmFileDescObject)commonFileTable.get(filename);
            if (null != fileObject) {
                return fileObject;
            }
            String relevantFilename = COMMON_PATH + File.separator + filename;
            InputStream in = InmProfileFactory._getResourceInputStream(relevantFilename);
            fileObject = new InmFileDescObject(in, filename, false);
            if (fileObject.isInitializeSuccess()) {
                commonFileTable.put(filename, fileObject);
                return fileObject;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCommonFileDescObject(String fileName) {
        if (fileName != null) {
            Hashtable hashtable = commonFileTable;
            synchronized (hashtable) {
                commonFileTable.remove(fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFileDescObject(String fileName) {
        if (fileName != null) {
            Hashtable hashtable = fileTable;
            synchronized (hashtable) {
                fileTable.remove(fileName);
            }
        }
    }

    public static void removeAllFileDescObject() {
        commonFileTable.clear();
        fileTable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InmFileDescObject getFileDescObject(String fileName) {
        Hashtable hashtable = fileTable;
        synchronized (hashtable) {
            InmFileDescObject fileObject = (InmFileDescObject)fileTable.get(fileName);
            if (fileObject != null) {
                return fileObject;
            }
            String relevantFilename = fileName;
            InputStream in = InmProfileFactory._getResourceInputStream(relevantFilename);
            fileObject = new InmFileDescObject(in, fileName, true);
            if (fileObject.isInitializeSuccess()) {
                fileObject.setPositionType(InmProfileFactory.getPositionType(relevantFilename));
                fileTable.put(fileName, fileObject);
                return fileObject;
            }
            return null;
        }
    }

    public static InmFileDescObject getFileDescObjectFromUser(String fileName) {
        boolean isLanguageID = false;
        InmFileDescObject fileObject = null;
        if (fileName.indexOf(LanguageID) >= 0) {
            isLanguageID = true;
        }
        String currentFilename = fileName.substring(fileName.indexOf(File.separator) + 1, fileName.length());
        InputStream in = InmProfileFactory._getResourceInputStreamFormUser(fileName);
        fileObject = isLanguageID ? new InmFileDescObject(in, currentFilename, true) : new InmFileDescObject(in, currentFilename, false);
        if (fileObject.isInitializeSuccess()) {
            fileObject.setPositionType(1);
            return fileObject;
        }
        fileObject = null;
        return null;
    }

    public static InmFileDescObject getFileDescObjectFromJar(String fileName) {
        boolean isLanguageID = false;
        InmFileDescObject fileObject = null;
        if (fileName.indexOf(LanguageID) >= 0) {
            isLanguageID = true;
        }
        String currentFilename = fileName.substring(fileName.indexOf(File.separator) + 1, fileName.length());
        InputStream in = InmProfileFactory._getResourceInputStreamFormJar(fileName);
        fileObject = isLanguageID ? new InmFileDescObject(in, currentFilename, true) : new InmFileDescObject(in, currentFilename, false);
        if (fileObject.isInitializeSuccess()) {
            fileObject.setPositionType(2);
            return fileObject;
        }
        fileObject = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InmFileDescObject getFileDescObjectEx(String fileName) {
        Hashtable hashtable = fileTable;
        synchronized (hashtable) {
            return (InmFileDescObject)fileTable.get(fileName);
        }
    }

    public static String getCommonStringProperty(String fileName, String areaDescName, String descName, String propertyName) {
        InmFileDescObject file = InmProfileFactory.getCommonFileDescObject(fileName);
        if (file == null) {
            return null;
        }
        String relevantFilename = COMMON_PATH + File.separator + fileName;
        return InmProfileFactory.getProperty(file, areaDescName, descName, propertyName, relevantFilename);
    }

    public static int writeBackCommonStringProperty(String fileName, String areaDescName, String descName, String propertyName, String propertyValue) {
        InmFileDescObject file = InmProfileFactory.getCommonFileDescObject(fileName);
        if (file == null) {
            return 8;
        }
        return InmProfileFactory.writeProperty(file, areaDescName, descName, propertyName, propertyValue);
    }

    public static String getStringProperty(String fileName, String areaDescName, String descName, String propertyName) {
        InmFileDescObject file = InmProfileFactory.getFileDescObject(fileName);
        if (file == null) {
            return null;
        }
        String relevantFilename = LanguageID + File.separator + fileName;
        return InmProfileFactory.getProperty(file, areaDescName, descName, propertyName, relevantFilename);
    }

    public static int writeBackStringProperty(String fileName, String areaDescName, String descName, String propertyName, String propertyValue) {
        InmFileDescObject file = InmProfileFactory.getFileDescObject(fileName);
        if (file == null) {
            return 8;
        }
        return InmProfileFactory.writeProperty(file, areaDescName, descName, propertyName, propertyValue);
    }

    public static int writeBackAbsStringProperty(String fileName, String areaDescName, String descName, String propertyName, String propertyValue) {
        InmFileDescObject file = InmProfileFactory.getAbsFileDescObject(fileName);
        if (file == null) {
            return 8;
        }
        return InmProfileFactory.writeProperty(file, areaDescName, descName, propertyName, propertyValue);
    }

    private static String getProperty(InmFileDescObject file, String areaDescName, String descName, String propertyName, String fileName) {
        InmAreaDescObject areaObject = file.getAreaDescObject(areaDescName);
        if (null == areaObject) {
            String property = InmProfileFactory.getPropertyAgain(file, areaDescName, descName, propertyName, fileName);
            return property;
        }
        return areaObject.getStringPropertyvalue(descName, propertyName);
    }

    private static String getPropertyAgain(InmFileDescObject file, String areaDescName, String descName, String propertyName, String fileName) {
        if (null == file) {
            return null;
        }
        String propertyValue = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" fileName = " + fileName);
        buffer.append(" areaName = " + areaDescName);
        buffer.append(" descName = " + descName);
        buffer.append(" propertyName = " + propertyName);
        if (null != file.getAbsFileName()) {
            return null;
        }
        InmFileDescObject fileObject = InmProfileFactory.getFileDescObjectFromUser(fileName);
        if (null == fileObject) {
            InmFileDescObject fileObject1 = InmProfileFactory.getFileDescObjectFromJar(fileName);
            if (null == fileObject1) {
                return null;
            }
            InmAreaDescObject areaObject = fileObject1.getAreaDescObjectEX(areaDescName, false);
            if (null == areaObject) {
                return null;
            }
            propertyValue = areaObject.getStringPropertyvalue(descName, propertyName);
        } else {
            InmAreaDescObject areaObject = fileObject.getAreaDescObjectEX(areaDescName, false);
            if (null == areaObject) {
                InmFileDescObject fileObject2 = InmProfileFactory.getFileDescObjectFromJar(fileName);
                if (null == fileObject2) {
                    return null;
                }
                InmAreaDescObject areaObject2 = fileObject2.getAreaDescObject(areaDescName, false);
                if (null == areaObject2) {
                    return null;
                }
                propertyValue = areaObject2.getStringPropertyvalue(descName, propertyName);
            } else {
                propertyValue = areaObject.getStringPropertyvalue(descName, propertyName);
                if (null == propertyValue) {
                    InmFileDescObject fileObject2 = InmProfileFactory.getFileDescObjectFromJar(fileName);
                    if (null == fileObject2) {
                        return null;
                    }
                    InmAreaDescObject areaObject2 = fileObject2.getAreaDescObject(areaDescName, false);
                    if (null == areaObject2) {
                        return null;
                    }
                    propertyValue = areaObject2.getStringPropertyvalue(descName, propertyName);
                }
            }
        }
        return propertyValue;
    }

    private static int writeProperty(InmFileDescObject file, String areaDescName, String descName, String propertyName, String propertyValue) {
        InmAreaDescObject areaObject = file.getAreaDescObject(areaDescName);
        if (null == areaObject) {
            areaObject = new InmAreaDescObject(file);
            Vector<String> areaInfo = new Vector<String>();
            areaInfo.addElement(descName);
            areaObject.initialize("[" + areaDescName + "]", areaInfo, true);
            InmDescObject descObject = new InmDescObject();
            descObject.initialize(areaObject, descName + "=" + propertyName + "(" + propertyValue + ")");
            return file.writeDescObject(descObject, true);
        }
        InmDescObject descObject = areaObject.getDescObject(descName);
        if (descObject == null) {
            descObject = new InmDescObject();
            descObject.initialize(areaObject, descName + "=" + propertyName + "(" + propertyValue + ")");
            return file.writeDescObject(descObject, true);
        }
        descObject.setPropertyValue(propertyName, propertyValue);
        return file.writeDescObject(descObject, true);
    }

    public static String getPath() {
        return System.getProperty("user.dir");
    }

    public static String getParentDirectory(String fullPathName) {
        int posU;
        int posS = fullPathName.lastIndexOf("/");
        int pos = Math.max(posS, posU = fullPathName.lastIndexOf(File.separator));
        if (pos < 0 || pos == 0 && fullPathName.length() == 1) {
            return null;
        }
        if (pos == 0) {
            return fullPathName.substring(0, 1);
        }
        return fullPathName.substring(0, pos);
    }

    public static void main(String[] args) {
    }

    public static String getGrandParentdirectory(String fullPathName) {
        String pathName = InmProfileFactory.getParentDirectory(fullPathName);
        if (pathName != null) {
            pathName = InmProfileFactory.getParentDirectory(pathName);
        }
        return pathName;
    }

    private static String getCommonCustomPath() {
        if (CommonCustomPath == null) {
            CommonCustomPath = InmProfileFactory.getPath() + File.separator + CUSTOMIZE_PATH + File.separator + COMMON_CUSTOMIZE_PATH;
        }
        return CommonCustomPath;
    }

    private static String getUserCustomPath() {
        try {
            String username = "user";
            StringBuffer currentUserPath = new StringBuffer(InmProfileFactory.getPath());
            currentUserPath.append(File.separator).append(CUSTOMIZE_PATH).append(File.separator).append(username);
            return currentUserPath.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static String getDevelopPath() {
        if (developPath == null) {
            developPath = TECommonUtil.getAppletPath() + "com/huawei/nglct/otdr/appletgraph/locale/";
        }
        return developPath;
    }

    public static InputStream getCommonResourceInputStream(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        return InmProfileFactory._getResourceInputStream(COMMON_PATH + File.separator + filename);
    }

    private static InputStream _getResourceInputStream(String relevantFilepath) {
        URL url = InmProfileFactory._getResourceURL(relevantFilepath);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (Exception ex) {
            TEAppletLogMgr.error("InmProfileFactory._getResourceInputStream() Exception!", ex);
            return null;
        }
    }

    private static InputStream _getResourceInputStreamFormUser(String relevantFilepath) {
        URL url = InmProfileFactory._getResourceURLByType(relevantFilepath, 1);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (Exception ex) {
            TEAppletLogMgr.error("InmProfileFactory._getResourceInputStreamFormUser() Exception!", ex);
            return null;
        }
    }

    private static InputStream _getResourceInputStreamFormJar(String relevantFilepath) {
        URL url = InmProfileFactory._getResourceURLByType(relevantFilepath, 2);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (Exception ex) {
            TEAppletLogMgr.error("InmProfileFactory._getResourceInputStreamFormJar() Exception!", ex);
            return null;
        }
    }

    public static URL getCommonResourceURL(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        return InmProfileFactory._getResourceURL(COMMON_PATH + File.separator + filename);
    }

    public static URL getResourceURL(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        return InmProfileFactory._getResourceURL(filename);
    }

    public static InputStream getResourceInputStream(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        return InmProfileFactory._getResourceInputStream(LanguageID + File.separator + filename);
    }

    private static URL _getResourceURL(String relevantFilepath) {
        String newstr = relevantFilepath;
        if (TECommonUtil.isDebug) {
            newstr = InmProfileFactory.getDebugPath() + relevantFilepath;
            File f = new File(newstr);
            if (f.exists() && f.isFile()) {
                try {
                    return f.toURL();
                }
                catch (Exception ex) {
                    TEAppletLogMgr.error("InmProfileFactory._getResourceURL() fail!", ex);
                    return null;
                }
            }
            return null;
        }
        newstr = newstr.replace("\\", "/");
        URL url0 = null;
        ClassLoader loader = null;
        try {
            loader = InmProfileFactory.class.getClassLoader();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (loader != null) {
            url0 = loader.getResource(newstr);
        }
        if (url0 == null) {
            System.out.println("Failed getResource URL from jar file. " + newstr);
        }
        return url0;
    }

    private static String getDebugPath() {
        if (null == debugPath) {
            debugPath = System.getProperty("user.dir");
            debugPath = debugPath + File.separator + "src/com/huawei/nglct/otdr/appletgraph/locale/";
        }
        return debugPath;
    }

    private static URL _getResourceURLByType(String relevantFilepath, int type) {
        return null;
    }

    private static File getCustomizedFile(String relevantFilename) {
        String customFilename = InmProfileFactory.getCommonCustomPath() + File.separator + relevantFilename;
        File file = new File(customFilename);
        if (file.exists()) {
            return file;
        }
        String userPath = InmProfileFactory.getUserCustomPath();
        if (userPath != null) {
            String userCustomFilename = userPath + File.separator + relevantFilename;
            File userFile = new File(userCustomFilename);
            return userFile;
        }
        return file;
    }

    public static String getUsersCustomPath(String username) {
        try {
            StringBuffer currentUserPath = new StringBuffer(InmProfileFactory.getPath());
            currentUserPath.append(File.separator).append(CUSTOMIZE_PATH).append(File.separator).append(username);
            return currentUserPath.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static File getCustomizedFile(String relevantFilename, boolean beCommon) {
        String filename = beCommon ? COMMON_PATH : LanguageID;
        filename = filename + File.separator + relevantFilename;
        return InmProfileFactory.getCustomizedFile(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String srcPath, String destFile, boolean beCommon) throws IOException {
        IOException ioe = null;
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            boolean delete;
            input = new FileInputStream(srcPath);
            File destF = InmProfileFactory.getCustomizedFile(destFile, beCommon);
            if (destF.exists() && !(delete = destF.delete())) {
                return;
            }
            boolean mkdirs = destF.getParentFile().mkdirs();
            if (!mkdirs) {
                return;
            }
            boolean createNewFile = destF.createNewFile();
            if (!createNewFile) {
                return;
            }
            output = new FileOutputStream(destF);
            byte[] buffer = new byte[32768];
            while ((bytesRead = input.read(buffer, 0, buffer.length)) > 0) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static void deleteDirectory(File f) throws Exception {
        if (f.exists() && f.isDirectory()) {
            File[] childrenF = f.listFiles();
            for (int i = 0; i < childrenF.length; ++i) {
                InmProfileFactory.deleteDirectory(childrenF[i]);
            }
        }
    }

    public static boolean deleteUsersCustomDirectory(String userName) {
        String userCustomPath = InmProfileFactory.getUsersCustomPath(userName);
        if (userCustomPath != null) {
            try {
                File customFile = new File(userCustomPath);
                if (customFile.exists()) {
                    InmProfileFactory.deleteDirectory(customFile);
                }
            }
            catch (Exception e) {
                TEAppletLogMgr.error("InmProfileFactory.deleteUsersCustomDirectory() fail!", e);
                return false;
            }
        }
        return true;
    }

    public static ImageIcon getImageIcon(String filename) {
        URL url = InmProfileFactory.getResourceURL(filename);
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public static ImageIcon getCommonImageIcon(String filename) {
        URL url = InmProfileFactory.getCommonResourceURL(filename);
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public static InmFileDescObject getAbsFileDescObject(String filename) {
        InmFileDescObject fileObject = new InmFileDescObject();
        boolean success = fileObject.initialize(filename);
        if (success) {
            return fileObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBackAbsFile(String absFilename, InmFileDescObject filedesc) {
        if (null == absFilename) {
            return false;
        }
        BufferedWriter bw = null;
        boolean retVal = true;
        try {
            File file = new File(absFilename);
            if (file.exists() && !file.delete()) {
                String sMessage = "Delete file failed. Can not write data to file:" + absFilename;
                TEAppletLogMgr.info(sMessage);
                boolean bl = false;
                return bl;
            }
            boolean mkdirs = file.getParentFile().mkdirs();
            if (!mkdirs) {
                boolean bl = false;
                return bl;
            }
            boolean createNewFile = file.createNewFile();
            if (!createNewFile) {
                boolean ex = false;
                return ex;
            }
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            String sReturn = "\r\n";
            int length = filedesc.getFileContent().size();
            StringBuffer sb = new StringBuffer(length * 16);
            for (int j = 0; j < length; ++j) {
                sb.append((String)filedesc.getFileContent().elementAt(j));
                sb.append(sReturn);
            }
            bw.write(sb.toString());
            bw.flush();
        }
        catch (Exception e) {
            retVal = false;
        }
        finally {
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (IOException ex) {
                    TEAppletLogMgr.error("InmProfileFactory.writeBackAbsFile() IOException!", ex);
                }
            }
        }
        return retVal;
    }

    static boolean writeBackToFile(String relevantFilename, InmFileDescObject filedesc) {
        File file = InmProfileFactory.getCustomizedFile(relevantFilename);
        return InmProfileFactory.writeBackAbsFile(file.getAbsolutePath(), filedesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFileToFile(String F1, String F2) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            int r;
            fis = new FileInputStream(new File(F1));
            file = new File(F2);
            fos = new FileOutputStream(file);
            while ((r = fis.read()) != -1) {
                fos.write((byte)r);
            }
        }
        catch (FileNotFoundException ex) {
            File file2 = null;
            return file2;
        }
        catch (IOException ex) {
            File file3 = null;
            return file3;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {}
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFileToFile_TXT(String F1, String F2) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        File file = null;
        try {
            file = new File(F2);
            reader = new BufferedReader(new FileReader(new File(F1)));
            writer = new BufferedWriter(new FileWriter(file));
            String line = reader.readLine();
            while (line != null) {
                writer.write(line, 0, line.length());
                writer.newLine();
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            File file2 = null;
            return file2;
        }
        catch (IOException ex) {
            File file3 = null;
            return file3;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {}
        }
        return file;
    }

    private static int getPositionType(String relevantFilename) {
        String userCustomFilename;
        File userFile;
        String customFilename = InmProfileFactory.getCommonCustomPath() + File.separator + relevantFilename;
        File file = new File(customFilename);
        if (file.exists()) {
            return 0;
        }
        String userPath = InmProfileFactory.getUserCustomPath();
        if (userPath != null && (userFile = new File(userCustomFilename = userPath + File.separator + relevantFilename)).exists()) {
            return 1;
        }
        return 2;
    }

    static {
        InmProfileFactory.initLanguageID();
        fileTable = new Hashtable();
        commonFileTable = new Hashtable();
        CommonCustomPath = null;
        developPath = null;
    }
}

