/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import com.huawei.nglct.otdr.appletgraph.core.imap.ui.HwTextField;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.zip.DataFormatException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmLongTextField
extends HwTextField {
    boolean bAlarm = true;
    long nLimit = 19L;
    long min = 0L;
    long max = Long.MAX_VALUE;
    protected int ct = 0;
    boolean isLocked = false;
    private String prevStr;
    boolean isDirectInsert = false;

    public InmLongTextField() {
        this(0L, Long.MAX_VALUE);
    }

    public InmLongTextField(long minN) {
        this(minN, Long.MAX_VALUE);
    }

    public InmLongTextField(long minN, long maxN) {
        this.setDocument(new IntegerDocument(this));
        this.min = minN;
        this.max = maxN;
        this.nLimit = this.min > 0L ? 19L : 20L;
        this.addFocusListener(new FocusListener(){

            @Override
            public synchronized void focusLost(FocusEvent e) {
                if (InmLongTextField.this.isLocked || e.isTemporary()) {
                    return;
                }
                String text = InmLongTextField.this.getText();
                try {
                    if (text.length() == 0) {
                        throw new DataFormatException();
                    }
                    long value = Long.parseLong(text);
                    if (value < InmLongTextField.this.min || value > InmLongTextField.this.max) {
                        throw new DataFormatException();
                    }
                }
                catch (Exception ex) {
                    InmLongTextField.this.isLocked = true;
                    if (InmLongTextField.this.bAlarm && InmLongTextField.this.ct == 0) {
                        ++InmLongTextField.this.ct;
                        Toolkit.getDefaultToolkit().beep();
                        InmOptionPane.showMessageDialog(InmOptionPane.getWindowForComponent(InmLongTextField.this), (Object)(InmUtilResourceManager.getString("KEY1") + InmLongTextField.this.min + InmUtilResourceManager.getString("KEY2") + InmLongTextField.this.max + InmUtilResourceManager.getString("KEY3")), InmUtilResourceManager.getString("KEY4"), 1);
                        --InmLongTextField.this.ct;
                    }
                    InmLongTextField.this.isDirectInsert = true;
                    InmLongTextField.this.setText(new Long(InmLongTextField.this.min).toString());
                    InmLongTextField.this.isDirectInsert = false;
                }
            }

            @Override
            public void focusGained(FocusEvent evt) {
                Document doc = InmLongTextField.this.getDocument();
                InmLongTextField.this.setCaretPosition(0);
                InmLongTextField.this.moveCaretPosition(doc.getLength());
                InmLongTextField.this.isLocked = false;
            }
        });
    }

    public long getValue() {
        String s = this.getText();
        if (s.length() == 0) {
            return this.min;
        }
        long value = s.equals("-") ? 0L : Long.parseLong(s);
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        return value;
    }

    public void setRange(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public void removeFocusListener() {
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    @Override
    public String getText() {
        long value;
        try {
            value = Long.parseLong(super.getText());
        }
        catch (Exception e) {
            return super.getText();
        }
        if (this.max < value) {
            super.setText(String.valueOf(this.max));
            if (this.bAlarm && this.ct == 0) {
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                InmOptionPane.showMessageDialog(InmOptionPane.getWindowForComponent(this), (Object)(InmUtilResourceManager.getString("KEY1") + this.min + InmUtilResourceManager.getString("KEY2") + this.max + InmUtilResourceManager.getString("KEY3")), InmUtilResourceManager.getString("KEY4"), 1);
                --this.ct;
            }
        }
        return super.getText();
    }

    class IntegerDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public IntegerDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (InmLongTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            InmLongTextField.this.prevStr = this.textComponent.getText();
            String dbgStr = "";
            if (s.equals("-") && InmLongTextField.this.min > 0L) {
                return;
            }
            if ((long)(InmLongTextField.this.prevStr.trim().length() + s.trim().length()) > InmLongTextField.this.nLimit) {
                return;
            }
            try {
                if (offset > 0 && offset < InmLongTextField.this.prevStr.length()) {
                    dbgStr = InmLongTextField.this.prevStr.substring(0, offset) + s + InmLongTextField.this.prevStr.substring(offset, InmLongTextField.this.prevStr.length());
                    Long.parseLong(dbgStr);
                } else if (offset == 0) {
                    if (!s.equals("-") || this.textComponent.getText().length() != 0) {
                        dbgStr = s + InmLongTextField.this.prevStr;
                        Long.parseLong(dbgStr);
                    }
                } else {
                    dbgStr = InmLongTextField.this.prevStr + s;
                    Long.parseLong(dbgStr);
                }
            }
            catch (Exception ex) {
                return;
            }
            if (dbgStr.startsWith("00")) {
                return;
            }
            super.insertString(offset, s, attributeSet);
            long value = s.equals("-") && this.textComponent.getText().length() == 1 ? 0L : Long.parseLong(this.textComponent.getText());
            if (value > InmLongTextField.this.max) {
                super.remove(offset, 1);
                if (InmLongTextField.this.bAlarm && InmLongTextField.this.ct == 0) {
                    ++InmLongTextField.this.ct;
                    Toolkit.getDefaultToolkit().beep();
                    InmOptionPane.showMessageDialog(InmOptionPane.getWindowForComponent(InmLongTextField.this), (Object)(InmUtilResourceManager.getString("KEY1") + InmLongTextField.this.min + InmUtilResourceManager.getString("KEY2") + InmLongTextField.this.max + InmUtilResourceManager.getString("KEY3")), InmUtilResourceManager.getString("KEY4"), 1);
                    --InmLongTextField.this.ct;
                }
            }
        }
    }
}

