/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class InmLengthLimitDocument
extends PlainDocument {
    public static final int LIMIT_BY_BYTE = 0;
    public static final int LIMIT_BY_CHAR = 1;
    private int limitMode = 0;
    private int iMaxLength = 10;
    private Vector vLimitStrings = null;

    public InmLengthLimitDocument(int iMaxLength) {
        this.iMaxLength = iMaxLength;
    }

    @Override
    public synchronized void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        String sOld = this.getText(0, this.getLength());
        int sOldLength = 0;
        int tempSize = 0;
        if (this.limitMode == 0) {
            sOldLength = sOld.getBytes().length;
            tempSize = sOldLength + s.getBytes().length;
        } else {
            sOldLength = sOld.length();
            tempSize = sOldLength + s.length();
        }
        if (tempSize > this.iMaxLength) {
            s = s.substring(0, this.getLimitCharLength(s, this.iMaxLength - sOldLength));
        }
        if (!this.accept(sOld + s)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offset, s, attributeSet);
    }

    private int getLimitCharLength(String s, int limitByteLength) {
        int low = 0;
        int length = s.length();
        int high = length - 1;
        String temp = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            temp = s;
            if ((s = s.substring(0, mid)).getBytes().length < limitByteLength) {
                low = mid + 1;
            } else if (s.getBytes().length > limitByteLength) {
                high = mid - 1;
            } else {
                return mid;
            }
            s = temp;
        }
        return low - 1;
    }

    public synchronized boolean accept(String s) {
        if (null != this.vLimitStrings) {
            Enumeration enumer = this.vLimitStrings.elements();
            while (enumer.hasMoreElements()) {
                Object obj = enumer.nextElement();
                String sObj = obj.toString();
                if (null == sObj || s.equals("") || 0 > s.indexOf(sObj)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized void addFilterStringList(Vector v) {
        if (null == this.vLimitStrings) {
            this.vLimitStrings = new Vector();
        }
        this.vLimitStrings.addAll(v);
    }

    public synchronized void addFilterStringList(String strFilter) {
        if (null == this.vLimitStrings) {
            this.vLimitStrings = new Vector();
        }
        int nCount = strFilter.length();
        for (int i = 0; i < nCount; ++i) {
            String str = strFilter.substring(i, i + 1);
            this.vLimitStrings.add(str);
        }
    }

    public synchronized void addFilterString(Object obj) {
        if (null == obj) {
            return;
        }
        if (obj.toString().equals("")) {
            return;
        }
        if (null == this.vLimitStrings) {
            this.vLimitStrings = new Vector();
        }
        this.vLimitStrings.add(obj);
    }

    public synchronized void removeFilterString() {
        this.vLimitStrings = null;
    }

    public synchronized void removeFilterString(Object obj) {
        if (null == obj) {
            return;
        }
        if (null != this.vLimitStrings) {
            this.vLimitStrings.remove(obj);
        }
    }

    public synchronized void setLengthLimit(int nMaxLength) {
        if (1 < nMaxLength) {
            this.iMaxLength = nMaxLength;
        }
    }

    public void setLimitMode(int mode) {
        this.limitMode = mode;
    }

    public int getLimitMode() {
        return this.limitMode;
    }
}

