/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmScreenToolKit;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import com.huawei.nglct.otdr.appletgraph.core.imap.ui.HwTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigInteger;
import java.util.zip.DataFormatException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmIntegerTextField
extends HwTextField {
    boolean bAlarm = true;
    int nLimit = 11;
    int min = 0;
    int max = Integer.MAX_VALUE;
    protected int ct = 0;
    int radix = -1;
    private boolean acceptNull = false;
    private boolean acceptSlash = false;
    private boolean acceptZeroStart = true;
    private boolean canRequestFoucs = true;
    private boolean focusStatus = false;
    private String prevStr;
    boolean isDirectInsert = false;
    FocusListener listener = new FocusListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void focusLost(FocusEvent e) {
            if (!e.isTemporary() && InmIntegerTextField.this.canRequestFoucs) {
                try {
                    InmIntegerTextField.this.doFocusOperation();
                    InmIntegerTextField.this.focusStatus = false;
                }
                catch (Exception ex) {
                    TEAppletLogMgr.error("InmIntegerTextField.focusLost() fail!", ex);
                }
                finally {
                    InmIntegerTextField.this.canRequestFoucs = true;
                }
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
            InmIntegerTextField.this.focusStatus = true;
        }
    };
    private boolean focusListenerHasRemoved = false;
    private boolean _autoCorrect = true;

    public void setAcceptNull(boolean acceptNull) {
        this.acceptNull = acceptNull;
    }

    public static void main(String[] args) {
        final JFrame frm = new JFrame("Focus Frame");
        frm.setSize(300, 250);
        InmScreenToolKit.centerLocateToScreen(frm);
        Container cont = frm.getContentPane();
        cont.setLayout(new BorderLayout());
        JPanel btnPane = new JPanel(new FlowLayout(1));
        JButton showBtn = new JButton("Show Dialog");
        showBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dlg = new JDialog(frm, "Focus Dialog", true);
                dlg.getContentPane().setLayout(new FlowLayout());
                InmIntegerTextField fld = new InmIntegerTextField(10, 100);
                fld.setPreferredSize(new Dimension(100, 26));
                dlg.getContentPane().add(fld);
                JButton okBtn = new JButton("OK");
                JButton cancelBtn = new JButton("Cancel");
                InmScreenToolKit.registerEnterAction(dlg.getRootPane(), okBtn, 2);
                InmScreenToolKit.registerEscapeAction(dlg.getRootPane(), cancelBtn, 2);
                dlg.getContentPane().add(okBtn);
                dlg.getContentPane().add(cancelBtn);
                dlg.setSize(300, 250);
                InmScreenToolKit.centerLocateToScreen(dlg);
                dlg.show();
            }
        });
        btnPane.add(showBtn);
        cont.add((Component)btnPane, "South");
        frm.show();
    }

    public InmIntegerTextField() {
        this(0, Integer.MAX_VALUE, 10);
    }

    public InmIntegerTextField(int minN) {
        this(minN, Integer.MAX_VALUE, 10);
    }

    public InmIntegerTextField(int minN, int maxN) {
        this(minN, maxN, 10);
    }

    public InmIntegerTextField(int minN, int maxN, int radix) {
        this.setDocument(new IntegerDocument(this));
        this.min = minN;
        this.max = maxN;
        this.radix = radix;
        this.nLimit = this.min > 0 ? 10 : 11;
        this.addFocusListener(this.listener);
    }

    public void removeFocusListener() {
        this.removeFocusListener(this.listener);
        this.focusListenerHasRemoved = true;
    }

    public int getValue() {
        String s = this.getText();
        if (s.length() == 0) {
            return this.min;
        }
        int value = s.equals("-") ? 0 : Integer.parseInt(s, this.radix);
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        return value;
    }

    public void setRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    public void setAutoCorrect(boolean autoCorrect) {
        this._autoCorrect = autoCorrect;
    }

    public boolean getAutoCorrent() {
        return this._autoCorrect;
    }

    @Override
    public String getText() {
        int value;
        try {
            value = Integer.parseInt(super.getText(), this.radix);
        }
        catch (Exception e) {
            String sTemp = super.getText();
            String sMax = String.valueOf(this.max);
            if (!("".equals(sTemp.trim()) || sTemp.length() <= sMax.length() && sTemp.compareTo(sMax) <= 0)) {
                sTemp = sMax + "1";
            }
            return sTemp;
        }
        if (this.max < value && this.getAutoCorrent() && this.canRequestFoucs) {
            super.setText(Integer.toString(this.max, this.radix));
            if (this.bAlarm && this.ct == 0) {
                ++this.ct;
                this.showTip();
                --this.ct;
            }
        }
        return super.getText();
    }

    private void showTip() {
        StringBuffer buf = new StringBuffer();
        if (Integer.MAX_VALUE == this.max) {
            buf.append(InmUtilResourceManager.getString("KEY11")).append(Integer.toString(this.min, this.radix)).append(InmUtilResourceManager.getString("KEY12"));
        } else {
            buf.append(InmUtilResourceManager.getString("KEY1")).append(Integer.toString(this.min, this.radix)).append(InmUtilResourceManager.getString("KEY2")).append(Integer.toString(this.max, this.radix)).append(InmUtilResourceManager.getString("KEY3"));
        }
        InmOptionPane.showMessageDialog(InmOptionPane.getWindowForComponent(this), (Object)buf.toString(), InmUtilResourceManager.getString("KEY4"), 1);
    }

    public String getTextEx() {
        return super.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doFocusOperation() {
        String text = this.getText();
        if (this.acceptNull && (text == null || text.equals("") || text.equals("/"))) {
            return true;
        }
        try {
            if (text.length() == 0) {
                throw new DataFormatException();
            }
            int value = Integer.parseInt(text, this.radix);
            if (value < this.min || value > this.max) {
                this.canRequestFoucs = false;
                throw new DataFormatException();
            }
        }
        catch (DataFormatException ex) {
            int currentValue = this.min;
            if (this.bAlarm && this.ct == 0) {
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                JTable table = null;
                int row = -1;
                int column = -1;
                if (this.getParent() instanceof JTable) {
                    table = (JTable)this.getParent();
                    row = table.getEditingRow();
                    column = table.getEditingColumn();
                }
                this.showTip();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InmIntegerTextField.this.requestFocus();
                    }
                });
                if (table != null && row != -1 && column != -1) {
                    table.editingStopped(new ChangeEvent(this));
                    try {
                        currentValue = Integer.parseInt(table.getValueAt(row, column).toString());
                    }
                    catch (Exception ex2) {
                        TEAppletLogMgr.error("InmIntegerTextField.doFocusOperation() fail!", ex2);
                    }
                }
                --this.ct;
            }
            this.isDirectInsert = true;
            this.setText(Integer.toString(currentValue, this.radix));
            this.isDirectInsert = false;
            boolean bl = false;
            return bl;
        }
        finally {
            this.canRequestFoucs = true;
            this.doOperation();
        }
        return true;
    }

    public void doOperation() {
    }

    public void setAcceptZeroStart(boolean b) {
        this.acceptZeroStart = b;
    }

    public boolean isAcceptZeroStart() {
        return this.acceptZeroStart;
    }

    public boolean isAcceptSlash() {
        return this.acceptSlash;
    }

    public void setAcceptSlash(boolean acceptSlash) {
        this.acceptSlash = acceptSlash;
    }

    private class IntegerDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public IntegerDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            int insertCount = s.length();
            if (InmIntegerTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            if (!InmIntegerTextField.this.canRequestFoucs) {
                return;
            }
            String prevStr = this.textComponent.getText();
            String dbgStr = "";
            if (s.equals("-") && InmIntegerTextField.this.min >= 0) {
                return;
            }
            if (InmIntegerTextField.this.isAcceptSlash() && s.equals("/") && this.textComponent.getText().length() == 0) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            try {
                if (offset > 0 && offset < prevStr.length()) {
                    dbgStr = prevStr.substring(0, offset) + s + prevStr.substring(offset, prevStr.length());
                    BigInteger bigInteger = new BigInteger(dbgStr, InmIntegerTextField.this.radix);
                } else if (offset == 0) {
                    if (!s.equals("-") || this.textComponent.getText().length() != 0) {
                        dbgStr = s + prevStr;
                        BigInteger bigInteger = new BigInteger(dbgStr, InmIntegerTextField.this.radix);
                    }
                } else {
                    dbgStr = prevStr + s;
                    BigInteger bigInteger = new BigInteger(dbgStr, InmIntegerTextField.this.radix);
                }
            }
            catch (Exception ex) {
                return;
            }
            if (InmIntegerTextField.this.acceptZeroStart && dbgStr.startsWith("00")) {
                return;
            }
            if (!InmIntegerTextField.this.focusStatus) {
                if (prevStr.length() > 0) {
                    super.remove(0, offset);
                    insertCount = 1;
                    offset = 0;
                }
                InmIntegerTextField.this.requestFocus();
            }
            super.insertString(offset, s, attributeSet);
            long value = s.equals("-") && this.textComponent.getText().length() == 1 ? 0L : new BigInteger(this.textComponent.getText(), InmIntegerTextField.this.radix).longValue();
            this.validValue(value, offset, insertCount);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void validValue(long value, int offset, int insertCount) throws BadLocationException {
            if (value <= (long)InmIntegerTextField.this.max && value >= (long)InmIntegerTextField.this.min) return;
            if (value > (long)InmIntegerTextField.this.max) {
                if (InmIntegerTextField.this.getAutoCorrent()) {
                    this.textComponent.setText(Integer.toString(InmIntegerTextField.this.max, InmIntegerTextField.this.radix));
                } else {
                    super.remove(offset, insertCount);
                }
            } else if (InmIntegerTextField.this.min >= 0) {
                if (InmIntegerTextField.this.acceptZeroStart || value != 0L) return;
                if (InmIntegerTextField.this.getAutoCorrent()) {
                    this.textComponent.setText(Integer.toString(InmIntegerTextField.this.min, InmIntegerTextField.this.radix));
                } else {
                    super.remove(offset, insertCount);
                }
            } else if (InmIntegerTextField.this.getAutoCorrent()) {
                this.textComponent.setText(Integer.toString(InmIntegerTextField.this.min, InmIntegerTextField.this.radix));
            } else {
                super.remove(offset, insertCount);
            }
            if (!InmIntegerTextField.this.bAlarm || InmIntegerTextField.this.ct != 0) return;
            ++InmIntegerTextField.this.ct;
            InmIntegerTextField inmfield = (InmIntegerTextField)this.textComponent;
            if (!inmfield.focusListenerHasRemoved) {
                inmfield.removeFocusListener(inmfield.listener);
            }
            Toolkit.getDefaultToolkit().beep();
            InmIntegerTextField.this.showTip();
            --InmIntegerTextField.this.ct;
            if (inmfield.focusListenerHasRemoved) return;
            inmfield.addFocusListener(inmfield.listener);
        }
    }
}

