/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmAreaDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObjectEx;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmProfileFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

public class InmFileDescObject {
    public static final int OBJECT_ADD_SUCCEED = 1;
    public static final int OBJECT_REPLACE_SUCCEED = 2;
    public static final int OBJECT_REPLACE_FAILED = 3;
    public static final int OBJECT_ADD_FAILED = 4;
    public static final int CONFIG_FILE_FORMAT_ERROR = 5;
    public static final int DESCOBJECT_FORMAT_ERROR = 6;
    public static final int OBJECT_ALREADY_EXIST = 7;
    public static final int OBJECT_NOT_EXIST = 8;
    public static final int OBJECT_DELETE_SUCCEED = 9;
    public static final int OBJECT_DELETE_FAILED = 10;
    private boolean isForGEN = false;
    private Vector vctFileContent = new Vector();
    private Vector vctAreaName = new Vector();
    private Hashtable mapNameToIndex = new Hashtable();
    private String fileName = null;
    private String absFileName = null;
    private Integer MAX_VALUE = new Integer(Integer.MAX_VALUE);
    private Integer MIN_VALUE = new Integer(Integer.MIN_VALUE);
    private boolean isInitializeSuccess = false;
    private int positionType = -1;

    InmFileDescObject() {
    }

    public InmFileDescObject(InputStream in, String relevantFilename, boolean inLangDir) {
        this();
        this.fileName = relevantFilename;
        this.initialize(in);
    }

    boolean isInitializeSuccess() {
        return this.isInitializeSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize(InputStream in) {
        if (in == null) {
            this.isInitializeSuccess = false;
            return false;
        }
        BufferedReader br = null;
        String strLine = null;
        int index = 0;
        try {
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            this.vctFileContent.clear();
            this.vctAreaName.clear();
            this.mapNameToIndex.clear();
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).length() <= 0) continue;
                this.vctFileContent.addElement(strLine);
                if ('[' == strLine.charAt(0) && ']' == strLine.charAt(strLine.length() - 1)) {
                    this.mapNameToIndex.put(strLine, new Integer(index));
                    this.vctAreaName.add(strLine.substring(1, strLine.length() - 1));
                }
                ++index;
            }
            this.isInitializeSuccess = true;
        }
        catch (Exception e) {
            this.isInitializeSuccess = false;
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    TEAppletLogMgr.error("InmFileDescObject.initialize() IOException!", ex);
                }
            } else {
                try {
                    in.close();
                }
                catch (Exception ex) {
                    TEAppletLogMgr.error("InmFileDescObject.initialize() Exception!", ex);
                }
            }
        }
        return this.isInitializeSuccess;
    }

    public synchronized Vector getAreaNames() {
        Vector<String> vctAreaNameOut = new Vector<String>();
        for (int i = 0; i < this.vctAreaName.size(); i += 2) {
            String sAreaName = (String)this.vctAreaName.elementAt(i);
            vctAreaNameOut.add(sAreaName);
        }
        return vctAreaNameOut;
    }

    public InmAreaDescObject getAreaDescObject(String areaName) {
        return this.getAreaDescObject(areaName, false);
    }

    public synchronized InmAreaDescObject getAreaDescObjectBuildingIndex(String areaName) {
        return this.getAreaDescObject(areaName, true);
    }

    public synchronized InmAreaDescObject getAreaDescObject(String areaName, boolean bBuildIndex) {
        String areaNameCopy = areaName;
        InmAreaDescObject areaObjecct = new InmAreaDescObject(this);
        Vector<String> vctAreaContent = new Vector<String>();
        Integer indexBegin = this.MAX_VALUE;
        Integer indexEnd = this.MIN_VALUE;
        String sEnd = "[\\" + areaName + "]";
        areaName = "[" + areaName + "]";
        try {
            indexBegin = (Integer)this.mapNameToIndex.get(areaName);
            if (null == indexBegin) {
                if (this.isForGEN) {
                    return null;
                }
                return this.getAreaDescObjectAgain(areaNameCopy, bBuildIndex);
            }
            indexEnd = (Integer)this.mapNameToIndex.get(sEnd);
            if (null == indexEnd) {
                if (this.isForGEN) {
                    return null;
                }
                return this.getAreaDescObjectAgain(areaNameCopy, bBuildIndex);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            if (this.isForGEN) {
                return null;
            }
            return this.getAreaDescObjectAgain(areaNameCopy, bBuildIndex);
        }
        for (int i = indexBegin + 1; i <= indexEnd - 1; ++i) {
            String sTemp = (String)this.vctFileContent.get(i);
            if (0 >= sTemp.length() || ';' == sTemp.charAt(0) || '#' == sTemp.charAt(0)) continue;
            if ('/' == sTemp.charAt(0)) {
                String sLast = (String)vctAreaContent.lastElement();
                sLast = sLast + sTemp.substring(1);
                vctAreaContent.removeElementAt(vctAreaContent.size() - 1);
                vctAreaContent.add(sLast);
                continue;
            }
            vctAreaContent.add(sTemp);
        }
        areaObjecct.setFileName(this.fileName);
        if (areaObjecct.initialize(areaName, vctAreaContent, bBuildIndex)) {
            areaObjecct.setPositionType(this.positionType);
            return areaObjecct;
        }
        if (this.isForGEN) {
            return null;
        }
        return this.getAreaDescObjectAgain(areaNameCopy, bBuildIndex);
    }

    public synchronized InmAreaDescObject getAreaDescObjectEX(String areaName, boolean bBuildIndex) {
        InmAreaDescObject areaObjecct = new InmAreaDescObject(this);
        Vector<String> vctAreaContent = new Vector<String>();
        Integer indexBegin = this.MAX_VALUE;
        Integer indexEnd = this.MIN_VALUE;
        String sEnd = "[\\" + areaName + "]";
        areaName = "[" + areaName + "]";
        try {
            indexBegin = (Integer)this.mapNameToIndex.get(areaName);
            if (null == indexBegin) {
                return null;
            }
            indexEnd = (Integer)this.mapNameToIndex.get(sEnd);
            if (null == indexEnd) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        for (int i = indexBegin + 1; i <= indexEnd - 1; ++i) {
            String sTemp = (String)this.vctFileContent.get(i);
            if (0 >= sTemp.length() || ';' == sTemp.charAt(0) || '#' == sTemp.charAt(0)) continue;
            if ('/' == sTemp.charAt(0)) {
                String sLast = (String)vctAreaContent.lastElement();
                sLast = sLast + sTemp.substring(1);
                vctAreaContent.removeElementAt(vctAreaContent.size() - 1);
                vctAreaContent.add(sLast);
                continue;
            }
            vctAreaContent.add(sTemp);
        }
        areaObjecct.setFileName(this.fileName);
        if (areaObjecct.initialize(areaName, vctAreaContent, bBuildIndex)) {
            areaObjecct.setPositionType(this.positionType);
            return areaObjecct;
        }
        return null;
    }

    public synchronized int removeDescObject(String areaObjectName) {
        String sBegin = "[";
        String sEnd = "[\\";
        sBegin = sBegin + areaObjectName + ']';
        sEnd = sEnd + areaObjectName + ']';
        Integer iBeginIndex = (Integer)this.mapNameToIndex.get(sBegin);
        Integer iEndIndex = (Integer)this.mapNameToIndex.get(sEnd);
        if (iBeginIndex != null && iEndIndex != null) {
            for (int i = iBeginIndex + 1; i < iEndIndex; ++i) {
                this.vctFileContent.remove(iBeginIndex + 1);
            }
            this.rebuildIndex();
            if (!this.writeBackToFile()) {
                return 10;
            }
            return 9;
        }
        return 8;
    }

    public synchronized int removeDescObject(String areaObjectName, int index) {
        String sBegin = "[";
        String sEnd = "[\\";
        sBegin = sBegin + areaObjectName + ']';
        sEnd = sEnd + areaObjectName + ']';
        Integer iBeginIndex = (Integer)this.mapNameToIndex.get(sBegin);
        Integer iEndIndex = (Integer)this.mapNameToIndex.get(sEnd);
        if (iBeginIndex != null && iEndIndex != null) {
            int indexTemp = -1;
            for (int i = iBeginIndex + 1; i < iEndIndex; ++i) {
                String sContent = (String)this.vctFileContent.get(i);
                if ('/' != sContent.charAt(0)) {
                    ++indexTemp;
                }
                if (index != indexTemp) continue;
                this.vctFileContent.remove(i);
                sContent = (String)this.vctFileContent.get(i);
                while ('/' == sContent.charAt(0)) {
                    this.vctFileContent.remove(i);
                    sContent = (String)this.vctFileContent.get(i);
                }
                this.rebuildIndex();
                if (!this.writeBackToFile()) {
                    return 10;
                }
                return 9;
            }
        }
        return 8;
    }

    public synchronized int removeDescObject(String areaObjectName, String descObjectName) {
        String sBegin = "[";
        String sEnd = "[\\";
        descObjectName = descObjectName.trim();
        sBegin = sBegin + areaObjectName + ']';
        sEnd = sEnd + areaObjectName + ']';
        Integer iBeginIndex = (Integer)this.mapNameToIndex.get(sBegin);
        Integer iEndIndex = (Integer)this.mapNameToIndex.get(sEnd);
        if (iBeginIndex != null && iEndIndex != null) {
            for (int i = iBeginIndex + 1; i < iEndIndex; ++i) {
                String descObject = (String)this.vctFileContent.get(i);
                int iPosOfEqual = descObject.indexOf("=");
                if (iPosOfEqual <= 0) {
                    return 6;
                }
                String sObjectName = descObject.substring(0, iPosOfEqual);
                sObjectName = sObjectName.trim();
                if (!sObjectName.equals(descObjectName)) continue;
                this.vctFileContent.remove(i);
                String sLine = (String)this.vctFileContent.elementAt(i);
                while ('/' == sLine.charAt(0)) {
                    this.vctFileContent.remove(i);
                    sLine = (String)this.vctFileContent.elementAt(i);
                }
                this.rebuildIndex();
                if (!this.writeBackToFile()) {
                    return 10;
                }
                return 9;
            }
        }
        return 8;
    }

    public synchronized boolean isDescObjectExist(String areaObjectName, String descObjectName) {
        String sBegin = "[";
        String sEnd = "[\\";
        descObjectName = descObjectName.trim();
        sBegin = sBegin + areaObjectName + ']';
        sEnd = sEnd + areaObjectName + ']';
        Integer iBeginIndex = (Integer)this.mapNameToIndex.get(sBegin);
        Integer iEndIndex = (Integer)this.mapNameToIndex.get(sEnd);
        if (iBeginIndex != null && iEndIndex != null) {
            for (int i = iBeginIndex + 1; i < iEndIndex; ++i) {
                String descObject = (String)this.vctFileContent.get(i);
                int iPosOfEqual = descObject.indexOf("=");
                if (iPosOfEqual <= 0) {
                    return false;
                }
                String sObjectName = descObject.substring(0, iPosOfEqual);
                sObjectName = sObjectName.trim();
                if (!sObjectName.equals(descObjectName)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized int writeDescObject(InmDescObjectEx descObjectEx, boolean bReplace) {
        String areaName = descObjectEx.getAreaObjectName();
        String descObject = descObjectEx.toString();
        return this.writeDescObject(areaName, descObject, bReplace);
    }

    public synchronized int writeDescObject(InmDescObject descObjectPara, boolean bReplace) {
        String areaName = descObjectPara.getAreaObjectName();
        String descObject = descObjectPara.toString();
        return this.writeDescObject(areaName, descObject, bReplace);
    }

    public synchronized int writeDescObject(String areaName, String descObject, boolean bReplace) {
        return this.writeDescObject(areaName, descObject, bReplace, true);
    }

    public synchronized int updateDescObject(InmDescObject descObjectPara, boolean bReplace) {
        String areaName = descObjectPara.getAreaObjectName();
        String descObject = descObjectPara.toString();
        return this.writeDescObject(areaName, descObject, bReplace, false);
    }

    public synchronized int writeDescObject(String areaName, String descObject, boolean bReplace, boolean bSaveToFile) {
        String sBegin = "[";
        String sEnd = "[\\";
        int iRet = 4;
        sBegin = sBegin + areaName + ']';
        sEnd = sEnd + areaName + ']';
        Integer iBeginIndex = (Integer)this.mapNameToIndex.get(sBegin);
        Integer iEndIndex = (Integer)this.mapNameToIndex.get(sEnd);
        String newDescObject = InmFileDescObject.transferBracket(descObject);
        if (iBeginIndex != null && iEndIndex != null) {
            int iPosOfEqualInPara = newDescObject.indexOf("=");
            if (iPosOfEqualInPara <= 0) {
                return 6;
            }
            String sObjectNameInPara = newDescObject.substring(0, iPosOfEqualInPara);
            sObjectNameInPara = sObjectNameInPara.trim();
            boolean bFindObject = false;
            for (int i = iBeginIndex + 1; i < iEndIndex; ++i) {
                String sTemp = (String)this.vctFileContent.get(i);
                if (0 == sTemp.length() || '/' == sTemp.charAt(0) || '#' == sTemp.charAt(0)) continue;
                int iPosOfEqualInFile = sTemp.indexOf("=");
                if (iPosOfEqualInFile <= 0) {
                    return 5;
                }
                String sObjectNameInFile = sTemp.substring(0, iPosOfEqualInFile);
                sObjectNameInFile = sObjectNameInFile.trim();
                if (!sObjectNameInFile.equals(sObjectNameInPara)) continue;
                bFindObject = true;
                if (bReplace) {
                    this.vctFileContent.removeElementAt(i);
                    sTemp = (String)this.vctFileContent.get(i);
                    while (sTemp.charAt(0) == '/') {
                        this.vctFileContent.removeElementAt(i);
                        sTemp = (String)this.vctFileContent.get(i);
                    }
                    this.vctFileContent.add(i, newDescObject);
                    iRet = 2;
                    break;
                }
                bFindObject = true;
                iRet = 7;
                break;
            }
            if (!bFindObject) {
                this.vctFileContent.add(iEndIndex, newDescObject);
                iRet = 1;
            }
        } else if (iBeginIndex == null && iEndIndex != null || iBeginIndex != null && iEndIndex == null) {
            if (iBeginIndex != null) {
                int i;
                Object obj;
                String value;
                int index;
                int beginIndex = index = iBeginIndex.intValue();
                int size = this.vctFileContent.size();
                while (index < size - 1 && !(value = (obj = this.vctFileContent.get(++index)).toString()).substring(0, 1).equals("[")) {
                }
                int endIndex = beginIndex + 1;
                for (i = index - 1; i > beginIndex; --i) {
                    String obj2 = this.vctFileContent.get(i).toString();
                    if (obj2.substring(0, 1).equals("#")) continue;
                    endIndex = i;
                    break;
                }
                for (i = beginIndex; i <= endIndex; ++i) {
                    this.vctFileContent.remove(beginIndex);
                }
                this.vctFileContent.add(sBegin);
                this.vctFileContent.add(newDescObject);
                this.vctFileContent.add(sEnd);
                iRet = 1;
            } else {
                iRet = 4;
            }
        } else {
            this.vctFileContent.add(sBegin);
            this.vctFileContent.add(newDescObject);
            this.vctFileContent.add(sEnd);
            iRet = 1;
        }
        if (1 == iRet || 2 == iRet) {
            this.rebuildIndex();
            if (bSaveToFile && !this.writeBackToFile()) {
                iRet = 1 == iRet ? 4 : 3;
            }
        }
        return iRet;
    }

    public synchronized int writeAreaObject(String areaName) {
        String sBegin = "[";
        String sEnd = "[\\";
        int iRet = 4;
        sBegin = sBegin + areaName + ']';
        sEnd = sEnd + areaName + ']';
        Integer iBeginIndex = (Integer)this.mapNameToIndex.get(sBegin);
        Integer iEndIndex = (Integer)this.mapNameToIndex.get(sEnd);
        if (iBeginIndex != null && iEndIndex != null) {
            iRet = 7;
        } else if (iBeginIndex == null && iEndIndex != null || iBeginIndex != null && iEndIndex == null) {
            iRet = 4;
        } else {
            this.vctFileContent.add(sBegin);
            this.vctFileContent.add(sEnd);
            iRet = 1;
        }
        if (1 == iRet) {
            this.rebuildIndex();
            if (!this.writeBackToFile()) {
                iRet = 4;
            }
        }
        return iRet;
    }

    private void rebuildIndex() {
        int index = 0;
        this.mapNameToIndex.clear();
        this.vctAreaName.clear();
        for (int i = 0; i < this.vctFileContent.size(); ++i) {
            String sTemp = (String)this.vctFileContent.elementAt(i);
            if ('[' == sTemp.charAt(0) && ']' == sTemp.charAt(sTemp.length() - 1)) {
                this.mapNameToIndex.put(sTemp, new Integer(index));
                this.vctAreaName.add(sTemp.substring(1, sTemp.length() - 1));
            }
            ++index;
        }
    }

    public boolean initialize(String _fileName) {
        FileInputStream in = null;
        try {
            this.absFileName = _fileName;
            in = new FileInputStream(_fileName);
            this.fileName = null;
        }
        catch (Exception ex) {
            TEAppletLogMgr.error("InmFileDescObject.initialize() fail!", ex);
        }
        return this.initialize(in);
    }

    private boolean writeBackToFile() {
        if (this.absFileName != null) {
            return InmProfileFactory.writeBackAbsFile(this.absFileName, this);
        }
        return InmProfileFactory.writeBackToFile(this.fileName, this);
    }

    private static String transferBracket(String source) {
        int index = source.indexOf(61);
        if (index == -1) {
            return source;
        }
        String attrName = source.substring(0, index);
        int leftIndex = attrName.indexOf(40);
        int rightIndex = attrName.indexOf(41);
        if (leftIndex == -1 && rightIndex == -1) {
            return source;
        }
        StringBuffer buf = new StringBuffer();
        int length = attrName.length();
        for (int i = 0; i < length; ++i) {
            int c2;
            char c1 = attrName.charAt(i);
            int n = c2 = i == 0 ? 92 : (int)attrName.charAt(i - 1);
            if ((c1 == '(' || c1 == ')') && c2 != 92) {
                buf.append('\\');
            }
            buf.append(c1);
        }
        buf.append(source.substring(index, source.length()));
        return buf.toString();
    }

    Vector getFileContent() {
        return this.vctFileContent;
    }

    private synchronized InmAreaDescObject getAreaDescObjectAgain(String areaName, boolean bBuildIndex) {
        if (null != this.getAbsFileName()) {
            return null;
        }
        InmAreaDescObject areaObject = null;
        InmFileDescObject fileObject = null;
        if (this.positionType == 2) {
            return null;
        }
        if (this.positionType == 1) {
            fileObject = InmProfileFactory.getFileDescObjectFromJar(this.fileName);
            if (null == fileObject) {
                return null;
            }
            areaObject = fileObject.getAreaDescObjectEX(areaName, bBuildIndex);
            return areaObject;
        }
        fileObject = InmProfileFactory.getFileDescObjectFromUser(this.fileName);
        if (null == fileObject) {
            fileObject = InmProfileFactory.getFileDescObjectFromJar(this.fileName);
            if (null == fileObject) {
                return null;
            }
            areaObject = fileObject.getAreaDescObjectEX(areaName, bBuildIndex);
        } else {
            areaObject = fileObject.getAreaDescObjectEX(areaName, bBuildIndex);
            if (null == areaObject && null != (fileObject = InmProfileFactory.getFileDescObjectFromJar(this.fileName))) {
                areaObject = fileObject.getAreaDescObjectEX(areaName, bBuildIndex);
            }
        }
        return areaObject;
    }

    public String getAbsFileName() {
        return this.absFileName;
    }

    public synchronized boolean isForGEN() {
        return this.isForGEN;
    }

    public synchronized void setForGEN(boolean isForGEN) {
        this.isForGEN = isForGEN;
    }

    public synchronized int getPositionType() {
        return this.positionType;
    }

    public synchronized void setPositionType(int positionType) {
        this.positionType = positionType;
    }

    public static void main(String[] args) {
        InmFileDescObject file = InmProfileFactory.getFileDescObject("imap12\\common\\test.ini");
        String descObject0 = "OptiX 10G\\(Metro 5000\\)=keyname(OptiX 10G\\(Metro 5000\\)) keyvalue(3)";
        String descObject1 = "\u00d7\u00d3\u00bc\u00dc/\u00b5\u00a5\u00b0\u00e5(\u00b6\u00cb\u00bf\u00da) = type(text) attrID(6) readonly(1) sortable(1) Filter(1) Position(4) Width(120)";
        file.writeDescObject("test", descObject0, true);
        file.writeDescObject("test", descObject1, true);
    }
}

