/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmScreenToolKit;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.zip.DataFormatException;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InmDoubleTextField
extends JTextField {
    static final String CAPITAL_E_STE = "E";
    static final String NORMAL_E_STR = "e";
    static final String MINUS_STR = "-";
    static final String PLUS_STR = "+";
    static final String ZERO_STR = "0";
    protected boolean bAlarm = true;
    protected boolean isDirectInsert = false;
    protected double min = Double.MIN_VALUE;
    protected double max = Double.MAX_VALUE;
    protected double defaultV = 0.0;
    protected String prevStr;
    boolean noDefaultValue = false;
    protected int m_nFraction = 17;
    private FocusListener listener = new FocusAdapter(){
        private boolean focusLostRunning = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent e) {
            if (this.focusLostRunning) {
                return;
            }
            this.focusLostRunning = true;
            String text = InmDoubleTextField.this.getText();
            try {
                if (text.length() == 0) {
                    throw new DataFormatException();
                }
                double value = Double.parseDouble(text);
                if (value < InmDoubleTextField.this.min || value > InmDoubleTextField.this.max) {
                    throw new DataFormatException();
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                JTable table = null;
                int row = -1;
                int column = -1;
                if (InmDoubleTextField.this.getParent() instanceof JTable) {
                    table = (JTable)InmDoubleTextField.this.getParent();
                    row = table.getEditingRow();
                    column = table.getEditingColumn();
                }
                InmOptionPane.showMessageDialog(InmOptionPane.getWindowForComponent(InmDoubleTextField.this), (Object)(InmUtilResourceManager.getString("KEY6") + InmDoubleTextField.this.getNormalDoubleString(InmDoubleTextField.this.min, InmDoubleTextField.this.m_nFraction) + InmUtilResourceManager.getString("KEY7") + InmDoubleTextField.this.getNormalDoubleString(InmDoubleTextField.this.max, InmDoubleTextField.this.m_nFraction) + InmUtilResourceManager.getString("KEY8")), InmUtilResourceManager.getString("KEY9"), 1);
                InmDoubleTextField.this.isDirectInsert = true;
                InmDoubleTextField.this.setText(new Double(InmDoubleTextField.this.getDefaultValue()).toString());
                InmDoubleTextField.this.isDirectInsert = false;
                if (table != null && row != -1 && column != -1) {
                    table.editingStopped(new ChangeEvent(InmDoubleTextField.this));
                }
            }
            finally {
                this.focusLostRunning = false;
            }
        }
    };
    private boolean _autoCorrect = true;
    private boolean beFixFraction = true;

    protected void setFractionLimit(int nLimit) {
        if (nLimit < 1) {
            nLimit = 1;
        }
        this.m_nFraction = nLimit;
    }

    public InmDoubleTextField(double minf, double maxf) {
        this(minf, maxf, 17);
    }

    public void setDefaultValue(double value) {
        this.defaultV = value;
    }

    public double getDefaultValue() {
        return this.defaultV;
    }

    public InmDoubleTextField(double minf, double maxf, int nLimit, boolean noDefaultValue) {
        this(minf, maxf, nLimit);
        this.noDefaultValue = noDefaultValue;
    }

    public InmDoubleTextField(double minf, double maxf, int nLimit) {
        this(minf, maxf, nLimit, minf);
        double v = minf < 0.0 && maxf > 0.0 ? 0.0 : minf;
        this.setDefaultValue(v);
    }

    public InmDoubleTextField(double minf, double maxf, int nLimit, double defaultValue) {
        this.setDocument(new FloatDocument(this));
        this.min = minf;
        this.max = maxf;
        this.defaultV = defaultValue;
        this.setFractionLimit(nLimit);
        this.addFocusListener(this.listener);
    }

    @Override
    public void setText(String str) {
        String tempStr = ZERO_STR;
        try {
            tempStr = str.indexOf(",") >= 0 ? str.replaceAll(",", "") : str;
            double f = Double.parseDouble(tempStr);
            super.setText(this.getStringFromDouble(f));
        }
        catch (Exception ex) {
            TEAppletLogMgr.error("InmDoubleTextField.setText() fail!", ex);
            double f = this.getDefaultValue();
            if (!this.noDefaultValue) {
                super.setText(this.getStringFromDouble(f));
            }
            super.setText("");
        }
    }

    public InmDoubleTextField() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public InmDoubleTextField(double minf) {
        this(minf, Double.MAX_VALUE);
    }

    public double getValue() {
        char c;
        double value;
        String s = this.getText();
        if (s.length() == 0) {
            return this.getDefaultValue();
        }
        if (s.equals(PLUS_STR) || s.equals(MINUS_STR)) {
            double d = 0.0;
        }
        if ((value = (c = s.charAt(s.length() - 1)) == 'e' || c == 'E' || c == '+' || c == '-' ? Double.parseDouble(this.getText() + ZERO_STR) : Double.parseDouble(this.getText())) < this.min || value > this.max) {
            value = this.getDefaultValue();
        }
        return value;
    }

    public void setRange(double minV, double maxV) {
        this.min = Double.parseDouble(this.getStringFromDouble(minV));
        this.max = Double.parseDouble(this.getStringFromDouble(maxV));
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public String getStringFromDouble(double f) {
        String str = this.getNormalDoubleString(f, this.m_nFraction);
        DecimalFormat form = new DecimalFormat("0.0");
        form.setMaximumFractionDigits(this.m_nFraction);
        int fraction = this.getStringFraction(str);
        if (fraction == this.m_nFraction || !this.beFixFraction && fraction < this.m_nFraction) {
            return str;
        }
        StringBuffer retStr = new StringBuffer(str);
        int n = str.indexOf(".");
        if (fraction > this.m_nFraction) {
            retStr = new StringBuffer(str.substring(0, n + this.m_nFraction + 1));
        } else if (this.beFixFraction && fraction < this.m_nFraction) {
            retStr = new StringBuffer(str.substring(0, n + fraction + 1));
            for (int i = 0; i < this.m_nFraction - fraction; ++i) {
                retStr.append(ZERO_STR);
            }
        }
        int m = Math.max(str.indexOf(NORMAL_E_STR), str.indexOf(CAPITAL_E_STE));
        if (m >= 0) {
            retStr.append(str.substring(m, str.length()));
        }
        return retStr.toString();
    }

    private String getNormalDoubleString(double f) {
        BigDecimal tmpDec = new BigDecimal(f).setScale(1, 4);
        return tmpDec.toString();
    }

    private String getNormalDoubleString(double f, int m_nFraction) {
        BigDecimal tmpDec = new BigDecimal(f).setScale(m_nFraction, 4);
        return tmpDec.toString();
    }

    private int getStringFraction(String dbgStr) {
        int nPoint = dbgStr.indexOf(".");
        if (nPoint < 0) {
            return -1;
        }
        int nE = Math.max(dbgStr.indexOf(CAPITAL_E_STE), dbgStr.indexOf(NORMAL_E_STR));
        if (nE < 0) {
            nE = dbgStr.length();
        }
        return nE - nPoint - 1;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    public void setAutoCorrect(boolean autoCorrect) {
        this._autoCorrect = autoCorrect;
    }

    public boolean getAutoCorrent() {
        return this._autoCorrect;
    }

    public int getNumberLength(String str) {
        int nE = Math.max(str.indexOf(NORMAL_E_STR), str.indexOf(CAPITAL_E_STE));
        if (nE < 0) {
            nE = str.length();
        }
        if (str.indexOf(".") > 0) {
            --nE;
        }
        return nE;
    }

    public void setFixFraction(boolean fixed) {
        this.beFixFraction = fixed;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(300, 200);
        InmScreenToolKit.centerLocateToScreen(frame);
        Container con = frame.getContentPane();
        con.setLayout(new BorderLayout());
        InmDoubleTextField editor = new InmDoubleTextField(3.0, 65535.0, 2, false);
        Object[] col = new String[]{"\u00cb\u00f7\u00d2\u00fd", "\u00b8\u00a1\u00b5\u00e3\u00d0\u00cd", "\u00d5\u00fb\u00d0\u00cd"};
        Object[][] data = new Object[][]{{new Integer(1), new Float(1.5), new Integer(2)}};
        JTable table = new JTable(data, col);
        table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(editor));
        con.add((Component)table, "Center");
        frame.show();
    }

    class FloatDocument
    extends PlainDocument {
        private JTextComponent textComponent;
        private int ct = 0;

        public FloatDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            double value;
            int insertCount = s.length();
            if (InmDoubleTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            InmDoubleTextField.this.prevStr = this.textComponent.getText();
            String dbgStr = "";
            try {
                if (offset > 0 && offset < InmDoubleTextField.this.prevStr.length()) {
                    dbgStr = InmDoubleTextField.this.prevStr.substring(0, offset) + s + InmDoubleTextField.this.prevStr.substring(offset, InmDoubleTextField.this.prevStr.length());
                    Double.parseDouble(dbgStr);
                } else if (offset == InmDoubleTextField.this.prevStr.length()) {
                    if (s.equalsIgnoreCase(InmDoubleTextField.NORMAL_E_STR) || s.equals(InmDoubleTextField.PLUS_STR) || s.equals(InmDoubleTextField.MINUS_STR)) {
                        dbgStr = InmDoubleTextField.this.prevStr + s + InmDoubleTextField.ZERO_STR;
                        Double.parseDouble(dbgStr);
                    } else {
                        dbgStr = InmDoubleTextField.this.prevStr + s;
                        Double.parseDouble(dbgStr);
                    }
                } else {
                    dbgStr = s + InmDoubleTextField.this.prevStr;
                    Double.parseDouble(dbgStr);
                }
            }
            catch (Exception ex) {
                return;
            }
            if (InmDoubleTextField.this.getStringFraction(dbgStr) > InmDoubleTextField.this.m_nFraction) {
                return;
            }
            if (dbgStr.startsWith("00")) {
                return;
            }
            if (dbgStr.startsWith(InmDoubleTextField.MINUS_STR) && InmDoubleTextField.this.getMin() >= 0.0) {
                return;
            }
            super.insertString(offset, s, attributeSet);
            try {
                value = (s.equalsIgnoreCase(InmDoubleTextField.NORMAL_E_STR) || s.equals(InmDoubleTextField.PLUS_STR) || s.equals(InmDoubleTextField.MINUS_STR)) && offset == InmDoubleTextField.this.prevStr.length() ? Double.parseDouble(this.textComponent.getText() + InmDoubleTextField.ZERO_STR) : Double.parseDouble(this.textComponent.getText());
            }
            catch (Exception ex) {
                TEAppletLogMgr.error("InmDoubleTextField.insertString() fail!", ex);
                return;
            }
            if (InmDoubleTextField.this.max < 0.0) {
                return;
            }
            if (value > InmDoubleTextField.this.max || InmDoubleTextField.this.min < 0.0 && value < InmDoubleTextField.this.min) {
                if (value > InmDoubleTextField.this.max) {
                    if (InmDoubleTextField.this.getAutoCorrent()) {
                        this.textComponent.setText(InmDoubleTextField.this.getStringFromDouble(InmDoubleTextField.this.max));
                    } else {
                        super.remove(offset, insertCount);
                    }
                } else if (InmDoubleTextField.this.getAutoCorrent()) {
                    this.textComponent.setText(InmDoubleTextField.this.getStringFromDouble(InmDoubleTextField.this.min));
                } else {
                    super.remove(offset, insertCount);
                }
                if (InmDoubleTextField.this.bAlarm && this.ct == 0) {
                    ++this.ct;
                    InmDoubleTextField.this.removeFocusListener(InmDoubleTextField.this.listener);
                    Toolkit.getDefaultToolkit().beep();
                    InmOptionPane.showMessageDialog(InmOptionPane.getWindowForComponent(InmDoubleTextField.this), (Object)(InmUtilResourceManager.getString("KEY6") + InmDoubleTextField.this.getNormalDoubleString(InmDoubleTextField.this.min, InmDoubleTextField.this.m_nFraction) + InmUtilResourceManager.getString("KEY7") + InmDoubleTextField.this.getNormalDoubleString(InmDoubleTextField.this.max, InmDoubleTextField.this.m_nFraction) + InmUtilResourceManager.getString("KEY8")), InmUtilResourceManager.getString("KEY9"), 1);
                    InmDoubleTextField.this.requestFocus();
                    InmDoubleTextField.this.addFocusListener(InmDoubleTextField.this.listener);
                    --this.ct;
                }
            }
        }
    }
}

