/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Vector;

public class InmButtonGroup
implements Serializable {
    public int groupIndex = 0;
    protected Vector buttons = new Vector();
    private int groupBtnWidth = 0;
    private int groupBtnHeight = 0;

    public InmButtonGroup() {
    }

    public InmButtonGroup(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public int getButtonSize() {
        return this.buttons.size();
    }

    public void add(InmButton b) {
        if (b == null) {
            return;
        }
        this.buttons.addElement(b);
        this.resizeButton(b);
    }

    private void resizeButton(InmButton b) {
        int tmpWidth = b.getWidth();
        int tmpHeight = b.getHeight();
        if (tmpWidth < this.groupBtnWidth || tmpHeight < this.groupBtnHeight) {
            Dimension size = new Dimension(this.groupBtnWidth, this.groupBtnHeight);
            b.setMinimumSize(size);
            b.setMaximumSize(size);
            b.setWidth(this.groupBtnWidth);
            b.setHeight(this.groupBtnHeight);
            return;
        }
        if (tmpWidth > this.groupBtnWidth) {
            this.groupBtnWidth = tmpWidth;
        }
        if (tmpHeight > this.groupBtnHeight) {
            this.groupBtnHeight = tmpHeight;
        }
        Dimension pSize = new Dimension(this.groupBtnWidth, this.groupBtnHeight);
        int btnNum = this.buttons.size();
        for (int i = 0; i < btnNum; ++i) {
            InmButton button = (InmButton)this.buttons.elementAt(i);
            button.setMinimumSize(pSize);
            button.setMaximumSize(pSize);
            button.setWidth(this.groupBtnWidth);
            button.setHeight(this.groupBtnHeight);
            if (this.groupIndex == 0 || i != 0) continue;
            button.setNewGroupInsets();
        }
    }

    public void setButtonWidth(int w) {
        this.groupBtnWidth = w;
        int btnNum = this.buttons.size();
        for (int i = 0; i < btnNum; ++i) {
            InmButton b = (InmButton)this.buttons.elementAt(i);
            this.resizeButton(b);
        }
    }

    public int getButtonWidth() {
        return this.groupBtnWidth;
    }

    public static void setIdenticalWidth(InmButtonGroup g1, InmButtonGroup g2) {
        int w2;
        int w1 = g1.getButtonWidth();
        if (w1 > (w2 = g2.getButtonWidth())) {
            g2.setButtonWidth(w1);
        } else if (w1 < w2) {
            g1.setButtonWidth(w2);
        }
    }

    public static void setIdenticalWidth(InmButtonGroup[] g) {
        int w = 0;
        int g_index = 0;
        for (int i = 0; i < g.length; ++i) {
            if (g[i].getButtonWidth() <= w) continue;
            w = g[i].getButtonWidth();
            g_index = i;
        }
        for (int ii = 0; ii < g.length; ++ii) {
            if (g_index == ii) continue;
            g[ii].setButtonWidth(w);
        }
    }
}

