/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import com.huawei.nglct.otdr.appletgraph.core.imap.ui.HwButton;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Action;
import javax.swing.Icon;

public class InmButton
extends HwButton {
    public static final int DefaultWidth = 60;
    public static final int DefaultHeight = 26;
    public static final int DefaultBaseWidth = 20;
    public final Insets DefaultMargin = new Insets(0, 4, 0, 0);
    public final Insets DefaultNewGroupMargin = new Insets(0, 10, 0, 0);
    public static final Insets DefaultContextInsets = new Insets(2, 2, 2, 2);
    public static final String NEW_TEXT_PROPERTY = InmUtilResourceManager.getString("button_New");
    public static final String QUERY_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Query");
    public static final String REFRESH_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Refresh");
    public static final String DELETE_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Delete");
    public static final String MODIFY_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Modify");
    public static final String CANCEL_TEXT_PROPERTY = InmUtilResourceManager.getString("button_CANCEL");
    public static final String FINISH_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Finish");
    public static final String OK_TEXT_PROPERTY = InmUtilResourceManager.getString("button_OK");
    public static final String APPLY_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Apply");
    public static final String YES_TEXT_PROPERTY = InmUtilResourceManager.getString("button_YES");
    public static final String NO_TEXT_PROPERTY = InmUtilResourceManager.getString("button_NO");
    public static final String LAST_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Last");
    public static final String NEXT_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Next");
    public static final String START_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Start");
    public static final String STOP_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Stop");
    public static final String PRINT_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Print");
    public static final String SAVETOFILE_TEXT_PROPERTY = InmUtilResourceManager.getString("button_SaveToFile");
    public static final String RESET_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Reset");
    public static final String CLOSE_TEXT_PROPERTY = InmUtilResourceManager.getString("button_Close");
    private int realWidth = 60;
    private int realHeight = 26;
    private Insets bInsets = this.DefaultMargin;
    private static final FocusListener focusApt = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            Object obj = e.getSource();
            if (obj instanceof InmButton) {
                ((InmButton)obj).doFocusLost();
            }
        }
    };

    public InmButton() {
        this(null, null);
    }

    public InmButton(Action a) {
        this();
        this.setAction(a);
    }

    public InmButton(Icon icon) {
        this(null, icon);
    }

    public InmButton(String text) {
        this(text, null);
    }

    public InmButton(String text, Icon icon) {
        super(text, icon);
        this.resetSize();
        this.addFocusListener(focusApt);
    }

    private void doFocusLost() {
        this.getModel().setPressed(false);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resetSize();
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        this.resetSize();
    }

    private void resetSize() {
        this.setMargin(DefaultContextInsets);
        Dimension pSize = super.getPreferredSize();
        double w = pSize.getWidth();
        int pw = (int)w;
        int tmpWidth = 0;
        tmpWidth = pw % 20 == 0 ? pw : (pw / 20 + 1) * 20;
        if (tmpWidth > 60) {
            this.realWidth = tmpWidth;
        }
        this.setSize(this.realWidth, this.realHeight);
        Dimension setedSize = new Dimension(this.realWidth, this.realHeight);
        this.setMaximumSize(setedSize);
        this.setMinimumSize(setedSize);
    }

    public void setNewGroupInsets() {
        this.bInsets = this.DefaultNewGroupMargin;
    }

    public Insets getBtnInsets() {
        return this.bInsets;
    }

    @Override
    public int getWidth() {
        return this.realWidth;
    }

    public void setWidth(int width) {
        this.realWidth = width;
    }

    public void setHeight(int height) {
        this.realHeight = height;
    }

    public void sizeLevelUp(int level) {
        if (level < 1) {
            return;
        }
        int w = this.realWidth;
        this.realWidth = w += 20 * level;
        this.setSize(this.realWidth, this.realHeight);
        Dimension setedSize = new Dimension(this.realWidth, this.realHeight);
        this.setPreferredSize(setedSize);
        this.setMaximumSize(setedSize);
        this.setMinimumSize(setedSize);
    }

    public void sizeLevelUp() {
        this.sizeLevelUp(1);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pSize = new Dimension(this.realWidth, this.realHeight);
        return pSize;
    }
}

