/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmFileDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmProfileFactory;
import java.util.Hashtable;
import java.util.Vector;

public class InmAreaDescObject {
    private Vector vctAreaContent = null;
    private String areaName = null;
    private String areaNameAgain = null;
    private Hashtable indexTable = null;
    private String currentfileName = "";
    private InmFileDescObject fileDescObject = null;
    private boolean isForGEN = false;
    static final int INIT_OBJECT_NAME_LENGTH = 20;
    private int positionType = -1;

    public InmAreaDescObject(InmFileDescObject fileDescObject) {
        this.fileDescObject = fileDescObject;
    }

    public InmAreaDescObject() {
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getAreaNameEx() {
        return this.areaName.substring(1, this.areaName.length() - 1);
    }

    public String getAreaNameAgainEx() {
        return this.areaNameAgain.substring(1, this.areaName.length() - 1);
    }

    public InmDescObject getDescObject(int index) {
        if (null == this.vctAreaContent) {
            return null;
        }
        if (index < 0 || index >= this.vctAreaContent.size()) {
            return null;
        }
        InmDescObject descObject = new InmDescObject();
        if (descObject.initialize(this, (String)this.vctAreaContent.elementAt(index))) {
            descObject.setPositionType(this.positionType);
            return descObject;
        }
        if (this.isForGEN) {
            return null;
        }
        if (this.positionType == 2) {
            return null;
        }
        return this.getDescObjectAgain(index);
    }

    private InmDescObject getDescObjectAgainEx(int index) {
        if (null == this.vctAreaContent) {
            return null;
        }
        if (index < 0 || index >= this.vctAreaContent.size()) {
            return null;
        }
        InmDescObject descObject = new InmDescObject();
        if (descObject.initialize(this, (String)this.vctAreaContent.elementAt(index))) {
            descObject.setPositionType(this.positionType);
            return descObject;
        }
        return null;
    }

    public InmDescObject getDescObject(String objectName) {
        if (this.vctAreaContent == null || objectName == null) {
            return null;
        }
        objectName = objectName.trim();
        if (null != this.indexTable) {
            Integer index = (Integer)this.indexTable.get(objectName);
            if (index == null) {
                return this.getDescObjectAgain(objectName);
            }
            InmDescObject descObject = new InmDescObject();
            String sDescObject = (String)this.vctAreaContent.elementAt(index);
            if (descObject.initialize(this, sDescObject)) {
                descObject.setPositionType(this.positionType);
                return descObject;
            }
            return this.getDescObjectAgain(objectName);
        }
        InmDescObject descObject = new InmDescObject();
        for (int i = 0; i < this.vctAreaContent.size(); ++i) {
            String sObjectName;
            String sObject = (String)this.vctAreaContent.elementAt(i);
            if (sObject.length() == 0 || (sObjectName = this.getDescObjectName(sObject)) == null || !sObjectName.equals(objectName)) continue;
            if (descObject.initialize(this, sObject)) {
                descObject.setPositionType(this.positionType);
                return descObject;
            }
            return this.getDescObjectAgain(objectName);
        }
        return this.getDescObjectAgain(objectName);
    }

    public InmDescObject getDescObjectAgainEx(String objectName) {
        if (this.vctAreaContent == null || objectName == null) {
            return null;
        }
        objectName = objectName.trim();
        if (null != this.indexTable) {
            Integer index = (Integer)this.indexTable.get(objectName);
            if (index == null) {
                return null;
            }
            InmDescObject descObject = new InmDescObject();
            String sDescObject = (String)this.vctAreaContent.elementAt(index);
            if (descObject.initialize(this, sDescObject)) {
                descObject.setPositionType(this.positionType);
                return descObject;
            }
            return null;
        }
        InmDescObject descObject = new InmDescObject();
        for (int i = 0; i < this.vctAreaContent.size(); ++i) {
            String sObjectName;
            String sObject = (String)this.vctAreaContent.elementAt(i);
            if (sObject.length() == 0 || (sObjectName = this.getDescObjectName(sObject)) == null || !sObjectName.equals(objectName)) continue;
            if (descObject.initialize(this, sObject)) {
                descObject.setPositionType(this.positionType);
                return descObject;
            }
            return null;
        }
        return null;
    }

    public boolean initialize(String areaName, Vector areaInfo, boolean bBuildIndex) {
        this.areaName = areaName;
        this.areaNameAgain = areaName;
        if (null == areaInfo) {
            return false;
        }
        this.vctAreaContent = areaInfo;
        int descSize = areaInfo.size();
        if (bBuildIndex || descSize > 10) {
            this.indexTable = new Hashtable(descSize + 10);
            for (int i = 0; i < descSize; ++i) {
                String sObjectName = this.getDescObjectName((String)areaInfo.elementAt(i));
                if (null == sObjectName) {
                    this.indexTable = null;
                    return false;
                }
                this.indexTable.put(sObjectName, new Integer(i));
            }
        }
        return true;
    }

    public String getStringPropertyvalue(String sObjectName, String sPropertyName) {
        if (null == this.vctAreaContent) {
            return null;
        }
        InmDescObject descObject = this.getDescObject(sObjectName);
        if (null == descObject) {
            return null;
        }
        String sValue = descObject.getStringPropertyValue(sPropertyName);
        return sValue;
    }

    public int getDescObjectCount() {
        if (null == this.vctAreaContent) {
            return -1;
        }
        return this.vctAreaContent.size();
    }

    private String getDescObjectName(String sObjectLine) {
        StringBuffer sObjectName = new StringBuffer(20);
        boolean bConverted = false;
        if (sObjectLine == null || sObjectLine.length() == 0) {
            return null;
        }
        boolean bGetObjectName = false;
        int objectLineLength = sObjectLine.length();
        for (int iPos = 0; iPos < objectLineLength; ++iPos) {
            char ch = sObjectLine.charAt(iPos);
            if ('\\' == ch) {
                if (bConverted) {
                    bConverted = false;
                    sObjectName.append(ch);
                    continue;
                }
                bConverted = true;
                continue;
            }
            if ('(' == ch || ')' == ch || '|' == ch) {
                if (bConverted) {
                    sObjectName.append(ch);
                    bConverted = false;
                    continue;
                }
                return null;
            }
            if ('=' == ch) {
                if (!bConverted) {
                    bGetObjectName = true;
                    break;
                }
                sObjectName.append(ch);
                bConverted = false;
                continue;
            }
            if (!bConverted) {
                sObjectName.append(ch);
                continue;
            }
            return null;
        }
        if (!bGetObjectName) {
            return null;
        }
        String returnString = sObjectName.toString().trim();
        if (0 == returnString.length()) {
            return null;
        }
        return returnString;
    }

    private InmDescObject getDescObjectAgain(int index) {
        InmDescObject descObject = null;
        InmAreaDescObject areaObject = null;
        if (this.positionType == 2) {
            return null;
        }
        if (this.positionType == 1) {
            areaObject = this.getAreaDescObjectFromJar();
            if (null != areaObject) {
                descObject = areaObject.getDescObjectAgainEx(index);
            }
            return descObject;
        }
        areaObject = this.getAreaDescObjectFromUser();
        if (null == areaObject) {
            areaObject = this.getAreaDescObjectFromJar();
            if (null != areaObject) {
                descObject = areaObject.getDescObjectAgainEx(index);
            }
        } else {
            descObject = areaObject.getDescObjectAgainEx(index);
            if (null == descObject && null != (areaObject = this.getAreaDescObjectFromJar())) {
                descObject = areaObject.getDescObjectAgainEx(index);
            }
        }
        return descObject;
    }

    private InmDescObject getDescObjectAgain(String objectName) {
        InmDescObject descObject = null;
        InmAreaDescObject areaObject = null;
        if (this.positionType == 2) {
            return null;
        }
        if (this.positionType == 1) {
            areaObject = this.getAreaDescObjectFromJar();
            if (null != areaObject) {
                descObject = areaObject.getDescObjectAgainEx(objectName);
            }
            return descObject;
        }
        areaObject = this.getAreaDescObjectFromUser();
        if (null == areaObject) {
            areaObject = this.getAreaDescObjectFromJar();
            if (null != areaObject) {
                descObject = areaObject.getDescObjectAgainEx(objectName);
            }
        } else {
            descObject = areaObject.getDescObjectAgainEx(objectName);
            if (null == descObject && null != (areaObject = this.getAreaDescObjectFromJar())) {
                descObject = areaObject.getDescObjectAgainEx(objectName);
            }
        }
        return descObject;
    }

    private InmAreaDescObject getAreaDescObjectFromUser() {
        if (null == this.fileDescObject) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(" fileName = " + this.currentfileName);
        buffer.append(" areaName = " + this.getAreaNameAgainEx());
        if (null != this.fileDescObject.getAbsFileName()) {
            return null;
        }
        InmFileDescObject fileObject = InmProfileFactory.getFileDescObjectFromUser(this.currentfileName);
        if (null == fileObject) {
            return null;
        }
        InmAreaDescObject areaObject = fileObject.getAreaDescObjectEX(this.getAreaNameAgainEx(), false);
        if (null == areaObject) {
            return null;
        }
        return areaObject;
    }

    private InmAreaDescObject getAreaDescObjectFromJar() {
        if (null == this.fileDescObject) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(" fileName = " + this.currentfileName);
        buffer.append(" areaName = " + this.getAreaNameAgainEx());
        if (null != this.fileDescObject.getAbsFileName()) {
            return null;
        }
        InmFileDescObject fileObject = InmProfileFactory.getFileDescObjectFromJar(this.currentfileName);
        if (null == fileObject) {
            return null;
        }
        InmAreaDescObject areaObject = fileObject.getAreaDescObjectEX(this.getAreaNameAgainEx(), false);
        if (null == areaObject) {
            return null;
        }
        return areaObject;
    }

    public void setFileName(String fileName) {
        this.currentfileName = fileName;
    }

    public String getFileName() {
        return this.currentfileName;
    }

    public InmFileDescObject getFileDescObject() {
        return this.fileDescObject;
    }

    public boolean isForGEN() {
        return this.isForGEN;
    }

    public void setForGEN(boolean isForGEN) {
        this.isForGEN = isForGEN;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public void setPositionType(int positionType) {
        this.positionType = positionType;
    }
}

