/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class IPAddrDocument
extends PlainDocument {
    private static final String initIPAddrStr = "   .   .   .   ";
    private static final int[] separators = new int[]{3, 7, 11};
    private JTextComponent textComponent;
    private int newOffset;

    public IPAddrDocument(JTextComponent tc) {
        this.textComponent = tc;
        try {
            this.insertString(0, initIPAddrStr, null);
        }
        catch (Exception e) {
            TEAppletLogMgr.error("IPAddrDocument.IPAddrDocument() fail!", e);
        }
    }

    @Override
    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (this.isMemeberOfInitString(s)) {
            super.insertString(offset, s, attributeSet);
        } else {
            block5: {
                try {
                    Integer.parseInt(s);
                }
                catch (Exception ex) {
                    if (s.equals(" ")) break block5;
                    return;
                }
            }
            this.newOffset = offset;
            if (this.atSeparator(offset)) {
                this.textComponent.setCaretPosition(++this.newOffset);
            }
            super.remove(this.newOffset, s.length());
            super.insertString(this.newOffset, s, attributeSet);
        }
    }

    private boolean isMemeberOfInitString(String str) {
        return str.equals(initIPAddrStr);
    }

    private boolean isMemberOfSeparators(int sep) {
        for (int i = 0; i < separators.length; ++i) {
            if (separators[i] != sep) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (this.atSeparator(offset)) {
            this.textComponent.setCaretPosition(offset - 1);
        } else {
            this.textComponent.setCaretPosition(offset);
        }
    }

    private boolean atSeparator(int offset) {
        return this.isMemberOfSeparators(offset);
    }
}

