/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort;

import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.SorterInterface;
import java.util.Arrays;
import java.util.Comparator;

public class TableSorter {
    private SorterInterface sortDelegator;
    private transient Entry[] table;
    private Comparator delegateComp = null;
    private int oldCol = -1;
    private static final int TRUE = 1;
    private static final int FALSE = -1;

    public TableSorter(SorterInterface model) {
        this.sortDelegator = model;
    }

    private int rehash(int initLen) {
        if (this.table == null) {
            this.table = new Entry[initLen];
            return 1;
        }
        if (this.table.length != initLen) {
            this.table = null;
            this.table = new Entry[initLen];
            return 1;
        }
        return -1;
    }

    public void sort(int column, boolean isAscent) {
        int[] indexes = this.sortDelegator.getIndexes();
        int len = indexes.length;
        if (this.rehash(len) == 1) {
            for (int i = 0; i < len; ++i) {
                this.table[i] = new Entry();
            }
        }
        for (int index = 0; index < len; ++index) {
            this.table[index].key = index;
            this.table[index].value = this.sortDelegator.getModelValueAt(index, column);
        }
        this.initComp(column);
        Object[] aux = new Entry[len];
        System.arraycopy(this.table, 0, aux, 0, len);
        this.mergeSort((Entry[])aux, this.table, 0, len);
        Arrays.fill(aux, null);
        if (isAscent) {
            for (int i = 0; i < len; ++i) {
                indexes[i] = this.table[i].key;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                indexes[i] = this.table[len - i - 1].key;
            }
        }
    }

    private void mergeSort(Entry[] src, Entry[] dest, int low, int high) {
        if (high - low < 7) {
            int i = 0;
            for (i = low; i < high; ++i) {
                for (int j = i; j > low && this.compare1(dest[j - 1].value, dest[j].value) > 0; --j) {
                    TableSorter.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >>> 1;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.compare1(src[mid - 1].value, src[mid].value) <= 0) {
            System.arraycopy(src, low, dest, low, high - low);
            return;
        }
        int i = 0;
        int p = 0;
        int q = 0;
        p = low;
        q = mid;
        for (i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && this.compare1(src[p].value, src[q].value) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Entry[] x, int a, int b) {
        int key = x[a].key;
        Object value = x[a].value;
        x[a].key = x[b].key;
        x[a].value = x[b].value;
        x[b].key = key;
        x[b].value = value;
    }

    private void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private void initComp(int col) {
        if (this.oldCol != col || this.delegateComp == null) {
            this.oldCol = col;
            this.delegateComp = null;
            Class type = this.sortDelegator.getColumnClass(col);
            this.delegateComp = type == Boolean.class ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TableSorter.this.compare((Boolean)a, (Boolean)b);
                }
            } : new Comparator(){

                public int compare(Object a, Object b) {
                    return TableSorter.this.compare(a, b);
                }
            };
        }
    }

    private int compare1(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return this.delegateComp.compare(o1, o2);
    }

    public int compare(Boolean o1, Boolean o2) {
        boolean b2;
        boolean b1 = o1;
        if (b1 == (b2 = o2.booleanValue())) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return this.compare((Comparable)o1, (Comparable)o2);
        }
        String o1str = o1.toString();
        String o2str = o2.toString();
        return o1str.compareTo(o2str);
    }

    public int compare(Comparable o1, Comparable o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    private static class Entry
    implements Comparable {
        int key;
        Object value;

        public Entry() {
        }

        protected Entry(int _key, Object _value) {
            this.key = _key;
            this.value = _value;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Entry)) {
                return -1;
            }
            Entry data = (Entry)o;
            return this.key - data.key;
        }
    }
}

