/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort;

import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.HeaderListener;
import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.SortButtonRenderer;
import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.SortableTableModel;
import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.TableSortInterface;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortableTable
extends JTable {
    private SortButtonRenderer renderer = new SortButtonRenderer();
    private HeaderListener headListener = null;

    public SortableTable() {
        this(new SortableTableModel());
    }

    public SortableTable(DefaultTableModel model) {
        super(model);
        JTableHeader header = this.getTableHeader();
        this.headListener = new HeaderListener(header, this.renderer);
        header.addMouseListener(this.headListener);
    }

    public void addColumnSortAction() {
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderRenderer(this.renderer);
        }
    }

    public void addColumnSortAction(int column) {
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(column).setHeaderRenderer(this.renderer);
    }

    public void clearSortFlag() {
        this.renderer.clearSortFlag();
        this.getTableHeader().repaint();
    }

    public void sortByColumn(int column, boolean ascent) {
        int sortState = ascent ? 2 : 1;
        this.renderer.setSortState(column, sortState);
        if (this.headListener.sortInterface != null) {
            this.headListener.sortInterface.sortByColumn(column, ascent);
        } else {
            TableModel model = this.getModel();
            if (model instanceof TableSortInterface) {
                ((TableSortInterface)((Object)model)).sortByColumn(column, ascent);
            }
        }
    }
}

