/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort;

import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.BevelArrowIcon;
import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.BlankIcon;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int DESCENT = 1;
    public static final int ASCENT = 2;
    private int sortState = 0;
    private int sortedColumn = -1;
    private int pushedColumn = -1;
    private Icon blankIcon = new BlankIcon();
    private Icon descentIcon = new BevelArrowIcon(0, false, false);
    private Icon pressedDescentIcon = new BevelArrowIcon(0, false, true);
    private Icon ascentIcon = new BevelArrowIcon(1, false, false);
    private Icon pressedAscentIcon = new BevelArrowIcon(1, false, true);

    public SortButtonRenderer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(4);
        this.setIcon(this.blankIcon);
        this.setPressedIcon(this.blankIcon);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.sortedColumn == column) {
            switch (this.sortState) {
                case 2: {
                    this.setIcon(this.ascentIcon);
                    this.setPressedIcon(this.pressedAscentIcon);
                    break;
                }
                case 1: {
                    this.setIcon(this.descentIcon);
                    this.setPressedIcon(this.pressedDescentIcon);
                    break;
                }
                default: {
                    this.setIcon(this.blankIcon);
                    this.setPressedIcon(this.blankIcon);
                    break;
                }
            }
        } else {
            this.setIcon(this.blankIcon);
            this.setPressedIcon(this.blankIcon);
        }
        this.setText(value == null ? "" : value.toString());
        boolean isPressed = column == this.pushedColumn;
        this.getModel().setPressed(isPressed);
        this.getModel().setArmed(isPressed);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    public void setPressedColumn(int col) {
        this.pushedColumn = col;
    }

    public void setSortedColumn(int col) {
        if (col < 0) {
            this.sortState = 0;
            this.sortedColumn = -1;
        } else {
            this.sortedColumn = col;
        }
    }

    public void clearSortFlag() {
        this.setSortedColumn(-1);
        this.sortState = 0;
        this.setIcon(null);
        this.setPressedIcon(null);
    }

    public int getSortState(int column) {
        if (column == this.sortedColumn) {
            return this.sortState;
        }
        return 0;
    }

    public void setSortState(int sortState) {
        this.sortState = sortState;
    }

    public void setSortState(int column, int sortState) {
        this.sortState = sortState;
        this.setSortedColumn(column);
    }
}

