/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort;

import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.SortButtonRenderer;
import com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort.TableSortInterface;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class HeaderListener
extends MouseAdapter {
    protected JTableHeader header;
    protected SortButtonRenderer renderer;
    TableSortInterface sortInterface;

    public HeaderListener(JTableHeader header, SortButtonRenderer renderer) {
        this.header = header;
        this.renderer = renderer;
    }

    public HeaderListener(JTableHeader header, SortButtonRenderer renderer, TableSortInterface sortI) {
        this.header = header;
        this.renderer = renderer;
        this.sortInterface = sortI;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.renderer.isEnabled()) {
            return;
        }
        int type = this.header.getCursor().getType();
        if (type != 10 && type != 11 && (e.getModifiers() & 0x10) != 0) {
            int col = this.header.columnAtPoint(e.getPoint());
            int sortCol = this.header.getTable().convertColumnIndexToModel(col);
            if (col < 0 || sortCol < 0) {
                return;
            }
            TableCellRenderer hr = this.header.getTable().getColumnModel().getColumn(col).getHeaderRenderer();
            if (!(hr instanceof SortButtonRenderer)) {
                return;
            }
            this.renderer.setPressedColumn(col);
            this.renderer.setSortedColumn(col);
            this.header.repaint();
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean isAscent = false;
            if (this.renderer.getSortState(col) != 2) {
                isAscent = true;
            }
            this.renderer.setSortState(isAscent ? 2 : 1);
            if (this.sortInterface != null) {
                this.sortInterface.sortByColumn(sortCol, isAscent);
            } else {
                TableModel m = this.header.getTable().getModel();
                if (m instanceof TableSortInterface) {
                    ((TableSortInterface)((Object)m)).sortByColumn(sortCol, isAscent);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.renderer.setPressedColumn(-1);
        this.header.repaint();
    }
}

