/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.beans.sort;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class DataSortor {
    public static final byte SORT_STATE_NONE = 0;
    public static final byte SORT_STATE_ASCEND = 1;
    public static final byte SORT_STATE_DESCEND = -1;

    public static void quickSortTableData(Vector dataVector, int low, int high, int nCol, int sortState) {
        if (low >= high) {
            return;
        }
        int k = low;
        for (int i = low + 1; i <= high; ++i) {
            if (DataSortor.comp(dataVector, low, i, nCol, sortState) <= 0) continue;
            DataSortor.swap(dataVector, ++k, i);
        }
        DataSortor.swap(dataVector, low, k);
        DataSortor.quickSortTableData(dataVector, k + 1, high, nCol, sortState);
        DataSortor.quickSortTableData(dataVector, low, k - 1, nCol, sortState);
    }

    public static void selectSortTableData(Vector dataVector, int nCol, int sortState) {
        for (int i = 0; i < dataVector.size() - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < dataVector.size(); ++j) {
                if (DataSortor.comp(dataVector, k, j, nCol, sortState) <= 0) continue;
                k = j;
            }
            if (k == i) continue;
            DataSortor.swap(dataVector, k, i);
        }
    }

    public static void selectSortVector(Vector dataVector, int sortState) {
        for (int i = 0; i < dataVector.size() - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < dataVector.size(); ++j) {
                if (DataSortor.comp(dataVector, k, j, sortState) <= 0) continue;
                k = j;
            }
            if (k == i) continue;
            DataSortor.swap(dataVector, k, i);
        }
    }

    public static void insertToSortedVector(Vector list, Object anObject, int sortState) {
        int cmpVal;
        if (list.size() == 0) {
            list.addElement(anObject);
            return;
        }
        int low = 0;
        int high = list.size() - 1;
        int mid = (low + high) / 2;
        while (low < high && (cmpVal = DataSortor.comp(anObject, list.elementAt(mid), sortState)) != 0) {
            if (cmpVal < 0) {
                high = mid - 1;
            } else {
                low = mid + 1;
            }
            mid = (low + high) / 2;
        }
        cmpVal = DataSortor.comp(anObject, list.elementAt(mid), sortState);
        if (cmpVal > 0) {
            if (mid < list.size() - 1) {
                list.insertElementAt(anObject, mid + 1);
            } else {
                list.addElement(anObject);
            }
        } else {
            list.insertElementAt(anObject, mid);
        }
    }

    public static void insertToSortedVector(Vector list, Object anObject) {
        DataSortor.insertToSortedVector(list, anObject, 1);
    }

    static int comp(Vector list, int i, int j, int sortState) {
        Object cmp1 = list.elementAt(i);
        Object cmp2 = list.elementAt(j);
        return DataSortor.comp(cmp1, cmp2, sortState);
    }

    static int comp(Object cmp1, Object cmp2, int sortState) {
        int compareValue;
        if (cmp1 == null) {
            compareValue = -1;
        } else if (cmp2 == null) {
            compareValue = 1;
        } else if (cmp1 instanceof Comparable && cmp2 instanceof Comparable) {
            if (cmp1 instanceof String && cmp2 instanceof String) {
                String s1 = (String)cmp1;
                String s2 = (String)cmp2;
                Collator myCollator = Collator.getInstance();
                compareValue = myCollator.compare(s1, s2);
            } else {
                compareValue = ((Comparable)cmp1).compareTo(cmp2);
            }
        } else {
            compareValue = cmp1 instanceof Comparator && cmp2 instanceof Comparator ? ((Comparator)cmp1).compare(cmp1, cmp2) : cmp1.toString().compareTo(cmp2.toString());
        }
        if (sortState == -1) {
            compareValue = -compareValue;
        }
        return compareValue;
    }

    public static int comp(Vector v, int i, int j, int nCol, int sortState) {
        Vector rowData1 = (Vector)v.elementAt(i);
        Vector rowData2 = (Vector)v.elementAt(j);
        Object cmp1 = rowData1.elementAt(nCol);
        Object cmp2 = rowData2.elementAt(nCol);
        return DataSortor.comp(cmp1, cmp2, sortState);
    }

    public static void sortTable(Vector dataVector, final int nCol, final int sortState) {
        Collections.sort(dataVector, new Comparator(){

            public int compare(Object o1, Object o2) {
                Vector v1 = (Vector)o1;
                Vector v2 = (Vector)o2;
                return DataSortor.comp(v1.elementAt(nCol), v2.elementAt(nCol), sortState);
            }
        });
    }

    public static void swap(Vector v, int i, int j) {
        if (i == j) {
            return;
        }
        Object o = v.elementAt(i);
        v.setElementAt(v.elementAt(j), i);
        v.setElementAt(o, j);
    }
}

