/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.datainterface;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Option;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;

public class Param
implements Serializable,
Cloneable {
    private String _name;
    private String _value;
    private boolean _modifyFlag;
    private boolean _has_modifyFlag;
    private ArrayList _optionList;

    public Param() {
        this._modifyFlag = true;
        this._optionList = new ArrayList();
    }

    public Param(String name, String value) {
        this.setName(name);
        this.setValue(value);
        this._modifyFlag = true;
        this._optionList = new ArrayList();
    }

    public void addOption(Option vOption) throws IndexOutOfBoundsException {
        this._optionList.add(vOption);
    }

    public void addOption(int index, Option vOption) throws IndexOutOfBoundsException {
        this._optionList.add(index, vOption);
    }

    public void clearOption() {
        this._optionList.clear();
    }

    public void deleteModifyFlag() {
        this._has_modifyFlag = false;
    }

    public boolean getModifyFlag() {
        return this._modifyFlag;
    }

    public String getName() {
        return this._name;
    }

    public Option getOption(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._optionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Option)this._optionList.get(index);
    }

    public Option[] getOption() {
        int size = this._optionList.size();
        Option[] mArray = new Option[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Option)this._optionList.get(index);
        }
        return mArray;
    }

    public int getOptionCount() {
        return this._optionList.size();
    }

    public String getValue() {
        return this._value;
    }

    public String getEncodeValue() {
        try {
            return URLEncoder.encode(this._value, "UTF-8");
        }
        catch (Exception e) {
            return this._value;
        }
    }

    public boolean hasModifyFlag() {
        return this._has_modifyFlag;
    }

    public boolean removeOption(Option vOption) {
        boolean removed = this._optionList.remove(vOption);
        return removed;
    }

    public void setModifyFlag(boolean modifyFlag) {
        this._modifyFlag = modifyFlag;
        this._has_modifyFlag = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOption(int index, Option vOption) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._optionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._optionList.set(index, vOption);
    }

    public void setOption(Option[] optionArray) {
        this._optionList.clear();
        for (int i = 0; i < optionArray.length; ++i) {
            this._optionList.add(optionArray[i]);
        }
    }

    public void setValue(String value) {
        this._value = value;
    }

    public int compareTo(Param anotherParam, String paramType) {
        int result = -1;
        if (!this._name.equals(anotherParam.getName())) {
            return result;
        }
        String value = this.getValue();
        String anothervalue = anotherParam.getValue();
        result = null == paramType || paramType.equals("") || paramType.equalsIgnoreCase("String") ? value.compareTo(anothervalue) : (paramType.equalsIgnoreCase("int") || paramType.equalsIgnoreCase("integer") || paramType.equalsIgnoreCase("byte") ? new Integer(value).compareTo(new Integer(anothervalue)) : (paramType.equalsIgnoreCase("long") ? new Long(value).compareTo(new Long(anothervalue)) : (paramType.equalsIgnoreCase("double") ? new Double(value).compareTo(new Double(anothervalue)) : (paramType.equalsIgnoreCase("float") ? new Float(value).compareTo(new Float(anothervalue)) : value.compareTo(anothervalue)))));
        return result;
    }

    public Object clone() {
        Param cloneParam = new Param();
        try {
            cloneParam = (Param)super.clone();
        }
        catch (Exception e) {
            TEAppletLogMgr.error("Param.clone() fail!", e);
        }
        return cloneParam;
    }
}

