/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.component.toolbar;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.util.TEFloatTextField;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TEOTDRGraphCustomZoomDlg
extends JDialog {
    private static final float GAIN_MIN_VALUE = 0.3f;
    private static final float RANGE_MIN_VALUE = 0.4f;
    private static final String GAIN_UNIT = "dB";
    private static final String RANGE_UNIT = "Km";
    private TEFloatTextField topGainField = null;
    private TEFloatTextField bottomGainField = null;
    private TEFloatTextField leftPositionField = null;
    private TEFloatTextField rightPositionField = null;
    private InmButton okBtn = null;
    private InmButton cancelBtn = null;
    private static final String DEBUGSTR = "**********TEOTDRGraphCustomZoomDlg**********";
    private float lineRange = 0.0f;
    private static final String STR_RES_FILE = "res" + File.separator + "toolbarstringres_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private static final TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance(STR_RES_FILE);
    private static final float DEFAULT_TOPGAIN = 20.0f;
    private static final float DEFAULT_BOTTOMGAIN = -40.0f;
    private static final float DEFAULT_LEFTPOS = 0.0f;
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;

    public TEOTDRGraphCustomZoomDlg(Frame parent, int lineRange, TEOTDRGraphModuleMgr teOTDRGraphModuleMgr) {
        super(parent);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.lineRange = (float)lineRange / 1000.0f;
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.initComponent();
        this.jbinit();
        this.setTitle(resUtil.getString("customzoomtitle"));
    }

    private void initComponent() {
        this.topGainField = new TEFloatTextField(-40.0f, 20.0f);
        this.topGainField.setText(String.valueOf(20.0f));
        this.bottomGainField = new TEFloatTextField(-40.0f, 20.0f);
        this.bottomGainField.setText(String.valueOf(-40.0f));
        this.leftPositionField = new TEFloatTextField(0.0f, this.lineRange);
        this.leftPositionField.setText(String.valueOf(0.0f));
        this.rightPositionField = new TEFloatTextField(0.0f, this.lineRange);
        this.rightPositionField.setText(String.valueOf(this.lineRange));
        this.okBtn = new InmButton(resUtil.getString("okbtntext"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphCustomZoomDlg.this.doCustomZoom();
            }
        });
        this.cancelBtn = new InmButton(resUtil.getString("cancelbtntext"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphCustomZoomDlg.this.destroy();
            }
        });
    }

    protected void destroy() {
        this.dispose();
    }

    protected void doCustomZoom() {
        if (!this.check()) {
            return;
        }
        int[] zdata = new int[]{(int)(Float.parseFloat(this.topGainField.getText()) * 1000.0f), (int)(Float.parseFloat(this.bottomGainField.getText()) * 1000.0f), (int)(Float.parseFloat(this.leftPositionField.getText()) * 1000.0f), (int)(Float.parseFloat(this.rightPositionField.getText()) * 1000.0f)};
        this.log("call TEOTDRGraphGraphInterface.doZoom(data)" + Arrays.toString(zdata));
        TEOTDRGraphGraphInterface ginf = this.teOTDRGraphModuleMgr.getGraphInteractor();
        if (null != ginf) {
            ginf.doZoom(zdata);
        }
        this.dispose();
    }

    private boolean check() {
        boolean result = true;
        float t_gain = Float.parseFloat(this.topGainField.getText());
        float b_gain = Float.parseFloat(this.bottomGainField.getText());
        float l_pos = Float.parseFloat(this.leftPositionField.getText());
        float r_pos = Float.parseFloat(this.rightPositionField.getText());
        boolean bl = result = t_gain >= b_gain + 0.3f;
        if (!result) {
            InmOptionPane.showMessageDialog(this, resUtil.getString("zoomgaindataerror") + 0.3f + GAIN_UNIT);
            return result;
        }
        boolean bl2 = result = r_pos >= 0.4f + l_pos;
        if (!result) {
            InmOptionPane.showMessageDialog(this, resUtil.getString("zoomrangedataerror") + 0.4f + RANGE_UNIT);
            return result;
        }
        return result;
    }

    private void jbinit() {
        Container con = this.getContentPane();
        con.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel topGainLabel = new JLabel("Top");
        JLabel topUnitLabel = new JLabel(GAIN_UNIT);
        JLabel bottomGainLabel = new JLabel("Bottom");
        JLabel bottomUnitLabel = new JLabel(GAIN_UNIT);
        JLabel leftPosLabel = new JLabel("Left");
        JLabel leftUnitLabel = new JLabel(RANGE_UNIT);
        JLabel rightPosLabel = new JLabel("Right");
        JLabel rightUnitLabel = new JLabel(RANGE_UNIT);
        panel.add((Component)topGainLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 10, 5), 0, 0));
        panel.add((Component)this.topGainField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)topUnitLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)bottomGainLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 10, 5), 0, 0));
        panel.add((Component)this.bottomGainField, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)bottomUnitLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 20), 0, 0));
        panel.add((Component)leftPosLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel.add((Component)this.leftPositionField, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)leftUnitLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)rightPosLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel.add((Component)this.rightPositionField, new GridBagConstraints(4, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)rightUnitLabel, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        panel.setBorder(BorderFactory.createEtchedBorder());
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.add(this.okBtn);
        btnPanel.add(this.cancelBtn);
        this.add((Component)panel, "Center");
        this.add((Component)btnPanel, "South");
        this.setSize(325, 140);
    }

    private void log(Object obj) {
        System.out.println(DEBUGSTR + obj);
    }
}

