/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.component.toolbar;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphViewTestRecordView;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import com.huawei.nglct.otdr.appletgraph.core.util.TEFloatTextField;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;

class TEOTDRGraphCustomMoveGraphDlg
extends JDialog {
    private static final String APPLYBTNTEXT = "applybtntext";
    private static final String CANCELBTNTEXT = "cancelbtntext";
    private static final String OKBTNTEXT = "okbtntext";
    private static final String DEFAULTBTNTEXT = "defaultbtntext";
    private static final String GRAPHMOVEDLGTLE = "graphmovedlgtle";
    private static final String GAIN_COLNAME = "gaincolname";
    private static final String LOCATION_COLNAME = "locationcolname";
    private static final String FILENAME_COLNAME = "filenamecolname";
    private InmButton defaultValueBtn = null;
    private InmButton okBtn = null;
    private InmButton cancelBtn = null;
    private InmButton applyBtn = null;
    private Map<String, int[]> moveData = null;
    private InmTable table = null;
    private DefaultCellEditor gainEditor = null;
    private DefaultCellEditor positionEditor = null;
    private static final int COL_FILENAME = 0;
    private static final int COL_GAIN = 2;
    private static final int COL_POSITION = 1;
    private static final float GAIN_MIN = -40.0f;
    private static final float GAIN_MAX = 20.0f;
    private static final float RANGE_MIN = 0.0f;
    private float lineRange = 0.0f;
    private static final String DEBUGSTR = "**********TEOTDRGraphCustomMoveGraphDlg**********";
    private static final String STR_RES_FILE = "res" + File.separator + "toolbarstringres_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private static final TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance(STR_RES_FILE);
    private final TEMarineResourceUtil strResUtil = TEMarineResourceUtil.getInstance("res/stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TECommonUtil teCommonUtil = null;

    TEOTDRGraphCustomMoveGraphDlg(Frame f, Map<String, int[]> moveData, TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TECommonUtil teCommonUtil) {
        super(f);
        this.setModal(true);
        this.moveData = moveData;
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teCommonUtil = teCommonUtil;
        TEOTDRGraphGraphInterface ginf = teOTDRGraphModuleMgr.getGraphInteractor();
        this.log("call TEOTDRGraphGraphInterface.getCurrentLineRange()");
        this.lineRange = ginf.getCurrentLineRange();
        this.lineRange /= 1000.0f;
        this.initComponent();
        this.jbinit();
        this.setTitle(resUtil.getString(GRAPHMOVEDLGTLE));
    }

    private void jbinit() {
        this.setDefaultCloseOperation(2);
        Container con = this.getContentPane();
        con.setLayout(new BorderLayout());
        JScrollPane tablePane = new JScrollPane(this.table);
        con.add((Component)tablePane, "Center");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2));
        p.add(this.defaultValueBtn);
        p.add(this.okBtn);
        p.add(this.cancelBtn);
        p.add(this.applyBtn);
        con.add((Component)p, "South");
        this.setSize(500, 200);
    }

    private void initComponent() {
        this.initTable();
        this.initButtons();
    }

    private void initButtons() {
        this.defaultValueBtn = new InmButton(resUtil.getString(DEFAULTBTNTEXT));
        this.defaultValueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphCustomMoveGraphDlg.this.setDefaultValue();
            }
        });
        this.defaultValueBtn.setEnabled(this.table.getRowCount() > 0);
        this.okBtn = new InmButton(resUtil.getString(OKBTNTEXT));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphCustomMoveGraphDlg.this.doOK();
            }
        });
        this.cancelBtn = new InmButton(resUtil.getString(CANCELBTNTEXT));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphCustomMoveGraphDlg.this.dispose();
            }
        });
        this.applyBtn = new InmButton(resUtil.getString(APPLYBTNTEXT));
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphCustomMoveGraphDlg.this.doApply();
            }
        });
        this.applyBtn.setEnabled(false);
    }

    protected boolean doApply() {
        this.table.cancelEditing();
        if (!this.check()) {
            return false;
        }
        HashMap<String, int[]> data = new HashMap<String, int[]>();
        int rowCount = this.table.getRowCount();
        int noChangeNum = 0;
        for (int i = 0; i < rowCount; ++i) {
            String fileName = ((FileNameWrapper)this.table.getValueAt(i, 0)).getRealName();
            int[] t_data = new int[2];
            int gain = (int)(Float.parseFloat(this.table.getValueAt(i, 2).toString()) * 1000.0f);
            int pos = (int)(Float.parseFloat(this.table.getValueAt(i, 1).toString()) * 1000.0f);
            t_data[0] = gain;
            t_data[1] = pos;
            if (gain == this.moveData.get(fileName)[0] && pos == this.moveData.get(fileName)[1]) {
                ++noChangeNum;
            }
            data.put(fileName, t_data);
        }
        if (noChangeNum == this.moveData.size()) {
            JFrame component = (JFrame)(TECommonUtil.isDebug ? TECommonUtil.getTopFrame(this) : this.teCommonUtil.getApplet());
            InmOptionPane.showMessageDialog(component, resUtil.getString("offsetnochange"));
            return false;
        }
        this.log("call TEOTDRGraphGraphInterface.doMove(data);" + data);
        TEOTDRGraphGraphInterface ginf = this.teOTDRGraphModuleMgr.getGraphInteractor();
        if (null != ginf) {
            ginf.doMove(data);
        }
        this.applyBtn.setEnabled(false);
        return true;
    }

    private boolean check() {
        return true;
    }

    protected void doOK() {
        if (!this.applyBtn.isEnabled()) {
            this.dispose();
        }
        if (this.doApply()) {
            this.dispose();
        }
    }

    protected void setDefaultValue() {
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.table.setValueAt(0, i, 1);
            this.table.setValueAt(i * -2, i, 2);
        }
    }

    private void initTable() {
        this.initCellEditor();
        if (null == this.moveData) {
            this.moveData = new HashMap<String, int[]>();
        }
        int len = this.moveData.size();
        Object[][] tableData = new Object[len][3];
        Object[] fArray = this.moveData.keySet().toArray();
        Arrays.sort(fArray);
        int index = 0;
        for (int i = 0; i < fArray.length; ++i) {
            String fileName = fArray[i].toString();
            int[] t_data = this.moveData.get(fileName);
            float gain = (float)t_data[0] / 1000.0f;
            float pos = (float)t_data[1] / 1000.0f;
            String showFileName = this.teCommonUtil.getParamFromFileName(fileName, "showName", this.isViewTestRecordView());
            if (showFileName.indexOf("mid") == -1) {
                boolean isBaseLine = TECommonUtil.getParamMapFromFileName(fileName, false).get("baseline").equals("1");
                showFileName = isBaseLine ? this.strResUtil.getString("BASELINE_NAME") : showFileName;
            }
            tableData[index][0] = new FileNameWrapper(fileName, showFileName);
            tableData[index][1] = Float.valueOf(pos);
            tableData[index][2] = Float.valueOf(gain);
            ++index;
        }
        String[] columnNames = new String[]{resUtil.getString(FILENAME_COLNAME), resUtil.getString(LOCATION_COLNAME), resUtil.getString(GAIN_COLNAME)};
        this.table = new InmTable(tableData, columnNames){

            @Override
            public boolean isCellEditable(int row, int col) {
                return 0 != col;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int col) {
                if (2 == col) {
                    return TEOTDRGraphCustomMoveGraphDlg.this.gainEditor;
                }
                if (1 == col) {
                    return TEOTDRGraphCustomMoveGraphDlg.this.positionEditor;
                }
                return super.getCellEditor();
            }

            @Override
            public void setValueAt(Object obj, int row, int col) {
                if ("-".equals(obj)) {
                    obj = 1 == col ? Float.valueOf(0.0f) : Float.valueOf(-40.0f);
                }
                super.setValueAt(obj, row, col);
                TEOTDRGraphCustomMoveGraphDlg.this.doAfterValueChanged();
            }
        };
        this.table.setSortable(false);
        this.table.setCustomizable(false);
    }

    protected void doAfterValueChanged() {
        this.applyBtn.setEnabled(true);
        this.okBtn.setEnabled(true);
    }

    private void initCellEditor() {
        this.gainEditor = new DefaultCellEditor(new TEFloatTextField(-40.0f, 20.0f));
        this.positionEditor = new DefaultCellEditor(new TEFloatTextField(0.0f, this.lineRange));
    }

    public static void main(String[] args) {
        HashMap<String, int[]> m = new HashMap<String, int[]>();
        m.put("a", new int[]{3, 4});
        m.put("b", new int[]{3, 4});
        m.put("c", new int[]{3, 4});
    }

    private void log(Object obj) {
        System.out.println(DEBUGSTR + obj);
    }

    private boolean isViewTestRecordView() {
        TEOTDRGraphModule module = this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module instanceof TEOTDRGraphViewTestRecordView;
    }

    private class FileNameWrapper
    implements Comparable<FileNameWrapper> {
        private String showName = null;
        private String realName = null;

        FileNameWrapper(String _realName, String _showName) {
            this.realName = _realName;
            this.showName = _showName;
        }

        public String toString() {
            return this.showName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.realName == null ? 0 : this.realName.hashCode());
            result = 31 * result + (this.showName == null ? 0 : this.showName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileNameWrapper other = (FileNameWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.realName == null ? other.realName != null : !this.realName.equals(other.realName)) {
                return false;
            }
            return !(this.showName == null ? other.showName != null : !this.showName.equals(other.showName));
        }

        private TEOTDRGraphCustomMoveGraphDlg getOuterType() {
            return TEOTDRGraphCustomMoveGraphDlg.this;
        }

        public String getShowName() {
            return this.showName;
        }

        public void setShowName(String showName) {
            this.showName = showName;
        }

        public String getRealName() {
            return this.realName;
        }

        public void setRealName(String realName) {
            this.realName = realName;
        }

        @Override
        public int compareTo(FileNameWrapper o) {
            if (null == this.realName) {
                return 0;
            }
            return this.realName.compareTo(o.realName);
        }
    }
}

