/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.common.colorselect;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TEColorSelectedDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String STR_RES_FILE = "res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance(STR_RES_FILE);
    private String titleName = null;
    private String labelName = this.resUtil.getString("selectColor");
    private JButton okBtn = null;
    private JButton cancelBtn = null;
    private Map<Integer, TEColorLabel> labelMap = new HashMap<Integer, TEColorLabel>();
    private int[] colorArray = new int[]{0xFF7171, 16744512, 0xFFFF62, 0x808040, 33023, 0x5252A5, 0xC0C0C0, 0xFFFFFF};
    private TEColorLabel selectedLabel = null;

    TEColorSelectedDlg(Frame frame, String title, boolean modal, ActionListener okListener) {
        super(frame, title, modal);
        this.titleName = title;
        this.initDlg(okListener);
    }

    private void initDlg(ActionListener okListener) {
        this.initColorLable();
        this.initButton();
        this.jbInit();
        if (okListener != null) {
            this.okBtn.addActionListener(okListener);
        }
    }

    private void jbInit() {
        this.setTitle(this.titleName);
        this.setSize(360, 160);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JLabel label = new JLabel(this.labelName);
        GridBagConstraints c1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(2, 2, 2, 0), 0, 0);
        this.add((Component)label, c1);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout());
        this.addLabel(labelPanel);
        GridBagConstraints c2 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
        this.add((Component)labelPanel, c2);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new GridBagLayout());
        btnPanel.add((Component)this.okBtn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 2, 10, 2), 0, 0));
        btnPanel.add((Component)this.cancelBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 2, 10, 2), 0, 0));
        this.add((Component)btnPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.repaint();
        this.setDefaultCloseOperation(2);
    }

    private void addLabel(JPanel labelPanel) {
        if (null == this.labelMap || this.labelMap.isEmpty() || null == labelPanel) {
            return;
        }
        Set<Map.Entry<Integer, TEColorLabel>> entrySet = this.labelMap.entrySet();
        for (Map.Entry<Integer, TEColorLabel> entry : entrySet) {
            TEColorLabel label = entry.getValue();
            labelPanel.add(label);
        }
    }

    private void initButton() {
        this.okBtn = new JButton(this.resUtil.getString("okBtnStr"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == TEColorSelectedDlg.this.getColor()) {
                    InmOptionPane.showMessageDialog(null, TEColorSelectedDlg.this.resUtil.getString("nochoosecolor"));
                    return;
                }
                TEColorSelectedDlg.this.dispose();
            }
        });
        this.cancelBtn = new JButton(this.resUtil.getString("cancelBtnStr"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEColorSelectedDlg.this.dispose();
            }
        });
    }

    @Override
    public void dispose() {
        this.colorArray = null;
        this.labelMap.clear();
        super.dispose();
    }

    private void initColorLable() {
        int len = this.colorArray.length;
        for (int i = 0; i < len; ++i) {
            this.labelMap.put(i, new TEColorLabel(this.colorArray[i]));
        }
    }

    Color getColor() {
        if (null == this.selectedLabel) {
            return null;
        }
        return new Color(this.selectedLabel.getIntColor());
    }

    class TEColorIcon
    implements Icon {
        private Color fillColor;
        private int width = 30;
        private int height = 30;

        public TEColorIcon(int colorInt) {
            this.fillColor = new Color(colorInt);
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.width - 1, this.height - 1);
            g.setColor(this.fillColor);
            g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
        }
    }

    class TEColorLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private Color borderColor;
        private int colorValue;

        public TEColorLabel(int colorInt) {
            super(new TEColorIcon(colorInt));
            this.borderColor = new Color(0, 0, 0);
            this.colorValue = colorInt;
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setVisible(true);
            this.initActionListener();
        }

        private void initActionListener() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TEColorLabel.this.handleMouseReleasedEvent(e);
                }
            };
            this.addMouseListener(mouseAdapter);
        }

        private void handleMouseReleasedEvent(MouseEvent e) {
            if (16 != e.getModifiers()) {
                return;
            }
            if (null != TEColorSelectedDlg.this.selectedLabel) {
                TEColorSelectedDlg.this.selectedLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            }
            this.setBorder(BorderFactory.createLineBorder(this.borderColor));
            TEColorSelectedDlg.this.selectedLabel = this;
        }

        public int getIntColor() {
            return this.colorValue;
        }
    }
}

