/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.common;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseXML {
    private TEParseXML() {
    }

    public static Document parseAppletFile(String filepath) {
        try {
            File file = new File(filepath);
            return TEParseXML.parseFile(file);
        }
        catch (Exception e) {
            System.out.println("Parse file is error,file name is " + filepath);
            TEAppletLogMgr.error("TEParseXML.parseAppletFile() fail!", e);
            return null;
        }
    }

    private static Document parseFile(File file) {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            System.out.println("Parse file is error,file name is " + file.getAbsolutePath());
            return null;
        }
        return doc;
    }

    public static HashMap<String, String> parseString(String urlStr) {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(urlStr);
        }
        catch (Exception e) {
            System.out.println("Parse file is error,xml is: " + urlStr);
            return null;
        }
        return TEParseXML.parseDoc(doc);
    }

    private static HashMap<String, String> parseDoc(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        TEParseXML.parseNode(doc.getFirstChild(), map);
        return map;
    }

    private static void parseNode(Node node, HashMap<String, String> map) {
        NodeList childNodeList = node.getChildNodes();
        Node childNode = null;
        String key = null;
        String value = null;
        if (null != childNodeList && childNodeList.getLength() > 0) {
            for (int i = childNodeList.getLength() - 1; i >= 0; --i) {
                childNode = childNodeList.item(i);
                if (childNode.getNodeType() != 1) continue;
                if (childNode.hasChildNodes() && childNode.getChildNodes().getLength() > 1) {
                    TEParseXML.parseNode(childNode, map);
                    continue;
                }
                key = childNode.getNodeName();
                value = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : childNode.getNodeValue();
                map.put(key, value);
            }
        }
    }
}

