/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.common;

import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceDataPtsInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceDeviceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceEventInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceParamsInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceReperterInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.ErrorMessage;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Param;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowErrors;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.TEOTDRAllError;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultStruct;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultVector;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.TEOperationShowMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.RootPaneContainer;

public class TECommonUtil {
    private static String serverURLStr = null;
    private JApplet applet = null;
    private HashMap<String, String> params = new HashMap();
    private ArrayList<String> fileList = new ArrayList();
    private ArrayList<String> opendedFileList = new ArrayList();
    private HashMap<String, TEOTDRGraphTraceInfo> opendedFileContentMap = new HashMap();
    private HashMap<String, Color> fileColorMap = new HashMap();
    public static boolean isDebug = false;
    private static final int INTEGRATION_STATUS = 1;

    public void destroy() {
        this.params.clear();
        this.fileList.clear();
        this.opendedFileList.clear();
        this.opendedFileContentMap.clear();
        this.fileColorMap.clear();
    }

    public void setApplet(JApplet obj) {
        String urlStr = null;
        this.applet = obj;
        if (null != this.applet) {
            urlStr = this.applet.getDocumentBase().toString();
            this.setUrl(urlStr);
            TECommonUtil.log("TECommonUtil.setApplet()", "urlStr is: " + urlStr);
            TESystemMgr.getInstance();
            TESystemMgr.getInstance().setProperty("nmUser", this.params.get("nmUser"));
            TESystemMgr.getInstance().setProperty("language", this.params.get("language"));
        }
    }

    public JApplet getApplet() {
        return this.applet;
    }

    public void setUrl(String urlStr) {
        int status;
        String[] paramStrSplit;
        String[] urlStrSplit = urlStr.split("/");
        StringBuffer sb = new StringBuffer();
        sb.append(urlStrSplit[0]).append("//");
        sb.append(urlStrSplit[2]).append("/");
        sb.append(urlStrSplit[3]).append("/");
        String paramStr = urlStr.substring(urlStr.indexOf("?") + 1);
        for (String str : paramStrSplit = paramStr.split("&")) {
            String[] valueStrSplit = str.split("=");
            if (valueStrSplit.length != 2) continue;
            this.params.put(valueStrSplit[0], valueStrSplit[1]);
        }
        if (null != this.params.get("status") && 1 == (status = Integer.parseInt(this.params.get("status")))) {
            sb.append(urlStrSplit[4]).append("/");
            sb.append(urlStrSplit[5]).append("/");
        }
        serverURLStr = sb.toString();
        System.out.println(serverURLStr);
    }

    public Frame getTopFrame() {
        return (Frame)this.applet.getParent();
    }

    public RootPaneContainer getRootPaneContainer(Component c) {
        if (null != c) {
            if (c instanceof RootPaneContainer) {
                return (RootPaneContainer)((Object)c);
            }
            while (c.getParent() != null) {
                if (!((c = c.getParent()) instanceof RootPaneContainer)) continue;
                return (RootPaneContainer)((Object)c);
            }
        }
        return null;
    }

    public static Frame getTopFrame(Component c) {
        if (null != c) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            while (c.getParent() != null) {
                if (!((c = c.getParent()) instanceof Frame)) continue;
                return (Frame)c;
            }
        }
        return null;
    }

    public static String getServerPath() {
        return serverURLStr;
    }

    public static String getAppletPath() {
        return System.getProperty("user.dir") + "/bin/";
    }

    public void showOptionMessage(Component parentComponent, Datainterface rsp, List<String> operObjParamList) {
        TEOTDRAllError allError = rsp.getAllError();
        ArrayList<RowErrors> rowErrorsList = allError.getRowErrors();
        RowErrors rowErrors = null;
        Iterator<String> iter = null;
        Param param = null;
        String paramName2 = null;
        String paramValue = null;
        StringBuffer operObjBuffer = new StringBuffer();
        int len = rowErrorsList.size();
        for (int i = 0; i < len; ++i) {
            rowErrors = rowErrorsList.get(i);
            for (String paramName2 : operObjParamList) {
                param = rowErrors.getParam(paramName2);
                paramValue = null == param || null == param.getValue() ? "UNKNOWN" : param.getValue();
                if (0 != operObjBuffer.length()) {
                    operObjBuffer.append("-");
                }
                operObjBuffer.append(paramValue);
            }
        }
        this.showOptionMessage(parentComponent, rsp, operObjBuffer.toString());
    }

    public void showOptionMessage(Component parentComponent, Datainterface rsp, String operObj) {
        TEOTDRAllError allError = rsp.getAllError();
        ErrorMessage errorMessage = allError.getS_error();
        ArrayList<RowErrors> rowErrorsList = allError.getRowErrors();
        RowErrors rowErrors = null;
        int errorCode = -1;
        String result = errorMessage.getErrorinfo();
        InmOperResultVector resultVector = new InmOperResultVector();
        InmOperResultStruct resultStruct = null;
        TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
        int len = rowErrorsList.size();
        for (int i = 0; i < len; ++i) {
            rowErrors = rowErrorsList.get(i);
            errorMessage = rowErrors.getErrorMessage();
            resultStruct = new InmOperResultStruct();
            resultStruct.operObj = operObj;
            errorCode = Integer.parseInt(errorMessage.getErrorcode());
            resultStruct.operResult = resUtil.getString("OPER" + errorCode);
            resultStruct.operReason = errorMessage.getErrorinfo();
            resultVector.add(resultStruct);
        }
        TEOperationShowMessage.showOperationDlg(parentComponent, result, resultVector, true, 1);
    }

    public void showOptionMessage(Component parentComponent, String result) {
        TEOperationShowMessage.showOperationDlg(parentComponent, result, true);
    }

    public void showOptionMessage(Component parentComponent, String result, InmOperResultVector resultVector) {
        TEOperationShowMessage.showOperationDlg(parentComponent, result, resultVector, true, 1);
    }

    public ArrayList<String> getAllFileList() {
        return this.fileList;
    }

    public ArrayList<String> getOpenedFileList() {
        return this.opendedFileList;
    }

    public HashMap<String, TEOTDRGraphTraceInfo> getOpendedFileContentMap() {
        return this.opendedFileContentMap;
    }

    public void setOpendedFileContentMap(HashMap<String, TEOTDRGraphTraceInfo> opendedFileContentMap) {
        this.opendedFileContentMap = opendedFileContentMap;
    }

    public Color getFileColor(String fileName) {
        TECommonUtil.log("TEcommonUtil.getFileColor", "fileName: " + fileName);
        if (null == fileName || "".equals(fileName)) {
            TECommonUtil.log("TEcommonUtil.getFileColor", "fileName is null!");
            return Color.GREEN;
        }
        ArrayList<String> openedFileList = this.getOpenedFileList();
        ArrayList<Color> usedColorList = new ArrayList<Color>();
        Color tempColor = null;
        for (String openedFileName : openedFileList) {
            tempColor = this.fileColorMap.get(openedFileName);
            if (null == tempColor) continue;
            usedColorList.add(tempColor);
        }
        Color[] defaultColorArray = new Color[]{new Color(16744512), new Color(0x808040), new Color(33023)};
        Color assignedColor = this.fileColorMap.get(fileName);
        if (null == assignedColor) {
            for (Color color : defaultColorArray) {
                if (this.isColorUsed(color, usedColorList)) continue;
                assignedColor = color;
                this.fileColorMap.put(fileName, color);
                break;
            }
        }
        if (null == assignedColor) {
            assignedColor = Color.GREEN;
            TECommonUtil.log("TECommonUtil.getFileColor()", "assign color error!");
            TECommonUtil.log("TECommonUtil.getFileColor()", "openedFileList " + openedFileList);
            TECommonUtil.log("TECommonUtil.getFileColor()", "usedColorList " + usedColorList);
        }
        TECommonUtil.log("TECommonUtil.getFileColor()", "fileName: " + fileName + " assignedColor: " + assignedColor);
        return assignedColor;
    }

    private boolean isColorUsed(Color color, ArrayList<Color> usedColorList) {
        if (null == usedColorList || 0 == usedColorList.size()) {
            return false;
        }
        for (Color element : usedColorList) {
            if (element == null || !element.equals(color)) continue;
            return true;
        }
        return false;
    }

    public void setFileColor(String fileName, Color color) {
        if (null == fileName) {
            return;
        }
        this.fileColorMap.put(fileName, color);
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    public String getUser() {
        return this.params.get("nmUser");
    }

    public String getNmUserName() {
        String username = this.params.get("nmUserName");
        return username == null ? this.getUser() : username;
    }

    public String getLanguage() {
        return this.params.get("language");
    }

    public String getNeIDStr() {
        return this.params.get("neID");
    }

    public String getIndexIDStr() {
        return this.params.get("indexID");
    }

    public String getTestModeStr() {
        return this.params.get("testMode");
    }

    public String getLmiNEIDStr() {
        return this.params.get("lmiNEID");
    }

    public String getLmiSlotIDStr() {
        return this.params.get("lmiSlotID");
    }

    public String getLmiPortIDStr() {
        return this.params.get("lmiPortID");
    }

    public int getNeID() {
        String str = this.params.get("neID");
        if (null != str) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    public String getNeName() {
        String str = this.params.get("nename");
        if (null != str) {
            return str;
        }
        return "";
    }

    public int getLineID() {
        String str = this.params.get("indexID");
        if (null != str) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    public int getTestMode() {
        String str = this.params.get("testMode");
        if (null != str) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    public int getLmiNEID() {
        String str = this.params.get("lmiNEID");
        if (null != str) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    public int getLmiSlotID() {
        String str = this.params.get("lmiSlotID");
        if (null != str) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    public int getLmiPortID() {
        String str = this.params.get("lmiPortID");
        if (null != str) {
            return Integer.parseInt(str);
        }
        return -1;
    }

    public TEOTDRGraphTraceInfo getTraceInfo(String fileName) {
        return this.opendedFileContentMap.get(fileName);
    }

    public TEOTDRGraphTraceInfo getTraceInfo(Datainterface data) {
        if (null == data) {
            return null;
        }
        TEOTDRGraphTraceInfo info = new TEOTDRGraphTraceInfo();
        String fileName = data.getDataRowParam(0, "filename").getValue();
        info.setFileName(fileName);
        int curveparamNum = Short.valueOf(data.getDataRowParam(0, "curveparam").getValue()).shortValue();
        short curveaxisNum = Short.valueOf(data.getDataRowParam(0, "curveaxis").getValue());
        short eventrowsNum = Short.valueOf(data.getDataRowParam(0, "eventrows").getValue());
        short repeaterrowsNum = Short.valueOf(data.getDataRowParam(0, "repeaterrows").getValue());
        short devicerowsNum = Short.valueOf(data.getDataRowParam(0, "devicerows").getValue());
        boolean valid = true;
        String repeaterName = String.valueOf(data.getDataRowParam(0, "repeaternames").getValue());
        String[] nameStrArray = repeaterName.split(";");
        if (nameStrArray.length != repeaterrowsNum - 1) {
            valid = false;
        }
        int index = curveparamNum;
        TEOTDRGraphTraceParamsInfo traceParamsInfo = info.getTraceParamsInfo();
        traceParamsInfo.setComment(data.getDataRowParam(index, "comment").getValue());
        traceParamsInfo.setCodeType(data.getDataRowParam(index, "codeType").getValue());
        traceParamsInfo.setDateTimeStamp(data.getDataRowParam(index, "dateTimeStamp").getValue());
        traceParamsInfo.setEndOfFiberThreshold(Float.valueOf(data.getDataRowParam(index, "endOfFiberThreshold").getValue()).floatValue());
        traceParamsInfo.setFileType(data.getDataRowParam(index, "fileType").getValue());
        traceParamsInfo.setFilterMethod(data.getDataRowParam(index, "filterMethod").getValue());
        traceParamsInfo.setLengthCoefficient((long)Double.parseDouble(data.getDataRowParam(index, "lengthCoefficient").getValue()));
        traceParamsInfo.setLossThreshold(Float.valueOf(data.getDataRowParam(index, "lossThreshold").getValue()).floatValue());
        traceParamsInfo.setMonitorOpticalPower(Float.valueOf(data.getDataRowParam(index, "monitorOpticalPower").getValue()).floatValue());
        traceParamsInfo.setMeasureRangeDistance(Float.valueOf(data.getDataRowParam(index, "measureRangeDistance").getValue()).floatValue());
        traceParamsInfo.setMonitorType(data.getDataRowParam(index, "monitorType").getValue());
        traceParamsInfo.setNumberOfCodeBits(Short.valueOf(data.getDataRowParam(index, "numberOfCodeBits").getValue()));
        traceParamsInfo.setPulseWidthsUsed(Integer.valueOf(data.getDataRowParam(index, "pulseWidthsUsed").getValue()));
        traceParamsInfo.setReceiveOpticalPower(Float.valueOf(data.getDataRowParam(index, "receiveOpticalPower").getValue()).floatValue());
        traceParamsInfo.setReflectanceThreshold(Float.valueOf(data.getDataRowParam(index, "reflectanceThreshold").getValue()).floatValue());
        traceParamsInfo.setSampleRate(Float.valueOf(data.getDataRowParam(index, "sampleRate").getValue()).floatValue());
        traceParamsInfo.setSupplierName(data.getDataRowParam(index, "supplierName").getValue());
        traceParamsInfo.setWaveLength(Float.valueOf(data.getDataRowParam(index, "waveLength").getValue()).floatValue());
        traceParamsInfo.setNumberOfAverages(Long.valueOf(data.getDataRowParam(index, "sampleTimes").getValue()));
        if (curveaxisNum == 1) {
            TEOTDRGraphTraceDataPtsInfo dps = info.getTraceDataPtsInfo();
            dps.setDptsCount(Integer.valueOf(data.getDataRowParam(index += curveaxisNum, "totalPointCount").getValue()));
            String dpsStr = data.getDataRowParam(index, "curvinfo").getValue();
            String[] dpsStrArray = dpsStr.split(" ");
            String tmpPoint = null;
            int[] dpsArray = new int[dpsStrArray.length];
            int standard = -1;
            int last = -1;
            for (int i = 0; i < dpsStrArray.length; ++i) {
                tmpPoint = dpsStrArray[i];
                int point = -1;
                if (!".".equals(tmpPoint)) {
                    point = Integer.valueOf(tmpPoint, 36);
                    if (0 == i) {
                        standard = point;
                    } else {
                        point += standard;
                    }
                    last = point;
                } else {
                    point = last;
                }
                dpsArray[i] = point * 1000;
            }
            dps.setDptsArray(dpsArray);
        }
        int j = index + 1;
        if (eventrowsNum > 0) {
            index += eventrowsNum;
            while (j <= index) {
                TEOTDRGraphTraceEventInfo evtInfo = new TEOTDRGraphTraceEventInfo();
                evtInfo.setAttenuationCoefficientLeadFib(Short.valueOf(data.getDataRowParam(j, "attenuationCoefficientLeadFib").getValue()));
                evtInfo.setComment(data.getDataRowParam(j, "comment").getValue());
                evtInfo.setEventCode(data.getDataRowParam(j, "eventCode").getValue());
                evtInfo.setEventIndexID(Short.valueOf(data.getDataRowParam(j, "eventIndexID").getValue()));
                evtInfo.setEventLocationInLine(Double.valueOf(data.getDataRowParam(j, "eventLocationInLine").getValue()));
                evtInfo.setEventLocationInSpan(Double.valueOf(data.getDataRowParam(j, "eventLocationInSpan").getValue()));
                evtInfo.setEventLoss(Short.valueOf(data.getDataRowParam(j, "eventLoss").getValue()));
                evtInfo.setEventReflectance(Long.valueOf(data.getDataRowParam(j, "eventReflectance").getValue()));
                evtInfo.setLossMeasurementTechnique(data.getDataRowParam(j, "lossMeasurementTechnique").getValue());
                evtInfo.setPropagationTime(Long.valueOf(data.getDataRowParam(j, "propagationTime").getValue()));
                info.addEventInfo(evtInfo);
                ++j;
            }
        }
        j = index + 1;
        if (repeaterrowsNum > 0) {
            index += repeaterrowsNum;
            while (j <= index) {
                TEOTDRGraphTraceReperterInfo rptInfo = new TEOTDRGraphTraceReperterInfo();
                rptInfo.setFiberLossCoefficient(Float.parseFloat(data.getDataRowParam(j, "fiberLossCoefficient").getValue()));
                rptInfo.setFiberType(data.getDataRowParam(j, "fiberType").getValue());
                rptInfo.setLossCoefficient(Float.parseFloat(data.getDataRowParam(j, "lossCoefficient").getValue()));
                rptInfo.setRefractiveIndex(Float.parseFloat(data.getDataRowParam(j, "refractiveIndex").getValue()));
                rptInfo.setRepeaterLocation(Float.parseFloat(data.getDataRowParam(j, "repeaterLocation").getValue()));
                rptInfo.setRepeatorTransfertime(Long.parseLong(data.getDataRowParamValue(j, "repeatortransfertime")));
                rptInfo.setRepeatorGain(Float.parseFloat(data.getDataRowParam(j, "repeatorGain").getValue()));
                rptInfo.setRepeatorPeakPower(Float.parseFloat(data.getDataRowParam(j, "repeatorPeakPower").getValue()));
                rptInfo.setRepeaterID(Short.parseShort(data.getDataRowParam(j, "spanid").getValue()));
                rptInfo.setSpanLength(Float.parseFloat(data.getDataRowParam(j, "spanLength").getValue()));
                if (valid && rptInfo.getRepeaterID() >= 1) {
                    rptInfo.setRepeaterName(nameStrArray[rptInfo.getRepeaterID() - 1]);
                }
                info.addRepeaterInfo(rptInfo);
                ++j;
            }
        }
        j = index + 1;
        if (devicerowsNum > 0) {
            index += devicerowsNum;
            while (j <= index) {
                TEOTDRGraphTraceDeviceInfo devInfo = new TEOTDRGraphTraceDeviceInfo();
                devInfo.setDeviceID(Short.parseShort(data.getDataRowParam(j, "deviceID").getValue()));
                devInfo.setSpanIDOfDevice(Short.parseShort(data.getDataRowParam(j, "spanIDOfDevice").getValue()));
                devInfo.setDeviceType(Short.parseShort(data.getDataRowParam(j, "deviceType").getValue()));
                devInfo.setDeviceOffsetFromSpanStartPoint(Integer.parseInt(data.getDataRowParam(j, "deviceOffsetFromSpanStartPoint").getValue()));
                devInfo.setDeviceName(data.getDataRowParam(j, "deviceName").getValue());
                info.addDeviceInfo(devInfo);
                ++j;
            }
        }
        return info;
    }

    public String getParamFromFileName(String fileName, String keyName) {
        HashMap<String, String> paramMap = TECommonUtil.getParamMapFromFileName(fileName, false);
        return paramMap.get(keyName);
    }

    public String getParamFromFileName(String fileName, String keyName, boolean showTestMode) {
        HashMap<String, String> paramMap = TECommonUtil.getParamMapFromFileName(fileName, showTestMode);
        return paramMap.get(keyName);
    }

    public HashMap<String, String> getParamMapFromFileName(String fileName) {
        return TECommonUtil.getParamMapFromFileName(fileName, false);
    }

    public static HashMap<String, String> getParamMapFromFileName(String fileName, boolean showTestMode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String fileNameTmp = fileName;
        int midIndex = fileNameTmp.indexOf("mid");
        if (-1 != midIndex) {
            TECommonUtil.midFileHandler(fileName, paramMap);
            return paramMap;
        }
        boolean isBaseLine = fileNameTmp.indexOf("baseline") != -1;
        String baseline = isBaseLine ? "1" : "0";
        int dotIndex = fileNameTmp.lastIndexOf(".");
        if (-1 != dotIndex) {
            fileNameTmp = fileNameTmp.substring(0, dotIndex);
            String[] fileAttr = fileNameTmp.split("_");
            String indexID = fileAttr[0];
            String testMode = fileAttr[1];
            String lmiNEID = fileAttr[2];
            String lmiSlotID = fileAttr[3];
            String lmiPortID = fileAttr[4];
            String timeStamp = fileAttr[5];
            String year = timeStamp.substring(0, 4);
            String month = timeStamp.substring(4, 6);
            String showName = timeStamp.substring(6);
            String day = showName.substring(0, 2);
            String hour = showName.substring(2, 4);
            String minute = showName.substring(4, 6);
            String second = showName.substring(6);
            showName = day + "_" + hour + ":" + minute + ":" + second;
            TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
            if (showTestMode) {
                showName = showName + "_" + resUtil.getString("testMode" + testMode);
            }
            paramMap.put("baseline", baseline);
            paramMap.put("indexID", indexID);
            paramMap.put("testMode", testMode);
            paramMap.put("lmiNEID", lmiNEID);
            paramMap.put("lmiSlotID", lmiSlotID);
            paramMap.put("lmiPortID", lmiPortID);
            paramMap.put("timeStamp", timeStamp);
            paramMap.put("year", year);
            paramMap.put("month", month);
            paramMap.put("day", day);
            paramMap.put("hour", hour);
            paramMap.put("minute", minute);
            paramMap.put("second", second);
            paramMap.put("showName", showName);
        }
        return paramMap;
    }

    private static void midFileHandler(String fileName, HashMap<String, String> paramMap) {
        if (null == paramMap || null == fileName) {
            return;
        }
        int dotIndex = fileName.lastIndexOf(".");
        String showName = fileName;
        if (-1 != dotIndex) {
            showName = fileName.substring(0, dotIndex);
        }
        paramMap.put("testMode", "2");
        paramMap.put("showName", showName);
    }

    public static void log(String classMethodName, String logInfo) {
        String curTime = Calendar.getInstance().getTime().toGMTString();
        System.out.println(curTime + " " + classMethodName + ": " + logInfo);
    }
}

