/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.bottomtable;

import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceReperterInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTable;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTableModel;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphEventRptLocateEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphEventRptLocateListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TERptGainReportPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int RPT_NO_COLUMN = 0;
    private static final int DEFAULT_DECIMAL_SCALE_3 = 3;
    private static final int DEFAULT_DECIMAL_SCALE_1 = 1;
    private TENormalTable rptGainReportTable = null;
    private TENormalTableModel rptGainReportTableModel = null;
    private transient TEOTDRGraphFileTreeFileOpenedListener fileOpenListener = null;
    private transient TEOTDRGraphLegendMakeFileSelectedListener fileSelectedListener = null;
    private transient TEOTDRGraphFileTreeFileClosedListener fileClosedListener = null;
    private transient TEOTDRGraphFileTreeFileDeletedListener fileDeletedListener = null;
    private transient TEOTDRGraphGraphEventRptLocateListener rptGainReportListener = null;
    private String selectedFileName = null;
    public static final String REPEATER_GAIN_REPORT_TABLE_PROFILE = "conf/rptgainreporttable_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TERptGainReportPanel(TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.initModel();
        this.initComponent();
        this.jbInit();
        this.initListener();
    }

    private void initModel() {
        if (null == this.rptGainReportTableModel) {
            this.rptGainReportTableModel = new TENormalTableModel("REPEATER_GAIN_REPORT_TABLE", REPEATER_GAIN_REPORT_TABLE_PROFILE);
        }
    }

    private void initComponent() {
        if (null != this.rptGainReportTable) {
            return;
        }
        this.rptGainReportTable = new TENormalTable(this.rptGainReportTableModel);
        this.rptGainReportTable.setAutoResizeMode(2);
        this.rptGainReportTable.setSelectionMode(0);
        this.rptGainReportTable.setSortable(false);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.rptGainReportTable);
        this.add((Component)scrollPane, "Center");
    }

    private void initListener() {
        this.fileOpenListener = new TEOTDRGraphFileTreeFileOpenedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TERptGainReportPanel.this.handleFileTreeFilOpenedEvent(event);
            }
        };
        this.fileSelectedListener = new TEOTDRGraphLegendMakeFileSelectedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TERptGainReportPanel.this.handleLegendMakeFileSelectedEvent(event);
            }
        };
        this.fileClosedListener = new TEOTDRGraphFileTreeFileClosedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TERptGainReportPanel.this.handleFileTreeFileClosedEvent(event);
            }
        };
        this.fileDeletedListener = new TEOTDRGraphFileTreeFileDeletedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TERptGainReportPanel.this.handleFileTreeFileDeleteEvent(event);
            }
        };
        this.rptGainReportListener = new TEOTDRGraphGraphEventRptLocateListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TERptGainReportPanel.this.handleGraphEventRptLocateEvent(event);
            }
        };
        this.teOTDRGraphEventManager.addListener(this.fileOpenListener);
        this.teOTDRGraphEventManager.addListener(this.fileSelectedListener);
        this.teOTDRGraphEventManager.addListener(this.fileClosedListener);
        this.teOTDRGraphEventManager.addListener(this.fileDeletedListener);
        this.teOTDRGraphEventManager.addListener(this.rptGainReportListener);
    }

    private void handleFileTreeFilOpenedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileOpenedEvent theEvent = (TEOTDRGraphFileTreeFileOpenedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TERptGainReportPanel.handleFileTreeFilOpenedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00b4\u00f2\u00bf\u00aa\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe  fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            this.selectedFileName = fileName;
            Vector<Object> tableVector = this.getTableVector(fileName);
            this.refreshTable(tableVector);
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TERptGainReportPanel.handleFileTreeFilOpenedEvent() fail!", e);
        }
    }

    private void handleLegendMakeFileSelectedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphLegendMakeFileSelectedEvent theEvent = (TEOTDRGraphLegendMakeFileSelectedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TERptGainReportPanel.handleLegendMakeFileSelectedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00cd\u00bc\u00c0\u00fd\u00c9\u00cf\u00d1\u00a1\u00d4\u00f1\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe  fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            this.selectedFileName = fileName;
            Vector<Object> tableVector = this.getTableVector(fileName);
            this.refreshTable(tableVector);
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TERptGainReportPanel.handleLegendMakeFileSelectedEvent() fail!", e);
        }
    }

    private void handleFileTreeFileClosedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileClosedEvent theEvent = (TEOTDRGraphFileTreeFileClosedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TERptGainReportPanel.handleFileTreeFileClosedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe  fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            if (null != this.selectedFileName && this.selectedFileName.equals(fileName)) {
                this.selectedFileName = null;
                this.clearTable();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TERptGainReportPanel.handleFileTreeFileClosedEvent() fail!", e);
        }
    }

    private void handleFileTreeFileDeleteEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileDeletedEvent theEvent = (TEOTDRGraphFileTreeFileDeletedEvent)event;
        try {
            List<String> fileNameList = theEvent.getFileNameList();
            String classMethodName = "TERptGainReportPanel.handleFileTreeFileDeleteEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00d4\u00da\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00bb\u00f2\u00cd\u00bc\u00c0\u00fd\u00c9\u00cf\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe  fileNameList: " + fileNameList;
            TECommonUtil.log(classMethodName, logInfo);
            if (fileNameList.contains(this.selectedFileName)) {
                this.selectedFileName = null;
                this.clearTable();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TERptGainReportPanel.handleFileTreeFileDeleteEvent() fail!", e);
        }
    }

    private Vector<Object> getTableVector(String fileName) {
        TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(fileName);
        Map<Integer, TEOTDRGraphTraceReperterInfo> rptInfoMap = traceInfo.getTraceSpanInfo();
        Vector<Object> tableVector = new Vector<Object>();
        Vector<Object> rowVector = null;
        int rptID = -1;
        double rptLocation = 0.0;
        double rptGain = 0.0;
        TEOTDRGraphTraceReperterInfo rptInfo = null;
        ArrayList<Integer> repeaterIdList = new ArrayList<Integer>(rptInfoMap.keySet());
        Collections.sort(repeaterIdList);
        Iterator i$ = repeaterIdList.iterator();
        while (i$.hasNext()) {
            int repeaterId = (Integer)i$.next();
            rptInfo = rptInfoMap.get(repeaterId);
            rptID = rptInfo.getRepeaterID();
            if (rptID <= 0) continue;
            rptLocation = rptInfo.getRepeaterLocation();
            rptGain = rptInfo.getRepeatorGain();
            rowVector = new Vector<Object>();
            rowVector.add(rptID);
            rowVector.add(this.getNumWithScale(rptLocation, 3));
            rowVector.add(this.getNumWithScale(rptGain, 1));
            tableVector.add(rowVector);
        }
        return tableVector;
    }

    private String getNumWithScale(double num, int scale) {
        StringBuffer strFormat = new StringBuffer("0.");
        if (scale < 1) {
            strFormat = new StringBuffer("0.0");
        } else {
            int len = scale;
            for (int i = 0; i < len; ++i) {
                strFormat.append("0");
            }
        }
        DecimalFormat formatter = new DecimalFormat(strFormat.toString());
        return formatter.format(num);
    }

    private void handleGraphEventRptLocateEvent(TEOTDRGraphEvent event) {
        System.out.println("TERptGainReportPanel: \u00b4\u00a6\u00c0\u00ed\u00cd\u00bc\u00d0\u00ce\u00c9\u00cfRpt\u00b6\u00a8\u00ce\u00bb\u00ca\u00c2\u00bc\u00fe");
        TEOTDRGraphGraphEventRptLocateEvent theEvent = (TEOTDRGraphGraphEventRptLocateEvent)event;
        String fileName = theEvent.getFileName();
        int rptNo = theEvent.getEvtNo();
        String classMethodName = "TERptGainReportPanel.handleGraphEventRptLocateEvent()";
        String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00cd\u00bc\u00d0\u00ce\u00c9\u00cfRpt\u00b6\u00a8\u00ce\u00bb\u00ca\u00c2\u00bc\u00fe  fileName: " + fileName + " rptNo: " + rptNo;
        TECommonUtil.log(classMethodName, logInfo);
        if (null == fileName || -1 == rptNo) {
            return;
        }
        if (null == this.selectedFileName || this.selectedFileName.equals(fileName)) {
            return;
        }
        int tableEventNo = -1;
        int len = this.rptGainReportTable.getRowCount();
        for (int i = 0; i < len; ++i) {
            tableEventNo = (Integer)this.rptGainReportTableModel.getValueAt(i, 0);
            if (rptNo != tableEventNo) continue;
            this.rptGainReportTable.setRowSelectionInterval(i, i);
        }
    }

    private void refreshTable(Vector<Object> tableVector) {
        if (null == this.rptGainReportTableModel) {
            return;
        }
        Vector<Vector> vector = this.rptGainReportTableModel.getDataVector();
        vector.clear();
        vector.addAll(tableVector);
        this.rptGainReportTableModel.fireTableDataChanged();
    }

    private void clearTable() {
        if (null == this.rptGainReportTableModel) {
            return;
        }
        Vector<Vector> vector = this.rptGainReportTableModel.getDataVector();
        vector.clear();
        this.rptGainReportTableModel.fireTableDataChanged();
    }

    public TENormalTable getTable() {
        return this.rptGainReportTable;
    }
}

