/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.bottomtable;

import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceEventInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTable;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTableModel;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventTabEventLocateEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphEventLocateEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphEventLocateListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TEEventPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int EVENT_NO_COLUMN = 0;
    private static final int DEFAULT_DECIMAL_SCALE_3 = 3;
    private TENormalTable eventTable = null;
    private TENormalTableModel eventTableModel = null;
    private transient TEOTDRGraphFileTreeFileOpenedListener fileOpenListener = null;
    private transient TEOTDRGraphLegendMakeFileSelectedListener fileSelectedListener = null;
    private transient TEOTDRGraphFileTreeFileClosedListener fileClosedListener = null;
    private transient TEOTDRGraphFileTreeFileDeletedListener fileDeletedListener = null;
    private transient TEOTDRGraphGraphEventLocateListener eventLocateListener = null;
    private String selectedFileName = null;
    private boolean isTriggeredByGraph = false;
    public static final String EVENT_TABLE_PROFILE = "conf/eventtable_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEEventPanel(TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.initTableModel();
        this.initTable();
        this.jbInit();
        this.initListener();
    }

    private void initTableModel() {
        if (null == this.eventTableModel) {
            this.eventTableModel = new TENormalTableModel("EVENT_TABLE", EVENT_TABLE_PROFILE);
        }
    }

    private void initTable() {
        if (null != this.eventTable) {
            return;
        }
        this.eventTable = new TENormalTable(this.eventTableModel){
            private static final long serialVersionUID = 1L;
        };
        this.eventTable.setAutoResizeMode(2);
        this.eventTable.setSelectionMode(0);
        this.eventTable.setSortable(false);
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!TEEventPanel.this.isTriggeredByGraph) {
                    TEEventPanel.this.fireTabEventLocateEvent(e);
                }
            }
        };
        this.eventTable.getSelectionModel().addListSelectionListener(selectionListener);
    }

    private void fireTabEventLocateEvent(ListSelectionEvent e) {
        int eventNo = -1;
        if (!e.getValueIsAdjusting()) {
            int row = this.eventTable.getSelectedRow();
            if (-1 == row) {
                return;
            }
            eventNo = (Integer)this.eventTableModel.getValueAt(row, 0);
            TECommonUtil.log("TEEventPanel.fireTabEventLocateEvent()", "\u00b4\u00a6\u00c0\u00ed\u00b1\u00ed\u00b8\u00f1\u00d0\u00d0\u00d1\u00a1\u00d6\u00d0\u00ca\u00c2\u00bc\u00fe eventNo: " + eventNo);
            TEOTDRGraphEventTabEventLocateEvent event = TEOTDRGraphEventTabEventLocateEvent.getEvent();
            event.setEvtNo(eventNo);
            event.setFileName(this.selectedFileName);
            this.teOTDRGraphEventManager.triggerEvent(event);
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.eventTable);
        this.add((Component)scrollPane, "Center");
    }

    private void initListener() {
        TECommonUtil.log("TEEventPanel.initListener()", "\u00b3\u00f5\u00ca\u00bc\u00bb\u00af\u00bc\u00e0\u00cc\u00fd\u00ba\u00af\u00ca\u00fd");
        this.fileOpenListener = new TEOTDRGraphFileTreeFileOpenedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEEventPanel.this.handleFileTreeFileOpenedEvent(event);
            }
        };
        this.fileSelectedListener = new TEOTDRGraphLegendMakeFileSelectedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEEventPanel.this.handleLegendmakeFileSelectedEvent(event);
            }
        };
        this.fileClosedListener = new TEOTDRGraphFileTreeFileClosedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEEventPanel.this.handleFileTreeFileClosedEvent(event);
            }
        };
        this.fileDeletedListener = new TEOTDRGraphFileTreeFileDeletedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEEventPanel.this.handleFileTreeFileDeletedEvent(event);
            }
        };
        this.eventLocateListener = new TEOTDRGraphGraphEventLocateListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEEventPanel.this.handleGraphEventLocateEvent(event);
            }
        };
        this.teOTDRGraphEventManager.addListener(this.fileOpenListener);
        this.teOTDRGraphEventManager.addListener(this.fileSelectedListener);
        this.teOTDRGraphEventManager.addListener(this.fileClosedListener);
        this.teOTDRGraphEventManager.addListener(this.fileDeletedListener);
        this.teOTDRGraphEventManager.addListener(this.eventLocateListener);
    }

    private void handleFileTreeFileOpenedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileOpenedEvent theEvent = (TEOTDRGraphFileTreeFileOpenedEvent)event;
        try {
            String fileName;
            this.selectedFileName = fileName = theEvent.getFileName();
            TECommonUtil.log("TEEventPanel.handleFileTreeFileOpenedEvent()", "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00b4\u00f2\u00bf\u00aa\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe fileName: " + fileName);
            Vector<Object> tableVector = this.getTableVector(fileName);
            this.refreshTable(tableVector);
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEEventPanel.handleFileTreeFileOpenedEvent() fail!", e);
        }
    }

    private void handleLegendmakeFileSelectedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphLegendMakeFileSelectedEvent theEvent = (TEOTDRGraphLegendMakeFileSelectedEvent)event;
        try {
            String fileName;
            this.selectedFileName = fileName = theEvent.getFileName();
            TECommonUtil.log("TEEventPanel.handleLegendmakeFileSelectedEvent()", "\u00b4\u00a6\u00c0\u00ed\u00cd\u00bc\u00c0\u00fd\u00c9\u00cf\u00d1\u00a1\u00d4\u00f1\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe fileName: " + fileName);
            Vector<Object> tableVector = this.getTableVector(fileName);
            this.refreshTable(tableVector);
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEEventPanel.handleLegendmakeFileSelectedEvent() fail!", e);
        }
    }

    private void handleFileTreeFileClosedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileClosedEvent theEvent = (TEOTDRGraphFileTreeFileClosedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            TECommonUtil.log("TEEventPanel.handleFileTreeFileClosedEvent()", "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00bb\u00f2Legend\u00c9\u00cf\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe fileName: " + fileName);
            if (fileName.equals(this.selectedFileName)) {
                this.selectedFileName = null;
                this.clearTable();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEEventPanel.handleFileTreeFileClosedEvent() fail!", e);
        }
    }

    private void handleFileTreeFileDeletedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileDeletedEvent theEvent = (TEOTDRGraphFileTreeFileDeletedEvent)event;
        try {
            List<String> fileNameList = theEvent.getFileNameList();
            TECommonUtil.log("TEEventPanel.handleFileTreeFileDeletedEvent()", "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00c9\u00be\u00b3\u00fd\u00bb\u00f2\u00b1\u00a3\u00b4\u00e6\u00ca\u00c2\u00bc\u00fe fileNameList: " + fileNameList);
            if (fileNameList.contains(this.selectedFileName)) {
                this.selectedFileName = null;
                this.clearTable();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEEventPanel.handleFileTreeFileDeletedEvent() fail!", e);
        }
    }

    private void handleGraphEventLocateEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphGraphEventLocateEvent theEvent = (TEOTDRGraphGraphEventLocateEvent)event;
        int eventNo = -1;
        try {
            String fileName = theEvent.getFileName();
            eventNo = theEvent.getEventNo();
            TECommonUtil.log("TEEventPanel.handleGraphEventLocateEvent()", "\u00b4\u00a6\u00c0\u00ed\u00cd\u00bc\u00d0\u00ce\u00c9\u00cf\u00ca\u00c2\u00bc\u00fe\u00b6\u00a8\u00ce\u00bb\u00ca\u00c2\u00bc\u00fe fileName: " + fileName);
            if (null == fileName || -1 == eventNo) {
                return;
            }
            if (null == this.selectedFileName || !this.selectedFileName.equals(fileName)) {
                return;
            }
            int tableEventNo = -1;
            int len = this.eventTable.getRowCount();
            for (int i = 0; i < len; ++i) {
                tableEventNo = (Integer)this.eventTableModel.getValueAt(i, 0);
                if (eventNo != tableEventNo) continue;
                this.isTriggeredByGraph = true;
                this.eventTable.setRowSelectionInterval(i, i);
                this.isTriggeredByGraph = false;
                break;
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEEventPanel.handleGraphEventLocateEvent() fail!", e);
        }
    }

    private Vector<Object> getTableVector(String fileName) {
        TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(fileName);
        Map<Integer, TEOTDRGraphTraceEventInfo> eventInfoMap = traceInfo.getTraceEventInfo();
        Vector<Object> tableVector = new Vector<Object>();
        Vector<Object> rowVector = null;
        int eventIndexID = -1;
        String eventCode = null;
        double eventLocationInLine = 0.0;
        float attenuationCoefficientLeadFib = 0.0f;
        float eventLoss = 0.0f;
        float eventReflectance = 0.0f;
        String eventComment = null;
        TEOTDRGraphTraceEventInfo eventInfo = null;
        Set<Map.Entry<Integer, TEOTDRGraphTraceEventInfo>> eventInfoSet = eventInfoMap.entrySet();
        for (Map.Entry<Integer, TEOTDRGraphTraceEventInfo> entry : eventInfoSet) {
            eventInfo = entry.getValue();
            eventIndexID = eventInfo.getEventIndexID();
            eventCode = eventInfo.getEventCode();
            eventLocationInLine = eventInfo.getEventLocationInLine();
            attenuationCoefficientLeadFib = (float)eventInfo.getAttenuationCoefficientLeadFib() / 1000.0f;
            eventLoss = (float)eventInfo.getEventLoss() / 1000.0f;
            eventReflectance = (float)eventInfo.getEventReflectance() / 1000.0f;
            eventComment = eventInfo.getComment();
            rowVector = new Vector<Object>();
            rowVector.add(eventIndexID);
            rowVector.add(this.getEventType(eventCode, eventComment));
            rowVector.add(this.getNumWithScale(eventLocationInLine, 3));
            rowVector.add(Float.valueOf(attenuationCoefficientLeadFib));
            rowVector.add(Float.valueOf(eventLoss));
            rowVector.add(Float.valueOf(eventReflectance));
            tableVector.add(rowVector);
        }
        return tableVector;
    }

    private String getNumWithScale(double num, int scale) {
        StringBuffer strFormat = new StringBuffer("0.");
        if (scale < 1) {
            strFormat = new StringBuffer("0.0");
        } else {
            int len = scale;
            for (int i = 0; i < len; ++i) {
                strFormat.append("0");
            }
        }
        DecimalFormat formatter = new DecimalFormat(strFormat.toString());
        return formatter.format(num);
    }

    private String getEventType(String eventCode, String eventComment) {
        String eventType = eventCode;
        if ("0M9999".equalsIgnoreCase(eventCode)) {
            eventType = this.resUtil.getString("startpointeventtype");
        } else if ("0D9999".equalsIgnoreCase(eventCode)) {
            eventType = this.resUtil.getString("endpointeventtype");
        } else {
            int evetTypeFirst = Integer.parseInt(String.valueOf(eventCode.charAt(0)));
            String eventTypeSecond = String.valueOf(eventCode.charAt(1));
            switch (evetTypeFirst) {
                case 0: {
                    if ("E".equals(eventTypeSecond)) {
                        eventType = this.resUtil.getString("endeventtype");
                        break;
                    }
                    if ("F".equals(eventTypeSecond)) {
                        eventType = this.resUtil.getString("losseventtype");
                        if (eventComment.indexOf("OADM.BU") >= 0) {
                            eventType = this.resUtil.getString("oadmbu_losseventtype");
                            break;
                        }
                        if (eventComment.indexOf("FP.BU") >= 0) {
                            eventType = this.resUtil.getString("fpbu_losseventtype");
                            break;
                        }
                        if (eventComment.indexOf("OEQ") >= 0) {
                            eventType = this.resUtil.getString("oeq_losseventtype");
                            break;
                        }
                        eventType = this.resUtil.getString("losseventtype");
                        break;
                    }
                    eventType = this.resUtil.getString("nonrefeventtype");
                    break;
                }
                case 1: {
                    if ("E".equals(eventTypeSecond)) {
                        eventType = this.resUtil.getString("endeventtype");
                        break;
                    }
                    eventType = this.resUtil.getString("refeventtype");
                    break;
                }
                case 2: {
                    eventType = this.resUtil.getString("endeventtype");
                    break;
                }
            }
        }
        return eventType;
    }

    private void refreshTable(Vector<Object> tableVector) {
        if (null == this.eventTableModel) {
            return;
        }
        Vector<Vector> vector = this.eventTableModel.getDataVector();
        vector.clear();
        vector.addAll(tableVector);
        this.eventTableModel.fireTableDataChanged();
    }

    private void clearTable() {
        if (null == this.eventTableModel) {
            return;
        }
        Vector<Vector> vector = this.eventTableModel.getDataVector();
        vector.clear();
        this.eventTableModel.fireTableDataChanged();
    }

    public TENormalTable getTable() {
        return this.eventTable;
    }
}

