/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMgrView;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Param;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowErrors;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowParams;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.TEOTDRAllError;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButtonGroup;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmScreenToolKit;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultStruct;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultVector;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.TEOperationShowMessage;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphFileTreeIntegerface;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class TEOTDRGraphViewTestRecordView
extends TEOTDRGraphMgrView {
    private static final long serialVersionUID = 1L;
    private InmButton saveTestRecordBtn = null;
    private InmButton saveAndSetBLBtn = null;
    private InmButton deleteTestRecordBtn = null;

    public TEOTDRGraphViewTestRecordView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        super(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil);
    }

    @Override
    protected void disableAllBtn() {
        this.saveTestRecordBtn.setEnabled(false);
        this.saveAndSetBLBtn.setEnabled(false);
        this.deleteTestRecordBtn.setEnabled(false);
    }

    @Override
    protected Map<String, Integer> getBtn2CmdMap() {
        HashMap<String, Integer> rightMap = new HashMap<String, Integer>();
        rightMap.put(this.saveTestRecordBtn.getName(), 2556008);
        rightMap.put(this.saveAndSetBLBtn.getName(), 2556009);
        rightMap.put(this.deleteTestRecordBtn.getName(), 2556010);
        return rightMap;
    }

    @Override
    protected Component getBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.add(this.deleteTestRecordBtn);
        btnPanel.add(this.saveAndSetBLBtn);
        btnPanel.add(this.saveTestRecordBtn);
        return btnPanel;
    }

    protected void doSaveAndSetBaseLine() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> fileNameList = finf.getCurrentSelectedFileList();
        if (null == fileNameList || fileNameList.size() != 1) {
            InmOptionPane.showMessageDialog(this, this.getString("selectonefile"));
            return;
        }
        String confirmStr = "dangeroperation";
        if (0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString(confirmStr))) {
            return;
        }
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createSaveAndSetBaseLineReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
        this.processSaveAndSetBaseLineRsp(rsp);
    }

    private void processSaveAndSetBaseLineRsp(Datainterface rsp) {
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                for (RowErrors row : rowErrows) {
                    operStruct = new InmOperResultStruct();
                    try {
                        operStruct.operObj = URLDecoder.decode(row.getParam("nmFileName").getValue(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        TEAppletLogMgr.error("TEOTDRGraphViewTestRecordView.processSaveAndSetBaseLineRsp() fail!", e);
                    }
                    catch (IndexOutOfBoundsException e) {
                        TEAppletLogMgr.error("TEOTDRGraphViewTestRecordView.processSaveAndSetBaseLineRsp() fail!", e);
                    }
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + "," + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            return;
        }
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> fileNameList = finf.getCurrentSelectedFileList();
        finf.deleteFile(fileNameList);
    }

    private OperationData createSaveAndSetBaseLineReq() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> fileNameList = finf.getCurrentSelectedFileList();
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        req.addURLParam("sfid", 2556009);
        RowParams rp = null;
        Param p = null;
        String fileName = fileNameList.get(0);
        rp = new RowParams();
        int testMode = this.getTestModeFromFileName(fileName);
        p = new Param("neID", String.valueOf(this.getNeID()));
        rp.addParam(p);
        p = new Param("indexID", String.valueOf(this.getIndexID()));
        rp.addParam(p);
        p = new Param("testMode", String.valueOf(testMode));
        rp.addParam(p);
        p = new Param("fileName", fileName);
        rp.addParam(p);
        p = new Param("lmiNEID", String.valueOf(this.getLmiNEID()));
        rp.addParam(p);
        p = new Param("lmiSlotID", String.valueOf(this.getLmiSlotID()));
        rp.addParam(p);
        p = new Param("lmiPortID", String.valueOf(this.getLmiPortID()));
        rp.addParam(p);
        String fileNameString = this.teCommonUtil.getParamFromFileName(fileName, "showName", this.isTestModeShown());
        try {
            p = new Param("nmFileName", URLEncoder.encode(fileNameString, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            TEAppletLogMgr.error("TEOTDRGraphViewTestRecordView.createSaveAndSetBaseLineReq() fail!", e);
        }
        rp.addParam(p);
        req.addXMLRowParams(rp);
        return req;
    }

    protected void doSaveTestRecord() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> fileNameList = finf.getCurrentSelectedFileList();
        if (null == fileNameList || fileNameList.isEmpty()) {
            InmOptionPane.showMessageDialog(this, this.getString("selectonefile"));
            return;
        }
        this.doSaveFile(fileNameList);
    }

    @Override
    protected boolean isTestModeShown() {
        return true;
    }

    @Override
    protected void refreshBtnStatus() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> selFileList = finf.getCurrentSelectedFileList();
        boolean hasFileSelected = selFileList != null && !selFileList.isEmpty();
        this.saveTestRecordBtn.setEnabled(this.hasOperationRight(this.saveTestRecordBtn.getName()) && hasFileSelected);
        boolean onlyOneSelected = selFileList != null && selFileList.size() == 1;
        boolean isBaseLineSelected = onlyOneSelected && selFileList.get(0).indexOf("baseline") != -1;
        this.saveAndSetBLBtn.setEnabled(this.hasOperationRight(this.saveAndSetBLBtn.getName()) && !isBaseLineSelected && onlyOneSelected);
        this.deleteTestRecordBtn.setEnabled(this.hasOperationRight(this.deleteTestRecordBtn.getName()) && hasFileSelected);
    }

    @Override
    protected void initBtn() {
        this.saveTestRecordBtn = new InmButton();
        this.saveTestRecordBtn.setName("savetestrecordbtnid");
        this.saveTestRecordBtn.setText(this.getString(this.saveTestRecordBtn.getName()));
        this.saveTestRecordBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    TEOTDRGraphViewTestRecordView.this.doSaveTestRecord();
                }
                catch (Exception e) {
                    InmScreenToolKit.setComponentCursorBusy(TEOTDRGraphViewTestRecordView.this.teCommonUtil.getRootPaneContainer(TEOTDRGraphViewTestRecordView.this), false);
                }
            }
        });
        this.saveAndSetBLBtn = new InmButton();
        this.saveAndSetBLBtn.setName("saveandsetbltestrecordbtnid");
        this.saveAndSetBLBtn.setText(this.getString(this.saveAndSetBLBtn.getName()));
        this.saveAndSetBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphViewTestRecordView.this.doSaveAndSetBaseLine();
            }
        });
        this.deleteTestRecordBtn = new InmButton();
        this.deleteTestRecordBtn.setName("deletetestrecordbtnid");
        this.deleteTestRecordBtn.setText(this.getString(this.deleteTestRecordBtn.getName()));
        this.deleteTestRecordBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphViewTestRecordView.this.doDeleteFile();
            }
        });
        InmButtonGroup bg = new InmButtonGroup();
        bg.add(this.saveTestRecordBtn);
        bg.add(this.saveAndSetBLBtn);
        bg.add(this.deleteTestRecordBtn);
    }

    @Override
    public void destroy() {
    }

    private void log(String info, Throwable e) {
        System.out.println(info);
        e.printStackTrace();
    }
}

