/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMgrView;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEOTDRDomCommUtil;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.ErrorMessage;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowErrors;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowParams;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.TEOTDRAllError;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButtonGroup;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmScreenToolKit;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultStruct;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultVector;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.TEOperationShowMessage;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphFileTreeIntegerface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TEOTDRGraphTestFileAnalysisView
extends TEOTDRGraphMgrView {
    private static final long serialVersionUID = 1L;
    private static final FileFilter OUTSVR_FILE_TYPE_FILTER = new FileNameExtensionFilter("*.sor", "sor");
    private InmButton deleteFileBtn = null;
    private InmButton importRecordBtn = null;
    private InmButton exportRecordBtn = null;
    private InmButton printButton = null;
    private static final String BASELINE = "baseline";

    public TEOTDRGraphTestFileAnalysisView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        super(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil);
    }

    private FileFilter getFileFilterByTestMode(int testMode) {
        return OUTSVR_FILE_TYPE_FILTER;
    }

    @Override
    protected void initBtn() {
        this.deleteFileBtn = new InmButton();
        this.deleteFileBtn.setName("deletetestrecordbtnid");
        this.deleteFileBtn.setText(this.getString(this.deleteFileBtn.getName()));
        this.deleteFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphTestFileAnalysisView.this.doDeleteFile();
            }
        });
        this.importRecordBtn = new InmButton();
        this.importRecordBtn.setName("importtestrecordsbtnid");
        this.importRecordBtn.setText(this.getString(this.importRecordBtn.getName()));
        this.importRecordBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphTestFileAnalysisView.this.doImportRecords();
            }
        });
        this.exportRecordBtn = new InmButton();
        this.exportRecordBtn.setName("exporttestrecordsbtnid");
        this.exportRecordBtn.setText(this.getString(this.exportRecordBtn.getName()));
        this.exportRecordBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphTestFileAnalysisView.this.doExportRecords();
            }
        });
        this.printButton = new InmButton();
        this.printButton.setName("printbtnid");
        this.printButton.setText(this.getString(this.printButton.getName()));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphTestFileAnalysisView.this.doPrint();
            }
        });
        InmButtonGroup bg = new InmButtonGroup();
        bg.add(this.deleteFileBtn);
        bg.add(this.importRecordBtn);
        bg.add(this.exportRecordBtn);
        bg.add(this.printButton);
    }

    protected void doExportRecords() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> selFileList = finf.getCurrentSelectedFileList();
        if (null == selFileList || selFileList.size() != 1) {
            InmOptionPane.showMessageDialog(this, this.getString("selectonefile"));
            return;
        }
        String fileName = selFileList.get(0);
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createExportRecordReq(fileName);
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processExportRecordRsp(rsp, fileName);
        this.refreshBtnStatus();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private void processExportRecordRsp(Datainterface rsp, String fileRealName) {
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                StringBuilder sb = null;
                for (RowErrors row : rowErrows) {
                    sb = new StringBuilder();
                    operStruct = new InmOperResultStruct();
                    String neName = row.getParam("nename").getValue();
                    String indexID = row.getParam("indexID").getValue();
                    sb.append(neName).append("-").append(this.getString("linestr")).append(indexID);
                    operStruct.operObj = sb.toString();
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else if (operVector.size() == rsp.getDataRowLength()) {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            return;
        }
        String blUrl = rsp.getDataRowParamValue(0, "blURL");
        TEAppletLogMgr.info(blUrl);
        char firstChar = blUrl.charAt(0);
        if ('\\' == firstChar || '/' == firstChar) {
            blUrl = blUrl.substring(1);
        }
        blUrl = TECommonUtil.getServerPath() + blUrl;
        try {
            URL fileUrl = new URL(blUrl);
            URLConnection uc = fileUrl.openConnection();
            uc.setDoInput(true);
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            int b = -1;
            while ((b = in.read()) != -1) {
                bo.write(b);
            }
            in.close();
            StringBuffer saveName = new StringBuffer(this.getNeName());
            saveName.append("_");
            saveName.append(fileRealName.substring(0, fileRealName.indexOf("_")));
            saveName.append("_");
            if (fileRealName.indexOf(BASELINE) > -1) {
                saveName.append(fileRealName.substring(fileRealName.lastIndexOf("_", fileRealName.lastIndexOf(BASELINE) - BASELINE.length() - 1) + 1));
            } else {
                saveName.append(fileRealName.substring(fileRealName.lastIndexOf("_") + 1));
            }
            JFileChooser jf = new JFileChooser();
            jf.setDialogTitle(this.getString("exporttestrecordsbtnid"));
            jf.setFileSelectionMode(0);
            jf.setAcceptAllFileFilterUsed(false);
            jf.addChoosableFileFilter(OUTSVR_FILE_TYPE_FILTER);
            jf.setSelectedFile(new File(saveName.toString()));
            int returnVal = jf.showSaveDialog(this);
            if (returnVal == 0) {
                File f = jf.getSelectedFile();
                if (null == f) {
                    return;
                }
                String fileName = f.getName();
                if (!this.isValidFileNameLength(fileName)) {
                    return;
                }
                fileName = this.getValidFileName(f.getAbsolutePath());
                File tempFile = new File(fileName);
                FileOutputStream fout = new FileOutputStream(tempFile);
                ByteBuffer bb = ByteBuffer.wrap(bo.toByteArray());
                fout.getChannel().write(bb);
                fout.flush();
                fout.close();
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operSucceeded"), true);
            }
        }
        catch (Exception e) {
            TEAppletLogMgr.error("TEOTDRGraphTestFileAnalysisView.processExportRecordRsp() fail!", e);
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), true);
            return;
        }
    }

    private boolean isValidFileNameLength(String fileName) {
        int fileNameLen = 64;
        if (fileName.length() > fileNameLen) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("IDS_InputFileNameLength"), true);
            return false;
        }
        return true;
    }

    private String getValidFileName(String fileName) {
        int pointIndex = fileName.lastIndexOf(".");
        String extendedName = "sor";
        StringBuffer buf = new StringBuffer();
        if (0 > pointIndex) {
            fileName = buf.append(fileName).append(".").append(extendedName).toString();
        } else if (fileName.length() - 1 == pointIndex) {
            fileName = fileName + extendedName;
        } else {
            String inputExtendedName = fileName.substring(pointIndex + 1).toLowerCase();
            boolean flag = false;
            if (inputExtendedName.equals(extendedName)) {
                flag = true;
            }
            if (!flag) {
                fileName = buf.append(fileName).append(".").append(extendedName).toString();
            }
        }
        return fileName;
    }

    private OperationData createExportRecordReq(String fileName) {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", String.valueOf(20080809));
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        RowParams row = new RowParams();
        row.addParam("neID", String.valueOf(this.getNeID()));
        row.addParam("indexID", String.valueOf(this.getIndexID()));
        row.addParam("testMode", String.valueOf(this.getTestMode()));
        row.addParam("fileName", fileName);
        req.addXMLRowParams(row);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportRecords() {
        JFileChooser jc = new JFileChooser();
        jc.setFileSelectionMode(0);
        jc.setFileFilter(this.getFileFilterByTestMode(this.getTestMode()));
        jc.setMultiSelectionEnabled(true);
        int result = jc.showOpenDialog(this);
        if (0 != result) {
            return;
        }
        File[] selFiles = jc.getSelectedFiles();
        if (selFiles == null || selFiles.length == 0) {
            return;
        }
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        File selFile = null;
        ArrayList<String> addingFileList = new ArrayList<String>();
        InmOperResultVector operVector = new InmOperResultVector();
        InmOperResultStruct operStruct = null;
        int iCancelNum = 0;
        for (int i = 0; i < selFiles.length; ++i) {
            selFile = selFiles[i];
            if (!this.checkImportFileName(selFile)) {
                ++iCancelNum;
                continue;
            }
            String boundary = "---------------------------7d12ed2e2001cc";
            String theCGI = null;
            StringBuilder sb = new StringBuilder();
            sb.append(TECommonUtil.getServerPath()).append("importRecord?");
            sb.append("neID=").append(this.getNeID()).append("&");
            sb.append("indexID=").append(this.getIndexID()).append("&");
            sb.append("testMode=").append(this.getTestMode()).append("&");
            sb.append("lmiNEID=").append(this.getLmiNEID()).append("&");
            sb.append("lmiSlotID=").append(this.getLmiSlotID()).append("&");
            sb.append("lmiPortID=").append(this.getLmiPortID()).append("&");
            sb.append("fileName=").append("uploadfile");
            theCGI = sb.toString();
            StringBuilder header = new StringBuilder();
            header.append("--").append(boundary).append("\r\n");
            header.append("Content-DisposITion:   form-data;   name=\"FILE1\";   filename=");
            header.append("uploadfile").append("\r\n");
            header.append("Content-Type:   application/octet-stream\r\n\r\n");
            String headerStr = header.toString();
            String endStr = "\r\n--" + boundary + "--\r\n";
            byte[] headerByte = headerStr.getBytes();
            byte[] endByte = endStr.getBytes();
            FilterOutputStream out = null;
            try {
                FileInputStream fin = new FileInputStream(selFile);
                byte[] fileByte = new byte[fin.available()];
                if (fin.read(fileByte) == -1) {
                    TEAppletLogMgr.info("TEOTDRGraphTestFileAnalysisView.doImportRecords() no content read.");
                }
                fin.close();
                byte[] allByte = new byte[headerByte.length + fileByte.length + endByte.length];
                System.arraycopy(headerByte, 0, allByte, 0, headerByte.length);
                System.arraycopy(fileByte, 0, allByte, headerByte.length, fileByte.length);
                System.arraycopy(endByte, 0, allByte, headerByte.length + fileByte.length, endByte.length);
                URL CGIurl = null;
                CGIurl = new URL(theCGI);
                URLConnection c = CGIurl.openConnection();
                c.setDoOutput(true);
                c.setUseCaches(false);
                c.setRequestProperty("content-type", "multipart/form-data;   boundary=" + boundary);
                out = new DataOutputStream(c.getOutputStream());
                out.write(allByte);
                ((DataOutputStream)out).flush();
                Document doc = null;
                Datainterface outputData = null;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                doc = db.parse(c.getInputStream());
                outputData = TEOTDRDomCommUtil.encapsulateData(doc);
                ErrorMessage ems = outputData.getErrorMessage();
                boolean success = "0".equals(ems.getErrorcode());
                String errCode = ems.getErrorcode();
                String errInfo = ems.getErrorinfo();
                if (success) {
                    String fileName = outputData.getDataRowParamValue(0, "fileName");
                    addingFileList.add(fileName);
                    continue;
                }
                operStruct = new InmOperResultStruct();
                operStruct.operObj = selFile.getName();
                operStruct.operResult = this.getString("operfailed");
                operStruct.operReason = errInfo + this.getString("errorcodestr") + errCode;
                operVector.add(operStruct);
                continue;
            }
            catch (Exception e1) {
                operStruct = new InmOperResultStruct();
                operStruct.operObj = selFile.getName();
                operStruct.operResult = this.getString("operfailed");
                operStruct.operReason = this.getString(e1.getMessage());
                operVector.add(operStruct);
                TEAppletLogMgr.error("TEOTDRGraphTestFileAnalysisView.doImportRecords() fail!", e1);
                continue;
            }
            catch (Error er) {
                InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
                TEOperationShowMessage.showOperationDlg((Component)this, er.toString(), true);
                TEAppletLogMgr.error("TEOTDRGraphTestFileAnalysisView.doImportRecords() fail!", er);
                return;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    TEAppletLogMgr.error("TEOTDRGraphTestFileAnalysisView.doImportRecords() fail!", e);
                }
            }
        }
        if (iCancelNum == selFiles.length) {
            InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
            TEAppletLogMgr.info("TEOTDRGraphTestFileAnalysisView.doImportRecords() cancel all!");
            return;
        }
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        if (!addingFileList.isEmpty()) {
            finf.addFileToTree(addingFileList);
        }
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
        if (operVector.isEmpty()) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operSucceeded"), true);
        } else if (operVector.size() == selFiles.length) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
        } else {
            Collections.sort(operVector);
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
        }
    }

    private boolean checkImportFileName(File selFile) {
        String fileName = selFile.getName();
        String[] fileStrut = fileName.split("_");
        if (fileStrut.length <= 2) {
            return true;
        }
        if (!this.getNeName().equals(fileStrut[0]) && 0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString("nenameDifferences"))) {
            return false;
        }
        return this.getIndexID() == Integer.parseInt(fileStrut[1]) || 0 == InmOptionPane.showConfirmDialog(this, (Object)this.getString("lineidDifferences"));
    }

    @Override
    protected Component getBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.add(this.importRecordBtn);
        btnPanel.add(this.exportRecordBtn);
        btnPanel.add(this.deleteFileBtn);
        btnPanel.add(this.printButton);
        return btnPanel;
    }

    @Override
    protected void disableAllBtn() {
        this.deleteFileBtn.setEnabled(false);
        this.printButton.setEnabled(false);
    }

    private boolean canBeDelete(List<String> fileNameList) {
        if (fileNameList == null || fileNameList.isEmpty()) {
            return false;
        }
        HashMap<String, String> fileNameParamMap = null;
        for (String selectedFileName : fileNameList) {
            fileNameParamMap = TECommonUtil.getParamMapFromFileName(selectedFileName, false);
            boolean isBaseline = "1".equals(fileNameParamMap.get(BASELINE));
            if (!isBaseline) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void refreshBtnStatus() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        if (null == finf) {
            return;
        }
        List<String> fileNameList = finf.getCurrentSelectedFileList();
        boolean hasFileSelected = fileNameList != null && !fileNameList.isEmpty();
        boolean onlyOneSelected = hasFileSelected && fileNameList.size() == 1;
        boolean canBeDelete = this.canBeDelete(fileNameList);
        this.exportRecordBtn.setEnabled(this.hasOperationRight(this.exportRecordBtn.getName()) && onlyOneSelected);
        this.importRecordBtn.setEnabled(this.hasOperationRight(this.importRecordBtn.getName()));
        this.deleteFileBtn.setEnabled(this.hasOperationRight(this.deleteFileBtn.getName()) && canBeDelete);
        TEOTDRGraphGraphInterface ginf = this.teOTDRGraphModuleMgr.getGraphInteractor();
        if (null == ginf) {
            return;
        }
        List<String> openedFileNameList = ginf.getOpenedFileNameList();
        boolean hasGraphOpened = openedFileNameList != null && !openedFileNameList.isEmpty();
        this.printButton.setEnabled(hasGraphOpened);
    }

    @Override
    protected Map<String, Integer> getBtn2CmdMap() {
        HashMap<String, Integer> rightMap = new HashMap<String, Integer>();
        rightMap.put(this.deleteFileBtn.getName(), 2556010);
        rightMap.put(this.importRecordBtn.getName(), 2172399);
        rightMap.put(this.exportRecordBtn.getName(), 2172400);
        return rightMap;
    }

    @Override
    public void destroy() {
    }
}

