/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMgrView;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.report.InmHtmlReport;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRRepeaterChartCanvas;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TEOTDRGraphRepeaterInfoView
extends TEOTDRGraphMgrView {
    private static final long serialVersionUID = 1L;
    private InmButton printButton = null;
    private JComboBox repeaterComboBox = null;
    private TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    private static final String STR_RES_FILE = "res/pagestringres_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private TEMarineResourceUtil pageResUtil = TEMarineResourceUtil.getInstance(STR_RES_FILE);
    private int sizeX = 0;
    private int sizeY = 0;
    private JScrollPane chartContainer;
    private TEOTDRRepeaterChartCanvas chartCanvas;
    private ViewResizeListener resizeListener = new ViewResizeListener();

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.sizeX, this.sizeY);
    }

    public TEOTDRGraphRepeaterInfoView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        super(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil);
    }

    public final void initRepeaterInfoView() {
        this.initRepeaterComboBox();
        this.initBtn();
        this.initComponent();
        this.refreshBtnStatus();
        this.addComponentListener(this.resizeListener);
    }

    private void initRepeaterComboBox() {
        this.repeaterComboBox = new JComboBox();
        this.repeaterComboBox.setPreferredSize(new Dimension(300, 28));
        ItemListener repeaterItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TEOTDRGraphRepeaterInfoView.this.handleRepeaterItemChanged();
            }
        };
        this.repeaterComboBox.addItemListener(repeaterItemListener);
    }

    public void handleRepeaterItemChanged() {
        Integer rptIDInteger = (Integer)this.repeaterComboBox.getSelectedItem();
        if (null == rptIDInteger) {
            return;
        }
        int rptID = rptIDInteger;
        this.queryRptInfo(rptID);
    }

    @Override
    protected void initBtn() {
        this.printButton = new InmButton();
        this.printButton.setName("printbtnid");
        this.printButton.setText(this.getString(this.printButton.getName()));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphRepeaterInfoView.this.doPrintGraph();
            }
        });
    }

    private void doPrintGraph() {
        Frame frame = TECommonUtil.getTopFrame(this);
        frame.toFront();
        String sHtmlTitle = "TEOTDRGraph";
        String sHtmlActor = this.teCommonUtil.getNmUserName();
        if ("10".equals(sHtmlActor)) {
            sHtmlActor = "admin";
        }
        InmHtmlReport createHtmlReport = new InmHtmlReport();
        createHtmlReport.createReport(this.teCommonUtil.getTopFrame(), sHtmlTitle);
        createHtmlReport.createHead(sHtmlTitle, sHtmlActor, null, this.teCommonUtil.getNeID(), this.teCommonUtil.getUser());
        InmHtmlReport graphReport = new InmHtmlReport();
        File graphImageFile = graphReport.createNewImageFile(this.teCommonUtil.getTopFrame(), "TEOTDRGraph");
        try {
            if (null == this.chartCanvas) {
                InmOptionPane.showMessageDialog(TECommonUtil.getTopFrame(this), this.pageResUtil.getString("NO_DATA"));
                return;
            }
            int width = this.chartCanvas.getWidth();
            int height = this.chartCanvas.getHeight();
            BufferedImage image = new BufferedImage(width, height, 5);
            Graphics g = image.getGraphics();
            this.chartCanvas.paintAll(g);
            FileOutputStream output = new FileOutputStream(graphImageFile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
            encoder.encode(image);
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            TEAppletLogMgr.error("TEOTDRGraphRepeaterInfoView.doPrintGraph() fail!", e);
        }
        catch (ImageFormatException e) {
            TEAppletLogMgr.error("TEOTDRGraphRepeaterInfoView.doPrintGraph() fail!", (Exception)((Object)e));
        }
        catch (IOException e) {
            TEAppletLogMgr.error("TEOTDRGraphRepeaterInfoView.doPrintGraph() fail!", e);
        }
        createHtmlReport.createGraph(graphImageFile.getAbsolutePath(), this.resUtil.getString("RepeaterTestData") + " RepeaterID: " + this.repeaterComboBox.getSelectedItem(), "");
        createHtmlReport.closeReport();
        createHtmlReport.showReportFrame();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.getRepaterComboBoxPanel(), "North");
        this.chartCanvas = new TEOTDRRepeaterChartCanvas(this.teOTDRGraphModuleMgr);
        this.chartContainer = new JScrollPane(22, 32);
        this.chartContainer.setBorder(BorderFactory.createEtchedBorder());
        this.chartContainer.getViewport().add(this.chartCanvas);
        this.add((Component)this.chartContainer, "Center");
        this.add(this.getBtnPanel(), "South");
    }

    private Component getRepaterComboBoxPanel() {
        JPanel comboBoxPanel = new JPanel();
        comboBoxPanel.setLayout(new FlowLayout(0));
        JLabel repeaterIDLabel = new JLabel();
        repeaterIDLabel.setText(this.resUtil.getString("repeaterID"));
        comboBoxPanel.add(repeaterIDLabel);
        comboBoxPanel.add(this.repeaterComboBox);
        return comboBoxPanel;
    }

    @Override
    protected Component getBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.add(this.printButton);
        return btnPanel;
    }

    public void getRepeaterIDInfo() {
        OperationData req = this.createGetRptIDInfoReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processGetRptIDInfoRsp(rsp);
    }

    private OperationData createGetRptIDInfoReq() {
        OperationData req = new OperationData();
        req.setServletName("rptIDList");
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        req.addURLParam("indexID", this.getIndexID());
        return req;
    }

    private void processGetRptIDInfoRsp(Datainterface rsp) {
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            ArrayList<String> operObjParamList = new ArrayList<String>();
            operObjParamList.add("neID");
            operObjParamList.add("indexID");
            this.teCommonUtil.showOptionMessage((Component)this, rsp, operObjParamList);
            return;
        }
        String rptListData = rsp.getDataRowParamValue(0, "rptID");
        if (null == rptListData || "".equals(rptListData)) {
            return;
        }
        String[] rptListDataSplit = rptListData.split(" ");
        if (0 == rptListDataSplit.length) {
            return;
        }
        Object[] repeaterIDArray = new Integer[rptListDataSplit.length];
        int len = rptListDataSplit.length;
        for (int i = 0; i < len; ++i) {
            repeaterIDArray[i] = Integer.valueOf(rptListDataSplit[i]);
        }
        Arrays.sort(repeaterIDArray);
        this.repeaterComboBox.setModel(new DefaultComboBoxModel<Object>(repeaterIDArray));
        this.repeaterComboBox.setSelectedIndex(0);
        this.handleRepeaterItemChanged();
    }

    private void queryRptInfo(int rptID) {
        OperationData req = this.createQueryRptInfoReq(rptID);
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processQueryRptInfoRsp(rsp);
    }

    private OperationData createQueryRptInfoReq(int rptID) {
        OperationData req = new OperationData();
        req.setServletName("linechart");
        req.addURLParam("indexID", this.getIndexID());
        req.addURLParam("repeaterID", rptID);
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        return req;
    }

    private void processQueryRptInfoRsp(Datainterface rsp) {
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            ArrayList<String> operObjParamList = new ArrayList<String>();
            operObjParamList.add("repeaterID");
            this.teCommonUtil.showOptionMessage((Component)this, rsp, operObjParamList);
            return;
        }
        String gainInfo = rsp.getDataRowParamValue(0, "rptGainInfo");
        this.chartCanvas.showRepeaterGainChart(gainInfo);
    }

    @Override
    protected void disableAllBtn() {
        this.printButton.setEnabled(false);
    }

    @Override
    protected void refreshBtnStatus() {
        this.printButton.setEnabled(true);
    }

    @Override
    protected Map<String, Integer> getBtn2CmdMap() {
        HashMap<String, Integer> rightMap = new HashMap<String, Integer>();
        return rightMap;
    }

    @Override
    public void destroy() {
    }

    class ViewResizeListener
    extends ComponentAdapter {
        ViewResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TEOTDRGraphRepeaterInfoView.this.getRepeaterIDInfo();
        }
    }
}

