/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphCurrTestFrameInteractor;
import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMgrView;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.component.toolbar.TEOTDRGraphToolbar;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.report.InmHtmlReport;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphPanel;
import com.huawei.nglct.otdr.appletgraph.lookandfeel.UIStyleTool;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphInteractor;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphLegendInterface;
import com.huawei.nglct.otdr.appletgraph.param.TEOTDRParamPanel;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public abstract class TEOTDRGraphParamView
extends JPanel
implements TEOTDRGraphModule {
    private static final long serialVersionUID = 1L;
    private TEOTDRGraphPanel showPanel = null;
    private boolean isInApplet = false;
    private JSplitPane graphAndParamSplit = new JSplitPane();
    private JSplitPane statusSplitPane = new JSplitPane();
    private JTextField timerStatusField = new JTextField("");
    private JTextField statusField = new JTextField("");
    private static final String STR_RES_FILE;
    private TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance(STR_RES_FILE);
    protected static final String T2000_ADMIN_ID = "10";
    protected static final String T2000_ADMIN_STR = "admin";
    private static final int SPLIT_DIVIDER_SIZE = 8;
    private static final double GRAPHSPLIT = 0.7;
    private static final double STATUSSPLIT = 0.5;
    private int windowWidth = -1;
    private int miniGraphWidth = -1;
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRGraphParamView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.showPanel = new TEOTDRGraphPanel(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil);
        this.setInApplet(true);
        this.registerModule();
    }

    public final void initView() {
        this.initComponent();
        this.refreshGraph();
    }

    public void registerModule() {
        this.teOTDRGraphModuleMgr.registerModule("mainframemodule", this);
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.getToolbar(), "North");
        this.initSplitPane();
        this.initStatusField();
        this.addComponentListener(new MainComponentListener());
    }

    private void initStatusField() {
        this.statusSplitPane.setOrientation(1);
        this.statusSplitPane.setDividerSize(8);
        this.statusSplitPane.setOneTouchExpandable(false);
        this.timerStatusField.setEditable(false);
        this.statusField.setEditable(false);
        this.statusSplitPane.setLeftComponent(this.timerStatusField);
        this.statusSplitPane.setRightComponent(this.statusField);
        this.add((Component)this.statusSplitPane, "South");
    }

    private void initSplitPane() {
        JPanel pp = new JPanel();
        pp.setBorder(BorderFactory.createEtchedBorder());
        pp.setLayout(new BorderLayout());
        pp.add((Component)this.graphAndParamSplit, "Center");
        this.add((Component)pp, "Center");
        this.graphAndParamSplit.setSize(new Dimension(900, 625));
        this.graphAndParamSplit.setOrientation(1);
        this.graphAndParamSplit.setDividerSize(8);
        this.graphAndParamSplit.setDividerLocation(0.7);
        this.graphAndParamSplit.setOneTouchExpandable(false);
        this.graphAndParamSplit.setContinuousLayout(false);
        this.graphAndParamSplit.setLeftComponent(this.getOTDRGraphShowPanel());
        this.graphAndParamSplit.setRightComponent(this.getParamPanel());
        this.initSplitpaneEvent();
    }

    private void initSplitpaneEvent() {
        this.graphAndParamSplit.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
    }

    public void setStatus(String timerInfo, String statusInfo) {
        this.timerStatusField.setText(timerInfo);
        this.timerStatusField.repaint();
        this.statusField.setText(statusInfo);
        this.statusField.repaint();
    }

    public boolean isInApplet() {
        return this.isInApplet;
    }

    public void setInApplet(boolean isInApplet) {
        this.isInApplet = isInApplet;
    }

    protected Component getToolbar() {
        return new TEOTDRGraphToolbar(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil, false);
    }

    protected Component getOTDRGraphShowPanel() {
        return this.showPanel;
    }

    protected Component getParamPanel() {
        return new TEOTDRParamPanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
    }

    protected abstract void refreshGraph();

    public String getString(String key) {
        return this.resUtil.getString(key);
    }

    public void openFile(int neid, String fileName) {
        TEOTDRGraphFileTreeFileOpenedEvent event = TEOTDRGraphFileTreeFileOpenedEvent.getEvent();
        event.setNeID(this.teCommonUtil.getNeID());
        event.setFileName(fileName);
        this.showPanel.openFile(neid, fileName);
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    public void closeFile(String fileName) {
        TEOTDRGraphFileTreeFileClosedEvent event = TEOTDRGraphFileTreeFileClosedEvent.getEvent();
        event.setFileName(fileName);
        event.setNeID(this.teCommonUtil.getNeID());
        this.teOTDRGraphEventManager.triggerEvent(event);
        ArrayList<String> list = new ArrayList<String>();
        list.add(fileName);
        this.showPanel.closeFiles(list);
    }

    @Override
    public TEOTDRGraphInteractor getInteractor() {
        return new TEOTDRGraphCurrTestFrameInteractor(this);
    }

    final void doPrint() {
        Frame frame = TECommonUtil.getTopFrame(this);
        frame.toFront();
        Component graphPanel = this.getOTDRGraphShowPanel();
        TEOTDRGraphLegendInterface legendInf = this.teOTDRGraphModuleMgr.getLegendInteractor();
        InmTable paramTable = (InmTable)legendInf.getParamTable();
        paramTable.cancelEditing();
        String sHtmlTitle = "TEOTDRGraph";
        String sHtmlActor = this.teCommonUtil.getNmUserName();
        if (T2000_ADMIN_ID.equals(sHtmlActor)) {
            sHtmlActor = T2000_ADMIN_STR;
        }
        InmHtmlReport createHtmlReport = new InmHtmlReport();
        createHtmlReport.createReport(this.teCommonUtil.getTopFrame(), sHtmlTitle);
        createHtmlReport.createHead(sHtmlTitle, sHtmlActor, null, this.teCommonUtil.getNeID(), this.teCommonUtil.getUser());
        int[] paramTableColumnWidth = new int[paramTable.getColumnCount() * 2];
        int[] paramTableColumnPosition = this.getTableColPositionArray(paramTable);
        int[] paramTableModelColIndex = new int[paramTable.getColumnCount()];
        int colCountAll = paramTable.getColumnCount();
        for (int i = 0; i < colCountAll; ++i) {
            int modelColIndex;
            paramTableModelColIndex[i] = modelColIndex = paramTable.convertColumnIndexToModel(i);
            paramTableColumnWidth[i * 2] = i;
            paramTableColumnWidth[i * 2 + 1] = paramTable.getColumnModel().getColumn(i).getWidth();
        }
        Vector<Object> paramPrintData = ((DefaultTableModel)paramTable.getModel()).getDataVector();
        Vector<Object> paramColumnNames = this.getTableHeadVector(paramTable);
        String[][] paramTableData = TEOTDRGraphMgrView.convertVectorToBiArray(paramColumnNames, paramPrintData);
        createHtmlReport.createTable(paramTableData, this.resUtil.getString("ParamTableTitle"), "", true, paramTableColumnWidth, paramTableColumnPosition);
        InmHtmlReport graphReport = new InmHtmlReport();
        File graphImageFile = graphReport.createNewImageFile(this.teCommonUtil.getTopFrame(), "TEOTDRGraph");
        try {
            int width = graphPanel.getWidth();
            int height = graphPanel.getHeight();
            BufferedImage image = new BufferedImage(width, height, 5);
            Graphics g = image.getGraphics();
            graphPanel.paintAll(g);
            FileOutputStream output = new FileOutputStream(graphImageFile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
            encoder.encode(image);
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            TEAppletLogMgr.error("TEOTDRGraphParamView.doPrint() fail!", e);
        }
        catch (ImageFormatException e) {
            TEAppletLogMgr.error("TEOTDRGraphParamView.doPrint() fail!", (Exception)((Object)e));
        }
        catch (IOException e) {
            TEAppletLogMgr.error("TEOTDRGraphParamView.doPrint() fail!", e);
        }
        createHtmlReport.createGraph(graphImageFile.getAbsolutePath(), this.resUtil.getString("GraphPanelTitle"), "");
        createHtmlReport.closeReport();
        createHtmlReport.showReportFrame();
    }

    private int[] getTableColPositionArray(JTable table) {
        int[] columnPosition = new int[table.getColumnCount() * 2];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            columnPosition[i * 2] = i;
            columnPosition[i * 2 + 1] = 1;
        }
        return columnPosition;
    }

    private Vector<Object> getTableHeadVector(JTable table) {
        Vector<Object> tableColName = new Vector<Object>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            tableColName.add(table.getColumnName(i));
        }
        return tableColName;
    }

    public static String[] convertVectorToArray(Vector<Object> inputDataVc) {
        if (inputDataVc == null) {
            return null;
        }
        String[] outputData = new String[inputDataVc.size()];
        for (int i = 0; i < inputDataVc.size(); ++i) {
            outputData[i] = inputDataVc.elementAt(i).toString();
        }
        return outputData;
    }

    void doHideParamPanel() {
        this.graphAndParamSplit.setDividerSize(0);
        this.graphAndParamSplit.setDividerLocation(1.0);
    }

    void doShowParamPanel() {
        this.graphAndParamSplit.setDividerSize(8);
        this.graphAndParamSplit.setDividerLocation(0.7);
    }

    static {
        UIStyleTool.setHuaweiStyle();
        STR_RES_FILE = "res/pagestringres_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    }

    class MainComponentListener
    extends ComponentAdapter {
        MainComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TEOTDRGraphParamView.this.windowWidth = TEOTDRGraphParamView.this.getWidth();
            System.out.println("windowwidth->" + TEOTDRGraphParamView.this.windowWidth);
            TEOTDRGraphParamView.this.miniGraphWidth = (int)((double)TEOTDRGraphParamView.this.windowWidth * 0.56);
            TEOTDRGraphParamView.this.showPanel.setMinimumSize(new Dimension(TEOTDRGraphParamView.this.miniGraphWidth, 0));
            try {
                TEOTDRGraphParamView.this.graphAndParamSplit.setDividerLocation(0.7);
                TEOTDRGraphParamView.this.statusSplitPane.setDividerLocation(0.5);
                if (SwingUtilities.isEventDispatchThread()) {
                    TEOTDRGraphParamView.this.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TEOTDRGraphParamView.this.repaint();
                        }
                    });
                }
            }
            catch (Exception ex) {
                TEAppletLogMgr.error("TEOTDRGraphParamView.MainComponentListener.componentResized() Exception!", ex);
            }
        }
    }
}

