/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMainFrameInteractor;
import com.huawei.nglct.otdr.appletgraph.bottomtable.TEOTDRBottomTabbedPane;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.component.toolbar.TEOTDRGraphToolbar;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Param;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowErrors;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowParams;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.TEOTDRAllError;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.report.InmHtmlReport;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmScreenToolKit;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultStruct;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultVector;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.TEOperationShowMessage;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTable;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTableModel;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileSelectedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphCurveStatusChangeListener;
import com.huawei.nglct.otdr.appletgraph.filetree.TEOTDRFileTreePanel;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphPanel;
import com.huawei.nglct.otdr.appletgraph.lookandfeel.UIStyleTool;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphInteractor;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphBottomTabInterface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphFileTreeIntegerface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphLegendInterface;
import com.huawei.nglct.otdr.appletgraph.param.TEOTDRParamPanel;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public abstract class TEOTDRGraphMgrView
extends JPanel
implements TEOTDRGraphModule {
    private static final long serialVersionUID = 1L;
    private boolean isInApplet = false;
    private int neID = -1;
    private String neName = "";
    private int indexID = -1;
    private int testMode = -1;
    private int lmiNEID = -1;
    private int lmiSlotID = -1;
    private int lmiPortID = -1;
    private JSplitPane upAndEvtTabSplit = new JSplitPane();
    private JSplitPane fileTreeAndRightSplit = new JSplitPane();
    private JSplitPane graphAndParamSplit = new JSplitPane();
    private Map<String, Boolean> btnRightMap = new HashMap<String, Boolean>();
    private static final String STR_RES_FILE = "res/pagestringres_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance(STR_RES_FILE);
    private static final double EVTSPLIT = 0.7;
    private static final double FILESPLIT = 0.2;
    private static final double GRAPHSPLIT = 0.7;
    private int windowWidth = -1;
    private int miniGraphWidth = -1;
    private int paramWidth = -1;
    private static final int SPLIT_DIVIDER_SIZE = 8;
    protected static final String T2000_ADMIN_ID = "10";
    protected static final String T2000_ADMIN_STR = "admin";
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;
    private TEOTDRParamPanel paramPanel = null;
    private TEOTDRGraphPanel graphPanel = null;
    private TEOTDRBottomTabbedPane evtPanel = null;

    public TEOTDRGraphMgrView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.setInApplet(true);
        this.initLineInfo();
        this.registerModule();
        this.registerListener();
        UIStyleTool.setHuaweiStyle();
    }

    protected abstract void initBtn();

    public final void initView() {
        this.initBtn();
        this.rightCheck();
        this.initComponent();
        this.refreshBtnStatus();
        this.addComponentListener(new MainComponentListener());
    }

    public String getString(String key) {
        return this.resUtil.getString(key);
    }

    private void initLineInfo() {
        this.setNeID(this.teCommonUtil.getNeID());
        this.setNeName(this.teCommonUtil.getNeName());
        this.setIndexID(this.teCommonUtil.getLineID());
        this.setTestMode(this.teCommonUtil.getTestMode());
        this.setLmiNEID(this.teCommonUtil.getLmiNEID());
        this.setLmiSlotID(this.teCommonUtil.getLmiSlotID());
        this.setLmiPortID(this.teCommonUtil.getLmiPortID());
    }

    protected void registerListener() {
        TEOTDRGraphFileTreeFileSelectedListener selListener = new TEOTDRGraphFileTreeFileSelectedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRGraphMgrView.this.refreshBtnStatus();
            }
        };
        this.teOTDRGraphEventManager.addListener(selListener);
        TEOTDRGraphFileTreeFileClosedListener closeFileListener = new TEOTDRGraphFileTreeFileClosedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRGraphMgrView.this.refreshBtnStatus();
            }
        };
        this.teOTDRGraphEventManager.addListener(closeFileListener);
        TEOTDRGraphFileTreeFileDeletedListener delFileListener = new TEOTDRGraphFileTreeFileDeletedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRGraphMgrView.this.refreshBtnStatus();
            }
        };
        this.teOTDRGraphEventManager.addListener(delFileListener);
        TEOTDRGraphGraphCurveStatusChangeListener graphOpenListener = new TEOTDRGraphGraphCurveStatusChangeListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRGraphMgrView.this.graphContentUpdated();
            }
        };
        this.teOTDRGraphEventManager.addListener(graphOpenListener);
    }

    protected void graphContentUpdated() {
        this.refreshBtnStatus();
    }

    protected void rightCheck() {
        OperationData req = new OperationData();
        req.setServletName("securityServlet");
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        Map<String, Integer> btnInfomap = this.getBtn2CmdMap();
        RowParams rp = null;
        Param pra = null;
        Iterator<Map.Entry<String, Integer>> iter = btnInfomap.entrySet().iterator();
        Map.Entry<String, Integer> entry = null;
        String btnName = null;
        Integer cmdCode = null;
        while (iter.hasNext()) {
            rp = new RowParams();
            entry = iter.next();
            if (null == entry) continue;
            btnName = entry.getKey();
            cmdCode = entry.getValue();
            pra = new Param("btnId", btnName);
            rp.addParam(pra);
            pra = new Param("sfid", cmdCode.toString());
            rp.addParam(pra);
            req.addXMLRowParams(rp);
        }
        Datainterface rsp = TECommUtil.sendCommand(req);
        if (null == rsp) {
            return;
        }
        int len = rsp.getDataRowLength();
        for (int i = 0; i < len; ++i) {
            String btnId = rsp.getDataRowParamValue(i, "btnId");
            int intRight = Integer.valueOf(rsp.getDataRowParamValue(i, "right"));
            Boolean right = intRight > 0;
            this.btnRightMap.put(btnId, right);
        }
    }

    public boolean hasOperationRight(String btnID) {
        Boolean right = this.btnRightMap.get(btnID);
        return right != null && right != false;
    }

    protected abstract Map<String, Integer> getBtn2CmdMap();

    public void registerModule() {
        this.teOTDRGraphModuleMgr.registerModule("mainframemodule", this);
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.initSplitPane();
        this.add(this.getBtnPanel(), "South");
        this.add(this.getToolbar(), "North");
    }

    private void initSplitPane() {
        JPanel pp = new JPanel();
        pp.setBorder(BorderFactory.createEtchedBorder());
        pp.setLayout(new BorderLayout());
        pp.add((Component)this.upAndEvtTabSplit, "Center");
        this.add((Component)pp, "Center");
        this.upAndEvtTabSplit.setOrientation(0);
        this.upAndEvtTabSplit.setContinuousLayout(false);
        this.upAndEvtTabSplit.setLeftComponent(this.fileTreeAndRightSplit);
        this.upAndEvtTabSplit.setDividerSize(8);
        this.upAndEvtTabSplit.setRightComponent(this.getEventTabPanel());
        this.upAndEvtTabSplit.setDividerLocation(0.7);
        this.fileTreeAndRightSplit.setOrientation(1);
        this.fileTreeAndRightSplit.setContinuousLayout(false);
        this.fileTreeAndRightSplit.setLeftComponent(this.getFileTreePanel());
        final JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.graphAndParamSplit, "Center");
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int newWidth = panel.getWidth();
                System.out.println("panel width->" + newWidth);
                int dsize = TEOTDRGraphMgrView.this.graphAndParamSplit.getDividerSize();
                int location = newWidth - TEOTDRGraphMgrView.this.paramWidth - dsize;
                if (location > 0) {
                    TEOTDRGraphMgrView.this.graphAndParamSplit.setDividerLocation(location);
                    TEOTDRGraphMgrView.this.validate();
                }
            }
        });
        this.fileTreeAndRightSplit.setRightComponent(panel);
        this.fileTreeAndRightSplit.setDividerSize(8);
        this.fileTreeAndRightSplit.setOpaque(true);
        this.fileTreeAndRightSplit.setDividerLocation(0.2);
        this.graphAndParamSplit.setOrientation(1);
        this.graphAndParamSplit.setContinuousLayout(false);
        this.graphAndParamSplit.setLeftComponent(this.getOTDRGraphPanel());
        this.graphAndParamSplit.setRightComponent(this.getParamPanel());
        this.graphAndParamSplit.setDividerSize(8);
        this.graphAndParamSplit.setDividerLocation(0.7);
        this.paramPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TEOTDRGraphMgrView.this.paramWidth = TEOTDRGraphMgrView.this.paramPanel.getWidth();
                System.out.println("paramwidth->" + TEOTDRGraphMgrView.this.paramWidth);
            }
        });
        this.initSplitpaneEvent();
    }

    private void initSplitpaneEvent() {
        this.upAndEvtTabSplit.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.fileTreeAndRightSplit.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TEOTDRGraphMgrView.this.fileTreeAndRightSplit.getDividerLocation();
                System.out.println(evt.getNewValue());
            }
        });
        this.graphAndParamSplit.addPropertyChangeListener("lastDividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
    }

    public boolean isInApplet() {
        return this.isInApplet;
    }

    public void setInApplet(boolean isInApplet) {
        this.isInApplet = isInApplet;
    }

    public String getUserName() {
        return this.teCommonUtil.getNmUserName();
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public String getNeName() {
        return this.neName;
    }

    public void setNeName(String neName) {
        this.neName = neName;
    }

    public static void main(String[] args) {
    }

    @Override
    public TEOTDRGraphInteractor getInteractor() {
        return new TEOTDRGraphMainFrameInteractor(this);
    }

    protected void doDeleteFile() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        if (null == finf) {
            return;
        }
        List<String> fileNameList = finf.getCurrentSelectedFileList();
        this.doDeleteFile(fileNameList);
    }

    final void doDeleteFile(List<String> fileNameList) {
        String confirmStr = "dangeroperation";
        if (0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString(confirmStr))) {
            return;
        }
        if (null != fileNameList && !fileNameList.isEmpty()) {
            this.disableAllBtn();
            this.doDeleteFileImpl(fileNameList);
            this.refreshBtnStatus();
        } else {
            InmOptionPane.showMessageDialog(this, this.getString("selectonefile"));
        }
    }

    private void doDeleteFileImpl(List<String> fileNameList) {
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        InmOperResultVector operVector = new InmOperResultVector();
        InmOperResultStruct operStruct = null;
        int rowsNum = 0;
        ArrayList<String> deletingList = new ArrayList<String>();
        for (String fileName : fileNameList) {
            OperationData req = this.createDeleteFilereq(fileName);
            Datainterface rsp = TECommUtil.sendCommand(req);
            rowsNum += rsp.getDataRowLength();
            if ("0".equals(rsp.getErrorMessage().getErrorcode())) {
                deletingList.add(fileName);
                continue;
            }
            TEOTDRAllError allError = rsp.getAllError();
            if (null == allError) continue;
            ArrayList<RowErrors> rowErrows = allError.getRowErrors();
            for (RowErrors row : rowErrows) {
                operStruct = new InmOperResultStruct();
                operStruct.operObj = row.getParam("nmFileName").getValue();
                operStruct.operResult = this.getString("operfailed");
                operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                operVector.add(operStruct);
            }
        }
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
        if (null == operVector || operVector.isEmpty()) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operSucceeded"), true);
        } else if (operVector.size() == rowsNum) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
        } else {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
        }
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        if (null != finf) {
            finf.deleteFile(deletingList);
        }
    }

    private OperationData createDeleteFilereq(String fileName) {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", 2556010);
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        RowParams rp = new RowParams();
        Param par = new Param();
        par.setName("indexID");
        par.setValue(String.valueOf(this.getIndexID()));
        rp.addParam(par);
        par = new Param();
        par.setName("neID");
        par.setValue(String.valueOf(this.getNeID()));
        rp.addParam(par);
        par = new Param();
        par.setName("testMode");
        par.setValue(String.valueOf(this.getTestModeFromFileName(fileName)));
        rp.addParam(par);
        par = new Param();
        par.setName("fileName");
        par.setValue(fileName);
        rp.addParam(par);
        par = new Param();
        par.setName("nmFileName");
        par.setValue(this.teCommonUtil.getParamFromFileName(fileName, "showName", this.isTestModeShown()));
        rp.addParam(par);
        req.addXMLRowParams(rp);
        return req;
    }

    protected boolean isTestModeShown() {
        return false;
    }

    protected int getTestModeFromFileName(String fileName) {
        String fileNameTmp = fileName.substring(0, fileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        String testModeStr = propArray[1];
        return Integer.parseInt(testModeStr);
    }

    public int getIndexID() {
        return this.indexID;
    }

    final void doSaveFile(List<String> fileNameList) {
        this.disableAllBtn();
        this.doSaveFileImpl(fileNameList);
        this.refreshBtnStatus();
    }

    private void doSaveFileImpl(List<String> fileNameList) {
        OperationData req = this.createSaveFileReq(fileNameList);
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processSaveFileResponse(rsp, fileNameList);
    }

    private void processSaveFileResponse(Datainterface rsp, List<String> fileNameList) {
        TEOTDRGraphFileTreeIntegerface finf;
        ArrayList<String> saveSuccessFileNameList = new ArrayList<String>();
        Iterator<String> iter = fileNameList.iterator();
        String fileName = null;
        while (iter.hasNext()) {
            fileName = iter.next();
            saveSuccessFileNameList.add(fileName);
        }
        ArrayList<String> saveFailFileNameList = new ArrayList<String>();
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            ArrayList<String> operObjParamList = new ArrayList<String>();
            operObjParamList.add("nename");
            operObjParamList.add("fileName");
            this.teCommonUtil.showOptionMessage((Component)this, rsp, operObjParamList);
            int size = rsp.getAllError().getRowErrLength();
            for (int i = 0; i < size; ++i) {
                fileName = rsp.getDataRowParamValue(i, "fileName");
                if (null == fileName || "".equals(fileName)) continue;
                saveFailFileNameList.add(fileName);
            }
        }
        saveSuccessFileNameList.removeAll(saveFailFileNameList);
        if (!saveSuccessFileNameList.isEmpty() && null != (finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor())) {
            finf.saveFile(saveSuccessFileNameList);
        }
        if (0 == errorCode) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operSucceeded"), true);
        }
    }

    private OperationData createSaveFileReq(List<String> fileNameList) {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", String.valueOf(2556008));
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        for (String fileName : fileNameList) {
            RowParams rp = new RowParams();
            Param par = new Param();
            par.setName("neID");
            par.setValue(String.valueOf(this.getNeID()));
            rp.addParam(par);
            par = new Param();
            par.setName("indexID");
            par.setValue(String.valueOf(this.getIndexID()));
            rp.addParam(par);
            par = new Param();
            par.setName("testMode");
            par.setValue(String.valueOf(this.getTestModeFromFileName(fileName)));
            rp.addParam(par);
            par = new Param();
            par.setName("fileName");
            par.setValue(fileName);
            rp.addParam(par);
            par = new Param();
            par.setName("nmFileName");
            par.setValue(fileName);
            rp.addParam(par);
            req.addXMLRowParams(rp);
        }
        return req;
    }

    final void doPrint() {
        int modelColIndex;
        int i;
        Frame frame = TECommonUtil.getTopFrame(this);
        frame.toFront();
        TEOTDRGraphGraphInterface graphInf = this.teOTDRGraphModuleMgr.getGraphInteractor();
        JPanel graphPanel = graphInf.getGraphPanel();
        TEOTDRGraphLegendInterface legendInf = this.teOTDRGraphModuleMgr.getLegendInteractor();
        InmTable paramTable = (InmTable)legendInf.getParamTable();
        TEOTDRGraphBottomTabInterface bottomInf = this.teOTDRGraphModuleMgr.getBottomTabInteractor();
        TENormalTable eventTable = (TENormalTable)bottomInf.getEventTable();
        TENormalTable rptTable = (TENormalTable)bottomInf.getRptGainInfoReportTable();
        if (null == graphPanel) {
            InmOptionPane.showMessageDialog(TECommonUtil.getTopFrame(this), this.resUtil.getString("NO_DATA"));
            return;
        }
        paramTable.cancelEditing();
        eventTable.cancelEditing();
        rptTable.cancelEditing();
        String sHtmlTitle = "TEOTDRGraph";
        String sHtmlActor = this.teCommonUtil.getNmUserName();
        if (T2000_ADMIN_ID.equals(sHtmlActor)) {
            sHtmlActor = T2000_ADMIN_STR;
        }
        InmHtmlReport createHtmlReport = new InmHtmlReport();
        createHtmlReport.createReport(frame, sHtmlTitle);
        createHtmlReport.createHead(sHtmlTitle, sHtmlActor, null, this.teCommonUtil.getNeID(), this.teCommonUtil.getUser());
        int[] paramTableColumnWidth = new int[paramTable.getColumnCount() * 2];
        int[] eventTableColumnWidth = new int[eventTable.getColumnCount() * 2];
        int[] rptTableColumnWidth = new int[rptTable.getColumnCount() * 2];
        int[] paramTableColumnPosition = this.getTableColPositionArray(paramTable);
        int[] eventTableColumnPosition = this.getTableColPositionArray(eventTable);
        int[] rptTableColumnPosition = this.getTableColPositionArray(rptTable);
        int[] paramTableModelColIndex = new int[paramTable.getColumnCount()];
        int[] eventTableModelColIndex = new int[eventTable.getColumnCount()];
        int[] rptTableModelColIndex = new int[rptTable.getColumnCount()];
        int colCountAll = paramTable.getColumnCount();
        for (i = 0; i < colCountAll; ++i) {
            paramTableModelColIndex[i] = modelColIndex = paramTable.convertColumnIndexToModel(i);
            paramTableColumnWidth[i * 2] = i;
            paramTableColumnWidth[i * 2 + 1] = paramTable.getColumnModel().getColumn(i).getWidth();
        }
        colCountAll = eventTable.getColumnCount();
        for (i = 0; i < colCountAll; ++i) {
            eventTableModelColIndex[i] = modelColIndex = eventTable.convertColumnIndexToModel(i);
            eventTableColumnWidth[i * 2] = i;
            eventTableColumnWidth[i * 2 + 1] = eventTable.getColumnModel().getColumn(i).getWidth();
        }
        colCountAll = rptTable.getColumnCount();
        for (i = 0; i < colCountAll; ++i) {
            rptTableModelColIndex[i] = modelColIndex = rptTable.convertColumnIndexToModel(i);
            rptTableColumnWidth[i * 2] = i;
            rptTableColumnWidth[i * 2 + 1] = rptTable.getColumnModel().getColumn(i).getWidth();
        }
        Vector<Object> paramPrintData = ((DefaultTableModel)paramTable.getModel()).getDataVector();
        Vector<Object> eventPrintData = ((TENormalTableModel)eventTable.getModel()).getDataVector();
        Vector<Object> rptPrintData = ((TENormalTableModel)rptTable.getModel()).getDataVector();
        Vector<Object> paramColumnNames = this.getTableHeadVector(paramTable);
        Vector<Object> eventColumnNames = this.getTableHeadVector(eventTable);
        Vector<Object> rptColumnNames = this.getTableHeadVector(rptTable);
        String[][] paramTableData = TEOTDRGraphMgrView.convertVectorToBiArray(paramColumnNames, paramPrintData);
        String[][] eventTableData = TEOTDRGraphMgrView.convertVectorToBiArray(eventColumnNames, eventPrintData);
        String[][] rptTableData = TEOTDRGraphMgrView.convertVectorToBiArray(rptColumnNames, rptPrintData);
        createHtmlReport.createTable(paramTableData, this.resUtil.getString("ParamTableTitle"), "", true, paramTableColumnWidth, paramTableColumnPosition);
        createHtmlReport.createTable(eventTableData, this.resUtil.getString("EventTableTitle"), "", true, eventTableColumnWidth, eventTableColumnPosition);
        createHtmlReport.createTable(rptTableData, this.resUtil.getString("RptTableTitle"), "", true, rptTableColumnWidth, rptTableColumnPosition);
        InmHtmlReport graphReport = new InmHtmlReport();
        File graphImageFile = graphReport.createNewImageFile(frame, "TEOTDRGraph");
        try {
            int width = graphPanel.getWidth();
            int height = graphPanel.getHeight();
            BufferedImage image = new BufferedImage(width, height, 5);
            Graphics g = image.getGraphics();
            graphPanel.printAll(g);
            FileOutputStream output = new FileOutputStream(graphImageFile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
            encoder.encode(image);
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            TEAppletLogMgr.error("TEOTDRGraphMgrView.doPrint() fail!", e);
        }
        catch (ImageFormatException e) {
            TEAppletLogMgr.error("TEOTDRGraphMgrView.doPrint() fail!", (Exception)((Object)e));
        }
        catch (IOException e) {
            TEAppletLogMgr.error("TEOTDRGraphMgrView.doPrint() fail!", e);
        }
        createHtmlReport.createGraph(graphImageFile.getAbsolutePath(), this.resUtil.getString("GraphPanelTitle"), "");
        createHtmlReport.closeReport();
        createHtmlReport.showReportFrame();
    }

    private int[] getTableColPositionArray(JTable table) {
        int[] columnPosition = new int[table.getColumnCount() * 2];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            columnPosition[i * 2] = i;
            columnPosition[i * 2 + 1] = 1;
        }
        return columnPosition;
    }

    private Vector<Object> getTableHeadVector(JTable table) {
        Vector<Object> tableColName = new Vector<Object>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            tableColName.add(table.getColumnName(i));
        }
        return tableColName;
    }

    public static String[][] convertVectorToBiArray(Vector<Object> paramColumnNames, Vector<Object> inputDataVc) {
        if (null == paramColumnNames || null == inputDataVc) {
            return null;
        }
        String[][] outputData = new String[inputDataVc.size() + 1][];
        outputData[0] = TEOTDRGraphMgrView.convertVectorToArray(paramColumnNames);
        Object rowData = null;
        for (int i = 0; i < inputDataVc.size(); ++i) {
            rowData = inputDataVc.elementAt(i);
            if (!(rowData instanceof Vector)) {
                TECommonUtil.log("TEOTDRGraphMgrView.convertVectorToBiArray", "convertVectorToBiArray: " + rowData);
                return null;
            }
            outputData[i + 1] = TEOTDRGraphMgrView.convertVectorToArray((Vector)rowData);
        }
        return outputData;
    }

    public static String[] convertVectorToArray(Vector<Object> inputDataVc) {
        if (inputDataVc == null) {
            return null;
        }
        String[] outputData = new String[inputDataVc.size()];
        for (int i = 0; i < inputDataVc.size(); ++i) {
            outputData[i] = inputDataVc.elementAt(i).toString();
        }
        return outputData;
    }

    protected abstract void disableAllBtn();

    protected abstract void refreshBtnStatus();

    public int getTestMode() {
        return this.testMode;
    }

    protected Component getParamPanel() {
        if (null == this.paramPanel) {
            this.paramPanel = new TEOTDRParamPanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
        }
        return this.paramPanel;
    }

    protected Component getOTDRGraphPanel() {
        if (null == this.graphPanel) {
            this.graphPanel = new TEOTDRGraphPanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
        }
        return this.graphPanel;
    }

    protected Component getFileTreePanel() {
        return new TEOTDRFileTreePanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil, 0);
    }

    protected Component getEventTabPanel() {
        if (null == this.evtPanel) {
            this.evtPanel = new TEOTDRBottomTabbedPane(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
        }
        return this.evtPanel;
    }

    protected Component getToolbar() {
        return new TEOTDRGraphToolbar(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil, true);
    }

    protected abstract Component getBtnPanel();

    public void setIndexID(int indexID) {
        this.indexID = indexID;
    }

    public void setTestMode(int testMode) {
        this.testMode = testMode;
    }

    public int getLmiNEID() {
        return this.lmiNEID;
    }

    public void setLmiNEID(int lmiNEID) {
        this.lmiNEID = lmiNEID;
    }

    public int getLmiSlotID() {
        return this.lmiSlotID;
    }

    public void setLmiSlotID(int lmiSlotID) {
        this.lmiSlotID = lmiSlotID;
    }

    public int getLmiPortID() {
        return this.lmiPortID;
    }

    public void setLmiPortID(int lmiPortID) {
        this.lmiPortID = lmiPortID;
    }

    void doHideParamPanel() {
        this.graphAndParamSplit.setDividerSize(0);
        this.graphAndParamSplit.setDividerLocation(1.0);
    }

    void doShowParamPanel() {
        this.graphAndParamSplit.setDividerSize(8);
        this.graphAndParamSplit.setDividerLocation(0.7);
    }

    void doShowFileTree() {
        this.fileTreeAndRightSplit.setDividerSize(8);
        this.fileTreeAndRightSplit.setDividerLocation(0.2);
    }

    void doShowEventTab() {
        this.upAndEvtTabSplit.setDividerSize(8);
        this.upAndEvtTabSplit.setDividerLocation(0.7);
    }

    void doHideFileTree() {
        this.fileTreeAndRightSplit.setDividerSize(0);
        this.fileTreeAndRightSplit.setDividerLocation(0);
    }

    void doHideEventTab() {
        this.upAndEvtTabSplit.setDividerSize(0);
        this.upAndEvtTabSplit.setDividerLocation(1.0);
    }

    class MainComponentListener
    extends ComponentAdapter {
        MainComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TEOTDRGraphMgrView.this.windowWidth = TEOTDRGraphMgrView.this.getWidth();
            System.out.println("windowwidth->" + TEOTDRGraphMgrView.this.windowWidth);
            TEOTDRGraphMgrView.this.miniGraphWidth = (int)((double)TEOTDRGraphMgrView.this.windowWidth * 0.56 - 16.0);
            int miniGraphHeight = (int)((double)TEOTDRGraphMgrView.this.getHeight() * 0.3 - 8.0);
            TEOTDRGraphMgrView.this.paramWidth = (int)((double)TEOTDRGraphMgrView.this.windowWidth * 0.24 - 16.0);
            TEOTDRGraphMgrView.this.graphPanel.setMinimumSize(new Dimension(TEOTDRGraphMgrView.this.miniGraphWidth, miniGraphHeight));
            try {
                TEOTDRGraphMgrView.this.upAndEvtTabSplit.setDividerLocation(0.7);
                TEOTDRGraphMgrView.this.graphAndParamSplit.setDividerLocation(0.7);
                TEOTDRGraphMgrView.this.fileTreeAndRightSplit.setDividerLocation(0.2);
                if (SwingUtilities.isEventDispatchThread()) {
                    TEOTDRGraphMgrView.this.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TEOTDRGraphMgrView.this.repaint();
                        }
                    });
                }
            }
            catch (Exception ex) {
                TEAppletLogMgr.error("TEOTDRGraphMgrView.MainComponentListener.componentResized() Exception!", ex);
            }
        }
    }
}

