/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphParamView;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class TEOTDRGraphCurrTestView
extends TEOTDRGraphParamView {
    private static final int REFRESH_TIME = 600000;
    private static final int WAIT_TIME = 180000;
    private static final int REFRESH_TYPE_OPEN = 1;
    private static final int REFRESH_TYPE_CLOSE = 0;
    private static final byte REFRESH_STATUS_FIRST_TIME = 1;
    private static final byte REFRESH_STATUS_TESTING = 2;
    private static final byte REFRESH_STATUS_WAITING = 3;
    private static final byte REFRESH_STATUS_TEST_STOP = 4;
    private static final byte REFRESH_STATUS_CLOSE = 5;
    private int refreshType = 0;
    private int refreshTime = 0;
    private int refreshStatus = 0;
    private Timer timer = null;
    private boolean isFileShow = false;
    private boolean isTimerStart = false;
    private ViewResizeListener resizeListener = new ViewResizeListener();

    public TEOTDRGraphCurrTestView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        super(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil);
    }

    @Override
    protected void refreshGraph() {
        this.startTimer();
        this.addComponentListener(this.resizeListener);
    }

    public int getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(int refreshType) {
        this.refreshType = refreshType;
    }

    private int refreshTypeHandler() {
        OperationData req = this.createGetRefreshTypeReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        return this.callbackGetRefreshTypeInfoRsp(rsp);
    }

    private OperationData createGetRefreshTypeReq() {
        OperationData req = new OperationData();
        req.setServletName("getRefreshTypeServlet");
        req.addURLParam("neID", this.teCommonUtil.getNeIDStr());
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        req.addURLParam("indexID", this.teCommonUtil.getLineID());
        return req;
    }

    private int callbackGetRefreshTypeInfoRsp(Datainterface rsp) {
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 == errorCode) {
            this.refreshTypeHandler(rsp);
        } else {
            ArrayList<String> operObjParamList = new ArrayList<String>();
            operObjParamList.add("neID");
            operObjParamList.add("indexID");
            String errorInfo = rsp.getAllError().getErrorInfo(operObjParamList);
            this.setStatusInfo(errorInfo, null);
            System.out.println("Get refresh type from server error! The error info is -> " + errorInfo);
        }
        return errorCode;
    }

    private int refreshFileHandler() {
        OperationData req = this.createGetFileInfoReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        return this.callbackGetFileInfoRsp(rsp);
    }

    private OperationData createGetFileInfoReq() {
        OperationData req = new OperationData();
        req.setServletName("xmldata");
        req.addURLParam("neID", this.teCommonUtil.getNeIDStr());
        req.addURLParam("indexID", this.teCommonUtil.getLineID());
        req.addURLParam("fileName", this.getMidFileName());
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        return req;
    }

    private int callbackGetFileInfoRsp(Datainterface rsp) {
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 == errorCode) {
            TEOTDRGraphTraceInfo traceInfo = this.getFileInfo(rsp);
            if (null == traceInfo) {
                return errorCode;
            }
            this.refreshCommonData(traceInfo);
        } else {
            String fileName = this.getMidFileName();
            if (this.isFileShow) {
                this.closeFile(fileName);
            }
            this.teCommonUtil.getOpendedFileContentMap().clear();
        }
        return errorCode;
    }

    private void refreshCommonData(TEOTDRGraphTraceInfo traceInfo) {
        String fileName = this.getMidFileName();
        if (this.isFileShow) {
            this.closeFile(fileName);
        }
        this.teCommonUtil.getOpendedFileContentMap().clear();
        this.teCommonUtil.getOpendedFileContentMap().put(fileName, traceInfo);
        ArrayList<String> fileList = this.teCommonUtil.getOpenedFileList();
        if (null == fileList) {
            return;
        }
        fileList.clear();
        fileList.add(fileName);
        this.openFile(this.teCommonUtil.getNeID(), fileName);
        this.isFileShow = true;
    }

    private String getMidFileName() {
        String lineID = this.teCommonUtil.getIndexIDStr();
        return lineID + "_mid.sor";
    }

    private int getRefreshData(Datainterface data, String indexStr) {
        if (null == data) {
            return -1;
        }
        String str = data.getDataRowParam(0, indexStr).getValue();
        if (null == str || "".equals(str)) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    private void refreshStatusField(int refreshType, int refreshStatus, int refreshTime) {
        StringBuilder statusInfo = new StringBuilder();
        if (1 == refreshType) {
            statusInfo.append(this.getString("statusname")).append(this.getString("statusopen"));
        } else if (0 == refreshType) {
            statusInfo.append(this.getString("statusname")).append(this.getString("statusclose"));
        } else {
            statusInfo.append(this.getString("statusunknown"));
        }
        String refreshInfoStr = this.getRefreshInfo(refreshType, refreshStatus, refreshTime);
        this.setStatusInfo(statusInfo.toString(), refreshInfoStr);
    }

    private String getRefreshInfo(int refreshType, int refreshStatus, int refreshTime) {
        StringBuilder refreshInfo = new StringBuilder();
        refreshInfo.append(this.getString("refreshstatusname"));
        if (1 == refreshType) {
            if (1 == refreshStatus && 0 == refreshTime) {
                refreshInfo.append(this.getString("refreshstatus_1"));
            } else if (2 == refreshStatus || 1 == refreshStatus) {
                if (0 >= refreshTime) {
                    refreshInfo.append(this.getString("refreshstatus_1"));
                } else {
                    refreshInfo.append(this.getString("refreshstatus_2_1")).append(refreshTime + 1).append(this.getString("refreshstatus_2_2"));
                }
            } else if (3 == refreshStatus) {
                refreshInfo.append(this.getString("refreshstatus_3"));
            } else if (4 == refreshStatus) {
                refreshInfo.append(this.getString("refreshstatus_4"));
            } else {
                refreshInfo.append(this.getString("refreshstatus_5"));
            }
        } else {
            refreshInfo.append(this.getString("refreshstatus_5"));
        }
        return refreshInfo.toString();
    }

    private void setStatusInfo(String timerInfo, String statusInfo) {
        if (null == statusInfo) {
            StringBuilder statusBuilder = new StringBuilder();
            statusBuilder.append(this.getString("statusname")).append(this.getString("statusclose"));
            statusInfo = statusBuilder.toString();
        }
        this.setStatus(timerInfo, statusInfo);
    }

    private void refreshTypeHandler(Datainterface data) {
        this.refreshType = this.getRefreshData(data, "refreshType");
        this.refreshStatus = this.getRefreshData(data, "refreshStatus");
        this.refreshTime = this.getRefreshData(data, "refreshTime");
        this.refreshStatusField(this.refreshType, this.refreshStatus, this.refreshTime);
    }

    private TEOTDRGraphTraceInfo getFileInfo(Datainterface data) {
        if (null == data) {
            return null;
        }
        return this.teCommonUtil.getTraceInfo(data);
    }

    private void startTimer() {
        if (!this.isTimerStart) {
            this.endTimer();
            this.timer = new Timer("RrefreshTimer");
            TERefreshTimerTask task = new TERefreshTimerTask();
            this.timer.schedule((TimerTask)task, 180000L, 600000L);
            this.isTimerStart = true;
        }
    }

    private void endTimer() {
        if (this.isTimerStart) {
            if (null != this.timer) {
                this.timer.cancel();
            }
            this.timer = null;
            this.isTimerStart = false;
        }
    }

    public void disposeHandler() {
        this.endTimer();
    }

    @Override
    public void destroy() {
        this.removeComponentListener(this.resizeListener);
    }

    class ViewResizeListener
    extends ComponentAdapter {
        ViewResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TEOTDRGraphCurrTestView.this.refreshTypeHandler();
            TEOTDRGraphCurrTestView.this.refreshFileHandler();
        }
    }

    class TERefreshTimerTask
    extends TimerTask {
        TERefreshTimerTask() {
        }

        @Override
        public void run() {
            TEOTDRGraphCurrTestView.this.refreshTypeHandler();
            TEOTDRGraphCurrTestView.this.refreshFileHandler();
        }
    }
}

