/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.app;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMgrView;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEOTDRDomCommUtil;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowErrors;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.RowParams;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.TEOTDRAllError;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmScreenToolKit;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultStruct;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.InmOperResultVector;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.operResult.TEOperationShowMessage;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphFileTreeIntegerface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TEOTDRGraphBaseLineMgrView
extends TEOTDRGraphMgrView {
    private static final long serialVersionUID = 1L;
    private InmButton setAsBLBtn = null;
    private InmButton deleteBLBtn = null;
    private InmButton printBtn = null;
    private InmButton exportBLBtn = null;
    private InmButton importBLBtn = null;
    private InmButton displayBLBtn = null;
    private InmButton uploadBLBtn = null;
    private static final FileFilter OUTSVR_FILE_TYPE_FILTER = new FileNameExtensionFilter("*.sor", "sor");
    private static final FileFilter INSVR_FILE_TYPE_FILTER = new FileNameExtensionFilter("*.g", "g");
    private static final String BASELINE = "baseline";

    public TEOTDRGraphBaseLineMgrView(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        super(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil);
    }

    @Override
    protected void disableAllBtn() {
        this.setAsBLBtn.setEnabled(false);
        this.deleteBLBtn.setEnabled(false);
        this.printBtn.setEnabled(false);
        this.exportBLBtn.setEnabled(false);
        this.importBLBtn.setEnabled(false);
        this.displayBLBtn.setEnabled(false);
        this.uploadBLBtn.setEnabled(false);
    }

    @Override
    protected Map<String, Integer> getBtn2CmdMap() {
        HashMap<String, Integer> rightMap = new HashMap<String, Integer>();
        rightMap.put(this.setAsBLBtn.getName(), 2556004);
        rightMap.put(this.deleteBLBtn.getName(), 2556006);
        rightMap.put(this.exportBLBtn.getName(), 2172398);
        rightMap.put(this.importBLBtn.getName(), 2172397);
        rightMap.put(this.displayBLBtn.getName(), 2556007);
        rightMap.put(this.uploadBLBtn.getName(), 2556005);
        return rightMap;
    }

    @Override
    protected Component getBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.add(this.deleteBLBtn);
        btnPanel.add(this.uploadBLBtn);
        btnPanel.add(this.displayBLBtn);
        btnPanel.add(this.setAsBLBtn);
        btnPanel.add(this.importBLBtn);
        btnPanel.add(this.exportBLBtn);
        btnPanel.add(this.printBtn);
        return btnPanel;
    }

    protected void doUploadBaseLine() {
        String confirmStr = "dangeroperation";
        if (0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString(confirmStr))) {
            return;
        }
        this.disableAllBtn();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createUploadBaseLineReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processUploadBaseLineRsp(rsp);
        this.refreshBtnStatus();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private void processUploadBaseLineRsp(Datainterface rsp) {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        String blName = finf.getBaseLineFileName();
        finf.closeGraphFromFileTree(blName);
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        boolean need2Del = false;
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                StringBuilder sb = null;
                for (RowErrors row : rowErrows) {
                    if ("42793".equals(row.getErrorMessage().getErrorcode())) {
                        need2Del = true;
                    }
                    sb = new StringBuilder();
                    operStruct = new InmOperResultStruct();
                    String neName = row.getParam("nename").getValue();
                    String indexID = row.getParam("indexID").getValue();
                    sb.append(neName).append("-").append(this.getString("linestr")).append(indexID);
                    operStruct.operObj = sb.toString();
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else if (operVector.size() == rsp.getDataRowLength()) {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            if (!need2Del) {
                return;
            }
        }
        if (null != blName) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            fileNameList.add(blName);
            finf.deleteFile(fileNameList);
        }
        if (success) {
            String newBlName = rsp.getDataRowParamValue(0, "fileName");
            ArrayList<String> nameList = new ArrayList<String>();
            nameList.add(newBlName);
            finf.addFileToTree(nameList);
            TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
        }
    }

    private OperationData createUploadBaseLineReq() {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", String.valueOf(2556005));
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        RowParams rowParams = new RowParams();
        rowParams.addParam("neID", String.valueOf(this.getNeID()));
        rowParams.addParam("indexID", String.valueOf(this.getIndexID()));
        rowParams.addParam("testMode", String.valueOf(this.getTestMode()));
        req.addXMLRowParams(rowParams);
        return req;
    }

    protected void doDisplayBaseLine() {
        this.disableAllBtn();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createDisplayBaseLineReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processDisplayBaseLineRsp(rsp);
        this.refreshBtnStatus();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private void processDisplayBaseLineRsp(Datainterface rsp) {
        TEOTDRGraphFileTreeIntegerface finf;
        String oldBlName;
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                StringBuilder sb = null;
                for (RowErrors row : rowErrows) {
                    sb = new StringBuilder();
                    operStruct = new InmOperResultStruct();
                    String neName = row.getParam("nename").getValue();
                    String indexID = row.getParam("indexID").getValue();
                    sb.append(neName).append("-").append(this.getString("linestr")).append(indexID);
                    operStruct.operObj = sb.toString();
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else if (operVector.size() == rsp.getDataRowLength()) {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            return;
        }
        String blFileName = rsp.getDataRowParamValue(0, "fileName");
        if (!blFileName.equals(oldBlName = (finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor()).getBaseLineFileName())) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            fileNameList.add(oldBlName);
            finf.deleteFile(fileNameList);
            fileNameList.clear();
            fileNameList.add(blFileName);
            finf.addFileToTree(fileNameList);
        }
        finf.openFileFromTree(blFileName);
    }

    private OperationData createDisplayBaseLineReq() {
        OperationData req = new OperationData();
        req.setServletName("showBaseLine");
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        req.addURLParam("indexID", String.valueOf(this.getIndexID()));
        req.addURLParam("testMode", String.valueOf(this.getTestMode()));
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportBaseLine() {
        String confirmStr = "dangeroperation";
        if (0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString(confirmStr))) {
            return;
        }
        JFileChooser jc = new JFileChooser();
        jc.setFileSelectionMode(0);
        jc.setFileFilter(this.getFileFilterByTestMode(this.getTestMode()));
        int result = jc.showOpenDialog(this);
        if (0 != result) {
            return;
        }
        File selFile = jc.getSelectedFile();
        if (selFile == null) {
            return;
        }
        if (!this.checkImportFileName(selFile)) {
            return;
        }
        String boundary = "---------------------------7d12ed2e2001cc";
        String theCGI = null;
        StringBuilder sb = new StringBuilder();
        sb.append(TECommonUtil.getServerPath()).append("importBaseLine?");
        sb.append("neID=").append(this.getNeID()).append("&");
        sb.append("indexID=").append(this.getIndexID()).append("&");
        sb.append("testMode=").append(this.getTestMode()).append("&");
        sb.append("lmiNEID=").append(this.getLmiNEID()).append("&");
        sb.append("lmiSlotID=").append(this.getLmiSlotID()).append("&");
        sb.append("lmiPortID=").append(this.getLmiPortID()).append("&");
        sb.append("fileName=").append("uploadfile");
        theCGI = sb.toString();
        StringBuilder header = new StringBuilder();
        header.append("--").append(boundary).append("\r\n");
        header.append("Content-DisposITion:   form-data;   name=\"FILE1\";   filename=");
        header.append("uploadfile").append("\r\n");
        header.append("Content-Type:   application/octet-stream\r\n\r\n");
        String headerStr = header.toString();
        String endStr = "\r\n--" + boundary + "--\r\n";
        byte[] headerByte = headerStr.getBytes();
        byte[] endByte = endStr.getBytes();
        FilterOutputStream out = null;
        try {
            InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
            FileInputStream fin = new FileInputStream(selFile);
            byte[] fileByte = new byte[fin.available()];
            if (fin.read(fileByte) == -1) {
                this.log("TEOTDRGraphBaseLineMgrView.doImportBaseLine(): no content read!", new FileNotFoundException());
            }
            fin.close();
            byte[] allByte = new byte[headerByte.length + fileByte.length + endByte.length];
            System.arraycopy(headerByte, 0, allByte, 0, headerByte.length);
            System.arraycopy(fileByte, 0, allByte, headerByte.length, fileByte.length);
            System.arraycopy(endByte, 0, allByte, headerByte.length + fileByte.length, endByte.length);
            URL CGIurl = null;
            CGIurl = new URL(theCGI);
            URLConnection c = CGIurl.openConnection();
            c.setDoOutput(true);
            c.setUseCaches(false);
            c.setRequestProperty("content-type", "multipart/form-data;   boundary=" + boundary);
            out = new DataOutputStream(c.getOutputStream());
            out.write(allByte);
            ((DataOutputStream)out).flush();
            Document doc = null;
            Datainterface outputData = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(c.getInputStream());
            outputData = TEOTDRDomCommUtil.encapsulateData(doc);
            boolean success = "0".equals(outputData.getErrorMessage().getErrorcode());
            if (success) {
                String fileName = outputData.getDataRowParamValue(0, "fileName");
                TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
                String blName = finf.getBaseLineFileName();
                ArrayList<String> fileNameList = new ArrayList<String>();
                if (null != blName) {
                    fileNameList.add(blName);
                    finf.deleteFile(fileNameList);
                }
                fileNameList.clear();
                fileNameList.add(fileName);
                finf.addFileToTree(fileNameList);
            }
            InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
            TEOperationShowMessage.showOperationDlg((Component)this, outputData.getErrorMessage().getErrorinfo(), true);
        }
        catch (Exception e1) {
            InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), true);
            this.log("TEOTDRGraphBaseLineMgrView.doImportBaseLine() fail!", e1);
            return;
        }
        catch (Error er) {
            InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
            TEOperationShowMessage.showOperationDlg((Component)this, er.toString(), true);
            this.log("TEOTDRGraphBaseLineMgrView.doImportBaseLine() fail!", er);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.log("TEOTDRGraphBaseLineMgrView.doImportBaseLine() fail!", e);
                }
            }
        }
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private boolean checkImportFileName(File selFile) {
        String fileName = selFile.getName();
        String[] fileStrut = fileName.split("_");
        if (fileStrut.length <= 2) {
            return true;
        }
        if (!this.getNeName().equals(fileStrut[0]) && 0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString("nenameDifferences"))) {
            return false;
        }
        return this.getIndexID() == Integer.parseInt(fileStrut[1]) || 0 == InmOptionPane.showConfirmDialog(this, (Object)this.getString("lineidDifferences"));
    }

    private FileFilter getFileFilterByTestMode(int testMode) {
        return OUTSVR_FILE_TYPE_FILTER;
    }

    protected void doExportBaseLine() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> selFileList = finf.getCurrentSelectedFileList();
        if (null == selFileList || selFileList.size() != 1) {
            InmOptionPane.showMessageDialog(this, this.getString("selectonefile"));
            return;
        }
        String fileName = selFileList.get(0);
        this.disableAllBtn();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createExportBaseLineReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processExportBaseLineRsp(rsp, fileName);
        this.refreshBtnStatus();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private void processExportBaseLineRsp(Datainterface rsp, String fileRealName) {
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                StringBuilder sb = null;
                for (RowErrors row : rowErrows) {
                    sb = new StringBuilder();
                    operStruct = new InmOperResultStruct();
                    String neName = row.getParam("nename").getValue();
                    String indexID = row.getParam("indexID").getValue();
                    sb.append(neName).append("-").append(this.getString("linestr")).append(indexID);
                    operStruct.operObj = sb.toString();
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else if (operVector.size() == rsp.getDataRowLength()) {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            return;
        }
        String blUrl = rsp.getDataRowParamValue(0, "blURL");
        blUrl = TECommonUtil.getServerPath() + blUrl;
        try {
            URL fileUrl = new URL(blUrl);
            URLConnection uc = fileUrl.openConnection();
            uc.setDoInput(true);
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            int b = -1;
            while ((b = in.read()) != -1) {
                bo.write(b);
            }
            in.close();
            StringBuffer saveName = new StringBuffer(this.getNeName());
            saveName.append("_");
            saveName.append(fileRealName.substring(0, fileRealName.indexOf("_")));
            saveName.append("_");
            if (fileRealName.indexOf(BASELINE) > -1) {
                saveName.append(fileRealName.substring(fileRealName.lastIndexOf("_", fileRealName.lastIndexOf(BASELINE) - BASELINE.length() - 1) + 1));
            } else {
                saveName.append(fileRealName.substring(fileRealName.lastIndexOf("_") + 1));
            }
            JFileChooser jf = new JFileChooser();
            jf.setDialogTitle(this.getString("savebltitle"));
            jf.setFileSelectionMode(0);
            jf.setAcceptAllFileFilterUsed(false);
            jf.addChoosableFileFilter(OUTSVR_FILE_TYPE_FILTER);
            jf.setSelectedFile(new File(saveName.toString()));
            int returnVal = jf.showSaveDialog(this);
            if (returnVal == 0) {
                File f = jf.getSelectedFile();
                if (null == f) {
                    return;
                }
                String fileName = f.getName();
                if (!this.isValidFileNameLength(fileName)) {
                    return;
                }
                fileName = this.getValidFileName(f.getAbsolutePath());
                File tempFile = new File(fileName);
                FileOutputStream fout = new FileOutputStream(tempFile);
                ByteBuffer bb = ByteBuffer.wrap(bo.toByteArray());
                fout.getChannel().write(bb);
                fout.flush();
                fout.close();
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operSucceeded"), true);
            }
        }
        catch (Exception e) {
            this.log("TEOTDRGraphBaseLineMgrView.processExportBaseLineRsp() fail!", e);
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), true);
            return;
        }
    }

    private boolean isValidFileNameLength(String fileName) {
        int fileNameLen = 64;
        if (fileName.length() > fileNameLen) {
            TEOperationShowMessage.showOperationDlg((Component)this, this.getString("IDS_InputFileNameLength"), true);
            return false;
        }
        return true;
    }

    private String getValidFileName(String fileName) {
        int pointIndex = fileName.lastIndexOf(".");
        String extendedName = "sor";
        StringBuffer buf = new StringBuffer();
        if (0 > pointIndex) {
            fileName = buf.append(fileName).append(".").append(extendedName).toString();
        } else if (fileName.length() - 1 == pointIndex) {
            fileName = fileName + extendedName;
        } else {
            String inputExtendedName = fileName.substring(pointIndex + 1).toLowerCase();
            boolean flag = false;
            if (inputExtendedName.equals(extendedName)) {
                flag = true;
            }
            if (!flag) {
                fileName = buf.append(fileName).append(".").append(extendedName).toString();
            }
        }
        return fileName;
    }

    private OperationData createExportBaseLineReq() {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", String.valueOf(20080809));
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        RowParams row = new RowParams();
        row.addParam("neID", String.valueOf(this.getNeID()));
        row.addParam("indexID", String.valueOf(this.getIndexID()));
        row.addParam("testMode", String.valueOf(this.getTestMode()));
        req.addXMLRowParams(row);
        return req;
    }

    protected void doDeleteBaseLine() {
        String confirmStr = "dangeroperation";
        if (0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString(confirmStr))) {
            return;
        }
        this.disableAllBtn();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createDeleteBaseLineReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processDeleteBaseLineRsp(rsp);
        this.refreshBtnStatus();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private void processDeleteBaseLineRsp(Datainterface rsp) {
        TEOTDRGraphFileTreeIntegerface finf;
        String blName;
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        boolean need2Del = false;
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                StringBuilder sb = null;
                for (RowErrors row : rowErrows) {
                    if ("42793".equals(row.getErrorMessage().getErrorcode())) {
                        need2Del = true;
                    }
                    sb = new StringBuilder();
                    operStruct = new InmOperResultStruct();
                    String neName = row.getParam("nename").getValue();
                    String indexID = row.getParam("indexID").getValue();
                    sb.append(neName).append("-").append(this.getString("linestr")).append(indexID);
                    operStruct.operObj = sb.toString();
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else if (operVector.size() == rsp.getDataRowLength()) {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            if (!need2Del) {
                return;
            }
        }
        if (null != (blName = (finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor()).getBaseLineFileName())) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            fileNameList.add(blName);
            finf.deleteFile(fileNameList);
        }
        if (success) {
            TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
        }
    }

    private OperationData createDeleteBaseLineReq() {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", String.valueOf(2556006));
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        RowParams rowParams = new RowParams();
        rowParams.addParam("neID", String.valueOf(this.getNeID()));
        rowParams.addParam("indexID", String.valueOf(this.getIndexID()));
        rowParams.addParam("testMode", String.valueOf(this.getTestMode()));
        req.addXMLRowParams(rowParams);
        return req;
    }

    protected void doSetAsBaseLine() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> selFileList = finf.getCurrentSelectedFileList();
        if (null == selFileList || selFileList.size() != 1) {
            InmOptionPane.showMessageDialog(this, this.getString("selectonefile"));
            return;
        }
        String confirmStr = "dangeroperation";
        if (0 != InmOptionPane.showConfirmDialog(this, (Object)this.getString(confirmStr))) {
            return;
        }
        this.disableAllBtn();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), true);
        OperationData req = this.createSetAsBaseLineReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processSetAsBaseLineRsp(rsp);
        this.refreshBtnStatus();
        InmScreenToolKit.setComponentCursorBusy(this.teCommonUtil.getRootPaneContainer(this), false);
    }

    private void processSetAsBaseLineRsp(Datainterface rsp) {
        boolean success = "0".equals(rsp.getErrorMessage().getErrorcode());
        if (!success) {
            InmOperResultVector operVector = null;
            InmOperResultStruct operStruct = null;
            TEOTDRAllError allError = rsp.getAllError();
            if (null != allError) {
                operVector = new InmOperResultVector();
                ArrayList<RowErrors> rowErrows = allError.getRowErrors();
                StringBuilder sb = null;
                for (RowErrors row : rowErrows) {
                    sb = new StringBuilder();
                    operStruct = new InmOperResultStruct();
                    String neName = row.getParam("nename").getValue();
                    String indexID = row.getParam("indexID").getValue();
                    sb.append(neName).append("-").append(this.getString("linestr")).append(indexID);
                    operStruct.operObj = sb.toString();
                    operStruct.operResult = this.getString("operfailed");
                    operStruct.operReason = row.getErrorMessage().getErrorinfo() + this.getString("errorcodestr") + row.getErrorMessage().getErrorcode();
                    operVector.add(operStruct);
                }
            }
            if (null == operVector || operVector.isEmpty()) {
                TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
            } else if (operVector.size() == rsp.getDataRowLength()) {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operfailed"), operVector, true);
            } else {
                TEOperationShowMessage.showOperationDlg((Component)this, this.getString("operPartSucceeded"), operVector, true);
            }
            return;
        }
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        String blName = finf.getBaseLineFileName();
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (null != blName) {
            fileNameList.add(blName);
            finf.deleteFile(fileNameList);
        }
        String newBlName = rsp.getDataRowParamValue(0, "newBaseLineFileName");
        fileNameList.clear();
        fileNameList.add(newBlName);
        finf.addFileToTree(fileNameList);
        if (success) {
            TEOperationShowMessage.showOperationDlg((Component)this, rsp.getErrorMessage().getErrorinfo(), true);
        }
    }

    private OperationData createSetAsBaseLineReq() {
        OperationData req = new OperationData();
        req.setServletName("neExlorerServlet");
        req.addURLParam("sfid", String.valueOf(2556004));
        req.addURLParam("neID", String.valueOf(this.getNeID()));
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        RowParams rowParams = new RowParams();
        rowParams.addParam("neID", String.valueOf(this.getNeID()));
        rowParams.addParam("indexID", String.valueOf(this.getIndexID()));
        rowParams.addParam("testMode", String.valueOf(this.getTestMode()));
        rowParams.addParam("lmiNEID", String.valueOf(this.getLmiNEID()));
        rowParams.addParam("lmiSlotID", String.valueOf(this.getLmiSlotID()));
        rowParams.addParam("lmiPortID", String.valueOf(this.getLmiPortID()));
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> selFileList = finf.getCurrentSelectedFileList();
        String fileName = selFileList.get(0);
        rowParams.addParam("nmFileName", this.teCommonUtil.getParamFromFileName(fileName, "showName", false));
        rowParams.addParam("fileName", fileName);
        req.addXMLRowParams(rowParams);
        return req;
    }

    @Override
    protected void refreshBtnStatus() {
        TEOTDRGraphFileTreeIntegerface finf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        List<String> selFileList = null;
        String blName = null;
        if (null != finf) {
            selFileList = finf.getCurrentSelectedFileList();
            blName = finf.getBaseLineFileName();
        }
        boolean onyOneFileSelected = selFileList != null && selFileList.size() == 1;
        TEOTDRGraphGraphInterface ginf = this.teOTDRGraphModuleMgr.getGraphInteractor();
        List<String> openedFileNameList = null;
        if (null != ginf) {
            openedFileNameList = ginf.getOpenedFileNameList();
        }
        boolean hasGraphOpened = openedFileNameList != null && !openedFileNameList.isEmpty();
        boolean isBaseLineSelected = onyOneFileSelected && selFileList.get(0).indexOf(BASELINE) != -1;
        this.setAsBLBtn.setEnabled(!isBaseLineSelected && this.hasOperationRight(this.setAsBLBtn.getName()) && onyOneFileSelected);
        this.deleteBLBtn.setEnabled(this.hasOperationRight(this.deleteBLBtn.getName()) && null != blName);
        this.printBtn.setEnabled(hasGraphOpened);
        this.exportBLBtn.setEnabled(this.hasOperationRight(this.exportBLBtn.getName()));
        this.importBLBtn.setEnabled(this.hasOperationRight(this.importBLBtn.getName()));
        boolean isBlShowing = openedFileNameList != null && openedFileNameList.contains(blName);
        this.displayBLBtn.setEnabled(this.hasOperationRight(this.displayBLBtn.getName()) && null != blName && !isBlShowing);
        this.uploadBLBtn.setEnabled(this.hasOperationRight(this.uploadBLBtn.getName()));
    }

    @Override
    protected void initBtn() {
        this.setAsBLBtn = new InmButton();
        this.setAsBLBtn.setName("setasbaselinebtnid");
        this.setAsBLBtn.setText(this.getString(this.setAsBLBtn.getName()));
        this.setAsBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphBaseLineMgrView.this.doSetAsBaseLine();
            }
        });
        this.deleteBLBtn = new InmButton();
        this.deleteBLBtn.setName("deletebaselinebtnid");
        this.deleteBLBtn.setText(this.getString(this.deleteBLBtn.getName()));
        this.deleteBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRGraphBaseLineMgrView.this.doDeleteBaseLine();
            }
        });
        this.printBtn = new InmButton();
        this.printBtn.setName("printbtnid");
        this.printBtn.setText(this.getString(this.printBtn.getName()));
        this.printBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphBaseLineMgrView.this.doPrint();
            }
        });
        this.exportBLBtn = new InmButton();
        this.exportBLBtn.setName("exportbaselinebtnid");
        this.exportBLBtn.setText(this.getString(this.exportBLBtn.getName()));
        this.exportBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphBaseLineMgrView.this.doExportBaseLine();
            }
        });
        this.importBLBtn = new InmButton();
        this.importBLBtn.setName("importbaselinebtnid");
        this.importBLBtn.setText(this.getString(this.importBLBtn.getName()));
        this.importBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphBaseLineMgrView.this.doImportBaseLine();
            }
        });
        this.displayBLBtn = new InmButton();
        this.displayBLBtn.setName("displaybaselinebtnid");
        this.displayBLBtn.setText(this.getString(this.displayBLBtn.getName()));
        this.displayBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphBaseLineMgrView.this.doDisplayBaseLine();
            }
        });
        this.uploadBLBtn = new InmButton();
        this.uploadBLBtn.setName("uploadbaselinebtnid");
        this.uploadBLBtn.setText(this.getString(this.uploadBLBtn.getName()));
        this.uploadBLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TEOTDRGraphBaseLineMgrView.this.doUploadBaseLine();
            }
        });
    }

    @Override
    public void destroy() {
    }

    private void log(String info, Throwable e) {
        System.out.println(info);
        e.printStackTrace();
    }
}

