/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.otdr.TESLMConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class TESLMOTDRXMLUtil {
    private static final String UTF_8_TYPE = "utf-8";
    private static final String XMLFILDSUFFIX = ".xml";
    private static final int REPEATORGAIN_INDEX = 1;
    private static final int REPEATORID_INDEX = 0;
    private static final int NULL_VALUE = -1;
    private static final String REPEATOR_ATTRNAME = "repeator";
    private static final String FILE_ATTRNAME = "file";
    private static final String ISCOMPLETE_ATTRNAME = "isComplete";
    private static final String ISTMP_ATTRNAME = "isTmp";
    private static final String ISSAVED_ATTRNAME = "isSaved";
    private static final String ISBASELINE_ATTRNAME = "isBaseLine";
    private static final String FILENAME_ATTRNAME = "fileName";
    private static final String NEIDSTR_ATTRNAME = "neID";
    private static final String INDEXIDSTR_ATTRNAME = "indexID";
    private static final String TESTTYPE_ATTRNAME = "testType";
    private static final String REPEATORIDSTR_ATTRNAME = "repeatorID";
    private static final String DATESTR_ATTRNAME = "date";
    private static final String GAINSTR_ATTRNAME = "gain";
    private static final String VALUESTR_ATTRNAME = "value";

    private TESLMOTDRXMLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNETestRecordFile(String absFilePath) {
        File f = new File(absFilePath);
        if (!f.exists()) {
            BufferedWriter writer = null;
            try {
                try {
                    f.createNewFile();
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().info("", (Throwable)e);
                }
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8_TYPE));
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fileList></fileList>");
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().info("", (Throwable)e);
            }
            finally {
                if (null != writer) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        TELogFactory.getNormalLogger().info("", (Throwable)e);
                    }
                }
            }
        }
    }

    static void refreshTestRecordFileProperty(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        String absFileName = TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID + File.separator + neID + "_" + indexID + XMLFILDSUFFIX;
        TESLMOTDRXMLUtil.mkdirNEFile(TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID);
        TESLMOTDRXMLUtil.createNETestRecordFile(absFileName);
        Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
        if (null == doc) {
            return;
        }
        Element file = TESLMOTDRXMLUtil.findFileNodeByFileName(neID, doc, fileName);
        if (null == file) {
            return;
        }
        TESLMOTDRXMLUtil.refreshTestRecordFileProperty(neID, indexID, testType, fileName, file, isBaseLine, isSaved, isTmp, isComplete);
        doc.normalize();
        TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
    }

    private static void refreshTestRecordFileProperty(int neID, int indexID, int testType, String fileName, Element file, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        file.setAttribute(FILENAME_ATTRNAME, fileName);
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(NEIDSTR_ATTRNAME, String.valueOf(neID));
        attrMap.put(INDEXIDSTR_ATTRNAME, String.valueOf(indexID));
        attrMap.put(TESTTYPE_ATTRNAME, String.valueOf(testType));
        attrMap.put(ISCOMPLETE_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isComplete)));
        attrMap.put(ISTMP_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isTmp)));
        attrMap.put(ISBASELINE_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isBaseLine)));
        attrMap.put(ISSAVED_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isSaved)));
        attrMap.put(ISCOMPLETE_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isComplete)));
        NodeList childNodeList = file.getChildNodes();
        Node childNode = null;
        int ksize = childNodeList.getLength();
        for (int k = 0; k < ksize; ++k) {
            childNode = childNodeList.item(k);
            if (1 != childNode.getNodeType()) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getNodeName();
            childElement.setAttribute(VALUESTR_ATTRNAME, String.valueOf(attrMap.get(nodeName)));
        }
    }

    private static void addTestRecordFileNameNode(int neID, int indexID, int testType, String fileName, Document doc, Element fileEle, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        fileEle.setAttribute(FILENAME_ATTRNAME, fileName);
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(NEIDSTR_ATTRNAME, String.valueOf(neID));
        attrMap.put(INDEXIDSTR_ATTRNAME, String.valueOf(indexID));
        attrMap.put(TESTTYPE_ATTRNAME, String.valueOf(testType));
        attrMap.put(ISCOMPLETE_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isComplete)));
        attrMap.put(ISTMP_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isTmp)));
        attrMap.put(ISBASELINE_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isBaseLine)));
        attrMap.put(ISSAVED_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isSaved)));
        attrMap.put(ISCOMPLETE_ATTRNAME, String.valueOf(TESLMOTDRXMLUtil.boolToInt(isComplete)));
        DocumentFragment docfrag = doc.createDocumentFragment();
        Element element = null;
        Set entrySet = attrMap.entrySet();
        Map.Entry entry2 = null;
        String nodeName = null;
        String attrValue = null;
        for (Map.Entry entry2 : entrySet) {
            nodeName = (String)entry2.getKey();
            attrValue = (String)entry2.getValue();
            element = doc.createElement(nodeName);
            element.setAttribute(VALUESTR_ATTRNAME, attrValue);
            docfrag.appendChild(element);
        }
        fileEle.appendChild(docfrag);
        doc.getDocumentElement().appendChild(fileEle);
    }

    private static int boolToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    private static List<Element> findFileNodeByFileName(int neID, Document doc, List<String> deletingFileList) {
        ArrayList<Element> fileEleList = new ArrayList<Element>();
        Node fileChildNode = null;
        Element fileChildElement = null;
        String fileName = null;
        NodeList fileNodeList = doc.getDocumentElement().getChildNodes();
        int isize = fileNodeList.getLength();
        block0: for (int i = 0; i < isize; ++i) {
            fileChildNode = fileNodeList.item(i);
            if (1 != fileChildNode.getNodeType() || !deletingFileList.contains(fileName = (fileChildElement = (Element)fileChildNode).getAttribute(FILENAME_ATTRNAME))) continue;
            NodeList childNodeList = fileChildElement.getChildNodes();
            Node childNode = null;
            int ksize = childNodeList.getLength();
            for (int k = 0; k < ksize; ++k) {
                String value;
                Element childElement;
                String nodeName;
                childNode = childNodeList.item(k);
                if (1 != childNode.getNodeType() || !NEIDSTR_ATTRNAME.equals(nodeName = (childElement = (Element)childNode).getNodeName()) || neID != Integer.parseInt(value = childElement.getAttribute(VALUESTR_ATTRNAME))) continue;
                fileEleList.add(fileChildElement);
                continue block0;
            }
        }
        return fileEleList;
    }

    private static Element findFileNodeByFileName(int neID, Document doc, String fileName) {
        Node fileChildNode = null;
        Element fileChildElement = null;
        String elementFileName = null;
        NodeList fileNodeList = doc.getDocumentElement().getChildNodes();
        int isize = fileNodeList.getLength();
        for (int i = 0; i < isize; ++i) {
            fileChildNode = fileNodeList.item(i);
            if (1 != fileChildNode.getNodeType() || !fileName.equals(elementFileName = (fileChildElement = (Element)fileChildNode).getAttribute(FILENAME_ATTRNAME))) continue;
            NodeList childNodeList = fileChildElement.getChildNodes();
            Node childNode = null;
            int ksize = childNodeList.getLength();
            for (int k = 0; k < ksize; ++k) {
                String value;
                Element childElement;
                String nodeName;
                childNode = childNodeList.item(k);
                if (1 != childNode.getNodeType() || !NEIDSTR_ATTRNAME.equals(nodeName = (childElement = (Element)childNode).getNodeName()) || neID != Integer.parseInt(value = childElement.getAttribute(VALUESTR_ATTRNAME))) continue;
                return fileChildElement;
            }
        }
        return null;
    }

    static void addTestRecordFileNameNode(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        String absFileName = TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID + File.separator + neID + "_" + indexID + XMLFILDSUFFIX;
        TESLMOTDRXMLUtil.mkdirNEFile(TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID);
        TESLMOTDRXMLUtil.createNETestRecordFile(absFileName);
        Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
        if (null == doc) {
            return;
        }
        Element file = TESLMOTDRXMLUtil.findFileNodeByFileName(neID, doc, fileName);
        if (null == file) {
            file = doc.createElement(FILE_ATTRNAME);
            TESLMOTDRXMLUtil.addTestRecordFileNameNode(neID, indexID, testType, fileName, doc, file, isBaseLine, isSaved, isTmp, isComplete);
        } else {
            TESLMOTDRXMLUtil.refreshTestRecordFileProperty(neID, indexID, testType, fileName, file, isBaseLine, isSaved, isTmp, isComplete);
        }
        doc.normalize();
        TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
    }

    private static void mkdirNEFile(String path) {
        File fileDir = new File(path);
        if (!fileDir.exists()) {
            try {
                if (!fileDir.mkdirs()) {
                    TELogFactory.getNormalLogger().info("fail to create directory----path -> " + path);
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info("", (Throwable)e);
            }
        }
    }

    private static boolean writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            String realFilePath = "";
            realFilePath = filename;
            File file = new File(realFilePath);
            StreamResult result = new StreamResult(file);
            if (!file.canWrite()) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().info("", (Throwable)e);
                }
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return true;
        }
        catch (TransformerConfigurationException e) {
            return false;
        }
        catch (TransformerException e) {
            return false;
        }
    }

    static Document parseFile(String filepath) {
        try {
            File file = new File(filepath);
            return TESLMOTDRXMLUtil.parseFile(file);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRXMLUtil.parseFile() fail!---" + filepath, (Throwable)e);
            return null;
        }
    }

    private static Document parseFile(File file) {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRXMLUtil.parseFile() fail!", (Throwable)e);
            return null;
        }
        return doc;
    }

    static void deleteTestRecordFromFile(int neID, int indexID, String fileName) {
        String absFileName = TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID + File.separator + neID + "_" + indexID + XMLFILDSUFFIX;
        TESLMOTDRXMLUtil.mkdirNEFile(TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID);
        TESLMOTDRXMLUtil.createNETestRecordFile(absFileName);
        try {
            Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
            if (null == doc) {
                return;
            }
            Element file = TESLMOTDRXMLUtil.findFileNodeByFileName(neID, doc, fileName);
            if (null != file) {
                doc.getDocumentElement().removeChild(file);
                doc.normalize();
                TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
                return;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRXMLUtil.deleteTestRecordFromFile() fail!", (Throwable)e);
        }
    }

    static void deleteTestRecordFromFile(int neID, List<String> deletingFileList) {
        String absFileName = TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH + neID;
        File dir = new File(absFileName);
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] fs;
            for (File oneFile : fs = dir.listFiles()) {
                if (!oneFile.isFile()) continue;
                TESLMOTDRXMLUtil.deleteTestRecordFromFile(neID, oneFile, deletingFileList);
            }
        }
    }

    static void deleteTestRecordFromFile(int neID, File xmlfile, List<String> deletingFileList) {
        String absFileName = xmlfile.getAbsolutePath();
        TESLMOTDRXMLUtil.mkdirNEFile(xmlfile.getParent());
        TESLMOTDRXMLUtil.createNETestRecordFile(absFileName);
        try {
            Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
            if (null == doc) {
                return;
            }
            List<Element> fileList = TESLMOTDRXMLUtil.findFileNodeByFileName(neID, doc, deletingFileList);
            if (!fileList.isEmpty()) {
                Element file2 = null;
                for (Element file2 : fileList) {
                    doc.getDocumentElement().removeChild(file2);
                }
                doc.normalize();
                TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRXMLUtil.deleteTestRecordFromFile() fail!", (Throwable)e);
        }
    }

    static void writeRepeatorInfoToFile(int neID, int indexID, int repeatorID, String date, String gain) {
        String absFileName = TESLMConstants.REPEATORRECORD_ABSTRACT_FILEPATH;
        Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
        if (null == doc) {
            return;
        }
        Node repeatorChildNode = null;
        Element repeatorChildElement = null;
        NodeList childNodeList = null;
        Node childNode = null;
        HashMap<String, String> atrrMap = null;
        Element childElement = null;
        String nodeName = null;
        String nodeValue = null;
        NodeList repeatorNodeList = doc.getDocumentElement().getChildNodes();
        int isize = repeatorNodeList.getLength();
        for (int i = 0; i < isize; ++i) {
            repeatorChildNode = repeatorNodeList.item(i);
            if (repeatorChildNode.getNodeType() != 1) continue;
            repeatorChildElement = (Element)repeatorChildNode;
            childNodeList = repeatorChildElement.getChildNodes();
            atrrMap = new HashMap<String, String>();
            int ksize = childNodeList.getLength();
            for (int k = 0; k < ksize; ++k) {
                childNode = childNodeList.item(k);
                if (1 != childNode.getNodeType()) continue;
                childElement = (Element)childNode;
                nodeName = childElement.getNodeName();
                nodeValue = childElement.getAttribute(VALUESTR_ATTRNAME);
                atrrMap.put(nodeName, nodeValue);
            }
            int neIDTmp = Integer.parseInt((String)atrrMap.get(NEIDSTR_ATTRNAME));
            int indexIDTmp = Integer.parseInt((String)atrrMap.get(INDEXIDSTR_ATTRNAME));
            int repeatorIDTmp = Integer.parseInt((String)atrrMap.get(REPEATORIDSTR_ATTRNAME));
            String dateTmp = (String)atrrMap.get(DATESTR_ATTRNAME);
            boolean neIDEqu = neID == neIDTmp;
            boolean indexIDEqu = indexID == indexIDTmp;
            boolean repeatorIDEqu = repeatorID == repeatorIDTmp;
            boolean dateEqu = date.equals(dateTmp);
            if (!neIDEqu || !indexIDEqu || !repeatorIDEqu || !dateEqu) continue;
            return;
        }
        Element repeatorElement = doc.createElement(REPEATOR_ATTRNAME);
        DocumentFragment docfrag = doc.createDocumentFragment();
        Element element = null;
        element = doc.createElement(NEIDSTR_ATTRNAME);
        element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(neID));
        docfrag.appendChild(element);
        element = doc.createElement(INDEXIDSTR_ATTRNAME);
        element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(indexID));
        docfrag.appendChild(element);
        element = doc.createElement(REPEATORIDSTR_ATTRNAME);
        element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(repeatorID));
        docfrag.appendChild(element);
        element = doc.createElement(DATESTR_ATTRNAME);
        element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(date));
        docfrag.appendChild(element);
        element = doc.createElement(GAINSTR_ATTRNAME);
        element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(gain));
        docfrag.appendChild(element);
        repeatorElement.appendChild(docfrag);
        doc.getDocumentElement().appendChild(repeatorElement);
        doc.normalize();
        TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
    }

    static void writeRepeatorInfoToFile(int neID, int indexID, String fileName, Object repeatorContent, String date) {
        String absFileName = TESLMConstants.REPEATORRECORD_ABSTRACT_FILEPATH;
        Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
        if (null == doc) {
            return;
        }
        Object[][] repeatorArray = (Object[][])repeatorContent;
        String repeatorIDStr = null;
        int repeatorID = -1;
        String repeatorGain = null;
        Element repeatorElement = null;
        DocumentFragment docfrag = null;
        Element element = null;
        for (int i = 0; i < repeatorArray.length; ++i) {
            Object[] repeatorInfo = repeatorArray[i];
            repeatorIDStr = repeatorInfo[0].toString();
            repeatorID = Integer.parseInt(repeatorIDStr);
            if (!TESLMOTDRXMLUtil.findRepeatorInfoInFile(doc, neID, indexID, repeatorID, date).isEmpty()) continue;
            repeatorGain = repeatorInfo[1].toString();
            repeatorElement = doc.createElement(REPEATOR_ATTRNAME);
            docfrag = doc.createDocumentFragment();
            element = doc.createElement(NEIDSTR_ATTRNAME);
            element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(neID));
            docfrag.appendChild(element);
            element = doc.createElement(INDEXIDSTR_ATTRNAME);
            element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(indexID));
            docfrag.appendChild(element);
            element = doc.createElement(REPEATORIDSTR_ATTRNAME);
            element.setAttribute(VALUESTR_ATTRNAME, repeatorIDStr);
            docfrag.appendChild(element);
            element = doc.createElement(DATESTR_ATTRNAME);
            element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(date));
            docfrag.appendChild(element);
            element = doc.createElement(GAINSTR_ATTRNAME);
            element.setAttribute(VALUESTR_ATTRNAME, String.valueOf(repeatorGain));
            docfrag.appendChild(element);
            repeatorElement.appendChild(docfrag);
            doc.getDocumentElement().appendChild(repeatorElement);
        }
        doc.normalize();
        TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
    }

    private static List<Element> findRepeatorInfoInFile(Document doc, int neID, int indexID, int repeatorID, String date) {
        ArrayList<Element> eleList = new ArrayList<Element>();
        Node repeatorChildNode = null;
        Element repeatorChildElement = null;
        NodeList childNodeList = null;
        HashMap<String, String> atrrMap = null;
        Node childNode = null;
        Element childElement = null;
        String nodeName = null;
        String nodeValue = null;
        NodeList repeatorNodeList = doc.getDocumentElement().getChildNodes();
        int isize = repeatorNodeList.getLength();
        for (int i = 0; i < isize; ++i) {
            boolean dateEqu;
            repeatorChildNode = repeatorNodeList.item(i);
            if (1 != repeatorChildNode.getNodeType()) continue;
            repeatorChildElement = (Element)repeatorChildNode;
            childNodeList = repeatorChildElement.getChildNodes();
            atrrMap = new HashMap<String, String>();
            int ksize = childNodeList.getLength();
            for (int k = 0; k < ksize; ++k) {
                childNode = childNodeList.item(k);
                if (1 != childNode.getNodeType()) continue;
                childElement = (Element)childNode;
                nodeName = childElement.getNodeName();
                nodeValue = childElement.getAttribute(VALUESTR_ATTRNAME);
                atrrMap.put(nodeName, nodeValue);
            }
            int neIDTmp = Integer.parseInt((String)atrrMap.get(NEIDSTR_ATTRNAME));
            int indexIDTmp = Integer.parseInt((String)atrrMap.get(INDEXIDSTR_ATTRNAME));
            int repeatorIDTmp = Integer.parseInt((String)atrrMap.get(REPEATORIDSTR_ATTRNAME));
            String dateTmp = (String)atrrMap.get(DATESTR_ATTRNAME);
            boolean neIDEqu = -1 == neID || neID == neIDTmp;
            boolean indexIDEqu = -1 == indexID || indexID == indexIDTmp;
            boolean repeatorIDEqu = -1 == repeatorID || repeatorID == repeatorIDTmp;
            boolean bl = dateEqu = null == date || date.equals(dateTmp);
            if (!neIDEqu || !indexIDEqu || !repeatorIDEqu || !dateEqu) continue;
            eleList.add(repeatorChildElement);
        }
        return eleList;
    }

    static void deleteRepeatorInfoFromFile(int neID, int indexID, String date) {
        String absFileName = TESLMConstants.REPEATORRECORD_ABSTRACT_FILEPATH;
        try {
            Document doc = TESLMOTDRXMLUtil.parseFile(absFileName);
            if (null == doc) {
                return;
            }
            List<Element> eleList = TESLMOTDRXMLUtil.findRepeatorInfoInFile(doc, neID, indexID, -1, date);
            if (!eleList.isEmpty()) {
                Element element2 = null;
                for (Element element2 : eleList) {
                    doc.getDocumentElement().removeChild(element2);
                }
                doc.normalize();
                TESLMOTDRXMLUtil.writeXmlFile(doc, absFileName);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRXMLUtil.deleteRepeatorInfoFromFile() fail!", (Throwable)e);
        }
    }
}

