/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TETimeParams;
import com.huawei.nglct.nelist.handler.TENEHandlerInf;
import com.huawei.nglct.nelist.handler.TENEHandlerMgr;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMSetHFCPStatusBean;
import com.huawei.nglct.otdr.TESLMConstants;
import com.huawei.nglct.otdr.TESLMFileDataMgr;
import com.huawei.nglct.otdr.TESLMFileTransferJniUtil;
import com.huawei.nglct.otdr.TESLMFileUtil;
import com.huawei.nglct.otdr.TESLMLineDataMgr;
import com.huawei.nglct.otdr.TESLMNoticeHandler;
import com.huawei.nglct.otdr.external.TEMarineTestStopNoticeMgr;
import com.huawei.nglct.otdr.filedata.TESLMTestFile;
import com.huawei.nglct.otdr.handler.TEDoAfterDeleteHandler;
import com.huawei.nglct.otdr.linedata.TESLMLineState;
import com.huawei.nglct.otdr.sor.TEOTDRFileInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRSorFileChecksumGenerator;
import com.huawei.nglct.otdr.sor.TEOTDRTraceInfo;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public final class TESLMOTDRDataMgr {
    private static TESLMFileDataMgr fileMgr = null;
    private static TESLMLineDataMgr lineMgr = null;
    private static final TESLMNoticeHandler handler = new TESLMNoticeHandler();
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String STORAGEPATH = TESLMConstants.TESTRECORD_STORAGE_PATH;
    private static final String BASELINE_FILE_STR = "_baseline";
    private static final String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";
    private static final String EVT_DES_PATH = "conf" + File.separator + "eventqxdescrib.xml";
    private static final String NSEVT_SLM_OTDR_TESTING = "NSEVT_SLM_OTDR_TESTING";
    private static final String NSEVT_SLM_OTDR_DONE = "NSEVT_SLM_OTDR_DONE";
    private static final String NSEVT_SLM_MID_RESULT_DONE = "NSEVT_SLM_MID_RESULT_DONE";
    private static final String NSEVT_SLM_LMU_PWR_DIF_EXC_ABN = "NSEVT_SLM_LMU_PWR_DIF_EXC_ABN";
    private static final String NSEVT_SLM_LMU_RECEIVE_PWR_ABN = "NSEVT_SLM_LMU_RECEIVE_PWR_ABN";
    private static final String NSEVT_SLM_LMU_LOGIC_DISORDER_ABN = "NSEVT_SLM_LMU_LOGIC_DISORDER_ABN";
    private static final String NSEVT_SLM_LMU_DSP_NO_RESPONSE_ABN = "NSEVT_SLM_LMU_DSP_NO_RESPONSE_ABN";
    private static final String NSEVT_SLM_WAVELOCK_FAILED_ABN = "NSEVT_SLM_WAVELOCK_FAILED_ABN";
    private static final String NSEVT_SLM_BD_RSP_ERROR_ABN = "NSEVT_SLM_BD_RSP_ERROR_ABN";
    private static final String NSEVT_SLM_SEND_BDCMD_FAILED_ABN = "NSEVT_SLM_SEND_BDCMD_FAILED_ABN";
    private static final String NSEVT_SLM_SERVICE_SIGNAL_EXIST_ABN = "NSEVT_SLM_SERVICE_SIGNAL_EXIST_ABN";
    private static final String NSEVT_SLM_FILE_WR_FAILED_ABN = "NSEVT_SLM_FILE_WR_FAILED_ABN";
    private static final String NSEVT_SLM_FILE_TRANS_ERR_ABN = "NSEVT_SLM_FILE_TRANS_ERR_ABN";
    private static final String NSEVT_SLM_PWRLOCK_FAILED_ABN = "NSEVT_SLM_PWRLOCK_FAILED_ABN";
    private static final String NSEVT_SLM_LASER_OFF_ABN = "NSEVT_SLM_LASER_OFF_ABN";
    private static final String NSEVT_SLM_BD_RESET_ABN = "NSEVT_SLM_BD_RESET_ABN";
    private static final String NSEVT_SLM_BD_OFFLINE_ABN = "NSEVT_SLM_BD_OFFLINE_ABN";
    private static final String NSEVT_SLM_UNDONE_BEFORE_RECYC_ABN = "NSEVT_SLM_UNDONE_BEFORE_RECYC_ABN";
    private static final String NSEVT_SLM_CMD_TIMEOUT_ABN = "NSEVT_SLM_CMD_TIMEOUT_ABN";
    private static final String NSEVT_SLM_REMOTE_LINEINFO_ERR_ABN = "NSEVT_SLM_REMOTE_LINEINFO_ERR_ABN";
    private static final String NSEVT_SLM_REMOTE_WAVELEN_CONFLICT_ABN = "NSEVT_SLM_REMOTE_WAVELEN_CONFLICT_ABN";
    private static final String NSEVT_SLM_DSP_RETURN_ERR_ABN = "NSEVT_SLM_DSP_RETURN_ERR_ABN";
    private static final String NSEVT_SLM_RL_LOW_ABN = "NSEVT_SLM_RL_LOW_ABN";
    private static final String NSEVT_SLM_SERVICE_SIGNAL_NOTEXIST_ABN = "NSEVT_SLM_SERVICE_SIGNAL_NOTEXIST_ABN";
    private static final String NSEVT_SLM_AUTOGAINADJUST_FAILED_ABN = "NSEVT_SLM_AUTOGAINADJUST_FAILED_ABN";
    private static final long TWENTY_YEARS = Long.parseLong("259e9d80", 16);
    private static final int BASE_YEAR1 = 1990;
    private static final int HFCP_STATUS_STOP = 0;

    public static synchronized void initOTDR() throws Exception {
        TESLMOTDRDataMgr.initOTDRDataMgr();
        TESLMOTDRDataMgr.registerNoticeHandler();
    }

    private TESLMOTDRDataMgr() {
    }

    private static void registerNoticeHandler() {
        try {
            TENECommMgr instance = TENECommMgr.getInstance();
            if (null == instance) {
                log.info("MARINE ---- failed to initialize TENECommMgr instance. abort to register events");
                return;
            }
            Definitions definitions = TECreateObjectFactory.parseQxDesFile(null, (String)QX_DES_PATH);
            Operation operation = definitions.getOperation(NSEVT_SLM_OTDR_TESTING);
            instance.registerListener((Operation)operation.clone(), (NoticeHandler)handler);
            operation = definitions.getOperation(NSEVT_SLM_OTDR_DONE);
            instance.registerListener((Operation)operation.clone(), (NoticeHandler)handler);
            operation = definitions.getOperation(NSEVT_SLM_MID_RESULT_DONE);
            instance.registerListener((Operation)operation.clone(), (NoticeHandler)handler);
            definitions = TECreateObjectFactory.parseQxDesFile(null, (String)EVT_DES_PATH);
            operation = definitions.getOperation(NSEVT_SLM_LMU_PWR_DIF_EXC_ABN);
            if (null != operation) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_LMU_RECEIVE_PWR_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_LMU_LOGIC_DISORDER_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_LMU_DSP_NO_RESPONSE_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_WAVELOCK_FAILED_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_BD_RSP_ERROR_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_SEND_BDCMD_FAILED_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_SERVICE_SIGNAL_EXIST_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_FILE_WR_FAILED_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_FILE_TRANS_ERR_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_PWRLOCK_FAILED_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_LASER_OFF_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_BD_RESET_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_BD_OFFLINE_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_UNDONE_BEFORE_RECYC_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_CMD_TIMEOUT_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_REMOTE_LINEINFO_ERR_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_REMOTE_WAVELEN_CONFLICT_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_DSP_RETURN_ERR_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_RL_LOW_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_SERVICE_SIGNAL_NOTEXIST_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
            if (null != (operation = definitions.getOperation(NSEVT_SLM_AUTOGAINADJUST_FAILED_ABN))) {
                instance.registerListener(operation, (NoticeHandler)handler);
            }
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRDataMgr.registerNoticeHandler() MarshalException!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRDataMgr.registerNoticeHandler() FileNotFoundException!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TESLMOTDRDataMgr.registerNoticeHandler() ValidationException!", (Throwable)e);
        }
        TENEHandlerMgr.getInstance().registerListener(61, (TENEHandlerInf)new TEDoAfterDeleteHandler());
    }

    private static void initOTDRDataMgr() {
        try {
            log.info("MARINE ---- BEGIN to initOTDRDataMgr");
            fileMgr = TESLMFileDataMgr.instance();
            lineMgr = TESLMLineDataMgr.instance();
            log.info("MARINE ---- succeeded to initOTDRDataMgr");
        }
        catch (Exception e) {
            log.error("MARINE ---- failed to initOTDRDataMgr");
            log.error("TESLMOTDRDataMgr.initOTDRDataMgr() fail!", (Throwable)e);
        }
    }

    public static boolean addTestRecord(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        return fileMgr.addTestRecord(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
    }

    private static void constructTestData() {
        String[] arr = new String[]{"1_1_638960_4_2_20080315164521.g", "1_2_638960_4_2_20080315164521.sor", "1_1_638960_4_2_20080315164522.g", "1_2_638960_4_2_20080315164522.sor", "1_1_638960_4_2_20080315164523.g", "1_2_638960_4_2_20080315164523.sor", "1_1_638960_4_2_20080315164524.g", "1_2_638960_4_2_20080315164524.sor", "1_1_638960_4_2_20080315164525.g", "1_2_638960_4_2_20080315164525.sor", "1_1_638960_4_2_20080315164526.g", "2_1_638960_4_2_20080315164521.g"};
        try {
            TESLMOTDRDataMgr.initOTDR();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < arr.length; ++i) {
            String n = arr[i];
            int id = Integer.parseInt(n.substring(0, n.indexOf("_")));
            fileMgr.addTestRecord(id, 1, 1, arr[i], false, true, false, true);
        }
    }

    public static void main(String[] args) {
        TESLMOTDRDataMgr.constructTestData();
    }

    public static void deleteBaseLine(int neID, int indexID, int testMode) {
        fileMgr.deleteBaseLine(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode);
    }

    public static void deleteTestRecord(int neID, int indexID, String fileName) {
        fileMgr.deleteTestRecord(TESLMOTDRDataMgr.getRealNEID(neID), indexID, fileName);
    }

    public static void deleteTestRecord(int neID, int indexID) {
        fileMgr.deleteTestRecord(TESLMOTDRDataMgr.getRealNEID(neID), indexID);
    }

    public static String getBaseLineFileName(int neID, int indexID, int testMode) {
        return fileMgr.getBaseLineFileName(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode);
    }

    public static List<String> getHistoryTestRecord(int neID, int indexID, int testMode) {
        return fileMgr.getHistoryTestRecord(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode);
    }

    public static List<String> getUnsavedTestRecord(int neID, int indexID) {
        return fileMgr.getUnsavedTestRecord(TESLMOTDRDataMgr.getRealNEID(neID), indexID);
    }

    public static void makeTestRecordSaved(int neID, int indexID, int testMode, String fileName) {
        fileMgr.makeTestRecordSaved(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode, fileName);
    }

    public static void updateBaseLine(int neID, int indexID, int testMode, String fileName) {
        fileMgr.updateBaseLine(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode, fileName);
    }

    public static void deleteRecordFromFile(int realNEID, String fileName) {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(fileName);
        TESLMOTDRDataMgr.deleteRecordFromFile(realNEID, fileList);
    }

    public static void refreshFileProperty(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        fileMgr.refreshFileProperty(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
    }

    public static void makeTmpFile(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        fileMgr.makeTmpFile(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
    }

    public static boolean fileExists(int neID, int indexID, String fileName) {
        String absFilePath;
        File file;
        int realNEID = TESLMOTDRDataMgr.getRealNEID(neID);
        boolean exist = fileMgr.fileExists(realNEID, indexID, fileName);
        if (!(!exist || (file = new File(absFilePath = TESLMOTDRDataMgr.getAbstractPath(realNEID) + fileName)).exists() && file.isFile())) {
            exist = false;
        }
        return exist;
    }

    public static void addNELineData(int neID, TIntArrayList lineList) {
        lineMgr.addNELIneData(TESLMOTDRDataMgr.getRealNEID(neID), lineList);
    }

    private static void clearNELineData(int neID) {
        lineMgr.clearNELineData(TESLMOTDRDataMgr.getRealNEID(neID));
    }

    public static void deleteLineState(int neID, int indexID) {
        lineMgr.deleteLine(TESLMOTDRDataMgr.getRealNEID(neID), indexID);
    }

    public static TESLMLineState getLineState(int neID, int indexID) {
        return lineMgr.getLineState(TESLMOTDRDataMgr.getRealNEID(neID), indexID);
    }

    public static void refreshLineState(int neID, int indexID, TESLMLineState state) {
        lineMgr.refreshLineState(TESLMOTDRDataMgr.getRealNEID(neID), indexID, state);
    }

    public static void refreshNELineData(int neID, TIntArrayList lineList) {
        lineMgr.refreshNELineData(TESLMOTDRDataMgr.getRealNEID(neID), lineList);
        fileMgr.refreshNEFileData(TESLMOTDRDataMgr.getRealNEID(neID), lineList);
    }

    public static int getNewLineIndexID(int neID) {
        return lineMgr.getNewLineIndexID(TESLMOTDRDataMgr.getRealNEID(neID));
    }

    public static Object loadFileContent(int neID, String fileName) {
        log.info("MARINE ---- BEGIN to load file content, fileName->" + fileName);
        String absFileName = TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID)) + fileName;
        return TEOTDRFileInterpreter.loadFileContent(absFileName, neID);
    }

    public static File copyNewFile(int neID, String srcFileName, String snkFileName) {
        String srcPath = TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID));
        String snkPath = TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID));
        return TESLMOTDRDataMgr.copyFile(srcPath, srcFileName, snkPath, snkFileName);
    }

    public static File copyFile(String srcPath, String srcFileName, String snkPath, String snkFileName) {
        return TESLMFileUtil.copyFile(srcPath, srcFileName, snkPath, snkFileName);
    }

    public static String makeBaseLineName(int indexID, int testMode, int lmiNEID, int lmiSlotID, int lmiPortID, String fileName) {
        log.info("MARINE ---- make base line name");
        log.info("MARINE ---- indexID->" + indexID);
        log.info("MARINE ---- testMode->" + testMode);
        log.info("MARINE ---- lmiNEID->" + lmiNEID);
        log.info("MARINE ---- lmiSlotID->" + lmiSlotID);
        log.info("MARINE ---- lmiPortI->" + lmiPortID);
        log.info("MARINE ---- fileName->" + fileName);
        StringBuffer buf = new StringBuffer();
        buf.append(indexID).append('_');
        buf.append(testMode).append('_');
        buf.append(lmiNEID).append('_');
        buf.append(lmiSlotID).append('_');
        buf.append(lmiPortID).append('_');
        String fileNameTmp = fileName.substring(0, fileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        buf.append(propArray[5]);
        buf.append(BASELINE_FILE_STR).append('.');
        int index = fileName.lastIndexOf(46);
        String fileSuffix = fileName.substring(index + 1);
        buf.append(fileSuffix);
        String newBLName = buf.toString();
        log.info("MARINE ---- new base line file name->" + newBLName);
        return newBLName;
    }

    public static String loadRepeatorGainInfo(int neID, int lineID, int testMode, int repeatorID) {
        return fileMgr.loadRepeatorGainInfo(TESLMOTDRDataMgr.getRealNEID(neID), lineID, testMode, repeatorID);
    }

    public static String getRepeaterIDInfo(int neID, int lineID) {
        return fileMgr.getRepeaterIDInfo(TESLMOTDRDataMgr.getRealNEID(neID), lineID);
    }

    public static Object loadFileRepeatorContent(int realNEID, String fileName) {
        String absFileName = TESLMOTDRDataMgr.getAbstractPath(realNEID) + fileName;
        log.info("MARINE ---- BEGIN to load file repeater content");
        log.info("MARINE ---- fileName->" + fileName);
        int neID = TENECommMgr.getInstance().getLogicNEID(realNEID);
        return TEOTDRFileInterpreter.loadFileRepeatorContent(neID, absFileName);
    }

    public static void deleteRecordFromFile(int realNEID, List<String> deletingFileList) {
        fileMgr.deleteRecordFromFile(realNEID, deletingFileList);
    }

    public static void deleteMidFile(int neID, int indexID) {
        String midFileName = "" + indexID + "_mid.sor";
        boolean delMidResult = TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID)), midFileName);
        if (delMidResult) {
            log.info("MARINE ------The mid file has been deleted because of the testing abort. mid file name is ->" + midFileName);
        }
    }

    public static int getFileFromNE(int neID, int indexID, int testType, String fileName) {
        boolean needRedo;
        log.info("MARINE ---- receive request to get file from ne");
        log.info("MARINE ---- neID->" + neID);
        log.info("MARINE ---- indexID->" + indexID);
        log.info("MARINE ---- testType->" + testType);
        log.info("MARINE ---- fileName->" + fileName);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int result = -1;
        if (null == ne) {
            log.info("MARINE ---- ne does exist. neID->" + neID);
            log.info("MARINE ---- failed to get file. result->" + result);
            return result;
        }
        String ipAdd = ne.getNEGWAddress();
        log.info("MARINE ---- ne ip address->" + ipAdd);
        int realNEID = ne.getRealNEID();
        log.info("MARINE ---- physical neid->" + realNEID);
        String neStoragePath = TESLMOTDRDataMgr.getAbstractPath(realNEID);
        log.info("MARINE ----- neStoragePath->" + neStoragePath);
        File file = new File(neStoragePath);
        try {
            if (file.exists() && !file.isDirectory()) {
                log.info("MARINE ---- file is not a folder, delete it. file->" + file.getPath());
                if (!file.delete()) {
                    return -1;
                }
            }
            if (!file.exists() && !file.mkdirs()) {
                return -1;
            }
        }
        catch (Exception e) {
            log.error("file operation error!", (Throwable)e);
            return -1;
        }
        log.info("MARINE ---- call jni interface to get file from ne");
        result = TEHFCPFileUtil.getFileFromNE((String)ipAdd, (int)realNEID, (String)"/cfs1/bdm", (String)neStoragePath, (String)fileName);
        if (0 == result && (needRedo = TESLMOTDRDataMgr.checkOTDRFile(neID, neStoragePath, fileName))) {
            TELogFactory.getHFCPFileTransferLogger().info("file checksum not equals. need to get the file again.... file name -> " + fileName);
            log.info("file checksum not equals. need to get the file again....file name -> " + fileName);
            String absFilePathName = neStoragePath + fileName;
            TEHFCPFileUtil.deleteRawFileFromNE((int)neID, (String)absFilePathName);
            result = TEHFCPFileUtil.getFileFromNE((String)ipAdd, (int)realNEID, (String)"/cfs1/bdm", (String)neStoragePath, (String)fileName);
            if (TESLMOTDRDataMgr.checkOTDRFile(neID, neStoragePath, fileName)) {
                TEHFCPFileUtil.deleteRawFileFromNE((int)neID, (String)absFilePathName);
                result = 1090650120;
            }
        }
        log.info("MARINE ---- END to get file, result->" + result);
        log.info("MARINE ---- Set HFCP status begin!");
        TESLMOTDRDataMgr.hfcpStatusSender(neID);
        log.info("MARINE ---- Set HFCP status end!");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkOTDRFile(int neID, String neStoragePath, String fileName) {
        TELogFactory.getHFCPFileTransferLogger().info("check the checksum begin-------fileName: " + fileName);
        String absFilePathName = neStoragePath + fileName;
        Object fileLock = TEHFCPFileUtil.acquireFileReadWriteLock((String)absFilePathName);
        boolean needRedo = false;
        Object object = fileLock;
        synchronized (object) {
            File sorFile = new File(absFilePathName);
            if (sorFile.exists()) {
                TEOTDRTraceInfo traceInfo = null;
                try {
                    traceInfo = TEOTDRFileInterpreter.loadFileContent0(sorFile.getAbsolutePath(), neID);
                }
                catch (Exception e) {
                    TELogFactory.getHFCPFileTransferLogger().info("OTDR file data error. need to get the file again....file name -> " + fileName);
                    log.info("OTDR file data error. need to get the file again....file name -> " + fileName);
                    log.info("", (Throwable)e);
                    needRedo = true;
                }
                if (null != traceInfo) {
                    int checkSumInTraceFile;
                    int generatedCheckSum = TEOTDRSorFileChecksumGenerator.generateCheckSum(sorFile);
                    needRedo = generatedCheckSum != (checkSumInTraceFile = traceInfo.getTraceFileCheckSum());
                }
            }
        }
        return needRedo;
    }

    public static int sendFileToNE(int neID, String fileName) {
        log.info("MARINE ---- receive request to send file to ne");
        log.info("MARINE ---- neID->" + neID);
        log.info("MARINE ---- fileName->" + fileName);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int result = -1;
        if (null == ne) {
            log.info("MARINE ---- ne does exist. neID->" + neID);
            log.info("MARINE ---- failed to send file. result->" + result);
            return result;
        }
        String ipAdd = ne.getNEGWAddress();
        log.info("MARINE ---- ne ip address->" + ipAdd);
        int realNEID = ne.getRealNEID();
        log.info("MARINE ---- physical neid->" + realNEID);
        log.info("MARINE ---- call TESLMHFCPFileUtil interface to send file to ne");
        result = TEHFCPFileUtil.sendFileToNE((String)ipAdd, (int)realNEID, (String)"/cfs1/bdm", (String)TESLMOTDRDataMgr.getAbstractPath(realNEID), (String)fileName);
        log.info("MARINE ---- END to send file to ne. result->" + result);
        return result;
    }

    public static int sendFileToNE(int neID, String filePath, String fileName) {
        log.info("MARINE ---- receive request to send file to ne");
        log.info("MARINE ---- neID->" + neID);
        log.info("MARINE ---- fileName->" + fileName);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int result = -1;
        if (null == ne) {
            log.info("MARINE ---- ne does exist. neID->" + neID);
            log.info("MARINE ---- failed to send file. result->" + result);
            return result;
        }
        String ipAdd = ne.getNEGWAddress();
        log.info("MARINE ---- ne ip address->" + ipAdd);
        int realNEID = ne.getRealNEID();
        log.info("MARINE ---- physical neid->" + realNEID);
        log.info("MARINE ---- call TESLMHFCPFileUtil interface to send file to ne");
        log.info("MARINE ---- filePath is->" + filePath);
        result = TEHFCPFileUtil.sendFileToNE((String)ipAdd, (int)realNEID, (String)"/cfs1/bdm", (String)(filePath + File.separator), (String)fileName);
        log.info("MARINE ---- END to send file to ne. result->" + result);
        return result;
    }

    public static void delConnect(int neID) {
        TESLMFileTransferJniUtil.delConnect(TESLMOTDRDataMgr.getRealNEID(neID));
    }

    public static int getFileTransferProgress(int neID) {
        return TEHFCPFileUtil.getFileTransferProgress((int)neID);
    }

    public static void doAfterDeleteNE(int neID) {
        log.info("MARINE ---- BEGIN --- do after delete ne.  neID->" + neID);
        TESLMOTDRDataMgr.clearNELineData(neID);
        fileMgr.doAfterDeleteNE(TESLMOTDRDataMgr.getRealNEID(neID));
        log.info("MARINE ---- END --- do after delete ne.  neID->" + neID);
    }

    public static void doAfterDeleteBoard(int neID, int slotID, int boardType) {
        log.info("MARINE ---- BEGIN --- do after delete board. neID->" + neID);
        log.info("MARINE ---- slotID->" + slotID);
        log.info("MARINE ---- boardType->" + boardType);
        fileMgr.doAfterDeleteLmiBoard(neID, slotID, boardType);
        log.info("MARINE ---- END --- do after delete board.");
    }

    public static String getAbstractPath(int phyNEID) {
        String path = STORAGEPATH + File.separator + "ne_" + phyNEID + File.separator;
        return path;
    }

    public static int getRealNEID(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return -1;
        }
        return ne.getRealNEID();
    }

    public static void updateBaseLineAfterActiveOp(int neID, int indexID, TESLMTestFile file) {
        fileMgr.updateBaseLineAfterActiveOp(TESLMOTDRDataMgr.getRealNEID(neID), indexID, file);
    }

    public static List getUnactivedFileList(int neID, int lmiNEID, int lmiSlotID, int lmiPortID) {
        return fileMgr.getUnactivedFileList(TESLMOTDRDataMgr.getRealNEID(neID), lmiNEID, lmiSlotID, lmiPortID);
    }

    public static void backupBaseLineAfterActiveOp(int neID, int indexID, TESLMTestFile file) {
        fileMgr.backupBaseLineAfterActiveOp(TESLMOTDRDataMgr.getRealNEID(neID), indexID, file);
    }

    public static void activeLine(int neID, int indexID, int lmiNEID, int lmiSlotID, int lmiPortID) {
        fileMgr.activeLine(TESLMOTDRDataMgr.getRealNEID(neID), indexID, lmiNEID, lmiSlotID, lmiPortID);
    }

    public static String convertNMFileTimeToNEFileTime(String nmFileTime) {
        long elapseSecond = TESLMOTDRDataMgr.getTimeElapsed(nmFileTime);
        return Long.toString(elapseSecond, 16);
    }

    private static long getTimeElapsed(String nmFileTime) {
        log.info("MARINE ---- get time elapsed. nmFileTime->" + nmFileTime);
        int year = Integer.parseInt(nmFileTime.substring(0, 4)) - 20;
        int month = Integer.parseInt(nmFileTime.substring(4, 6)) - 1;
        int day = Integer.parseInt(nmFileTime.substring(6, 8));
        int hour = Integer.parseInt(nmFileTime.substring(8, 10));
        int minute = Integer.parseInt(nmFileTime.substring(10, 12));
        int second = Integer.parseInt(nmFileTime.substring(12, 14));
        Calendar ca = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        ca.set(year, month, day, hour, minute, second);
        long nmTimeMilli = ca.getTimeInMillis();
        log.info("MARINE ---- timeelapsed->" + nmTimeMilli / 1000L + "(s)");
        return nmTimeMilli / 1000L;
    }

    public static String convertNEFileTimeToNMFileTime(String neTime) {
        log.info("MARINE ---- convert nefile time to nm file time. neTime->" + neTime);
        long neTimeSecond = Long.parseLong(neTime, 16);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        cal.setTimeInMillis(neTimeSecond * 1000L);
        StringBuffer timeStr = new StringBuffer();
        int year = cal.get(1) + 20;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        timeStr.append(year);
        timeStr.append(month >= 10 ? String.valueOf(month) : "0" + month);
        timeStr.append(day >= 10 ? String.valueOf(day) : "0" + day);
        timeStr.append(hour >= 10 ? String.valueOf(hour) : "0" + hour);
        timeStr.append(minute >= 10 ? String.valueOf(minute) : "0" + minute);
        timeStr.append(second >= 10 ? String.valueOf(second) : "0" + second);
        String nmFileTime = timeStr.toString();
        log.info("MARINE ---- nmFileTime->" + nmFileTime);
        return nmFileTime;
    }

    public static String convertNMFileTimeToNEFileTime(String nmFileTime, int neID) {
        return TESLMOTDRDataMgr.getTimeElapsed(nmFileTime, neID);
    }

    private static String getTimeElapsed(String nmFileTime, int neID) {
        log.info("MARINE ---- get time elapsed. nmFileTime->" + nmFileTime);
        int year = Integer.parseInt(nmFileTime.substring(0, 4));
        int month = Integer.parseInt(nmFileTime.substring(4, 6)) - 1;
        int day = Integer.parseInt(nmFileTime.substring(6, 8));
        int hour = Integer.parseInt(nmFileTime.substring(8, 10));
        int minute = Integer.parseInt(nmFileTime.substring(10, 12));
        int second = Integer.parseInt(nmFileTime.substring(12, 14));
        Calendar ca = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        ca.set(year, month, day, hour, minute, second);
        String nmTimeMilli = Long.toHexString(ca.getTimeInMillis() / 1000L - TWENTY_YEARS);
        log.info("MARINE ---- timeelapsed UTC time->" + nmTimeMilli);
        return nmTimeMilli;
    }

    public static String convertAppletFileTimeToNMUTCFileTime(String mAppletFileTime, int neID) {
        log.info("MARINE Convert AppletFileTimeTo NMFileTime. appletFileTime->" + mAppletFileTime);
        String appletFileTime = mAppletFileTime;
        boolean isDST = false;
        if (-1 != appletFileTime.indexOf("DST")) {
            appletFileTime = appletFileTime.substring(0, appletFileTime.indexOf("DST"));
            isDST = true;
        }
        int year = Integer.parseInt(appletFileTime.substring(0, 4));
        int month = Integer.parseInt(appletFileTime.substring(4, 6)) - 1;
        int day = Integer.parseInt(appletFileTime.substring(6, 8));
        int hour = Integer.parseInt(appletFileTime.substring(8, 10));
        int minute = Integer.parseInt(appletFileTime.substring(10, 12));
        int second = Integer.parseInt(appletFileTime.substring(12, 14));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        calendar.set(year, month, day, hour, minute, second);
        TETimeParams serverTimeParams = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neID).getServerTimeParams();
        int tzOffset = serverTimeParams.getTZOffset();
        int dstOffset = serverTimeParams.getDSTOffset();
        calendar.add(12, -tzOffset);
        if (isDST) {
            calendar.add(12, -dstOffset);
        }
        StringBuffer timeStr1 = new StringBuffer();
        int yearnew = calendar.get(1);
        int monthnew = calendar.get(2) + 1;
        int daynew = calendar.get(5);
        int hournew = calendar.get(11);
        int minutenew = calendar.get(12);
        int secondnew = calendar.get(13);
        timeStr1.append(yearnew);
        timeStr1.append(monthnew >= 10 ? String.valueOf(monthnew) : "0" + monthnew);
        timeStr1.append(daynew >= 10 ? String.valueOf(daynew) : "0" + daynew);
        timeStr1.append(hournew >= 10 ? String.valueOf(hournew) : "0" + hournew);
        timeStr1.append(minutenew >= 10 ? String.valueOf(minutenew) : "0" + minutenew);
        timeStr1.append(secondnew >= 10 ? String.valueOf(secondnew) : "0" + secondnew);
        String nmUTCFileTime = timeStr1.toString();
        log.info("nmUTCFileTime: " + nmUTCFileTime);
        return nmUTCFileTime;
    }

    public static String convertNMUTCFileTimeToAppletFileTime(String nmUTCFileTime, int neID) {
        log.info("MARINE Convert NMUTCFileTime To AppletFileTime. nmUTCFileTime: " + nmUTCFileTime);
        int year = Integer.parseInt(nmUTCFileTime.substring(0, 4));
        int month = Integer.parseInt(nmUTCFileTime.substring(4, 6)) - 1;
        int day = Integer.parseInt(nmUTCFileTime.substring(6, 8));
        int hour = Integer.parseInt(nmUTCFileTime.substring(8, 10));
        int minute = Integer.parseInt(nmUTCFileTime.substring(10, 12));
        int second = Integer.parseInt(nmUTCFileTime.substring(12, 14));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        cal.set(year, month, day, hour, minute, second);
        boolean isDST = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neID).changeCalendarToServerTime(cal);
        StringBuffer timeStr1 = new StringBuffer();
        int yearnew = cal.get(1);
        int monthnew = cal.get(2) + 1;
        int daynew = cal.get(5);
        int hournew = cal.get(11);
        int minutenew = cal.get(12);
        int secondnew = cal.get(13);
        timeStr1.append(yearnew);
        timeStr1.append(monthnew >= 10 ? String.valueOf(monthnew) : "0" + monthnew);
        timeStr1.append(daynew >= 10 ? String.valueOf(daynew) : "0" + daynew);
        timeStr1.append(hournew >= 10 ? String.valueOf(hournew) : "0" + hournew);
        timeStr1.append(minutenew >= 10 ? String.valueOf(minutenew) : "0" + minutenew);
        timeStr1.append(secondnew >= 10 ? String.valueOf(secondnew) : "0" + secondnew);
        if (isDST) {
            timeStr1.append("DST");
        }
        String appletFileTime = timeStr1.toString();
        log.info("appletFileTime: " + appletFileTime);
        return appletFileTime;
    }

    public static String convertCalendarToServerTime(Calendar cal, int neID) {
        log.info("MARINE Convert cal To ServerTime. serverTime.");
        boolean isDST = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neID).changeCalendarToServerTime(cal);
        StringBuffer timeStr1 = new StringBuffer();
        int yearnew = cal.get(1);
        int monthnew = cal.get(2) + 1;
        int daynew = cal.get(5);
        int hournew = cal.get(11);
        int minutenew = cal.get(12);
        int secondnew = cal.get(13);
        timeStr1.append(yearnew);
        timeStr1.append('-');
        timeStr1.append(monthnew >= 10 ? String.valueOf(monthnew) : "0" + monthnew);
        timeStr1.append('-');
        timeStr1.append(daynew >= 10 ? String.valueOf(daynew) : "0" + daynew);
        timeStr1.append(' ');
        timeStr1.append(hournew >= 10 ? String.valueOf(hournew) : "0" + hournew);
        timeStr1.append(':');
        timeStr1.append(minutenew >= 10 ? String.valueOf(minutenew) : "0" + minutenew);
        timeStr1.append(':');
        timeStr1.append(secondnew >= 10 ? String.valueOf(secondnew) : "0" + secondnew);
        if (isDST) {
            timeStr1.append(" DST");
        }
        String serverTimeStr = timeStr1.toString();
        log.info("serverTimeStr: " + serverTimeStr);
        return serverTimeStr;
    }

    public static String convertAppletFileNameToNMUTCFileName(String appletFileName, int neID) {
        String nmTime;
        log.info("Marine Convert AppletFileName To NMUTCFileName. appletFileName: " + appletFileName);
        log.info("neID: " + neID);
        String fileNameTmp = appletFileName.substring(0, appletFileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        String appletTime = propArray[5];
        propArray[5] = nmTime = TESLMOTDRDataMgr.convertAppletFileTimeToNMUTCFileTime(appletTime, neID);
        StringBuffer nmUTCFileName = new StringBuffer();
        int len = propArray.length - 1;
        for (int i = 0; i < len; ++i) {
            nmUTCFileName.append(propArray[i]).append('_');
        }
        nmUTCFileName.append(propArray[propArray.length - 1]);
        String fileSuffix = appletFileName.substring(appletFileName.lastIndexOf("."));
        nmUTCFileName.append(fileSuffix);
        String nmUTCFileNameStr = nmUTCFileName.toString();
        log.info("nmUTCFileNameStr: " + nmUTCFileNameStr);
        return nmUTCFileNameStr;
    }

    public static String convertNMUTCFileNameToAppletFileName(String nmUTCFileName, int neID) {
        String appletTime;
        log.info("Marine Convert NMUTCFileName To AppletFileName. nmUTCFileName: " + nmUTCFileName);
        log.info("neID: " + neID);
        String fileNameTmp = nmUTCFileName.substring(0, nmUTCFileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        String nmUTCTime = propArray[5];
        propArray[5] = appletTime = TESLMOTDRDataMgr.convertNMUTCFileTimeToAppletFileTime(nmUTCTime, neID);
        StringBuffer appletFileName = new StringBuffer();
        int len = propArray.length - 1;
        for (int i = 0; i < len; ++i) {
            appletFileName.append(propArray[i]).append('_');
        }
        appletFileName.append(propArray[propArray.length - 1]);
        String fileSuffix = nmUTCFileName.substring(nmUTCFileName.lastIndexOf("."));
        appletFileName.append(fileSuffix);
        String appletFileNameStr = appletFileName.toString();
        log.info("appletFileNameStr: " + appletFileNameStr);
        return appletFileNameStr;
    }

    public static String convertNEFileTimeToNMFileTime(String neTime, int neID) {
        log.info("MARINE ---- convert nefile time to nm file time. neTime->" + neTime);
        long neTimeSecond = Long.parseLong(neTime, 16);
        int nebaseyear = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neID).nebaseyear;
        if (nebaseyear == 1990) {
            neTimeSecond += TWENTY_YEARS;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        cal.setTimeInMillis(neTimeSecond * 1000L);
        StringBuffer timeStr1 = new StringBuffer();
        int yearnew = cal.get(1);
        int monthnew = cal.get(2) + 1;
        int daynew = cal.get(5);
        int hournew = cal.get(11);
        int minutenew = cal.get(12);
        int secondnew = cal.get(13);
        timeStr1.append(yearnew);
        timeStr1.append(monthnew >= 10 ? String.valueOf(monthnew) : "0" + monthnew);
        timeStr1.append(daynew >= 10 ? String.valueOf(daynew) : "0" + daynew);
        timeStr1.append(hournew >= 10 ? String.valueOf(hournew) : "0" + hournew);
        timeStr1.append(minutenew >= 10 ? String.valueOf(minutenew) : "0" + minutenew);
        timeStr1.append(secondnew >= 10 ? String.valueOf(secondnew) : "0" + secondnew);
        String nmFileTime = timeStr1.toString();
        log.info("MARINE ---- nmFileTime->" + nmFileTime);
        return nmFileTime;
    }

    public static String convertNEFileNameToNMFileName(int neid, int indexID, int testMode, int testType, int lmiNEID, int lmiSlotID, int lmiPortID, String nmFileTime, boolean isBaseLine, String fileSuffixType) {
        StringBuffer buf = new StringBuffer();
        buf.append(indexID);
        buf.append('_');
        buf.append(testMode).append('_');
        buf.append(lmiNEID).append('_');
        buf.append(lmiSlotID).append('_');
        buf.append(lmiPortID).append('_');
        buf.append(nmFileTime);
        if (isBaseLine) {
            buf.append('_').append("baseline");
        }
        buf.append('.').append(fileSuffixType);
        return buf.toString();
    }

    public static String getTimeString(long time, int neid) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        cal.setTimeInMillis(time * 1000L);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        cal.set(year, month - 1, day, hour, minute, second);
        StringBuffer timeStr1 = new StringBuffer();
        int yearnew = cal.get(1);
        int monthnew = cal.get(2) + 1;
        int daynew = cal.get(5);
        int hournew = cal.get(11);
        int minutenew = cal.get(12);
        int secondnew = cal.get(13);
        timeStr1.append(yearnew);
        timeStr1.append(monthnew >= 10 ? String.valueOf(monthnew) : "0" + monthnew);
        timeStr1.append(daynew >= 10 ? String.valueOf(daynew) : "0" + daynew);
        timeStr1.append(hournew >= 10 ? String.valueOf(hournew) : "0" + hournew);
        timeStr1.append(minutenew >= 10 ? String.valueOf(minutenew) : "0" + minutenew);
        timeStr1.append(secondnew >= 10 ? String.valueOf(secondnew) : "0" + secondnew);
        String nmFileTime = timeStr1.toString();
        return nmFileTime;
    }

    public static String getFileSuffixTypeStr(String newBLName) {
        int dotIndex = newBLName.indexOf(".");
        if (-1 == dotIndex) {
            return null;
        }
        return newBLName.substring(dotIndex + 1);
    }

    public static void recordUploadResult(int neID, int indexID, int testMode, List errList) {
        fileMgr.recordUploadResult(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode, errList);
    }

    public static Object getUploadResult(int neID, int indexID, int testMode) {
        return fileMgr.getUploadResult(TESLMOTDRDataMgr.getRealNEID(neID), indexID, testMode);
    }

    private static void hfcpStatusSender(int neID) {
        try {
            TESLMSetHFCPStatusBean neExplorerBean = new TESLMSetHFCPStatusBean();
            int sfId = 2556126;
            SubFunc subfunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfId);
            Datainterface inputData = new Datainterface();
            inputData.setBussinessParams(new BussinessParams());
            RowParams rowParams = new RowParams();
            rowParams.addParam("hfcpStatus", String.valueOf(0));
            inputData.getBussinessParams().addRowParams(rowParams);
            neExplorerBean.performBussinessProcess(neID, subfunc, inputData, null, null, null);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TESLMOTDRDataMgr.hfcpStatusSender() fail!", (Throwable)ex);
        }
    }

    public static void clear() {
        if (null != fileMgr) {
            fileMgr.clear();
        }
        TEMarineTestStopNoticeMgr.getInstance().clear();
    }
}

