/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnDateTimeType;
import com.huawei.nglct.nemgr.marine.e2e.linemonitor.TESLMLineTestStateNoticeMgr;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.otdr.TESLMFileUtil;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.external.TEMarineTestStopEvent;
import com.huawei.nglct.otdr.external.TEMarineTestStopNoticeMgr;
import com.huawei.nglct.otdr.linedata.TESLMLineState;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.slf4j.Logger;

class TESLMNoticeHandler
implements NoticeHandler {
    public static final int TEST_IN_PROGRESS_CMDCODE = 16500;
    public static final int TEST_STOPPED_CMDCODE = 16501;
    public static final int NSEVT_SLM_LMU_PWR_DIF_EXC_ABN = 16574;
    public static final int NSEVT_SLM_LMU_RECEIVE_PWR_ABN = 16575;
    public static final int NSEVT_SLM_LMU_LOGIC_DISORDER_ABN = 16576;
    public static final int NSEVT_SLM_LMU_DSP_NO_RESPONSE_ABN = 16577;
    public static final int NSEVT_SLM_WAVELOCK_FAILED_ABN = 16578;
    public static final int NSEVT_SLM_BD_RSP_ERROR_ABN = 16579;
    public static final int NSEVT_SLM_SEND_BDCMD_FAILED_ABN = 16580;
    public static final int NSEVT_SLM_SERVICE_SIGNAL_EXIST_ABN = 16581;
    public static final int NSEVT_SLM_FILE_WR_FAILED_ABN = 16582;
    public static final int NSEVT_SLM_FILE_TRANS_ERR_ABN = 16583;
    public static final int NSEVT_SLM_PWRLOCK_FAILED_ABN = 16584;
    public static final int NSEVT_SLM_LASER_OFF_ABN = 16585;
    public static final int NSEVT_SLM_BD_RESET_ABN = 16586;
    public static final int NSEVT_SLM_BD_OFFLINE_ABN = 16587;
    public static final int NSEVT_SLM_UNDONE_BEFORE_RECYC_ABN = 16588;
    public static final int NSEVT_SLM_CMD_TIMEOUT_ABN = 16589;
    public static final int NSEVT_SLM_REMOTE_LINEINFO_ERR_ABN = 18448;
    public static final int NSEVT_SLM_REMOTE_WAVELEN_CONFLICT_ABN = 18449;
    public static final int NSEVT_SLM_DSP_RETURN_ERR_ABN = 18451;
    public static final int NSEVT_SLM_RL_LOW_ABN = 18461;
    public static final int NSEVT_SLM_AUTOGAINADJUST_FAILED_ABN = 16665;
    public static final int NSEVT_SLM_SERVICE_SIGNAL_NOTEXIST_ABN = 18485;
    public static final int VIEW_MID_RESULT_OVER_CMDCODE = 16521;
    public static final int MID_FILE_TRANS_UNFINISHED = 0;
    public static final int MID_FILE_TRANS_FINISHED = 1;
    public static final int TIMEOUT = 1000;
    private Logger log = TELogFactory.getNormalLogger();
    public static final int NE_BASE_TEAR = 1990;

    TESLMNoticeHandler() {
    }

    public void handleNotice(int cmdKey, int neID, Operation oper) {
        switch (cmdKey) {
            case 16500: {
                this.processTestInProgressNotice(neID, oper);
                break;
            }
            case 16501: {
                this.processTestStoppedNotice(neID, oper);
                break;
            }
            case 16574: 
            case 16575: 
            case 16576: 
            case 16577: 
            case 16578: 
            case 16579: 
            case 16580: 
            case 16581: 
            case 16582: 
            case 16583: 
            case 16584: 
            case 16585: 
            case 16586: 
            case 16587: 
            case 16588: 
            case 16589: 
            case 16665: 
            case 18448: 
            case 18449: 
            case 18451: 
            case 18461: 
            case 18485: {
                this.processTestAbortNotice(neID, oper);
                break;
            }
            case 16521: {
                this.processViewMidResultNotice(neID, oper);
                break;
            }
        }
    }

    private void processTestAbortNotice(int neID, Operation oper) {
        this.log.info("MARINE ------receive test abort notice------ neID->" + neID);
        if (null == oper) {
            this.log.info("MARINE ------receive test abort notice------ notice is null, resurn. neID->" + neID);
            return;
        }
        Output[] outputArray = oper.getOutput();
        Output output = null;
        int testState = 2;
        TESLMLineState state = null;
        for (int i = 0; i < outputArray.length; ++i) {
            this.log.info("MARINE ------process one output");
            output = outputArray[i];
            int indexID = Integer.parseInt(output.getPartValue("indexID"));
            this.log.info("MARINE ------indexID->" + indexID);
            int testType = Integer.parseInt(output.getPartValue("testType"));
            this.log.info("MARINE ------testType->" + testType);
            int testMode = Integer.parseInt(output.getPartValue("testMode"));
            this.log.info("MARINE ------testMode->" + testMode);
            testState = 1;
            state = new TESLMLineState();
            state.setTestState(testState);
            state.setAbortErrorCode(oper.getCmdid());
            state.setMidResultState(1);
            TESLMOTDRDataMgr.refreshLineState(neID, indexID, state);
            TESLMRefreshTypeMgr.getInstance().stopTimer(neID, indexID);
            AsnDateTimeType curDT = new AsnDateTimeType();
            curDT.year = -1;
            curDT.month = 1;
            curDT.day = 1;
            curDT.hour = 1;
            curDT.minute = 1;
            curDT.second = 1;
            TESLMLineTestStateNoticeMgr.sendLineTestStateProgressChangeNtfToC(neID, indexID, state, curDT);
            this.delMidFile(neID, indexID);
            TEMarineTestStopEvent event = new TEMarineTestStopEvent();
            event.setNeid(neID);
            event.setLineid(indexID);
            event.setTestMode(testMode);
            event.setTestType(testType);
            event.setRetCode(1090615267);
            this.dispatchTestStopEvent(event);
        }
        this.log.info("MARINE ------end to process test abort notice. neID->" + neID);
    }

    private void processTestStoppedNotice(final int neID, final Operation oper) {
        this.log.info("MARINE ------receive test stop notice------ neID->" + neID);
        if (null == oper) {
            this.log.info("MARINE ------receive test stop notice------ notice is null, resurn. neID->" + neID);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Output[] outputArray = oper.getOutput();
                TESLMNoticeHandler.this.log.info("MARINE ------begin to process test stop notice. neID->" + neID + "  output size->" + outputArray.length);
                for (int i = 0; i < outputArray.length; ++i) {
                    TESLMNoticeHandler.this.log.info("MARINE ------process one output");
                    Output output = outputArray[i];
                    String usedTime = output.getPartValue("usedTime");
                    TESLMNoticeHandler.this.log.info("MARINE ------usedTime->" + usedTime);
                    String neFileTime = output.getPartValue("neFileTime");
                    TESLMNoticeHandler.this.log.info("MARINE ------neFileTime->" + neFileTime);
                    int indexID = Integer.parseInt(output.getPart("indexID").getValue());
                    TESLMNoticeHandler.this.log.info("MARINE ------indexID->" + indexID);
                    int testType = Integer.parseInt(output.getPart("testType").getValue());
                    TESLMNoticeHandler.this.log.info("MARINE ------testType->" + testType);
                    int testMode = Integer.parseInt(output.getPart("testMode").getValue());
                    TESLMNoticeHandler.this.log.info("MARINE ------testMode->" + testMode);
                    int lmiNEID = Integer.parseInt(output.getPartValue("lmiNEID"));
                    TESLMNoticeHandler.this.log.info("MARINE ------lmiNEID->" + lmiNEID);
                    int lmiSlotID = Integer.parseInt(output.getPartValue("lmiSlotID"));
                    TESLMNoticeHandler.this.log.info("MARINE ------lmiSlotID->" + lmiSlotID);
                    int lmiPortID = Integer.parseInt(output.getPartValue("lmiPortID"));
                    TESLMNoticeHandler.this.log.info("MARINE ------lmiPortID->" + lmiPortID);
                    String fileName = output.getPartValue("fileName").trim();
                    TESLMNoticeHandler.this.log.info("MARINE ------fileName->" + fileName);
                    String nmFileTime = TESLMOTDRDataMgr.convertNEFileTimeToNMFileTime(fileName.substring(0, fileName.indexOf(46)), neID);
                    TESLMNoticeHandler.this.log.info("MARINE ------convert to ne file time,  nmFileTime->" + nmFileTime);
                    AsnDateTimeType curDT = TESLMNoticeHandler.this.createAsnCurrentDateTime(output);
                    boolean isBaseLine = false;
                    boolean isSaved = false;
                    boolean isTmp = false;
                    boolean isComplete = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        TESLMNoticeHandler.this.log.error("MARINE ---- Stop test waiting error...");
                        TESLMNoticeHandler.this.log.error("TESLMNoticeHandler.processTestStoppedNotice() fail!", (Throwable)e);
                    }
                    int result = TESLMOTDRDataMgr.getFileFromNE(neID, indexID, testType, fileName);
                    String nmFileName = "";
                    if (0 == result) {
                        String fileSuffixType = TESLMOTDRDataMgr.getFileSuffixTypeStr(fileName);
                        TESLMNoticeHandler.this.log.info("MARINE ---- fileSuffixType->" + fileSuffixType);
                        if (4 == testType) {
                            isBaseLine = true;
                            isSaved = true;
                        }
                        nmFileName = TESLMOTDRDataMgr.convertNEFileNameToNMFileName(neID, indexID, testMode, testType, lmiNEID, lmiSlotID, lmiPortID, nmFileTime, isBaseLine, fileSuffixType);
                        TESLMNoticeHandler.this.log.info("MARINE ---- convert ne file name to nm file name. nmFileName->" + nmFileName);
                        if (TESLMOTDRDataMgr.fileExists(neID, indexID, nmFileName)) {
                            TESLMNoticeHandler.this.log.info("MARINE ---- file exists. fileName->" + nmFileName);
                            TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID)), fileName);
                            continue;
                        }
                        TESLMOTDRDataMgr.copyNewFile(neID, fileName, nmFileName);
                        TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID)), fileName);
                        if (isBaseLine) {
                            TESLMNoticeHandler.this.log.info("MARINE ---- delete current base line");
                            TESLMOTDRDataMgr.deleteBaseLine(neID, indexID, testMode);
                            TESLMOTDRDataMgr.addTestRecord(neID, indexID, testType, nmFileName, isBaseLine, isSaved, isTmp, isComplete);
                            TESLMNoticeHandler.this.log.info("MARINE ---- SET NEW BASELINE ON NM");
                            TESLMOTDRDataMgr.updateBaseLine(neID, indexID, testMode, nmFileName);
                        } else {
                            TESLMOTDRDataMgr.addTestRecord(neID, indexID, testType, nmFileName, isBaseLine, isSaved, isTmp, isComplete);
                        }
                    }
                    TESLMNoticeHandler.this.postProcessTestStoppedNotice(neID, indexID, curDT);
                    TEMarineTestStopEvent event = new TEMarineTestStopEvent();
                    event.setNeid(neID);
                    event.setLineid(indexID);
                    event.setTestMode(testMode);
                    event.setTestType(testType);
                    event.setRetCode(result);
                    event.setFileName(nmFileName);
                    TESLMNoticeHandler.this.dispatchTestStopEvent(event);
                }
                TESLMNoticeHandler.this.log.info("MARINE ------end to process test stop notice. neID->" + neID);
            }
        }).start();
    }

    private void processTestInProgressNotice(int neID, Operation oper) {
        this.log.info("MARINE ------receive test in progress notice------ neID->" + neID);
        if (null == oper) {
            this.log.info("MARINE ------receive test in progress notice------ notice is null, resurn. neID->" + neID);
            return;
        }
        Output[] outputArray = oper.getOutput();
        Output output = null;
        int indexID = -1;
        int testMode = -1;
        int testType = -1;
        int progress = -1;
        int testState = 2;
        TESLMLineState state = null;
        String stringValue = null;
        int startYear = 0;
        int startMonth = 0;
        int startDay = 0;
        int startHour = 0;
        int startMinute = 0;
        int startSecond = 0;
        String startTime = "";
        for (int i = 0; i < outputArray.length; ++i) {
            output = outputArray[i];
            indexID = Integer.parseInt(output.getPart("indexID").getValue());
            this.log.info("MARINE ------indexID->" + indexID);
            testType = Integer.parseInt(output.getPart("testType").getValue());
            this.log.info("MARINE ------testType->" + testType);
            testMode = Integer.parseInt(output.getPart("testMode").getValue());
            this.log.info("MARINE ------testMode->" + testMode);
            progress = Integer.parseInt(output.getPart("progress").getValue());
            this.log.info("MARINE ------progress->" + progress);
            stringValue = output.getPart("startYear").getValue().trim();
            startYear = Integer.parseInt(stringValue);
            stringValue = output.getPart("startMonth").getValue().trim();
            startMonth = Integer.parseInt(stringValue);
            stringValue = output.getPart("startDay").getValue().trim();
            startDay = Integer.parseInt(stringValue);
            stringValue = output.getPart("startHour").getValue().trim();
            startHour = Integer.parseInt(stringValue);
            stringValue = output.getPart("startMinute").getValue().trim();
            startMinute = Integer.parseInt(stringValue);
            stringValue = output.getPart("startSecond").getValue().trim();
            startSecond = Integer.parseInt(stringValue);
            startTime = this.getFormattedTime(neID, startYear, startMonth, startDay, startHour, startMinute, startSecond);
            this.log.info("MARINE ------startTime->" + startTime);
            String timeToEnd = output.getPart("remainTime").getValue().trim();
            this.log.info("MARINE ------timeToEnd->" + timeToEnd);
            state = new TESLMLineState();
            state.setTestMode(testMode);
            state.setTestType(testType);
            state.setTestProgress(progress);
            state.setStartTime(startTime);
            state.setTimeToEnd(timeToEnd);
            state.setTestState(testState);
            TESLMOTDRDataMgr.refreshLineState(neID, indexID, state);
            AsnDateTimeType curDT = new AsnDateTimeType();
            if (startYear == 0) {
                startYear = -1;
            }
            curDT.year = startYear + 1990;
            curDT.month = startMonth;
            curDT.day = startDay;
            curDT.hour = startHour;
            curDT.minute = startMinute;
            curDT.second = startSecond;
            TESLMLineTestStateNoticeMgr.sendLineTestStateProgressChangeNtfToC(neID, indexID, state, curDT);
        }
    }

    private void processViewMidResultNotice(final int neID, final Operation oper) {
        this.log.info("MARINE ------receive view  middle result notice------ neID->" + neID);
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (null == oper) {
                    TESLMNoticeHandler.this.log.info("MARINE ------receive view middle result notice------ notice is null, resurn. neID->" + neID);
                    return;
                }
                TESLMLineState state = null;
                Output[] outputArray = oper.getOutput();
                TESLMNoticeHandler.this.log.info("MARINE ------begin to process view middle result notice. neID->" + neID + "  output size->" + outputArray.length);
                Output output = null;
                for (int i = 0; i < outputArray.length; ++i) {
                    TESLMNoticeHandler.this.log.info("MARINE ------process one output");
                    output = outputArray[i];
                    int indexID = Integer.parseInt(output.getPart("indexID").getValue());
                    TESLMNoticeHandler.this.log.info("MARINE ------indexID->" + indexID);
                    int testType = Integer.parseInt(output.getPart("testType").getValue());
                    TESLMNoticeHandler.this.log.info("MARINE ------testType->" + testType);
                    int testMode = Integer.parseInt(output.getPart("testMode").getValue());
                    TESLMNoticeHandler.this.log.info("MARINE ------testMode->" + testMode);
                    int lmiNEID = Integer.parseInt(output.getPartValue("lmiNEID"));
                    TESLMNoticeHandler.this.log.info("MARINE ------lmiNEID->" + lmiNEID);
                    int lmiSlotID = Integer.parseInt(output.getPartValue("lmiSlotID"));
                    TESLMNoticeHandler.this.log.info("MARINE ------lmiSlotID->" + lmiSlotID);
                    int lmiPortID = Integer.parseInt(output.getPartValue("lmiPortID"));
                    TESLMNoticeHandler.this.log.info("MARINE ------lmiPortID->" + lmiPortID);
                    String doneTime = output.getPartValue("doneTime");
                    TESLMNoticeHandler.this.log.info("MARINE ------doneTime->" + doneTime);
                    String fileName = output.getPartValue("midFileName").trim();
                    String nmFileTime = TESLMOTDRDataMgr.convertNEFileTimeToNMFileTime(fileName.substring(0, fileName.indexOf(46)), neID);
                    TESLMNoticeHandler.this.log.info("MARINE ------convert to nm file time,  nmFileTime->" + nmFileTime);
                    state = TESLMOTDRDataMgr.getLineState(neID, indexID);
                    state.setMidResultState(0);
                    String nmFileName = "";
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        TESLMNoticeHandler.this.log.info("MARINE ---- View middle test waiting error...");
                        TESLMNoticeHandler.this.log.info("", (Throwable)e);
                    }
                    int result = TESLMOTDRDataMgr.getFileFromNE(neID, indexID, testType, fileName);
                    if (0 != result) continue;
                    nmFileName = indexID + "_mid.sor";
                    TESLMNoticeHandler.this.log.info("MARINE ---- convert ne file name to nm file name. nmFileName->" + nmFileName);
                    TESLMOTDRDataMgr.copyNewFile(neID, fileName, nmFileName);
                    TESLMNoticeHandler.this.log.info("MARINE ---- cope ne middle result file name to nm one. nmFileName->" + nmFileName);
                    TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID)), fileName);
                    state.setMidResultState(1);
                }
                state.setMidResultState(1);
                TESLMNoticeHandler.this.log.info("MARINE ------end to process test stop notice. neID->" + neID);
            }
        }).start();
    }

    public String getFormattedTime(int neid, int year, int month, int day, int hour, int minute, int second) {
        String time = "";
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + 1990, month - 1, day, hour, minute, second);
        SimpleDateFormat formatter = new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH);
        this.log.info("Marine Formatted Time.calendar: " + formatter.format(calendar.getTime()));
        time = TESLMOTDRDataMgr.convertCalendarToServerTime(calendar, neid);
        this.log.info("Marine Formatted Time. time: " + time);
        return time;
    }

    private void delMidFile(int neID, int indexID) {
        String midFileName = "" + indexID + "_mid.sor";
        boolean delMidResult = TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neID)), midFileName);
        if (delMidResult) {
            this.log.info("MARINE ------The mid file has been deleted because of the testing abort. mid file name is ->" + midFileName);
        }
    }

    private void dispatchTestStopEvent(TEMarineTestStopEvent event) {
        TEMarineTestStopNoticeMgr.getInstance().dispatch(event);
    }

    private AsnDateTimeType createAsnCurrentDateTime(Output output) {
        String stringValue = output.getPart("startYear").getValue().trim();
        int startYear = Integer.parseInt(stringValue);
        stringValue = output.getPart("startMonth").getValue().trim();
        int startMonth = Integer.parseInt(stringValue);
        stringValue = output.getPart("startDay").getValue().trim();
        int startDay = Integer.parseInt(stringValue);
        stringValue = output.getPart("startHour").getValue().trim();
        int startHour = Integer.parseInt(stringValue);
        stringValue = output.getPart("startMinute").getValue().trim();
        int startMinute = Integer.parseInt(stringValue);
        stringValue = output.getPart("startSecond").getValue().trim();
        int startSecond = Integer.parseInt(stringValue);
        AsnDateTimeType curDT = new AsnDateTimeType();
        curDT.year = startYear + 1990;
        curDT.month = startMonth;
        curDT.day = startDay;
        curDT.hour = startHour;
        curDT.minute = startMinute;
        curDT.second = startSecond;
        return curDT;
    }

    private TESLMLineState createLineStateForStopNotice() {
        TESLMLineState state = new TESLMLineState();
        state.setTestState(1);
        state.setAbortErrorCode(0);
        state.setMidResultState(1);
        return state;
    }

    private TESLMLineState postProcessTestStoppedNotice(int neID, int indexID, AsnDateTimeType curDT) {
        TESLMLineState state = this.createLineStateForStopNotice();
        TESLMOTDRDataMgr.refreshLineState(neID, indexID, state);
        TESLMRefreshTypeMgr.getInstance().stopTimer(neID, indexID);
        TESLMLineTestStateNoticeMgr.sendLineTestStateProgressChangeNtfToC(neID, indexID, state, curDT);
        this.delMidFile(neID, indexID);
        return state;
    }
}

