/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.otdr.TESLMConstants;
import com.huawei.nglct.otdr.TESLMFileUtil;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.TESLMOTDRLMIData;
import com.huawei.nglct.otdr.TESLMOTDRXMLUtil;
import com.huawei.nglct.otdr.filedata.TESLMNEFileData;
import com.huawei.nglct.otdr.filedata.TESLMNERepeatorInfo;
import com.huawei.nglct.otdr.filedata.TESLMTestFile;
import com.huawei.nglct.otdr.report.TESLMReportInf;
import com.huawei.nglct.otdr.sor.TEOTDREvent;
import com.huawei.nglct.otdr.sor.TEOTDRFileInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRKeyEventsBlock;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRSLMRepeaterInfo;
import com.huawei.nglct.otdr.sor.TEOTDRTraceInfo;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TESLMFileDataMgr {
    private static final String VALUE_ATTR = "value";
    private static final String FILE_NAME_ATTR = "fileName";
    private static final String KEY_EVENT_BLOCK = "KeyEvents";
    private static final String SLM_BLOCK = "SpecProp";
    private static TESLMFileDataMgr fdmInstance = new TESLMFileDataMgr();
    private TIntObjectHashMap<TESLMNEFileData> testRecordMap = null;
    private Map<TESLMOTDRLMIData, List<TESLMTestFile>> tmpRecordMap = null;
    private TIntObjectHashMap<TESLMNERepeatorInfo> repeatorInfoMap = null;
    private Map uploadRecordMap = null;
    private final TIntObjectHashMap<Object> testRecordWriteMutex = new TIntObjectHashMap();
    private final Object repeatorWriteMutex = new Object();
    private final Map<String, Object> fileInDiskReadWriteLockMap = new HashMap<String, Object>();
    private Logger log = TELogFactory.getNormalLogger();
    private static final String NEID_STR = "neID";
    private static final String INDEXID_STR = "indexID";
    private static final String TESTTYPE_STR = "testType";
    private static final String ISTMP_STR = "isTmp";
    private static final String ISSAVED_STR = "isSaved";
    private static final String ISCOMPLETE_STR = "isComplete";
    private static final String ISBASELINE_STR = "isBaseLine";
    private static final String REPEATORID_STR = "repeatorID";
    private static final String DATE_STR = "date";
    private static final String GAIN_STR = "gain";
    private static final String FILE_SPLIT_STR = "_";
    private static final String TRUESTR = "1";
    private static final int FILENAME_INDEXID_INDEX = 0;
    private static final int FILENAME_TESTMODE_INDEX = 1;
    private static final int FILENAME_LMINEID_INDEX = 2;
    private static final int FILENAME_LMISLOTID_INDEX = 3;
    private static final int FILENAME_LMIPORTID_INDEX = 4;
    private static final int FILENAME_DATE_INDEX = 5;
    private static final int ACTIVE_MAX_FILE_SIZE = 10;
    private static final int ACTIVE_MAX_PERIOD_FILE_SIZE = 6;
    private static final int IN_SERVICE_MODE = 1;
    private static final int OUT_SERVICE_MODE = 2;
    private ExecutorService pool = Executors.newFixedThreadPool(5);

    private TESLMFileDataMgr() {
        this.log.info("MARINE ---- enter constructor, className->TESLMFileDataMgr");
        this.initUploadRecord();
        this.initRecord();
        this.initTestStorage();
        this.log.info("MARINE ---- leave constructor, className->TESLMFileDataMgr");
    }

    private void initUploadRecord() {
        this.uploadRecordMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object acquireTestFileRecordWriteLock(int neID) {
        TIntObjectHashMap<Object> tIntObjectHashMap = this.testRecordWriteMutex;
        synchronized (tIntObjectHashMap) {
            Object lock = this.testRecordWriteMutex.get(neID);
            if (null == lock) {
                lock = new Object();
                this.testRecordWriteMutex.put(neID, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTestFileRecordWriteLock(int neID) {
        TIntObjectHashMap<Object> tIntObjectHashMap = this.testRecordWriteMutex;
        synchronized (tIntObjectHashMap) {
            this.testRecordWriteMutex.remove(neID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquireFileReadWriteLock(String absFilePath) {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            File file = new File(absFilePath);
            String fpath = file.getAbsolutePath();
            this.log.info("MARINE ---- BEGIN to acquire file in disk lock, file->" + fpath);
            Object lock = this.fileInDiskReadWriteLockMap.get(fpath);
            if (null == lock) {
                lock = new Object();
                this.fileInDiskReadWriteLockMap.put(fpath, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileInDiskLock(String absFilePath) {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            File file = new File(absFilePath);
            String fPath = file.getAbsolutePath();
            this.log.info("MARINE ---- BEGIN to add file in disk lock, file->" + fPath);
            Object lock = this.fileInDiskReadWriteLockMap.get(fPath);
            if (null == lock) {
                lock = new Object();
                this.fileInDiskReadWriteLockMap.put(fPath, lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileInDiskLock(String absPath) {
        Map<String, Object> map = this.fileInDiskReadWriteLockMap;
        synchronized (map) {
            File file = new File(absPath);
            String fPath = file.getAbsolutePath();
            this.log.info("MARINE ---- BEGIN to remove file in disk lock, file->" + fPath);
            this.fileInDiskReadWriteLockMap.remove(fPath);
        }
    }

    private void initTestStorage() {
        String realPath = "";
        realPath = TESLMConstants.TESTRECORD_STORAGE_PATH;
        File storage = new File(realPath);
        boolean needNewCreate = false;
        if (!storage.exists()) {
            needNewCreate = true;
        } else if (!storage.isDirectory()) {
            try {
                storage.delete();
            }
            catch (Exception e) {
                this.log.error("MARINE ---- Delete otdrtmp directory failed! storage dir->" + storage.getAbsolutePath());
            }
            needNewCreate = true;
        }
        if (needNewCreate) {
            try {
                storage = new File(realPath);
                if (!storage.mkdir()) {
                    this.log.error("MARINE ---- create otdrtmp directory failed! storage dir->" + TESLMConstants.TESTRECORD_STORAGE_PATH);
                }
            }
            catch (Exception e) {
                this.log.error("MARINE ---- create otdrtmp directory failed! storage dir->" + TESLMConstants.TESTRECORD_STORAGE_PATH);
            }
        }
    }

    public static TESLMFileDataMgr instance() {
        return fdmInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTestRecord(int neID, int indexID, String fileName) {
        this.log.info("MARINE ---- delete test record");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- fileName->" + fileName);
        boolean deleteResult = false;
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                this.log.info("MARINE ---- ne data does not exist. neID->" + neID);
                return;
            }
            deleteResult = neData.deleteTestRecord(indexID, fileName);
            this.log.info("MARINE ---- delete test record result->" + deleteResult);
        }
        if (deleteResult) {
            this.deleteFile(neID, fileName);
            this.deleteRecordFromFile(neID, indexID, fileName);
            String fileNameTmp = fileName.substring(0, fileName.lastIndexOf("."));
            String[] propArray = fileNameTmp.split(FILE_SPLIT_STR);
            String date = propArray[5];
            this.delRepeatorGainInfo0(neID, indexID, date);
            this.deleteRepeatorInfoFromFile(neID, indexID, date);
            int testMode = TESLMFileDataMgr.getTestMode(fileName);
            TESLMReportInf.delReportData(neID, indexID, 1, fileName, testMode);
            if (2 == testMode) {
                TESLMReportInf.delReportData(neID, indexID, 2, fileName, testMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(int neID, String fileName) {
        this.log.info("MARINE ---- delete file in disk.");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- fileName->" + fileName);
        String path = TESLMOTDRDataMgr.getAbstractPath(neID);
        String absFileName = path + fileName;
        boolean delResult = false;
        Object object = this.acquireFileReadWriteLock(absFileName);
        synchronized (object) {
            delResult = TESLMFileUtil.deleteFile(path, fileName);
            this.log.info("MARINE ---- delResult->" + delResult);
        }
        this.removeFileInDiskLock(absFileName);
        return delResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRepeatorInfoFromFile(int neID, int indexID, String date) {
        this.log.info("MARINE ---- begin to deleteRepeatorInfoFromFile");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- date->" + date);
        Object object = this.repeatorWriteMutex;
        synchronized (object) {
            TESLMOTDRXMLUtil.deleteRepeatorInfoFromFile(neID, indexID, date);
        }
        this.log.info("MARINE ---- end to deleteRepeatorInfoFromFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRepeatorInfoFromFile(int neID) {
        this.log.info("MARINE ---- begin to deleteRepeatorInfoFromFile");
        this.log.info("MARINE ---- neID->" + neID);
        Object object = this.repeatorWriteMutex;
        synchronized (object) {
            TESLMOTDRXMLUtil.deleteRepeatorInfoFromFile(neID, -1, null);
        }
        this.log.info("MARINE ---- end to deleteRepeatorInfoFromFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRepeatorInfoFromFile(int neID, int indexID) {
        this.log.info("MARINE ---- BEGIN delete Repeator Info From File");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        Object object = this.repeatorWriteMutex;
        synchronized (object) {
            TESLMOTDRXMLUtil.deleteRepeatorInfoFromFile(neID, indexID, null);
        }
        this.log.info("MARINE ---- END delete Repeator Info From File");
    }

    void deleteRecordFromFile(final int neID, final List<String> deletingFileList) {
        this.pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                TESLMFileDataMgr.this.log.info("MARINE ---- BEGIN delete records from file");
                TESLMFileDataMgr.this.log.info("MARINE ---- neID->" + neID);
                TESLMFileDataMgr.this.log.info("MARINE ---- fileList->" + deletingFileList);
                Object object = lock = TESLMFileDataMgr.this.acquireTestFileRecordWriteLock(neID);
                synchronized (object) {
                    TESLMOTDRXMLUtil.deleteTestRecordFromFile(neID, deletingFileList);
                }
                TESLMFileDataMgr.this.log.info("MARINE ---- END delete records from file");
            }
        });
    }

    void deleteRecordFromFile(final int neID, final int indexID, final String fileName) {
        this.pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                TESLMFileDataMgr.this.log.info("MARINE ---- BEGIN delete record from file");
                TESLMFileDataMgr.this.log.info("MARINE ---- neID->" + neID);
                TESLMFileDataMgr.this.log.info("MARINE ---- fileName->" + fileName);
                Object object = lock = TESLMFileDataMgr.this.acquireTestFileRecordWriteLock(neID);
                synchronized (object) {
                    TESLMOTDRXMLUtil.deleteTestRecordFromFile(neID, indexID, fileName);
                }
                TESLMFileDataMgr.this.log.info("MARINE ---- END delete record from file");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTestRecord(int neID, int indexID) {
        this.log.info("MARINE ---- BEGIN do after delete a marine line");
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                return;
            }
            neData.deleteTestRecord(indexID);
        }
        this.delRepeatorGainInfo0(neID, indexID);
        this.deleteRepeatorInfoFromFile(neID, indexID);
        this.log.info("MARINE ---- END do after delete a marine line");
        TESLMReportInf.delReportData(neID, indexID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTestRecord(int neID) {
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                return;
            }
            neData.clear();
            this.testRecordMap.remove(neID);
        }
        this.delRepeatorGainInfo0(neID);
        this.deleteRepeatorInfoFromFile(neID);
        TESLMReportInf.delReportData(neID);
    }

    boolean addTestRecord(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        this.log.info("MARINE ---- BEGIN to add test record");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- testType->" + testType);
        this.log.info("MARINE ---- fileName->" + fileName);
        this.log.info("MARINE ---- isBaseLine->" + isBaseLine);
        this.log.info("MARINE ---- isSaved->" + isSaved);
        this.log.info("MARINE ---- isTmp->" + isTmp);
        this.log.info("MARINE ---- isComplete->" + isComplete);
        this.log.info("MARINE ---- BEGIN to add test to memory");
        boolean addResult = this.addTestRecord0(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
        this.log.info("MARINE ---- add to memory result->" + addResult);
        if (addResult) {
            this.writeRecordToFile(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
            int testMode = TESLMFileDataMgr.getTestMode(fileName);
            if (testMode == 1) {
                this.writeRepeatorInfoToFile(neID, indexID, fileName);
            }
            Object repeatorContent = TESLMOTDRDataMgr.loadFileRepeatorContent(neID, fileName);
            TESLMReportInf.addReportData(neID, indexID, fileName, 1, repeatorContent);
            Object eventContent = TESLMFileDataMgr.getEventData(neID, fileName);
            TESLMReportInf.addReportData(neID, indexID, fileName, 2, eventContent);
        }
        return addResult;
    }

    private static Object getEventData(int neID, String fileName) {
        TEOTDRTraceInfo traceInfo = TEOTDRFileInterpreter.getTraceInfo();
        if (null == traceInfo) {
            return null;
        }
        TEOTDRKeyEventsBlock eventBlock = (TEOTDRKeyEventsBlock)traceInfo.getBlock(KEY_EVENT_BLOCK);
        TEOTDRSLMParametersBlock slmBlock = (TEOTDRSLMParametersBlock)traceInfo.getBlock(SLM_BLOCK);
        double c = 2.99792458;
        List eventList = eventBlock.getEvents();
        Object[][] dataArray = new Object[eventList.size()][];
        if (eventList.isEmpty()) {
            return null;
        }
        List spanList = slmBlock.getRepeatorInfoList();
        short spanCount = slmBlock.getSpanCount();
        long[] propagationTimeArray = new long[spanCount - 1];
        int[] spanLengthArray = new int[spanCount - 1];
        long[] refractiveIndexArray = new long[spanCount];
        int index = 0;
        long oldRptPosition = 0L;
        Iterator spanIter = spanList.iterator();
        spanIter.next();
        while (spanIter.hasNext()) {
            TEOTDRSLMRepeaterInfo info = (TEOTDRSLMRepeaterInfo)spanIter.next();
            long curRptPosition = info.getRealRptPosition();
            spanLengthArray[index] = (int)(curRptPosition - oldRptPosition);
            oldRptPosition = curRptPosition;
        }
        index = 0;
        for (TEOTDRSLMRepeaterInfo info : spanList) {
            long refractiveIndex;
            refractiveIndexArray[index] = refractiveIndex = info.getRefractiveIndex();
            if (index == spanCount - 1) break;
            int spanLength = spanLengthArray[index];
            double realSpanLength = (double)spanLength / 1000.0;
            propagationTimeArray[index] = (long)(realSpanLength * (double)refractiveIndex / c);
            ++index;
        }
        Collections.sort(eventList);
        TEOTDREvent event = null;
        Iterator iter = eventList.iterator();
        int eventIndex = 0;
        while (iter.hasNext()) {
            double eventLocationInSpan;
            int i;
            event = (TEOTDREvent)iter.next();
            short eventIndexID = event.getEventIndexID();
            long propagationTime = event.getPropagationTime();
            String eventCode = event.getEventCode();
            long sum = 0L;
            for (i = 0; i < spanCount - 1; ++i) {
                if ((sum += propagationTimeArray[i]) < propagationTime) continue;
                sum -= propagationTimeArray[i];
                break;
            }
            long spanPropagationTime = propagationTime - sum;
            double eventLocationInLine = eventLocationInSpan = c * (double)spanPropagationTime / (double)refractiveIndexArray[i];
            for (int j = 0; j < i; ++j) {
                eventLocationInLine += (double)spanLengthArray[j] / 1000.0;
            }
            Object[] repeatorInfo = new Object[]{String.valueOf(eventIndexID), String.valueOf(eventLocationInLine), String.valueOf(TESLMFileDataMgr.getEventCode(eventCode)), String.valueOf(TESLMFileDataMgr.getTestMode(fileName))};
            dataArray[eventIndex] = repeatorInfo;
            ++eventIndex;
        }
        return dataArray;
    }

    private static int getEventCode(String eventCode) {
        int eventType = 0;
        if ("0M9999" == eventCode) {
            eventType = 4;
        } else if ("0D9999" == eventCode) {
            eventType = 5;
        } else {
            int evetTypeFirst = Integer.parseInt("" + eventCode.charAt(0));
            String eventTypeSecond = "" + eventCode.charAt(1);
            eventTypeSecond = eventTypeSecond.toUpperCase();
            switch (evetTypeFirst) {
                case 0: {
                    if ("E".equals(eventTypeSecond)) {
                        eventType = 3;
                        break;
                    }
                    eventType = 1;
                    break;
                }
                case 1: {
                    if ("E".equals(eventTypeSecond)) {
                        eventType = 3;
                        break;
                    }
                    eventType = 2;
                    break;
                }
                case 2: {
                    eventType = 3;
                    break;
                }
            }
        }
        return eventType;
    }

    private void writeRepeatorInfoToFile(int neID, int indexID, String fileName) {
        this.log.info("MARINE ---- BEGIN to write repeator info to file");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- fileName->" + fileName);
        this.log.info("MARINE ---- BEGIN to load file content");
        Object repeatorContent = TESLMOTDRDataMgr.loadFileRepeatorContent(neID, fileName);
        if (null == repeatorContent) {
            this.log.info("MARINE ---- failed to load file content. failed to write repeater info to file");
            return;
        }
        String fileNameTmp = fileName.substring(0, fileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split(FILE_SPLIT_STR);
        String date = propArray[5];
        this.addRepeatorGainInfo0(neID, indexID, repeatorContent, date);
        this.writeRepeatorInfoToFile(neID, indexID, fileName, repeatorContent, date);
    }

    private void addRepeatorGainInfo0(int neID, int indexID, Object repeatorContent, String date) {
        Object[][] repeatorArray = (Object[][])repeatorContent;
        String repeatorIDStr = null;
        int repeatorID = -1;
        String repeatorGain = null;
        for (int i = 0; i < repeatorArray.length; ++i) {
            Object[] repeatorInfo = repeatorArray[i];
            repeatorIDStr = repeatorInfo[0].toString();
            repeatorID = Integer.parseInt(repeatorIDStr);
            repeatorGain = repeatorInfo[1].toString();
            this.addRepeatorGainInfo0(neID, indexID, repeatorID, date, repeatorGain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRepeatorInfoToFile(int neID, int indexID, String fileName, Object repeatorContent, String date) {
        Object object = this.repeatorWriteMutex;
        synchronized (object) {
            TESLMOTDRXMLUtil.writeRepeatorInfoToFile(neID, indexID, fileName, repeatorContent, date);
        }
    }

    void writeRecordToFile(final int neID, final int indexID, final int testType, final String fileName, final boolean isBaseLine, final boolean isSaved, final boolean isTmp, final boolean isComplete) {
        this.pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                TESLMFileDataMgr.this.log.info("MARINE ---- BEGIN to write record to file");
                TESLMFileDataMgr.this.log.info("MARINE ---- neID->" + neID);
                TESLMFileDataMgr.this.log.info("MARINE ---- indexID->" + indexID);
                TESLMFileDataMgr.this.log.info("MARINE ---- testType->" + testType);
                TESLMFileDataMgr.this.log.info("MARINE ---- fileName->" + fileName);
                TESLMFileDataMgr.this.log.info("MARINE ---- isBaseLine->" + isBaseLine);
                TESLMFileDataMgr.this.log.info("MARINE ---- isSaved->" + isSaved);
                TESLMFileDataMgr.this.log.info("MARINE ---- isTmp->" + isTmp);
                TESLMFileDataMgr.this.log.info("MARINE ---- isComplete->" + isComplete);
                Object object = lock = TESLMFileDataMgr.this.acquireTestFileRecordWriteLock(neID);
                synchronized (object) {
                    TESLMOTDRXMLUtil.addTestRecordFileNameNode(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
                }
                TESLMFileDataMgr.this.log.info("MARINE ---- END to write record to file");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getHistoryTestRecord(int neID, int indexID, int testMode) {
        this.log.info("MARINE ---- BEGIN to get history test record");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- testMode->" + testMode);
        ArrayList<String> resultList = new ArrayList();
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null != neData) {
                resultList = neData.getHistoryTestRecord(indexID, testMode);
            }
        }
        this.log.info("MARINE ---- END to get history test record. resultList->" + resultList);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getUnsavedTestRecord(int neID, int indexID) {
        this.log.info("MARINE ---- BEGIN to get unsaved test record");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        ArrayList<String> resultList = new ArrayList();
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null != neData) {
                resultList = neData.getUnsavedTestRecord(indexID);
            }
        }
        this.log.info("MARINE ---- END to get unsaved test record. resultList->" + resultList);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBaseLine(int neID, int indexID, int testMode) {
        this.log.info("MARINE ---- BEGIN to delete base line.");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- testMode->" + testMode);
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                return;
            }
            neData.deleteBaseLine(indexID, testMode);
        }
        this.log.info("MARINE ---- END to delete base line.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBaseLine(int neID, int indexID, int testMode, String fileName) {
        this.log.info("MARINE ---- BEGIN to UPDATE base line.");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        this.log.info("MARINE ---- testMode->" + testMode);
        this.log.info("MARINE ---- fileName->" + fileName);
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                neData = new TESLMNEFileData(neID);
                this.testRecordMap.put(neID, (Object)neData);
            }
            neData.updateBaseLine(indexID, testMode, fileName);
        }
        this.writeRecordToFile(neID, indexID, 4, fileName, true, true, false, true);
        this.log.info("MARINE ---- END to UPDATE base line.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getBaseLineFileName(int neID, int indexID, int testMode) {
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                return null;
            }
            return neData.getBaseLineName(indexID, testMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeTestRecordSaved(int neID, int indexID, int testMode, String fileName) {
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null != neData) {
                neData.makeTestRecordSaved(indexID, testMode, fileName);
            }
        }
    }

    private void initRecord() {
        this.log.info("MARINE ---- begin to init test record");
        this.initTestFileRecord();
        this.initRepeatorInfo();
        this.log.info("MARINE ---- end to init test record");
    }

    private void initRepeatorInfo() {
        this.log.info("MARINE ---- BEGIN to initialize repeater info");
        if (null != this.repeatorInfoMap) {
            return;
        }
        this.repeatorInfoMap = new TIntObjectHashMap();
        String file = TESLMConstants.REPEATORRECORD_ABSTRACT_FILEPATH;
        Document doc = TESLMOTDRXMLUtil.parseFile(file);
        if (null == doc) {
            this.log.info("MARINE ---- failed to parse repeater file.");
            return;
        }
        NodeList repeatorNodeList = doc.getDocumentElement().getChildNodes();
        int infoCount = repeatorNodeList.getLength();
        for (int i = 0; i < infoCount; ++i) {
            Node repeatorChildNode = repeatorNodeList.item(i);
            Element repeatorChildElement = null;
            if (1 != repeatorChildNode.getNodeType()) continue;
            repeatorChildElement = (Element)repeatorChildNode;
            this.processRepeatorElement(repeatorChildElement);
        }
        this.log.info("MARINE ---- END to initialize repeater info");
    }

    private void processRepeatorElement(Element element) {
        NodeList childNodeList = element.getChildNodes();
        HashMap<String, String> atrrMap = new HashMap<String, String>();
        int ksize = childNodeList.getLength();
        for (int k = 0; k < ksize; ++k) {
            Node childNode = childNodeList.item(k);
            Element childElement = null;
            if (1 != childNode.getNodeType()) continue;
            childElement = (Element)childNode;
            String nodeName = childElement.getNodeName();
            String nodeValue = childElement.getAttribute(VALUE_ATTR);
            atrrMap.put(nodeName, nodeValue);
        }
        int neID = Integer.parseInt(atrrMap.get(NEID_STR).toString());
        int indexID = Integer.parseInt(atrrMap.get(INDEXID_STR).toString());
        int repeatorID = Integer.parseInt(atrrMap.get(REPEATORID_STR).toString());
        String date = atrrMap.get(DATE_STR).toString();
        String gain = atrrMap.get(GAIN_STR).toString();
        this.addRepeatorGainInfo0(neID, indexID, repeatorID, date, gain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepeatorGainInfo0(int neID, int indexID, int repeatorID, String date, String gain) {
        TIntObjectHashMap<TESLMNERepeatorInfo> tIntObjectHashMap = this.repeatorInfoMap;
        synchronized (tIntObjectHashMap) {
            TESLMNERepeatorInfo neInfo = (TESLMNERepeatorInfo)this.repeatorInfoMap.get(neID);
            if (null == neInfo) {
                neInfo = new TESLMNERepeatorInfo(neID);
                this.repeatorInfoMap.put(neID, (Object)neInfo);
            }
            neInfo.addRepeatorGainInfo(indexID, repeatorID, date, gain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delRepeatorGainInfo0(int neID, int indexID, String date) {
        TIntObjectHashMap<TESLMNERepeatorInfo> tIntObjectHashMap = this.repeatorInfoMap;
        synchronized (tIntObjectHashMap) {
            TESLMNERepeatorInfo neInfo = (TESLMNERepeatorInfo)this.repeatorInfoMap.get(neID);
            if (null != neInfo) {
                neInfo.delRepeatorGainInfo(indexID, date);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delRepeatorGainInfo0(int neID, int indexID) {
        TIntObjectHashMap<TESLMNERepeatorInfo> tIntObjectHashMap = this.repeatorInfoMap;
        synchronized (tIntObjectHashMap) {
            TESLMNERepeatorInfo neInfo = (TESLMNERepeatorInfo)this.repeatorInfoMap.get(neID);
            if (null != neInfo) {
                neInfo.delRepeatorGainInfo(indexID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delRepeatorGainInfo0(int neID) {
        TIntObjectHashMap<TESLMNERepeatorInfo> tIntObjectHashMap = this.repeatorInfoMap;
        synchronized (tIntObjectHashMap) {
            this.repeatorInfoMap.remove(neID);
        }
    }

    void addRepeatorGainInfo(int neID, int indexID, int repeatorID, String date, String gain) {
        this.addRepeatorGainInfo0(neID, indexID, repeatorID, date, gain);
        this.writeRepeatorInfoToFile(neID, indexID, repeatorID, date, gain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRepeatorInfoToFile(int neID, int indexID, int repeatorID, String date, String gain) {
        Object object = this.repeatorWriteMutex;
        synchronized (object) {
            TESLMOTDRXMLUtil.writeRepeatorInfoToFile(neID, indexID, repeatorID, date, gain);
        }
    }

    private void initTestFileRecord() {
        this.log.info("MARINE ---- BEGIN to initialize TEST RECORD info");
        if (null != this.testRecordMap && null != this.tmpRecordMap) {
            return;
        }
        this.testRecordMap = new TIntObjectHashMap();
        this.tmpRecordMap = new HashMap<TESLMOTDRLMIData, List<TESLMTestFile>>();
        this.loadAllLineTestFileRecord();
        this.log.info("MARINE ---- END to initialize TEST RECORD info");
    }

    private void loadAllLineTestFileRecord() {
        String dirPath = TESLMConstants.TESTRECORD_ABSTRACT_FILEPATH;
        File dir = new File(dirPath);
        if (!dir.exists()) {
            try {
                if (!dir.mkdirs()) {
                    this.log.error("MARINE ---- Create testrecord file dir failed! testrecord dirPath ->" + dirPath);
                }
            }
            catch (Exception e) {
                this.log.error("MARINE ---- Create testrecord file dir failed! testrecord dir->" + dir.getAbsolutePath());
            }
            this.log.info("MARINE ---- testrecord file dir not exists..." + dirPath);
            return;
        }
        if (!dir.exists()) {
            this.log.info("MARINE ---- testrecord file dir not exists..." + dirPath);
            return;
        }
        this.recursionLoadAllLineTestFileRecord(dir);
    }

    private void recursionLoadAllLineTestFileRecord(final File file) {
        if (!file.exists()) {
            this.log.info("MARINE ---- testrecord file isnot exists..." + file);
            return;
        }
        if (file.isDirectory()) {
            File[] fs;
            for (File oneFile : fs = file.listFiles()) {
                this.recursionLoadAllLineTestFileRecord(oneFile);
            }
        } else if (file.getName().lastIndexOf(".xml") > 0) {
            this.log.info("MARINE ---- testrecord file loading..." + file);
            this.pool.execute(new Runnable(){

                @Override
                public void run() {
                    TESLMFileDataMgr.this.loadOneNETestFileRecord(file);
                }
            });
        } else {
            this.log.info("MARINE ---- testrecord file isnot xml type..." + file);
            return;
        }
    }

    private void loadOneNETestFileRecord(File oneFile) {
        String file = oneFile.getAbsolutePath();
        Document doc = TESLMOTDRXMLUtil.parseFile(file);
        if (null == doc) {
            this.log.info("MARINE ---- FAILED to parse test record file. fileName->" + file);
            return;
        }
        NodeList fileNodeList = doc.getDocumentElement().getChildNodes();
        int fileCount = fileNodeList.getLength();
        for (int i = 0; i < fileCount; ++i) {
            Node fileChildNode = fileNodeList.item(i);
            Element fileChildElement = null;
            if (1 != fileChildNode.getNodeType()) continue;
            fileChildElement = (Element)fileChildNode;
            this.processFileNode(fileChildElement);
        }
    }

    public static void main(String[] args) {
    }

    private void processFileNode(Element ele) {
        String fileName = ele.getAttribute(FILE_NAME_ATTR);
        NodeList childNodeList = ele.getChildNodes();
        HashMap<String, String> atrrMap = new HashMap<String, String>();
        int ksize = childNodeList.getLength();
        for (int k = 0; k < ksize; ++k) {
            Node childNode = childNodeList.item(k);
            Element childElement = null;
            if (1 != childNode.getNodeType()) continue;
            childElement = (Element)childNode;
            String nodeName = childElement.getNodeName();
            String nodeValue = childElement.getAttribute(VALUE_ATTR);
            atrrMap.put(nodeName, nodeValue);
        }
        int neID = Integer.parseInt(atrrMap.get(NEID_STR).toString());
        int indexID = Integer.parseInt(atrrMap.get(INDEXID_STR).toString());
        int testType = Integer.parseInt(atrrMap.get(TESTTYPE_STR).toString());
        boolean isTmp = TRUESTR.equals(atrrMap.get(ISTMP_STR));
        boolean isSaved = TRUESTR.equals(atrrMap.get(ISSAVED_STR));
        boolean isComplete = TRUESTR.equals(atrrMap.get(ISCOMPLETE_STR));
        boolean isBaseLine = TRUESTR.equals(atrrMap.get(ISBASELINE_STR));
        if (isTmp) {
            this.initOneTmpRecord(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
        } else {
            this.addTestRecord0(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTestRecord0(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMTestFile file = this.processFileName(fileName);
            file.setTestType(testType);
            file.setIndexID(indexID);
            file.setBaseLIne(isBaseLine);
            file.setTmp(isTmp);
            file.setSaved(isSaved);
            file.setComplete(isComplete);
            file.setNeID(neID);
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                neData = new TESLMNEFileData(neID);
                this.testRecordMap.put(neID, (Object)neData);
            }
            String path = TESLMOTDRDataMgr.getAbstractPath(neID);
            String absPath = path + fileName;
            this.addFileInDiskLock(absPath);
            return neData.addTestRecord(indexID, file);
        }
    }

    private TESLMTestFile processFileName(String fileName) {
        String fileNameTmp = fileName.substring(0, fileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split(FILE_SPLIT_STR);
        int length = propArray.length;
        int indexID = Integer.parseInt(propArray[0]);
        int testMode = Integer.parseInt(propArray[1]);
        int lmiNEID = Integer.parseInt(propArray[2]);
        int lmiSlotID = Integer.parseInt(propArray[3]);
        int lmiPortID = Integer.parseInt(propArray[4]);
        String date = propArray[5];
        boolean isBaseLine = length > 5;
        TESLMTestFile file = new TESLMTestFile(isBaseLine, fileName);
        file.setIndexID(indexID);
        file.setTestMode(testMode);
        TESLMOTDRLMIData lmiPort = new TESLMOTDRLMIData(lmiNEID, lmiSlotID, lmiPortID);
        file.setLmiPort(lmiPort);
        file.setDate(date);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOneTmpRecord(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        Map<TESLMOTDRLMIData, List<TESLMTestFile>> map = this.tmpRecordMap;
        synchronized (map) {
            TESLMTestFile file = this.processFileName(fileName);
            file.setTestType(testType);
            file.setIndexID(indexID);
            file.setBaseLIne(isBaseLine);
            file.setTmp(isTmp);
            file.setSaved(isSaved);
            file.setComplete(isComplete);
            file.setNeID(neID);
            TESLMOTDRLMIData port = file.getLmiPort();
            List<TESLMTestFile> fileList = this.tmpRecordMap.get(port);
            if (null == fileList) {
                fileList = new ArrayList<TESLMTestFile>();
                this.tmpRecordMap.put(port, fileList);
            }
            if (!fileList.contains(file)) {
                fileList.add(file);
            }
            String path = TESLMOTDRDataMgr.getAbstractPath(neID);
            String absPath = path + fileName;
            this.addFileInDiskLock(absPath);
        }
    }

    void makeTmpFile(int neID, int indexID, int testType, String fileName, boolean isBaseLine, boolean isSaved, boolean isTmp, boolean isComplete) {
        this.initOneTmpRecord(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
        this.refreshFileProperty(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fileExists(int neID, int indexID, String fileName) {
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            TESLMNEFileData neData = (TESLMNEFileData)this.testRecordMap.get(neID);
            if (null == neData) {
                return false;
            }
            return neData.fileExists(indexID, fileName);
        }
    }

    void refreshFileProperty(final int neID, final int indexID, final int testType, final String fileName, final boolean isBaseLine, final boolean isSaved, final boolean isTmp, final boolean isComplete) {
        this.pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = lock = TESLMFileDataMgr.this.acquireTestFileRecordWriteLock(neID);
                synchronized (object) {
                    TESLMOTDRXMLUtil.refreshTestRecordFileProperty(neID, indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String loadRepeatorGainInfo(int neID, int lineID, int testMode, int repeatorID) {
        TIntObjectHashMap<TESLMNERepeatorInfo> tIntObjectHashMap = this.repeatorInfoMap;
        synchronized (tIntObjectHashMap) {
            TESLMNERepeatorInfo neInfo = (TESLMNERepeatorInfo)this.repeatorInfoMap.get(neID);
            if (null == neInfo) {
                return null;
            }
            return neInfo.loadRepeatorGainInfo(lineID, testMode, repeatorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAfterDeleteLmiBoard(int neID, int slotID, int boardType) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        Map<TESLMOTDRLMIData, List<TESLMTestFile>> map = this.tmpRecordMap;
        synchronized (map) {
            Set<TESLMOTDRLMIData> keySet = this.tmpRecordMap.keySet();
            for (TESLMOTDRLMIData lmiPort : keySet) {
                if (lmiPort.getNeID() != neID || lmiPort.getSlotID() != slotID) continue;
                fileNameList.addAll(this.tmpRecordMap.get(lmiPort));
                this.tmpRecordMap.remove(lmiPort);
            }
        }
        this.deleteRecordFromFile(neID, fileNameList);
        int size = fileNameList.size();
        for (int i = 0; i < size; ++i) {
            String fileName = ((TESLMTestFile)fileNameList.get(i)).getFileName();
            this.deleteFile(neID, fileName);
        }
    }

    void doAfterDeleteNE(int neID) {
        this.deleteTestRecord(neID);
        this.deleteUploadResult(neID);
        this.removeTestFileRecordWriteLock(neID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepeaterIDInfo(int neID, int lineID) {
        TIntObjectHashMap<TESLMNERepeatorInfo> tIntObjectHashMap = this.repeatorInfoMap;
        synchronized (tIntObjectHashMap) {
            TESLMNERepeatorInfo neInfo = (TESLMNERepeatorInfo)this.repeatorInfoMap.get(neID);
            if (null == neInfo) {
                return null;
            }
            return neInfo.getRepeaterIDInfo(lineID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNEFileData(int realNEID, TIntArrayList lineList) {
        int[] idData;
        TESLMNEFileData neData = null;
        TIntObjectHashMap<TESLMNEFileData> tIntObjectHashMap = this.testRecordMap;
        synchronized (tIntObjectHashMap) {
            neData = (TESLMNEFileData)this.testRecordMap.get(realNEID);
            if (null == neData) {
                return;
            }
        }
        for (int indexID : idData = neData.getLineIDData()) {
            if (lineList.contains(indexID)) continue;
            this.deleteTestRecord(realNEID, indexID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeLine(int realNEID, int indexID, int lmiNEID, int lmiSlotID, int lmiPortID) {
        Map<TESLMOTDRLMIData, List<TESLMTestFile>> map = this.tmpRecordMap;
        synchronized (map) {
            TESLMOTDRLMIData lmiPort = new TESLMOTDRLMIData(realNEID, lmiSlotID, lmiPortID);
            List<TESLMTestFile> fileList = this.tmpRecordMap.get(lmiPort);
            Iterator<TESLMTestFile> iter = fileList.iterator();
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (int i = fileList.size() - 1; i >= 0; --i) {
                File tfile;
                TESLMTestFile file = fileList.get(i);
                if (file.getNeID() != realNEID || (tfile = new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + file.getFileName())).exists()) continue;
                fileList.remove(i);
                this.deleteRecordFromFile(file.getNeID(), indexID, file.getFileName());
            }
            while (iter.hasNext()) {
                TESLMTestFile file = iter.next();
                if (file.getNeID() != realNEID || file.isBaseLIne()) continue;
                String fileName = file.getFileName();
                fileNameList.add(fileName);
                iter.remove();
                String newFileName = indexID + fileName.substring(1);
                File tfile = new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + file.getFileName());
                try {
                    if (!tfile.renameTo(new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + newFileName))) continue;
                    this.deleteRecordFromFile(file.getNeID(), indexID, fileName);
                    this.addTestRecord(realNEID, indexID, file.getTestType(), newFileName, file.isBaseLIne(), file.isSaved(), false, file.isComplete());
                }
                catch (Exception e) {
                    this.log.error("MARINE ---- Rename testrecord file failed! testrecord dir->" + tfile.getAbsolutePath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnactivedFileList(int realNEID, int lmiNEID, int lmiSlotID, int lmiPortID) {
        Map<TESLMOTDRLMIData, List<TESLMTestFile>> map = this.tmpRecordMap;
        synchronized (map) {
            boolean hasInSevBaseLine = false;
            boolean hasOutSevBaseLine = false;
            boolean hasSingleTest = false;
            boolean hasManualTest = false;
            TESLMOTDRLMIData lmiPort = new TESLMOTDRLMIData(realNEID, lmiSlotID, lmiPortID);
            List<TESLMTestFile> fileList = this.tmpRecordMap.get(lmiPort);
            ArrayList<TESLMTestFile> targetList = new ArrayList<TESLMTestFile>();
            if (null == fileList || fileList.isEmpty()) {
                return targetList;
            }
            Iterator<TESLMTestFile> iter = fileList.iterator();
            int peroNum = 0;
            while (iter.hasNext() && targetList.size() <= 10) {
                TESLMTestFile file = iter.next();
                if (file.getNeID() != realNEID) continue;
                if (1 == file.getTestMode()) {
                    if (!hasInSevBaseLine && file.isBaseLIne()) {
                        targetList.add(file);
                        hasInSevBaseLine = true;
                        continue;
                    }
                    if (!hasSingleTest && 1 == file.getTestType()) {
                        targetList.add(file);
                        hasSingleTest = true;
                        continue;
                    }
                    if (!hasManualTest && 2 == file.getTestType()) {
                        targetList.add(file);
                        hasManualTest = true;
                        continue;
                    }
                    if (peroNum >= 6 || 3 != file.getTestType()) continue;
                    targetList.add(file);
                    ++peroNum;
                    continue;
                }
                if (2 != file.getTestMode() || hasOutSevBaseLine || !file.isBaseLIne()) continue;
                targetList.add(file);
                hasOutSevBaseLine = true;
            }
            return targetList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupBaseLineAfterActiveOp(int realNEID, int indexID, TESLMTestFile file) {
        Map<TESLMOTDRLMIData, List<TESLMTestFile>> map = this.tmpRecordMap;
        synchronized (map) {
            TESLMOTDRLMIData lmiPort = file.getLmiPort();
            List<TESLMTestFile> fileList = this.tmpRecordMap.get(lmiPort);
            fileList.remove(file);
            String fileName = file.getFileName();
            int index = fileName.lastIndexOf(".");
            String fileSuffix = fileName.substring(index + 1);
            String newFileName = fileName.substring(0, index) + "backup" + "." + fileSuffix;
            File tFile = new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + fileName);
            try {
                if (!tFile.renameTo(new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + newFileName))) {
                    this.log.error("MARINE ---- Rename testrecord file failed! testrecord dir->" + tFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                this.log.error("MARINE ---- Rename testrecord file failed! testrecord dir->" + tFile.getAbsolutePath());
            }
            this.deleteRecordFromFile(file.getNeID(), indexID, fileName);
        }
    }

    public void updateBaseLineAfterActiveOp(int realNEID, int indexID, TESLMTestFile file) {
        String fileName = file.getFileName();
        String newFileName = indexID + fileName.substring(1);
        File tfile = new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + file.getFileName());
        try {
            if (!tfile.renameTo(new File(TESLMOTDRDataMgr.getAbstractPath(realNEID) + newFileName))) {
                this.log.error("MARINE ---- Rename testrecord file failed! testrecord dir->" + tfile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.log.error("MARINE ---- Rename testrecord file failed! testrecord dir->" + tfile.getAbsolutePath());
        }
        this.deleteRecordFromFile(file.getNeID(), indexID, fileName);
        this.updateBaseLine(realNEID, indexID, file.getTestMode(), newFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordUploadResult(int neID, int indexID, int testMode, List errList) {
        Map map = this.uploadRecordMap;
        synchronized (map) {
            Integer indexInt;
            HashMap<Integer, List> indexMap;
            Integer neInt = neID;
            HashMap neMap = (HashMap)this.uploadRecordMap.get(neInt);
            if (null == neMap) {
                neMap = new HashMap();
                this.uploadRecordMap.put(neInt, neMap);
            }
            if (null == (indexMap = (HashMap<Integer, List>)neMap.get(indexInt = Integer.valueOf(indexID)))) {
                indexMap = new HashMap<Integer, List>();
                neMap.put(indexInt, indexMap);
            }
            Integer testModeInt = testMode;
            indexMap.put(testModeInt, errList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getUploadResult(int neID, int indexID, int testMode) {
        Map map = this.uploadRecordMap;
        synchronized (map) {
            Integer neInt = neID;
            Map neMap = (Map)this.uploadRecordMap.get(neInt);
            if (null == neMap) {
                return null;
            }
            Integer indexInt = indexID;
            Map indexMap = (Map)neMap.get(indexInt);
            if (null == indexMap) {
                return null;
            }
            Integer testModeInt = testMode;
            return indexMap.get(testModeInt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUploadResult(int neID) {
        Map map = this.uploadRecordMap;
        synchronized (map) {
            Integer neInt = neID;
            Map neMap = (Map)this.uploadRecordMap.get(neInt);
            if (null == neMap) {
                return;
            }
            neMap.clear();
            this.uploadRecordMap.remove(neInt);
        }
    }

    private static int getTestMode(String fileName) {
        String fileNameTmp = fileName;
        int dotIndex = fileNameTmp.lastIndexOf(".");
        fileNameTmp = fileNameTmp.substring(0, dotIndex);
        String testMode = null;
        String[] fileAttr = (fileNameTmp = fileNameTmp.substring(0, dotIndex)).split(FILE_SPLIT_STR);
        testMode = fileAttr[1];
        if (testMode.equalsIgnoreCase(TRUESTR)) {
            return 1;
        }
        return 2;
    }

    public void clear() {
        this.pool.shutdownNow();
    }
}

