/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1marine.reportform;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Vector;

public class TENESaveBdDetailBean
extends TETL1NEExplorerBean {
    TENE ne;
    private String neName = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.ne = TENEListUtils.getNEObj((int)neid);
            if (this.ne.getLogStatus() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
                return this.outputData;
            }
            this.getBdDetailData();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void getBdDetailData() {
        this.outputData.setBussinessParams(new BussinessParams());
        Vector boardList = this.ne.getBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            RowParams rowParam = new RowParams();
            TEBoard boardInfo = (TEBoard)boardList.get(i);
            rowParam.addParam("bdDetailInfo", this.getBdDetailInfo(boardInfo, this.ne));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
    }

    private String getBdDetailInfo(TEBoard boardInfo, TENE ne) {
        if (null == ne || null == boardInfo) {
            return "";
        }
        StringBuilder detail = new StringBuilder();
        detail.append("[NE:" + ne.getNEName() + "]" + "\r\n");
        detail.append("[Board:");
        detail.append(ne.getNEName() + "-");
        detail.append(boardInfo.getSlotID() + "-");
        detail.append(boardInfo.getBoardName());
        detail.append("]\r\n");
        detail.append("[Main_Board]\r\n");
        detail.append("[Board Properties]\r\n");
        detail.append("BoardType=" + boardInfo.getBoardType() + "\r\n");
        detail.append("BarCode=\r\n");
        detail.append("Item=\r\n");
        detail.append("Description=\r\n");
        detail.append("Manufactured=\r\n");
        detail.append("VendorName=\r\n");
        detail.append("IssueNumber=\r\n");
        detail.append("CLEICode=\r\n");
        detail.append("BOM=\r\n");
        detail.append("---------------------------------------------------------------------------------------------------");
        return detail.toString();
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc) {
        int i;
        ArrayList errorDataList = new ArrayList();
        RowParams rowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList<String> boardDetailList = new ArrayList<String>();
        int n = tl1OperList.size();
        for (i = 0; i < n; ++i) {
            boolean flag = true;
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            for (OutMsg out : tl1Operation.getOutMsg()) {
                if (out.getFault().getCompletionCode() == 0) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            boardDetailList.add(tl1Operation.getStrTL1Info());
        }
        n = boardDetailList.size();
        for (i = 0; i < n; ++i) {
            String boardDetail = (String)boardDetailList.get(i);
            boardDetail = boardDetail.replaceAll("\\>", "");
            boardDetail = boardDetail.replaceAll("\\\\\"\"", "");
            boardDetail = boardDetail.replaceAll("\"\\\\\"", "");
            boardDetail = boardDetail.replaceAll("\\/\\$", "");
            boardDetail = boardDetail + "\r\n---------------------------------------------------------------------------------------------------\r\n";
            rowparams = new RowParams();
            rowparams.addParam(new Param("boardDetail", boardDetail));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (errorDataList.size() != 0) {
            this.outputData.setBussinessParams(new BussinessParams());
            rowparams = new RowParams();
            int y = errorDataList.size();
            for (int x = 0; x < y; ++x) {
                rowparams.addRowErrors((RowErrors)errorDataList.get(x));
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

