/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1marine.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.performance.TEPerformModel;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;

public class TEPfmCommonBean
extends TENEExplorerBean {
    private int slotid = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.slotid = this.getSlotID(inputData);
        if (subFunc.getCode() == 0x201021) {
            return this.getPfmMonObjIDs();
        }
        if (subFunc.getCode() == 2101283) {
            return this.getCpSupportEvents();
        }
        if (subFunc.getCode() == 2101284) {
            return this.getCpSupportEventType();
        }
        return null;
    }

    private Datainterface getPfmMonObjIDs() {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        TEPerformModel model = TEPfmUtility.getPfmModel((int)this.neid, (int)this.slotid);
        ArrayList pfmMonObjIDs = model.getPfmMonObjIDList(this.slotid);
        Collections.sort(pfmMonObjIDs);
        int size = pfmMonObjIDs.size();
        for (int i = 0; i < size; ++i) {
            TEPfmMonObjID monObjID = (TEPfmMonObjID)pfmMonObjIDs.get(i);
            RowParams rowParam = new RowParams();
            Param[] params = monObjID.toRowParams();
            for (int j = 0; j < params.length; ++j) {
                rowParam.addParam(params[j]);
            }
            outputData.getBussinessParams().addRowParams(rowParam);
        }
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return outputData;
    }

    private Datainterface getCpSupportEventType() {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotid);
        ArrayList cpSupPfmEventList = TETL1PfmConfigDataMgr.getInstance().getCPSupportEventType(boardType);
        RowParams rowParam = new RowParams();
        rowParam.addParam("fbType", String.valueOf(0));
        rowParam.addParam("eventType", TEPfmUtility.getStringFromSequenceOfInt((ArrayList)cpSupPfmEventList));
        outputData.getBussinessParams().addRowParams(rowParam);
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return outputData;
    }

    private Datainterface getCpSupportEvents() {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        TEPerformModel model = TEPfmUtility.getPfmModel((int)this.neid, (int)this.slotid);
        RowParams rowParam = null;
        ArrayList eventList = model.getEventList();
        int size = eventList.size();
        for (int i = 0; i < size; ++i) {
            rowParam = new RowParams();
            Integer tmp = (Integer)eventList.get(i);
            TEPfmBsEvent event = model.getPfmBsEvent(tmp.intValue());
            if (null == event) continue;
            rowParam.addParam("peid", String.valueOf(event.m_usEventID));
            rowParam.addParam("m_dMinThr15mLow", String.valueOf((int)event.m_dMinThr15mLow));
            rowParam.addParam("m_dMaxThr15mLow", String.valueOf((int)event.m_dMaxThr15mLow));
            rowParam.addParam("m_dMinThr15mHigh", String.valueOf((int)event.m_dMinThr15mHigh));
            rowParam.addParam("m_dMaxThr15mHigh", String.valueOf((int)event.m_dMaxThr15mHigh));
            rowParam.addParam("m_dMinThr24h", String.valueOf((int)event.m_dMinThr24h));
            rowParam.addParam("m_dMaxThr24h", String.valueOf((int)event.m_dMaxThr24h));
            rowParam.addParam("m_dDefThr15mLow", String.valueOf((int)event.m_dDefThr15mLow));
            rowParam.addParam("m_dDefThr15mHigh", String.valueOf((int)event.m_dDefThr15mHigh));
            rowParam.addParam("m_dDefThr24h", String.valueOf((int)event.m_dDefThr24h));
            outputData.getBussinessParams().addRowParams(rowParam);
        }
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return outputData;
    }

    private int getSlotID(Datainterface inputData) {
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int tmp = -1;
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase("slotid")) continue;
            try {
                tmp = Integer.parseInt(paramArr[i].getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Get slotid fail:\n", (Throwable)e);
                return -1;
            }
            return tmp;
        }
        return -1;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

