/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1marine.performance;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nemgr.tl1necommon.performance.TEPfmUtility;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;

public class TEPfmBoardRegResetBean
extends TETL1NEExplorerBean {
    private static final String CURRENT_TIME_15_MIN = "1";
    private static final String CURRENT_TIME_1_DAY = "2";
    private static final String HISTORY_TIME_15_MIN = "3";
    private static final String HISTORY_TIME_1_DAY = "4";
    private String regType;

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                String port = rowparams.getParam("portID").getValue();
                String slot = rowparams.getParam("slotID").getValue();
                if (port.equals("-2")) {
                    String monListArr = rowparams.getParam("ObjListStr").getValue();
                    ArrayList fbList = TEPfmUtility.constructPfmMonObj((String)monListArr);
                    Collections.sort(fbList);
                    if (fbList == null || fbList.size() == 0) continue;
                    int len = fbList.size();
                    for (int j = 0; j < len; ++j) {
                        if (null == tl1Operation) continue;
                        TL1Operation operation = (TL1Operation)tl1Operation.clone();
                        TETL1PfmMonObjID fbobj = (TETL1PfmMonObjID)fbList.get(j);
                        String mod2 = fbobj.mod2Name;
                        TETL1CommonUtil.modifyMOD2((TL1Operation)operation, (String)mod2);
                        inputMsg = operation.getInMsg();
                        if (null == inputMsg) {
                            tl1OperList.add(operation);
                            continue;
                        }
                        String aid = this.getAIDFromalmFB(Integer.parseInt(slot), fbobj);
                        fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock(), aid);
                        if (fillComplete) {
                            fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                        }
                        if (!this.msgBlockFlag && !fillComplete) continue;
                        tl1OperList.add(operation);
                    }
                    continue;
                }
                this.changeMod2(tl1Operation, rowparams);
                if (null == tl1Operation) continue;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock(), "");
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        return tl1OperList;
    }

    protected boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock, String aid) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (this.convertPartValue(part, rowparams, aid)) continue;
            if (null != part.getDefault()) {
                part.setValue(part.getDefault());
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int num = 0;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                if (!this.convertPartValue(part, rowparams, "")) {
                    if (null == part.getDefault()) continue;
                    part.setValue(part.getDefault());
                    continue;
                }
                ++num;
            }
        }
        if (num < 1) {
            flag = false;
        }
        return flag;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        int fbType = Integer.parseInt(rowparams.getParam("fbType").getValue());
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        String mod2 = fbDesc.getMOD2(fbType);
        if (mod2 == null) {
            mod2 = "ALL";
        }
        if (mod2.equals("")) {
            mod2 = "ALL";
        }
        tl1Operation.setMod2(mod2);
        tl1Operation.setName(tl1Operation.getCmdCode() + "-" + tl1Operation.getMod1() + "-" + mod2);
    }

    protected boolean convertPartValue(Part part, RowParams rowparams, String _aid) {
        if (part.getName().equalsIgnoreCase("AID")) {
            String slot = rowparams.getParam("slotID").getValue();
            String port = rowparams.getParam("portID").getValue();
            String path = rowparams.getParam("pathID").getValue();
            String aid = "";
            if (port.equals("-2")) {
                part.setValue(_aid);
            } else {
                aid = TETL1CommonUtil.getAIDFromPort((int)this.neid, (String)slot, (String)port, (String)path);
                part.setValue(aid);
            }
            return true;
        }
        if (part.getName().equalsIgnoreCase("MONTYPE")) {
            part.setValue("ALL");
            return true;
        }
        if (part.getName().equalsIgnoreCase("TMPER")) {
            Param tmperParam = rowparams.getParam("regtypes");
            if (null == tmperParam) {
                return false;
            }
            this.regType = tmperParam.getValue();
            if (this.regType.equals(CURRENT_TIME_15_MIN) || this.regType.equals(HISTORY_TIME_15_MIN)) {
                part.setValue("15-MIN");
            } else if (this.regType.equals(CURRENT_TIME_1_DAY) || this.regType.equals(HISTORY_TIME_1_DAY)) {
                part.setValue("1-DAY");
            }
            return true;
        }
        if (part.getName().equalsIgnoreCase("MONDAT")) {
            Param tmperParam = rowparams.getParam("regtypes");
            if (null == tmperParam) {
                return false;
            }
            this.regType = tmperParam.getValue();
            if (this.regType.equals(HISTORY_TIME_15_MIN) || this.regType.equals(HISTORY_TIME_1_DAY)) {
                part.setValue("01-01");
            } else {
                part.setValue("");
            }
            return true;
        }
        if (part.getName().equalsIgnoreCase("MONTM")) {
            Param tmperParam = rowparams.getParam("regtypes");
            if (null == tmperParam) {
                return false;
            }
            this.regType = tmperParam.getValue();
            if (this.regType.equals(HISTORY_TIME_15_MIN) || this.regType.equals(HISTORY_TIME_1_DAY)) {
                part.setValue("00-00");
            } else {
                part.setValue("");
            }
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    private String getAIDFromalmFB(int slotid, TETL1PfmMonObjID fbobj) {
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotid);
        String aidpre = TETL1CommonUtil.getAIDFrefix((int)this.neid, (int)fbobj.m_usSlotID, (int)fbobj.m_usPortID);
        int portNENo = TETL1CommonUtil.getAIDPortNo((int)this.neid, (int)fbobj.m_usSlotID, (int)fbobj.m_usPortID);
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        if (aidpre.equals("") && (aidpre = fbobj.aidPreFix).equals("")) {
            aidpre = fbDesc.getAIDPrefix(fbobj.m_usFBType);
        }
        if (fbobj.m_usPortID == 0) {
            return new StringBuffer().append("SLOT").append("-").append(neSlot).toString();
        }
        if (fbobj.m_usPathID == 0) {
            return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(portNENo).toString();
        }
        return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(portNENo).append("-").append(fbobj.m_usPathID).toString();
    }

    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        RowErrors rowerror = TEPfmUtility.handleRowError((OutMsg)output, (String)neObj.getNEName());
        return rowerror;
    }
}

