/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1marine.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nemgr.tl1necommon.performance.TEPfmUtility;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmComparator;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmFilter;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmRecord;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class TEHistoryPfmDataBean
extends TETL1NEExplorerBean {
    private TimeZoneDateBean TimeProccessor = null;
    ArrayList hisPfmList = new ArrayList();
    private static final String SORT_BY_COL = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_ASC = "asc";
    private static final String SORT_BY_DES = "des";
    private String sortby = "asc";
    private int sortCol = 1;
    ArrayList pfmMonObjIDs = new ArrayList();
    ArrayList eventList = new ArrayList();
    private int neID = 0;
    private int slotID = 0;
    private int period = 1;
    private static Datainterface output = null;
    private boolean ShowZeroData = false;
    private TETL1PfmMonObjID pfmmonobj = null;
    TEHisPfmFilter filter = null;
    private boolean isFalse = false;
    private boolean isTrue = false;
    private TETL1NE neObj = null;
    private String monObjStruct = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        this.TimeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neID);
        this.pfmmonobj = new TETL1PfmMonObjID();
        this.filter = new TEHisPfmFilter();
        this.subfunc = subFunc;
        this.cloneTL1OperationList = new ArrayList();
        this.neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        if (null != rowParams[0].getParam("filename")) {
            rowParams = output.getBussinessParams().getRowParams();
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                Param param = null;
                String value = "";
                param = rowParams[i].getParam("peValue");
                value = param.getValue();
                int index = value.indexOf(".");
                if (index > value.length() - 3) {
                    param.setValue(value + "0");
                }
                if (value.length() - index <= 3) continue;
                param.setValue(value.substring(0, index + 3));
            }
            return output;
        }
        PageParams pageParams = inputData.getPageParams();
        int size = pageParams.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageParams.getParam(i).getName().equals(SORT_BY_PARAM)) {
                this.sortby = pageParams.getParam(i).getValue();
                continue;
            }
            if (!pageParams.getParam(i).getName().equals(SORT_BY_COL)) continue;
            this.sortCol = Integer.parseInt(pageParams.getParam(i).getValue());
        }
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int len = rParams[0].getParam().length;
        for (int j = 0; j < len; ++j) {
            Calendar cal;
            Param[] params = rParams[0].getParam();
            long offset = 0L;
            Param offsetParam = rParams[0].getParam("offset");
            Param param = params[j];
            String pValue = param.getValue();
            if (TEPfmUtility.validateParam((Param)param, (String)"neID")) {
                this.pfmmonobj.m_ulNEID = Integer.parseInt(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"slotID")) {
                this.pfmmonobj.m_usSlotID = this.slotID = Integer.parseInt(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"fbType")) {
                this.pfmmonobj.m_usFBType = Integer.parseInt(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"portID")) {
                this.pfmmonobj.m_usPortID = Integer.parseInt(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"pathID")) {
                this.pfmmonobj.m_usPathID = Integer.parseInt(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"period")) {
                this.period = Integer.parseInt(pValue);
                this.filter.setPeriod(Integer.parseInt(pValue));
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"mainType")) {
                this.filter.setMainTypeList(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"extType")) {
                this.filter.setExtTypeList(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"subType")) {
                this.filter.setSubTypeList(pValue);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"beginTime")) {
                if (offsetParam != null && offsetParam.getValue() != null) {
                    offset = Long.parseLong(offsetParam.getValue());
                }
                cal = Calendar.getInstance();
                cal.setTimeInMillis(TEDateUtils.strToCalendar((String)pValue, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                cal = TEDateUtils.getTL1NETimeFromNMUTCTime((int)neid, (long)cal.getTimeInMillis());
                String startTime = TEDateUtils.calendarToStr((Calendar)cal);
                this.filter.setNeid(this.neID);
                this.filter.setOffset(offset);
                this.filter.setStartTime(startTime);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"endTime")) {
                if (offsetParam != null && offsetParam.getValue() != null) {
                    offset = Long.parseLong(offsetParam.getValue());
                }
                cal = Calendar.getInstance();
                cal.setTimeInMillis(TEDateUtils.strToCalendar((String)pValue, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                cal = TEDateUtils.getTL1NETimeFromNMUTCTime((int)neid, (long)cal.getTimeInMillis());
                String endTime = TEDateUtils.calendarToStr((Calendar)cal);
                this.filter.setEndTime(endTime);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"ZeroData")) {
                this.ShowZeroData = pValue.equalsIgnoreCase("true");
                if (!this.ShowZeroData) continue;
                this.TIME_OUT = 30;
                continue;
            }
            if (!TEPfmUtility.validateParam((Param)param, (String)"ObjListStr")) continue;
            this.monObjStruct = pValue;
        }
        this.filter.setPfmmonobj(this.pfmmonobj);
        if (this.pfmmonobj.m_usPortID == -2) {
            this.pfmMonObjIDs.add(this.pfmmonobj);
            this.filter.setFb(false);
        } else {
            this.filter.setFb(true);
        }
        output = this.queryHistoryPfmData(this.neID, this.pfmmonobj, this.filter);
        output.setErrorMessage(new ErrorMessage());
        if (this.isTrue && !this.isFalse) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        } else if (this.isTrue && this.isFalse) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)1));
        } else {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)2));
        }
        if (this.isNeedOperationlog()) {
            super.writeLog(this.neID, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return output;
    }

    public Datainterface queryHistoryPfmData(int neID, TETL1PfmMonObjID pfmmonobj, TEHisPfmFilter filter) {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.slotID);
        ArrayList pfmMonObjID = TEPfmUtility.constructPfmMonObj((String)this.monObjStruct);
        this.eventList = TETL1PfmConfigDataMgr.getInstance().getBoardSupportPfmIDList(boardType);
        if (pfmmonobj.m_usPortID == -2) {
            int size = pfmMonObjID.size();
            for (int i = 0; i < size; ++i) {
                TETL1PfmMonObjID pfmMonObj = (TETL1PfmMonObjID)pfmMonObjID.get(i);
                this.pfmMonObjIDs.add(pfmMonObj);
                ArrayList operationList = this.createQueryHisPfmDataRequest(this.period, pfmMonObj, filter);
                int result = this.sendMessage(neID, operationList);
                if (result != 0) {
                    output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    return output;
                }
                ArrayList eventList = this.convertHisPfmDataFromNE(neID, outputData, operationList, pfmMonObj, filter);
                this.hisPfmList.addAll(eventList);
            }
        } else {
            ArrayList operationList = this.createQueryHisPfmDataRequest(this.period, pfmmonobj, filter);
            int result = this.sendMessage(neID, operationList);
            if (result == 0) {
                ArrayList eventList = this.convertHisPfmDataFromNE(neID, outputData, operationList, pfmmonobj, filter);
                this.hisPfmList.addAll(eventList);
            } else {
                output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return output;
            }
        }
        TEHisPfmComparator pfmComparator = new TEHisPfmComparator();
        if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
            pfmComparator.setSortBy(1);
            pfmComparator.setcolSort(this.sortCol);
        } else {
            pfmComparator.setSortBy(0);
            pfmComparator.setcolSort(this.sortCol);
        }
        Collections.sort(this.hisPfmList, pfmComparator);
        RowParams[] rowparams = TEHistoryPfmDataBean.convertPfmDataToRowData(neID, this.hisPfmList, this.TimeProccessor);
        for (int k = 0; k < rowparams.length; ++k) {
            outputData.getBussinessParams().addRowParams(rowparams[k]);
        }
        return outputData;
    }

    private ArrayList convertHisPfmDataFromNE(int neID2, Datainterface outputData, ArrayList operationList, TETL1PfmMonObjID pfmMonObj2, TEHisPfmFilter filter2) {
        ArrayList<TEHisPfmRecord> temp = new ArrayList<TEHisPfmRecord>();
        TL1Operation operation = (TL1Operation)operationList.get(0);
        Date date = operation.getDate();
        int size = operation.getOutMsgCount();
        if (size == 0) {
            this.isTrue = true;
        }
        for (int i = 0; i < size; ++i) {
            OutMsg output = operation.getOutMsg(i);
            if (!output.getFault().getErrDesc().equals("")) {
                this.isFalse = true;
                operation.addCmdFault(output.getFault());
                RowErrors rowerror = TEPfmUtility.handleRowError((OutMsg)output, (String)this.neObj.getNEName());
                RowParams errrowparams = new RowParams();
                errrowparams.addRowErrors(rowerror);
                outputData.getBussinessParams().addRowParams(errrowparams);
                break;
            }
            this.isTrue = true;
            TEHisPfmRecord eventRecord = this.convertHisPfmDataFromNE(this.neID, output, this.filter, date);
            if (eventRecord == null || eventRecord.getPeid() == -1) continue;
            temp.add(eventRecord);
        }
        this.cloneTL1OperationList.add(operation.clone());
        return temp;
    }

    private ArrayList createQueryHisPfmDataRequest(int periodType, TETL1PfmMonObjID pfmmonobj, TEHisPfmFilter filter) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation operSour = definitions.getTL1Operation("RTRV-PM");
            TL1Operation tl1oper = (TL1Operation)operSour.clone();
            TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
            if (pfmmonobj.mod2Name.equals("")) {
                String mod2 = fbDesc.getMOD2(pfmmonobj.m_usFBType);
                if (mod2 == null || mod2.equals("")) {
                    tl1oper.setMod2("");
                } else {
                    tl1oper.setMod2(mod2);
                }
            } else {
                tl1oper.setMod2(pfmmonobj.mod2Name);
            }
            String name = tl1oper.getCmdCode() + "-" + tl1oper.getMod1() + "-" + tl1oper.getMod2();
            tl1oper.setName(name);
            InMsg inputMsg = tl1oper.getInMsg();
            StagBlock stagblock = inputMsg.getStagBlock();
            AID aid = stagblock.getAID();
            Part aidPart = aid.getPart(0);
            String newAid = this.getAIDFromalmFB(this.slotID, pfmmonobj);
            aidPart.setValue(newAid);
            MsgBlock msgblock = inputMsg.getMsgBlock();
            DataBlock dataBlock = null;
            Part partObj = null;
            int len = msgblock.getDataBlockCount();
            for (int j = 0; j < len; ++j) {
                dataBlock = msgblock.getDataBlock(j);
                int length = dataBlock.getPartCount();
                for (int k = 0; k < length; ++k) {
                    partObj = dataBlock.getPart(k);
                    this.convertPartValue(partObj, pfmmonobj, filter);
                }
            }
            operationList.add(tl1oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEHistoryPfmDataBean.createQueryHisPfmDataRequest() fail!", (Throwable)e);
        }
        return operationList;
    }

    private TEHisPfmRecord convertHisPfmDataFromNE(int neID, OutMsg output, TEHisPfmFilter filter, Date date) {
        HashMap partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        TEHisPfmRecord record = new TEHisPfmRecord();
        String aidType = "";
        String location = "";
        String direction = "";
        String startDate = "";
        String startTime = "";
        Part partObj = null;
        partObj = (Part)partMap.get("AID");
        if (partObj.getValue() == null) {
            return record;
        }
        String aid = partObj.getValue();
        int slotID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neID);
        record.getPfmmonobj().m_ulNEID = neID;
        record.getPfmmonobj().m_usSlotID = slotID;
        int portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid, (int)neID);
        int pathID = TETL1CommonUtil.getPathIDFromAidStruct((String)aid, (int)neID);
        if (-1 == portID) {
            portID = 0;
        }
        if (-1 == pathID) {
            pathID = 0;
        }
        record.getPfmmonobj().m_usPortID = portID;
        record.getPfmmonobj().m_usPathID = pathID;
        partObj = (Part)partMap.get("AIDTYPE");
        aidType = partObj.getValue();
        partObj = (Part)partMap.get("LOCN");
        location = partObj.getValue();
        partObj = (Part)partMap.get("DIRN");
        direction = partObj.getValue();
        if ("NA".equals(direction)) {
            direction = "ALL";
        }
        partObj = (Part)partMap.get("MONTYPE");
        TETL1PfmBsEvent event = TEPfmUtility.getPfmDataFromStatic((String)aidType, (int)TETL1FaultUtil.getTL1AlarmLocation((String)location), (int)TETL1FaultUtil.getTL1AlarmDirection((String)direction), (String)partObj.getValue());
        if (event == null) {
            return record;
        }
        record.setPeid(event.getEventID());
        record.setPeName(partObj.getValue() + "(" + event.getUnitName() + ")");
        record.setLocation(TETL1FaultUtil.converAlarmLocation((String)location));
        record.setDirection(TETL1FaultUtil.convertAlarmDirection((String)direction));
        record.getPfmmonobj().m_usFBType = event.getFbType();
        record.getPfmmonobj().mod2Name = aidType;
        partObj = (Part)partMap.get("TMPER");
        if (partObj.getValue().equals("15-MIN")) {
            record.setPeriod(1);
        } else {
            record.setPeriod(0);
        }
        partObj = (Part)partMap.get("MONDAT");
        startDate = partObj.getValue();
        String[] strdate = startDate.split("-");
        int month = Integer.parseInt(strdate[0]);
        int day = Integer.parseInt(strdate[1]);
        partObj = (Part)partMap.get("MONTM");
        startTime = partObj.getValue();
        String[] strtime = startTime.split("-");
        int hour = Integer.parseInt(strtime[0]);
        int minute = Integer.parseInt(strtime[1]);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1) - 1900;
        if (year < 1900) {
            year = cal.get(1);
        }
        Calendar calnew = Calendar.getInstance();
        calnew.set(year, month - 1, day, hour, minute, 0);
        record.setStartTime(TEDateUtils.calendarToStr((Calendar)calnew));
        record.setStartCal(calnew);
        partObj = (Part)partMap.get("MONVAL");
        record.setPeValue(Double.parseDouble(partObj.getValue()));
        partObj = (Part)partMap.get("VLDTY");
        record.setValidity(partObj.getValue());
        if (filter.filter(event, record, this.pfmMonObjIDs, this.eventList, true)) {
            return record;
        }
        return null;
    }

    private void convertPartValue(Part part, TETL1PfmMonObjID pfmmonobj2, TEHisPfmFilter filter2) {
        if (part.getName().equalsIgnoreCase("TMPER")) {
            int tmper = filter2.getPeriod();
            if (tmper == 1) {
                part.setValue("15-MIN");
            } else {
                part.setValue("1-DAY");
            }
        } else if (part.getName().equalsIgnoreCase("monlev")) {
            if (this.ShowZeroData) {
                part.setValue("0-UP");
            } else {
                part.setValue("");
            }
        } else if (part.getName().equalsIgnoreCase("mondat")) {
            Calendar cal = TEDateUtils.strToCalendar((String)filter2.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            cal.setTimeInMillis(cal.getTimeInMillis());
            String time = TEDateUtils.calendarToStr((Calendar)cal);
            part.setValue(this.convertStrDateTimeToDate(time));
        } else if (part.getName().equalsIgnoreCase("montm")) {
            Calendar cal = TEDateUtils.strToCalendar((String)filter2.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            cal.setTimeInMillis(cal.getTimeInMillis());
            String time = TEDateUtils.calendarToStr((Calendar)cal);
            part.setValue(this.convertStrDateTimeToTime(time));
        } else {
            part.setValue("");
        }
    }

    private String convertStrDateTimeToDate(String startTime) {
        String[] dateTime = startTime.split(" ");
        String[] date = dateTime[0].split("-");
        return date[1] + "-" + date[2];
    }

    private String convertStrDateTimeToTime(String startTime) {
        String[] dateTime = startTime.split(" ");
        String[] date = dateTime[1].split(":");
        return date[0] + "-" + date[1];
    }

    private String getAIDFromalmFB(int slotid, TETL1PfmMonObjID fbobj) {
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neID, (int)slotid);
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        String aidpre = TETL1CommonUtil.getAIDFrefix((int)this.neID, (int)fbobj.m_usSlotID, (int)fbobj.m_usPortID);
        int portNMNo = TETL1CommonUtil.getAIDPortNo((int)this.neID, (int)fbobj.m_usSlotID, (int)fbobj.m_usPortID);
        if (aidpre.equals("") && (aidpre = fbobj.aidPreFix).equals("")) {
            aidpre = fbDesc.getAIDPrefix(this.pfmmonobj.m_usFBType);
        }
        if (fbobj.m_usPortID == 0) {
            return new StringBuffer().append("SLOT").append("-").append(neSlot).toString();
        }
        if (fbobj.m_usPathID == 0) {
            return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(portNMNo).toString();
        }
        return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(portNMNo).append("-").append(fbobj.m_usPathID).toString();
    }

    public static RowParams[] convertPfmDataToRowData(int neID, ArrayList eventList, TimeZoneDateBean TimeProccessor) {
        RowParams[] rowparams = new RowParams[eventList.size()];
        for (int i = 0; i < eventList.size(); ++i) {
            TEHisPfmRecord record = (TEHisPfmRecord)eventList.get(i);
            rowparams[i] = new RowParams();
            rowparams[i].addParam("pfmMonObj", record.getPfmmonobj().toString());
            rowparams[i].addParam("peid", String.valueOf(record.getPeid()));
            rowparams[i].addParam("peName", record.getPeName());
            rowparams[i].addParam("location", record.getLocation());
            rowparams[i].addParam("direction", record.getDirection());
            String period = record.getPeriod() == 1 ? "15-MIN" : "1-DAY";
            rowparams[i].addParam("period", period);
            Calendar cal = TEDateUtils.strToCalendar((String)record.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            cal = TEDateUtils.getTL1NMTimeFromNETime((int)neID, (long)cal.getTimeInMillis());
            rowparams[i].addParam("beginTime", String.valueOf(cal.getTimeInMillis()));
            rowparams[i].addParam("peValue", String.valueOf(record.getPeValue()));
            rowparams[i].addParam("validity", record.getValidity());
        }
        return rowparams;
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

