/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1marine.config.neattribute;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1NELoginMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class TENEAttributeSetBean
extends TETL1NEExplorerBean {
    private static final int NE_NAME_EXISTED = 74005;
    private ArrayList operLogList = null;
    private boolean hasWirteLog = false;
    private static final int COMM_TCP = 1;
    private TETL1NE ne = null;

    public TENEAttributeSetBean() {
        this.msgBlockFlag = false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.operLogList = new ArrayList();
        this.neid = neid;
        this.curUser = user;
        this.curIpAddress = ipAddress;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        Datainterface outputData = new Datainterface();
        RowParams rParams = inputData.getBussinessParams().getRowParams(0);
        Param neNameParam = rParams.getParam("neName");
        if (neNameParam != null) {
            String neName = neNameParam.getValue();
            boolean neNameIsModify = rParams.getParam("neName").getModifyFlag();
            if (neNameIsModify) {
                if (this.isExistedNE(neid, neName)) {
                    ErrorMessage errorMessage = null;
                    errorMessage = new ErrorMessage();
                    errorMessage.setErrorcode(String.valueOf(74005));
                    errorMessage.setErrorinfo("NE Name has existed");
                    outputData.setErrorMessage(errorMessage);
                    return outputData;
                }
                if (this.sendModifyNeName(neName)) {
                    TELogFactory.getNormalLogger().debug("NE Name Changed.");
                    this.modifyNeListInfo(neid, outputData, neName);
                    TETL1NECommMgr.getInstance().putLogicNEIDName((long)neid, neName);
                } else {
                    TELogFactory.getNormalLogger().debug("NE Name Change Fail");
                    TETL1NECommMgr.getInstance().deleteTL1NEID((long)neid);
                    TETL1NECommMgr.getInstance().putLogicNEIDName((long)neid, neName);
                }
                this.printLog();
                this.hasWirteLog = true;
            }
        }
        Datainterface outputDataAll = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        Param ipParam = rParams.getParam("ip");
        if (ipParam != null) {
            String ipAddr = ipParam.getValue();
            String oldIP = this.ne.getNEGWAddress();
            boolean ipIsModify = rParams.getParam("ip").getModifyFlag();
            if (ipIsModify && !ipAddr.equals(oldIP)) {
                int port = Integer.parseInt(this.ne.getPort());
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("neGWAddress", ipAddr);
                boolean writeDocResult = true;
                writeDocResult = TEResourceManager.setNeListInfoNEKeys((String)TENEListMgr.NELIST_PATH, (int)neid, ht);
                if (!writeDocResult) {
                    outputDataAll.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
                } else {
                    outputDataAll.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                }
                this.ne.logout();
                TENECommMgr.getInstance().closeConnect((long)neid, port, oldIP, 1);
                TENEListUtils.getNEObj((int)neid).setNEGWAddress(ipAddr);
                CreateNewConnect newConnec = new CreateNewConnect(port, ipAddr);
                newConnec.start();
            }
        }
        return outputDataAll;
    }

    private boolean sendModifyNeName(String neName) {
        ArrayList tl1OperList = this.getSetSIDOperList(neName);
        if (null == tl1OperList || tl1OperList.size() == 0) {
            return false;
        }
        int result = this.sendMessage(this.neid, tl1OperList);
        if (result == 0) {
            TL1Operation tl1Opertion = (TL1Operation)tl1OperList.get(0);
            this.operLogList.add(tl1Opertion.clone());
            return true;
        }
        return false;
    }

    private ArrayList getSetSIDOperList(String neName) {
        try {
            this.operLogList.clear();
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation tl1Operation = tl1definitions.getTL1Operation("SET-SID");
            InMsg inputMsg = tl1Operation.getInMsg();
            inputMsg.getMsgBlock().getPart("SID").setValue(neName);
            ArrayList<TL1Operation> tl1List = new ArrayList<TL1Operation>();
            tl1List.add(tl1Operation);
            return tl1List;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void writeLog(int neid, SubFunc subfunc, String user, String ipAddress, ArrayList tl1OperList) {
        if (!this.hasWirteLog) {
            tl1OperList.addAll(this.operLogList);
        }
        super.writeLog(neid, subfunc, user, ipAddress, tl1OperList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean convertPartValue(Part part, RowParams rowparams) {
        TENE ne;
        Param param;
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("NELOCATION")) {
            param = rowparams.getParam("NELOCATION");
            if (param == null) return false;
            part.setValue("\"" + param.getValue() + "\"");
        }
        if (part.getName().equalsIgnoreCase("TMZONE")) {
            param = rowparams.getParam("TMZONE");
            if (param == null) return false;
            part.setValue(param.getValue());
            ne = TENEListUtils.getNEObj((int)this.neid);
            ne.setTimeZome(param.getValue());
        }
        if (!part.getName().equalsIgnoreCase("pm-day-start")) return super.convertPartValue(part, rowparams);
        param = rowparams.getParam("pm-day-start");
        if (param == null) return false;
        part.setValue(param.getValue());
        ne = (TETL1NE)TENEListUtils.getNEObj((int)this.neid);
        int pmdayvalue = 0;
        try {
            pmdayvalue = Integer.parseInt(param.getValue());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEAttributeSetBean.convertPartValue() fail!", (Throwable)e);
        }
        ne.setPmdaytime(pmdayvalue);
        return flag;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            ArrayList tl1OperList = super.getTL1Operation(neid, subFunc, inputData, memeryData);
            TENE ne = TENEListUtils.getNEObj((int)neid);
            if (ne.getNEType() == 66) {
                Iterator it = tl1OperList.iterator();
                while (it.hasNext()) {
                    TL1Operation tl1Oper = (TL1Operation)it.next();
                    if (!tl1Oper.getName().equals("ED-SERIAL")) continue;
                    it.remove();
                }
            }
            return tl1OperList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private void modifyNeListInfo(int neid, Datainterface outputData, String neName) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("neName", neName);
        boolean writeDocResult = true;
        writeDocResult = TEResourceManager.setNeListInfoNEKeys((String)TENEListMgr.NELIST_PATH, (int)neid, ht);
        if (!writeDocResult) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            TENEListUtils.getNEObj((int)neid).setNEName(neName);
        }
    }

    private boolean isExistedNE(int neid, String neName) {
        boolean existed = false;
        ArrayList nelistinfo = TEResourceManager.getNeListInfo((String)TENEListMgr.NELIST_PATH);
        if (nelistinfo != null) {
            int size = nelistinfo.size();
            for (int i = 0; i < size; ++i) {
                HashMap hm = (HashMap)nelistinfo.get(i);
                String tmpName = String.valueOf(hm.get("neName"));
                if (!tmpName.equals(neName)) continue;
                existed = true;
                break;
            }
        }
        return existed;
    }

    class CreateNewConnect
    extends Thread {
        private int port = -1;
        private String ipAddr = "";

        public CreateNewConnect(int port, String ipAddr) {
            this.port = port;
            this.ipAddr = ipAddr;
        }

        @Override
        public void run() {
            try {
                CreateNewConnect.sleep(35000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            int result = TETL1NECommMgr.getInstance().createConect((long)TENEAttributeSetBean.this.neid, this.port, this.ipAddr, 1, null);
            if (result != 0) {
                TELogFactory.getNormalLogger().debug("IP Changed,Connect New NE Fail!");
                TENEAttributeSetBean.this.ne.setComStatus(0);
            } else {
                TELogFactory.getNormalLogger().debug("IP Changed,Connect New NE Success!");
                TENEAttributeSetBean.this.ne.setComStatus(1);
            }
            TENEAttributeSetBean.this.ne = TETL1NELoginMgr.getInstance().login(TENEAttributeSetBean.this.ne, TENEAttributeSetBean.this.ne.getCurUser(), TENEAttributeSetBean.this.ne.getCurUserPassword());
            int retCode = TENEAttributeSetBean.this.ne.getLoginCode();
            if (retCode != 0) {
                TENEAttributeSetBean.this.ne.setLogStatus(0);
            } else {
                TENEAttributeSetBean.this.ne.initNEData();
                if (TENEAttributeSetBean.this.ne.getLoginCode() == 0) {
                    TENEAttributeSetBean.this.ne.setLogStatus(1);
                    TENEAttributeSetBean.this.ne.queryTL1Alarm();
                }
            }
        }
    }
}

