/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1marine.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.nemgr.tl1marine.channel.TEChannelThreadMgr;
import com.huawei.nglct.nemgr.tl1marine.channel.TEPathViewTreeOBJ;
import com.huawei.nglct.nemgr.tl1marine.channel.TEPathViewTreeOBJComparator;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TEBoardState;
import com.huawei.nglct.tl1.TEBoardSupportAlarmAID;
import com.huawei.nglct.tl1.TEBoardSupportAlarmMgr;
import com.huawei.nglct.tl1.TEBoardTypeConvertUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TEState;
import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEChannelPathGraph
extends TETL1NEExplorerBean {
    int slotID = -1;
    int boardtype = -1;
    private Map portMap = new HashMap();
    private List portList = new ArrayList();
    boolean isDynPortBoardType = false;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();

    public TEChannelPathGraph() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        ArrayList<TEPathViewTreeOBJ> result = new ArrayList<TEPathViewTreeOBJ>();
        String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        this.slotID = Integer.parseInt(slotinfo);
        this.boardtype = this.mgr.getBoard(neid, this.slotID).getBoardType();
        this.isDynPortBoardType = this.mgr.isDynPortBoardType(neid, this.boardtype);
        this.slotIDList = this.getSlotIDFromInputDdata(inputData);
        if (this.isDynPortBoardType) {
            this.queryDynPort(this.slotID);
        }
        TEPathViewTreeOBJ root = this.setRoot(neid, this.slotID);
        result.add(root);
        TEPathViewTreeOBJ board = this.setBoard(neid, this.slotID, root);
        result.add(board);
        this.outputData = new Datainterface();
        this.setTree(result, root);
        this.getChannelData(result);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.outputData;
    }

    private void setPort(int neid, Map aidMap) {
        for (Map.Entry entry : aidMap.entrySet()) {
            List aidList = (List)entry.getValue();
            int n = aidList.size();
            for (int i = 0; i < n; ++i) {
                TEAIDAndType aidAndType = (TEAIDAndType)aidList.get(i);
                String[] aidArr = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)neid);
                String portName = "";
                portName = "OTHER";
                this.processPort(aidAndType, portName, this.isDynPortBoardType);
            }
        }
    }

    private void setMod2(int neid, Map aidMap) {
        for (Map.Entry entry : aidMap.entrySet()) {
            List aidList = (List)entry.getValue();
            int n = aidList.size();
            for (int i = 0; i < n; ++i) {
                TEAIDAndType aidAndType = (TEAIDAndType)aidList.get(i);
                String[] aidArr = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)neid);
                if (!aidArr[0].equals("SLOT") && aidArr[4].equals("-1")) {
                    this.processList(aidAndType);
                } else {
                    this.processSlotList(aidAndType, "SFP");
                }
                if (aidArr[4].equals("-1")) continue;
                this.processChannelList(aidAndType);
            }
        }
    }

    private TEPathViewTreeOBJ setRoot(int neID, int slotID) {
        TEPathViewTreeOBJ root = new TEPathViewTreeOBJ();
        TENE ne = TENEListUtils.getNEObj((int)neID);
        TEBoard board = ne.getBoard(slotID);
        String shelfSlotName = TETL1CommonUtil.getShelfSlotName((int)neID, (int)board.getSlotID());
        root.setName(shelfSlotName + "-" + board.getBoardName());
        root.setId("0");
        root.setPid("-1");
        root.setSeqenceLevel(0);
        root.setLogicPortInPosition(1);
        return root;
    }

    private TEPathViewTreeOBJ setBoard(int neID, int slotID, TEPathViewTreeOBJ root) {
        TEPathViewTreeOBJ board = new TEPathViewTreeOBJ();
        board.setId(root.getId() + "-" + slotID);
        board.setPid(root.getId());
        board.setName("EQPT");
        board.setPortid(0);
        board.setSortid(0);
        board.setPathID(0);
        board.setPortName("");
        board.setSeqenceLevel(1);
        board.setSlotID(TETL1CommonUtil.slotIDNMToNESlotID((int)slotID));
        board.setShelf(TETL1CommonUtil.slotIDNMToNEShelfID((int)slotID));
        board.setNeid(neID);
        board.setLogicPortInPosition(1);
        board.setMod2("EQPT");
        String shlefSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neID, (int)slotID);
        board.setAid("SLOT-" + shlefSlot);
        board.setIsDynPortBoardType(this.isDynPortBoardType);
        TENE ne = TENEListUtils.getNEObj((int)neID);
        TEBoard tempBoard = ne.getBoard(slotID);
        board.setState(String.valueOf(tempBoard.getState()));
        board.setSetMaintance(false);
        board.setSetState(true);
        return board;
    }

    private void processPort(TEAIDAndType aidAndType, String portName, boolean isDynPortBoardType) {
        PortDes portDes = (PortDes)this.portMap.get(aidAndType.getAid());
        if (portDes == null) {
            portDes = new PortDes();
            this.portMap.put(aidAndType.getAid(), portDes);
        }
        portDes.setPortAtt(aidAndType.getAidArr());
        portDes.setPortName(portName);
        portDes.setAid(aidAndType.getAid());
        portDes.setDynPortBoardType(isDynPortBoardType);
        String[] aid = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)this.neid);
        portDes.setPortID(Integer.parseInt(aid[3]));
        portDes.setIndex(aid[0]);
        PortDes tempPortDes = this.getViewPort(portDes);
        portDes.setState(7);
        if (tempPortDes != null) {
            portDes.setCanAddPort(tempPortDes.getCanAddPort());
            portDes.setCanDelPort(tempPortDes.getCanDelPort());
            portDes.setCanModifyPort(tempPortDes.getCanModifyPort());
            portDes.setLogicPortInPosition(tempPortDes.getLogicPortInPosition());
            portDes.setState(7);
            portDes.setCanSetMaintance(false);
            portDes.setCanSetState(false);
            portDes.setPortType(tempPortDes.getPortType());
        } else {
            portDes.setLogicPortInPosition(1);
            portDes.setCanSetMaintance(false);
            portDes.setCanSetState(false);
        }
        if (aidAndType.getType().equals("UNEQ") || aidAndType.getType().equals("NA") || aidAndType.getPldType().equals("UNEQ") || aidAndType.getPldType().equals("NA")) {
            portDes.setCanVisable(false);
        }
    }

    private void processSlotList(TEAIDAndType aidAndType, String portName) {
        String aid = aidAndType.getAid().replaceAll("SLOT", "FAC");
        PortDes portDes = (PortDes)this.portMap.get(aid);
        if (portDes != null) {
            ChannelDes channelDes = new ChannelDes(aidAndType.getAid(), portName);
            channelDes.setChannelMod2(false);
            TETL1AIDKey key = new TETL1AIDKey(this.neid, aidAndType.getAid(), aidAndType.getType());
            TEState state = this.mgr.getPortState(key);
            channelDes.setState(this.getColorFromTEState(state));
            portDes.getMod2List().put(aidAndType.getAid() + "-" + portName, channelDes);
        }
    }

    private void processList(TEAIDAndType aidAndType) {
        String aid = aidAndType.getAid();
        if (aid.indexOf("SLOT") > 0) {
            return;
        }
        String[] aids = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)this.neid);
        aid = aids[1].equals("-1") ? aids[0] + "-" + aids[2] + "-" + aids[3] : aids[0] + "-" + aids[1] + "-" + aids[2] + "-" + aids[3];
        PortDes portDes = (PortDes)this.portMap.get(aid);
        if (portDes != null) {
            this.setChannelToPort(aidAndType, portDes);
        } else {
            portDes = new PortDes();
            portDes.setAid(aidAndType.getAid());
            String portName = TETL1CommonUtil.getPortNameFromNEPort((String)aids[0], (int)this.slotID, (int)Integer.parseInt(aids[3]), (int)this.neid);
            portDes.setPortName(portName);
            portDes.setPortAtt(aidAndType.getAidArr());
            portDes.setDynPortBoardType(this.isDynPortBoardType);
            portDes.setPortID(Integer.parseInt(aids[3]));
            portDes.setIndex(aids[0]);
            portDes.setLogicPortInPosition(1);
            portDes.setCanSetMaintance(false);
            portDes.setCanSetState(false);
            portDes.setState(7);
            this.portMap.put(aid, portDes);
            this.setChannelToPort(aidAndType, portDes);
        }
    }

    private void setChannelToPort(TEAIDAndType aidAndType, PortDes portDes) {
        TEState state;
        TETL1AIDKey key;
        ChannelDes channelDes;
        int i;
        int n;
        String actType = aidAndType.getType();
        String pldType = aidAndType.getPldType();
        if (!"".equals(actType) && !"UNEQ".equals(actType)) {
            ArrayList actTypesList = TETL1CommonUtil.parseString((String)actType, (String)"|");
            n = actTypesList.size();
            for (i = 0; i < n; ++i) {
                if (String.valueOf(actTypesList.get(i)).equals("UNEQ") || String.valueOf(actTypesList.get(i)).equals("NA") || !this.isSupportMod2(String.valueOf(actTypesList.get(i)))) continue;
                channelDes = new ChannelDes(portDes.getAid(), String.valueOf(actTypesList.get(i)));
                channelDes.setChannelMod2(false);
                key = new TETL1AIDKey(this.neid, aidAndType.getAid(), String.valueOf(actTypesList.get(i)));
                state = this.mgr.getPortState(key);
                channelDes.setState(this.getColorFromTEState(state));
                portDes.getMod2List().put(aidAndType.getAid() + "-" + actTypesList.get(i), channelDes);
            }
        }
        if (!"".equals(pldType) && !"UNEQ".equals(pldType)) {
            ArrayList pldTypesList = TETL1CommonUtil.parseString((String)pldType, (String)"|");
            n = pldTypesList.size();
            for (i = 0; i < n; ++i) {
                if (String.valueOf(pldTypesList.get(i)).equals("UNEQ") || String.valueOf(pldTypesList.get(i)).equals("NA")) continue;
                channelDes = new ChannelDes(portDes.getAid(), String.valueOf(pldTypesList.get(i)));
                channelDes.setChannelMod2(false);
                key = new TETL1AIDKey(this.neid, aidAndType.getAid(), String.valueOf(pldTypesList.get(i)));
                state = this.mgr.getPortState(key);
                channelDes.setState(this.getColorFromTEState(state));
                portDes.getMod2List().put(aidAndType.getAid() + "-" + pldTypesList.get(i), channelDes);
            }
        }
    }

    private boolean isSupportMod2(String mod2) {
        boolean flag = true;
        if (60008 == this.boardtype && "OCH".equals(mod2)) {
            flag = false;
        }
        return flag;
    }

    private boolean processChannelList(TEAIDAndType aidAndType) {
        boolean flag = false;
        String[] aids = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)this.neid);
        if (aids[0].equals("SLOT")) {
            return false;
        }
        String aid = "";
        aid = aids[1].equals("-1") ? aids[0] + "-" + aids[2] + "-" + aids[3] : aids[0] + "-" + aids[1] + "-" + aids[2] + "-" + aids[3];
        PortDes portDes = (PortDes)this.portMap.get(aid);
        if (portDes != null) {
            flag = this.setChannelToPort(aidAndType, aidAndType.getAid(), portDes);
        } else {
            portDes = new PortDes();
            portDes.setAid(aidAndType.getAid());
            String portName = TETL1CommonUtil.getPortNameFromNEPort((String)aids[0], (int)this.slotID, (int)Integer.parseInt(aids[3]), (int)this.neid);
            portDes.setPortName(portName);
            portDes.setPortAtt(aidAndType.getAidArr());
            portDes.setDynPortBoardType(this.isDynPortBoardType);
            portDes.setPortID(Integer.parseInt(aids[3]));
            portDes.setIndex(aids[0]);
            portDes.setLogicPortInPosition(1);
            portDes.setCanSetMaintance(false);
            portDes.setCanSetState(false);
            portDes.setState(7);
            this.portMap.put(aid, portDes);
            flag = this.setChannelToPort(aidAndType, aid, portDes);
        }
        return flag;
    }

    private boolean setChannelToPort(TEAIDAndType aidAndType, String aid, PortDes portDes) {
        boolean flag = false;
        HashMap mod2List = portDes.getMod2List();
        ChannelDes channelDes = (ChannelDes)mod2List.get(aid);
        if (channelDes == null) {
            channelDes = new ChannelDes(aid, "");
            channelDes.setChannelMod2(false);
            portDes.getMod2List().put(aidAndType.getAid(), channelDes);
        }
        if (channelDes.getAid().equals(aid)) {
            TEState state;
            TETL1AIDKey key;
            ChannelDes subChannel;
            String mod2Name;
            String[] aids;
            int j;
            int m;
            portDes.setHasChannel(true);
            String actType = aidAndType.getType();
            String pldType = aidAndType.getPldType();
            if (!(actType.equals("") || actType.equals("UNEQ") || actType.equals("NA"))) {
                ArrayList actTypesList = TETL1CommonUtil.parseString((String)actType, (String)"|");
                m = actTypesList.size();
                for (j = 0; j < m; ++j) {
                    aids = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)this.neid);
                    mod2Name = (String)actTypesList.get(j) + "-" + aids[4];
                    if (mod2Name.indexOf("UNEQ") != -1 || mod2Name.indexOf("NA") != -1) continue;
                    subChannel = new ChannelDes(aidAndType.getAid(), mod2Name);
                    key = new TETL1AIDKey(this.neid, aidAndType.getAid(), String.valueOf(actTypesList.get(j)));
                    state = this.mgr.getPortState(key);
                    subChannel.setState(this.getColorFromTEState(state));
                    subChannel.setChannelMod2(true);
                    mod2List.put(aidAndType.getAid() + "-" + mod2Name, subChannel);
                }
            }
            if (!(pldType.equals("") || pldType.equals("UNEQ") || pldType.equals("NA"))) {
                ArrayList pldTypesList = TETL1CommonUtil.parseString((String)pldType, (String)"|");
                m = pldTypesList.size();
                for (j = 0; j < m; ++j) {
                    aids = TETL1CommonUtil.parseAID((String)aidAndType.getAid(), (int)this.neid);
                    mod2Name = (String)pldTypesList.get(j) + "-" + aids[4];
                    if (mod2Name.indexOf("UNEQ") != -1 || mod2Name.indexOf("NA") != -1) continue;
                    subChannel = new ChannelDes(aidAndType.getAid(), mod2Name);
                    key = new TETL1AIDKey(this.neid, aidAndType.getAid(), String.valueOf(pldTypesList.get(j)));
                    state = this.mgr.getPortState(key);
                    subChannel.setState(this.getColorFromTEState(state));
                    subChannel.setChannelMod2(true);
                    mod2List.put(aidAndType.getAid() + "-" + mod2Name, subChannel);
                }
            }
        }
        return flag;
    }

    public PortDes getViewPort(PortDes portDes) {
        int n = this.portList.size();
        for (int i = 0; i < n; ++i) {
            PortDes tmpPortDes = (PortDes)this.portList.get(i);
            if (!portDes.getIndex().equals("FAC") || tmpPortDes.getPortID() != portDes.getPortID()) continue;
            return tmpPortDes;
        }
        return null;
    }

    private void setTree(ArrayList result, TEPathViewTreeOBJ root) {
        List portList = this.sortPort();
        TEBoardTypeConvertUtil boardType = TEBoardTypeConvertUtil.getInstance();
        TENE ne = TENEListUtils.getNEObj((int)this.neid);
        boardType.setNeType(ne.getNEType());
        boardType.setHostVersion(ne.getHostVersion());
        List xmlPortList = TEBoardTypeConvertUtil.getInstance().getPortListByBoardType(this.boardtype);
        ArrayList tempModtStateQueryList = new ArrayList();
        int m = portList.size();
        for (int j = 0; j < m; ++j) {
            PortDes portDes = (PortDes)portList.get(j);
            TEPathViewTreeOBJ portObj = new TEPathViewTreeOBJ();
            portObj.setId(root.getId() + "-" + this.slotID + "-" + portDes.getAid());
            portObj.setPid(root.getId());
            portObj.setPortid(portDes.getPortID());
            portObj.setName(portDes.getPortName());
            portObj.setSortid(1);
            portObj.setSeqenceLevel(2);
            portObj.setSlotID(TETL1CommonUtil.slotIDNMToNESlotID((int)this.slotID));
            portObj.setShelf(TETL1CommonUtil.slotIDNMToNEShelfID((int)this.slotID));
            portObj.setAid(portDes.getAid());
            portObj.setNeid(this.neid);
            portObj.setCanAddPort(portDes.getCanAddPort());
            portObj.setCanModifyPort(portDes.getCanModifyPort());
            portObj.setCanDelPort(portDes.getCanDelPort());
            portObj.setIndex(portDes.getIndex());
            portObj.setPortType(portDes.getPortType());
            portObj.setSetState(false);
            portObj.setSetMaintance(false);
            portObj.setState(String.valueOf(portDes.getState()));
            portObj.setLogicPortInPosition(portDes.getLogicPortInPosition());
            Vector subrackList = ne.getSubrackList();
            int curSubrackId = TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)this.slotID);
            String curSubrack = "";
            int nnn = subrackList.size();
            for (int iii = 0; iii < nnn; ++iii) {
                TESubrack tempsubrack = (TESubrack)subrackList.get(iii);
                if (!tempsubrack.getSubrackID().equals(String.valueOf(curSubrackId))) continue;
                curSubrack = tempsubrack.getLogicSubrackType();
                break;
            }
            if (!(curSubrack.indexOf("8800") == -1 || this.boardtype != 2109 && this.boardtype != 2110 || !portDes.getIndex().equals("ACC") || portDes.getPortID() != 3 && portDes.getPortID() != 4)) {
                portDes.setCanVisable(false);
            }
            portObj.setCanVisable(portDes.isCanVisable());
            result.add(portObj);
            List tempList = this.getMod2List(portDes.getMod2List());
            int portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)portObj.getAid(), (int)this.neid);
            List mod2List = new ArrayList();
            mod2List = this.boardtype != 1573 ? this.filterMod2List(tempList, xmlPortList, portID) : this.filter52TomMod2List(tempList, portID);
            Mod2Comparator mod2Comparator = new Mod2Comparator();
            Collections.sort(mod2List, mod2Comparator);
            tempModtStateQueryList.addAll(mod2List);
            int n = mod2List.size();
            for (int i = 0; i < n; ++i) {
                ChannelDes mod2 = (ChannelDes)mod2List.get(i);
                if (mod2 == null || mod2.getMod2Name().equals("")) continue;
                TEPathViewTreeOBJ mod2Obj = new TEPathViewTreeOBJ();
                mod2Obj.setId(root.getId() + "-" + this.slotID + "-" + portDes.getAid() + "-" + mod2.getMod2Name());
                mod2Obj.setPid(root.getId() + "-" + this.slotID + "-" + portDes.getAid());
                mod2Obj.setName(mod2.getMod2Name());
                mod2Obj.setSortid(2);
                mod2Obj.setSeqenceLevel(3);
                mod2Obj.setSlotID(TETL1CommonUtil.slotIDNMToNESlotID((int)this.slotID));
                mod2Obj.setShelf(TETL1CommonUtil.slotIDNMToNEShelfID((int)this.slotID));
                mod2Obj.setNeid(this.neid);
                mod2Obj.setAid(mod2.getAid());
                mod2Obj.setMod2(mod2.getMod2Name());
                mod2Obj.setLogicPortInPosition(1);
                mod2Obj.setState(String.valueOf(mod2.getState()));
                if (this.isSupportState(mod2)) {
                    mod2Obj.setSetState(true);
                    mod2Obj.setSetMaintance(true);
                } else {
                    mod2Obj.setSetState(false);
                    mod2Obj.setSetMaintance(false);
                    mod2Obj.setState("7");
                }
                if (mod2.getMod2Name().equals("SFP") || mod2.getMod2Name().equals("EQPT")) {
                    mod2Obj.setSetState(true);
                    mod2Obj.setSetMaintance(false);
                }
                result.add(mod2Obj);
                List channleList = mod2.getChannelList();
                int y = channleList.size();
                for (int x = 0; x < y; ++x) {
                    SubChannel subChannel = (SubChannel)channleList.get(x);
                    if (subChannel == null) continue;
                    TEPathViewTreeOBJ channelObj = new TEPathViewTreeOBJ();
                    channelObj.setId(root.getId() + "-" + this.slotID + "-" + portDes.getAid() + "-" + mod2.getMod2Name() + "-" + subChannel.getName());
                    channelObj.setPid(root.getId() + "-" + this.slotID + "-" + portDes.getAid() + "-" + mod2.getMod2Name());
                    channelObj.setName(subChannel.getName() + "-" + (x + 1));
                    channelObj.setSortid(3);
                    channelObj.setSeqenceLevel(4);
                    channelObj.setSlotID(TETL1CommonUtil.slotIDNMToNESlotID((int)this.slotID));
                    channelObj.setShelf(TETL1CommonUtil.slotIDNMToNEShelfID((int)this.slotID));
                    channelObj.setNeid(this.neid);
                    channelObj.setAid(subChannel.getAid());
                    channelObj.setState(String.valueOf(subChannel.getState()));
                    channelObj.setMod2(subChannel.getName());
                    channelObj.setSetState(true);
                    channelObj.setSetMaintance(true);
                    channelObj.setLogicPortInPosition(1);
                    result.add(channelObj);
                }
            }
        }
    }

    private boolean isSupportState(ChannelDes mod2) {
        boolean flag = true;
        if (mod2.getMod2Name() != null) {
            if (mod2.getMod2Name().indexOf("OMS") != -1) {
                flag = false;
            } else if (mod2.getMod2Name().indexOf("PL") != -1) {
                flag = false;
            } else if (mod2.getMod2Name().indexOf("MCACHN") != -1) {
                flag = false;
            }
        }
        if (this.boardtype == 1207 || this.boardtype == 1206) {
            if (mod2.getMod2Name().indexOf("OCH") != -1) {
                flag = false;
            }
        } else if ((this.boardtype == 1174 || this.boardtype == 1173 || this.boardtype == 1150 || this.boardtype == 1149 || this.boardtype == 60026 || this.boardtype == 60038 || this.boardtype == 1546 || this.boardtype == 60015 || this.boardtype == 60005 || this.boardtype == 1147 || this.boardtype == 60027 || this.boardtype == 1148 || this.boardtype == 60037) && mod2.getMod2Name().indexOf("OCH") != -1) {
            flag = false;
        }
        return flag;
    }

    private List filterMod2List(List mod2List, List xmlPortList, int portID) {
        Iterator it = mod2List.iterator();
        ArrayList<ChannelDes> tempList = new ArrayList<ChannelDes>();
        while (it.hasNext()) {
            ChannelDes channelDes = (ChannelDes)it.next();
            int n = xmlPortList.size();
            for (int i = 0; i < n; ++i) {
                TEBoardTypeConvertUtil.Port port = (TEBoardTypeConvertUtil.Port)xmlPortList.get(i);
                if (portID != port.getPortid()) continue;
                List mod2list = port.getMod2List();
                boolean isAllMod2Flag = this.isAllMod2(mod2list);
                List portList = port.getTcmList();
                ArrayList tcmList = new ArrayList();
                tcmList.addAll(portList);
                this.handleTCMModList(tcmList, channelDes);
                if (!channelDes.getMod2Name().equals("SFP")) {
                    int nn = tcmList.size();
                    for (int ii = 0; ii < nn; ++ii) {
                        boolean flag;
                        String tcmMod2 = (String)tcmList.get(ii);
                        if (this.isHasTcmMod2(tempList, tcmMod2) || !(flag = this.getTcmMod2Flag(tcmMod2, channelDes))) continue;
                        String pathFlag = port.getDynTcmSupportPath();
                        String tempTcmMod2 = tcmMod2;
                        String tempAid = channelDes.getAid();
                        int channel = TETL1CommonUtil.getPathIDFromAidStruct((String)tempAid, (int)this.neid);
                        if (pathFlag.equals("FB_DYN_PAYLOAD_TCM_NOPATH") && tcmMod2.indexOf("-") != -1) {
                            tempTcmMod2 = tcmMod2.split("-")[0];
                        }
                        if (pathFlag.equals("FB_DYN_PAYLOAD_TCM_NOPATH") && channel != -1) {
                            tempAid = tempAid.substring(0, tempAid.lastIndexOf(45));
                        }
                        ChannelDes tcmChannel = new ChannelDes(tempAid, tempTcmMod2);
                        if (tcmMod2.indexOf(45) != -1) {
                            tcmMod2 = tcmMod2.split("-")[0];
                        }
                        TETL1AIDKey key = new TETL1AIDKey(this.neid, tempAid, tcmMod2);
                        TEState state = this.mgr.getPortState(key);
                        tcmChannel.setState(this.getColorFromTEState(state));
                        tempList.add(tcmChannel);
                    }
                }
                if (isAllMod2Flag || channelDes.getMod2Name().equals("") || mod2list.contains(channelDes.getMod2Name())) continue;
                it.remove();
            }
        }
        int n = tempList.size();
        for (int i = 0; i < n; ++i) {
            mod2List.add(tempList.get(i));
        }
        return mod2List;
    }

    private List filter52TomMod2List(List mod2List, int portID) {
        Iterator it = mod2List.iterator();
        ArrayList<ChannelDes> tempList = new ArrayList<ChannelDes>();
        while (it.hasNext()) {
            ChannelDes channelDes = (ChannelDes)it.next();
            ArrayList tcmList = new ArrayList();
            this.handle52TomTCMModList(tcmList, channelDes);
            int nn = tcmList.size();
            for (int ii = 0; ii < nn; ++ii) {
                boolean flag;
                String tcmMod2 = (String)tcmList.get(ii);
                if (this.isHasTcmMod2(tempList, tcmMod2) || !(flag = this.getTcmMod2Flag(tcmMod2, channelDes))) continue;
                String tempTcmMod2 = tcmMod2;
                String tempAid = channelDes.getAid();
                ChannelDes tcmChannel = new ChannelDes(tempAid, tempTcmMod2);
                if (tcmMod2.indexOf(45) != -1) {
                    tcmMod2 = tcmMod2.split("-")[0];
                }
                TETL1AIDKey key = new TETL1AIDKey(this.neid, tempAid, tcmMod2);
                TEState state = this.mgr.getPortState(key);
                tcmChannel.setState(this.getColorFromTEState(state));
                tempList.add(tcmChannel);
            }
        }
        int n = tempList.size();
        for (int i = 0; i < n; ++i) {
            mod2List.add(tempList.get(i));
        }
        return mod2List;
    }

    private void handle52TomTCMModList(List mod2List, ChannelDes channelDes) {
        String mod2Name = channelDes.getMod2Name();
        boolean addFlag = false;
        if (mod2Name.indexOf("OTU") != -1) {
            addFlag = true;
        }
        if (addFlag) {
            String pathStr = "";
            if (mod2Name.indexOf(45) != -1) {
                pathStr = mod2Name.substring(mod2Name.indexOf(45));
            }
            if (mod2Name.indexOf("OTU1") != -1) {
                mod2Name = "ODU1TCM";
            } else if (mod2Name.indexOf("OTU2") != -1) {
                mod2Name = "ODU2TCM";
            } else if (mod2Name.indexOf("OTU3") != -1) {
                mod2Name = "ODU3TCM";
            }
            for (int j = 1; j <= 6; ++j) {
                mod2List.add(mod2Name + j + pathStr);
            }
        }
    }

    private void handleTCMModList(List tcmList, ChannelDes channelDes) {
        String mod2Name = channelDes.getMod2Name();
        String channelStr = "";
        boolean addFlag = false;
        int len = tcmList.size();
        for (int i = 0; i < len; ++i) {
            String str = (String)tcmList.get(i);
            if (str.indexOf("ODUNTCM") == -1) continue;
            String[] strArr = str.split("-");
            String[] mod2Arr = mod2Name.split("-");
            if (strArr.length > 1 && mod2Arr.length > 1) {
                channelStr = strArr[1];
                mod2Name = mod2Arr[0];
            }
            if (mod2Name.indexOf("OTU") != -1) {
                addFlag = true;
            }
            tcmList.remove(i);
            break;
        }
        if (addFlag) {
            mod2Name = mod2Name.replaceAll("OTU", "ODU");
            for (int j = 1; j <= 6; ++j) {
                if (channelStr.equals("")) {
                    tcmList.add(mod2Name + "TCM" + j);
                    continue;
                }
                tcmList.add(mod2Name + "TCM" + j + "-" + channelStr);
            }
        }
    }

    private boolean isAllMod2(List mod2list) {
        int n = mod2list.size();
        for (int i = 0; i < n; ++i) {
            String mod2 = (String)mod2list.get(i);
            if (mod2.indexOf("ALL") == -1) continue;
            return true;
        }
        return false;
    }

    private boolean getTcmMod2Flag(String tcmMod2, ChannelDes channelDes) {
        String[] aids = TETL1CommonUtil.parseAID((String)channelDes.getAid(), (int)this.neid);
        int channel = Integer.parseInt(aids[4]);
        if (tcmMod2.indexOf("-") != -1) {
            int tcmPathID = Integer.parseInt(tcmMod2.split("-")[1]);
            return channel == tcmPathID;
        }
        return -1 == channel;
    }

    private boolean isHasTcmMod2(List mod2List, String tcmMod2) {
        int n = mod2List.size();
        for (int i = 0; i < n; ++i) {
            ChannelDes temp = (ChannelDes)mod2List.get(i);
            if (temp.getMod2Name().indexOf(tcmMod2) == -1) continue;
            return true;
        }
        return false;
    }

    private List sortPort() {
        ArrayList portList = new ArrayList();
        Object[] keys = this.portMap.keySet().toArray();
        PortComparator comparator = new PortComparator();
        Arrays.sort(keys, comparator);
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            portList.add(this.portMap.get(keys[i]));
        }
        return portList;
    }

    private List getMod2List(HashMap mod2Map) {
        ArrayList portList = new ArrayList();
        Object[] keys = mod2Map.keySet().toArray();
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            portList.add(mod2Map.get(keys[i]));
        }
        return portList;
    }

    public void getChannelData(ArrayList result) {
        TEPathViewTreeOBJComparator comparator = new TEPathViewTreeOBJComparator();
        Collections.sort(result, comparator);
        this.outputData.setBussinessParams(new BussinessParams());
        for (int i = 0; i < result.size(); ++i) {
            TEPathViewTreeOBJ pv = (TEPathViewTreeOBJ)result.get(i);
            RowParams rowParam = new RowParams();
            rowParam.addParam("id", pv.getId());
            rowParam.addParam("pid", pv.getPid());
            rowParam.addParam("name", pv.getName());
            rowParam.addParam("portID", String.valueOf(pv.getPortid()));
            rowParam.addParam("pathID", String.valueOf(pv.getSortid()));
            rowParam.addParam("portName", pv.getPortName());
            rowParam.addParam("slotid", String.valueOf(pv.getSlotID()));
            rowParam.addParam("shelf", String.valueOf(pv.getShelf()));
            rowParam.addParam("neid", String.valueOf(pv.getNeid()));
            rowParam.addParam("aid", String.valueOf(pv.getAid()));
            rowParam.addParam("mod2", String.valueOf(pv.getMod2()));
            rowParam.addParam("canDelPort", String.valueOf(pv.getCanDelPort()));
            rowParam.addParam("canModifyPort", String.valueOf(pv.getCanModifyPort()));
            rowParam.addParam("logicPortInPosition", String.valueOf(pv.getLogicPortInPosition()));
            rowParam.addParam("IsDynBoard", String.valueOf(pv.getIsDynPortBoardType()));
            rowParam.addParam("isSetState", String.valueOf(pv.getSetState()));
            rowParam.addParam("state", String.valueOf(pv.getState()));
            rowParam.addParam("isSetMaintance", String.valueOf(pv.getSetMaintance()));
            rowParam.addParam("maintance", String.valueOf(pv.getMaintance()));
            rowParam.addParam("portType", String.valueOf(pv.getPortType()));
            rowParam.addParam("portSpeed", String.valueOf(pv.getPortSpeed()));
            rowParam.addParam("canVisable", String.valueOf(pv.isCanVisable()));
            if (pv.getSortid() >= 0) {
                this.geAlarmStatus(this.neid, this.slotID, pv);
            }
            rowParam.addParam("topAlarmLevel", String.valueOf(pv.getTopAlarmLevel()));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
    }

    private void geAlarmStatus(int neID, int slotID, TEPathViewTreeOBJ pvTreeOBJ) {
        TENE neobj = TENEListUtils.getNEObj((int)neID);
        Vector alarams = neobj.getAlarmList();
        ArrayList SupportAlmList = TEBoardSupportAlarmMgr.getInstance().getBoardSupportAlarmFBList(this.boardtype);
        pvTreeOBJ.setTopAlarmLevel(0);
        int size = alarams.size();
        for (int i = 0; i < size; ++i) {
            TETL1Alarm alarm = (TETL1Alarm)alarams.get(i);
            int slot = alarm.getSlotID();
            int port = alarm.getPort();
            int path = alarm.getPath();
            if (pvTreeOBJ.getPathID() > 0) {
                if (port != pvTreeOBJ.getPortid() || slot != slotID || path != pvTreeOBJ.getPathID()) continue;
                int AlarmLevel = TETL1FaultUtil.getTL1AlarmLevel((String)alarm.getAlarmLevel());
                if (pvTreeOBJ.getTopAlarmLevel() > 0) {
                    if (AlarmLevel >= pvTreeOBJ.getTopAlarmLevel()) continue;
                    if (AlarmLevel == 5) {
                        pvTreeOBJ.setTopAlarmLevel(-1);
                        break;
                    }
                    pvTreeOBJ.setTopAlarmLevel(AlarmLevel);
                    break;
                }
                if (AlarmLevel == 5) {
                    pvTreeOBJ.setTopAlarmLevel(-1);
                    continue;
                }
                pvTreeOBJ.setTopAlarmLevel(AlarmLevel);
                continue;
            }
            if (port != pvTreeOBJ.getPortid() || slot != slotID) continue;
            int size2 = SupportAlmList.size();
            for (int k = 0; k < size2; ++k) {
                TEBoardSupportAlarmAID alarmFb = (TEBoardSupportAlarmAID)SupportAlmList.get(k);
                if (alarmFb.getPortID() != port || alarmFb.getPathID() != path) continue;
                int AlarmLevel = TETL1FaultUtil.getTL1AlarmLevel((String)alarm.getAlarmLevel());
                if (pvTreeOBJ.getTopAlarmLevel() > 0) {
                    if (AlarmLevel >= pvTreeOBJ.getTopAlarmLevel()) continue;
                    if (AlarmLevel == 5) {
                        pvTreeOBJ.setTopAlarmLevel(0);
                        continue;
                    }
                    pvTreeOBJ.setTopAlarmLevel(AlarmLevel);
                    continue;
                }
                if (AlarmLevel == 5) {
                    pvTreeOBJ.setTopAlarmLevel(0);
                    continue;
                }
                pvTreeOBJ.setTopAlarmLevel(AlarmLevel);
            }
        }
    }

    public void queryDynPort(int slotID) {
        TL1Operation oper1 = null;
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            oper1 = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = oper1.getInMsg();
            StringBuffer sb = new StringBuffer();
            sb.append("SLOT-");
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotID);
            sb.append(shelfSlotID);
            sb.append("-ALL");
            input.getPart("AID").setValue(sb.toString());
            operationList.add(oper1.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operationList, 60);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return;
        }
        for (OutMsg out : ((TL1Operation)operationList.get(0)).getOutMsg()) {
            HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            Part AID = (Part)hm.get("slotID");
            if (AID.getValue() == null) continue;
            String[] aid = TETL1CommonUtil.parseAID((String)AID.getValue(), (int)this.neid);
            PortDes portDes = new PortDes();
            portDes.setAid(AID.getValue());
            portDes.setPortID(Integer.parseInt(aid[3]));
            Part provType = (Part)hm.get("PROVTYPE");
            portDes.setPortType(provType.getValue());
            if (provType.getValue() == null) {
                portDes.setLogicPortInPosition(0);
                portDes.setCanAddPort(1);
            } else {
                portDes.setLogicPortInPosition(1);
                portDes.setCanDelPort(1);
                portDes.setCanModifyPort(1);
            }
            portDes.setState(7);
            this.portList.add(portDes);
        }
    }

    private void queryLogicPortState(List mod2List) {
        TEChannelThreadMgr.getInstance().handleStateQueryTask(this.neid, this.slotID, mod2List);
    }

    private int getColorFromTEState(TEState state) {
        return TEBoardState.setStateInPSTANDSST((String)state.getPST(), (String)state.getSST());
    }

    public class PortComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int port2;
            int port1 = TETL1CommonUtil.getNMPortNOFromAidStruct((String)((String)o1), (int)TEChannelPathGraph.this.neid);
            if (port1 > (port2 = TETL1CommonUtil.getNMPortNOFromAidStruct((String)((String)o2), (int)TEChannelPathGraph.this.neid))) {
                return 1;
            }
            if (port2 > port1) {
                return -1;
            }
            return 0;
        }
    }

    public class Mod2Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String[] fb1 = ((ChannelDes)o1).getMod2Name().split("-");
            String[] fb2 = ((ChannelDes)o2).getMod2Name().split("-");
            if (fb1.length > 1 && fb2.length > 1) {
                if (Integer.parseInt(fb1[1]) > Integer.parseInt(fb2[1])) {
                    return 1;
                }
                if (Integer.parseInt(fb1[1]) < Integer.parseInt(fb2[1])) {
                    return -1;
                }
                return fb1[0].compareTo(fb2[0]);
            }
            if (fb1[0].compareTo(fb2[0]) > 0) {
                return 1;
            }
            if (fb1[0].compareTo(fb2[0]) < 0) {
                return -1;
            }
            return 0;
        }
    }

    class SubChannel {
        private String aid = "";
        private int state = 0;
        private String name = "";

        SubChannel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }
    }

    class ChannelDes {
        private String aid = "";
        private String mod2Name = "";
        private List channelList = new ArrayList();
        private boolean isChannelMod2 = false;
        private int state = 0;

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public ChannelDes(String aid, String mod2Name) {
            this.aid = aid;
            this.mod2Name = mod2Name;
        }

        public String getMod2Name() {
            return this.mod2Name;
        }

        public void setMod2Name(String mod2Name) {
            this.mod2Name = mod2Name;
        }

        public List getChannelList() {
            return this.channelList;
        }

        public void setChannelList(List channelList) {
            this.channelList = channelList;
        }

        public String toString() {
            return this.mod2Name;
        }

        public boolean isChannelMod2() {
            return this.isChannelMod2;
        }

        public void setChannelMod2(boolean isChannelMod2) {
            this.isChannelMod2 = isChannelMod2;
        }
    }

    class PortDes {
        private String portType = "";
        private HashMap mod2List = new HashMap();
        private String name = "";
        private String[] portAtt;
        private String portName = "";
        private int portID = -1;
        private String aid = "";
        private int canAddPort = 0;
        private int canDelPort = 0;
        private int canModifyPort = 0;
        private String portSpeed;
        private boolean isDynPortBoardType = false;
        private int logicPortInPosition = 0;
        private int state = 0;
        private boolean canSetState = false;
        private boolean canSetMaintance = false;
        private String index = "";
        private boolean canVisable = true;
        private boolean hasChannel = false;

        PortDes() {
        }

        public boolean isCanVisable() {
            return this.canVisable;
        }

        public void setCanVisable(boolean canVisable) {
            this.canVisable = canVisable;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public boolean getCanSetState() {
            return this.canSetState;
        }

        public void setCanSetState(boolean canSetState) {
            this.canSetState = canSetState;
        }

        public boolean getCanSetMaintance() {
            return this.canSetMaintance;
        }

        public void setCanSetMaintance(boolean canSetMaintance) {
            this.canSetMaintance = canSetMaintance;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getCanAddPort() {
            return this.canAddPort;
        }

        public void setCanAddPort(int canAddPort) {
            this.canAddPort = canAddPort;
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public int getPortID() {
            return this.portID;
        }

        public void setPortID(int portID) {
            this.portID = portID;
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public String[] getPortAtt() {
            return this.portAtt;
        }

        public void setPortAtt(String[] portAtt) {
            this.portAtt = portAtt;
        }

        public String getPortType() {
            return this.portType;
        }

        public void setPortType(String portType) {
            this.portType = portType;
        }

        public HashMap getMod2List() {
            return this.mod2List;
        }

        public void setMod2List(HashMap mod2List) {
            this.mod2List = mod2List;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getCanDelPort() {
            return this.canDelPort;
        }

        public void setCanDelPort(int canDelPort) {
            this.canDelPort = canDelPort;
        }

        public int getCanModifyPort() {
            return this.canModifyPort;
        }

        public void setCanModifyPort(int canModifyPort) {
            this.canModifyPort = canModifyPort;
        }

        public String getPortSpeed() {
            return this.portSpeed;
        }

        public void setPortSpeed(String portSpeed) {
            this.portSpeed = portSpeed;
        }

        public boolean getDynPortBoardType() {
            return this.isDynPortBoardType;
        }

        public void setDynPortBoardType(boolean isDynPortBoardType) {
            this.isDynPortBoardType = isDynPortBoardType;
        }

        public int getLogicPortInPosition() {
            return this.logicPortInPosition;
        }

        public void setLogicPortInPosition(int logicPortInPosition) {
            this.logicPortInPosition = logicPortInPosition;
        }

        public boolean isHasChannel() {
            return this.hasChannel;
        }

        public void setHasChannel(boolean hasChannel) {
            this.hasChannel = hasChannel;
        }
    }
}

